function AllPlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    for i = 1:length(panelNames)
        matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{i}));
        load(matfile);
        tempopts.dir = sprintf('/%s/',panelNames{i});
        tempopts.name = sprintf('_%s',panelNames{i});
        dataopts.norm = 'n';
        StatPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesFinal(1,:,:), dataopts);
        if opts.WealthQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_wealth/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesWealthFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesWealthFinal);
        end
        if opts.LearnQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_learn/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesLearnFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesLearnFinal);
        end
        if opts.HumanCapQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_humancap/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesHumanCapFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesHumanCapFinal);
        end
        matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{i}));
        load(matfile);        
        dataopts.norm = 'y';        
        tempopts.dir = sprintf('/%s/',panelNames{i});
        tempopts.name = sprintf('_%sNorm',panelNames{i});
        StatPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesFinal, dataopts);
        if opts.WealthQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);            
            tempopts.dir = sprintf('/%s_wealth/',panelNames{i});
            tempopts.name = sprintf('_%sNorm',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesWealthFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesWealthFinal);
        end
        if opts.LearnQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);            
            tempopts.dir = sprintf('/%s_learn/',panelNames{i});
            tempopts.name = sprintf('_%sNorm',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesLearnFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesLearnFinal);
        end
        if opts.HumanCapQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);            
            tempopts.dir = sprintf('/%s_humancap/',panelNames{i});
            tempopts.name = sprintf('_%sNorm',panelNames{i});            
            HeterogeneityPlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesHumanCapFinal, dataopts);
            HeterogeneityStats(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, modelProfilesHumanCapFinal);
        end
    end         
    clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;

end