function [prob] = BoundedMultiVarPDF( x , y, lbnd , ubnd , pdfname )
%RndCopula
% Generate correlated draw from a log-normal distribution using a copula.
% CorrMat contains the correlations between the variables along the off-diagonals
% Simulations contains the number of draws
% Mu and Sigma are the mean and standard deviation of the marginal distribution of log-normals, respectively.
% Author: Ben Griffy
    
    if max(reshape(lbnd,[],1) - reshape(y,[],1)) > 0
        prob = 0;
    elseif min(reshape(ubnd,[],1) - reshape(y,[],1)) < 0
        prob = 0;
    else
        prob = prod(1./(reshape(ubnd,[],1) - reshape(lbnd,[],1)));
    end
        
    
end