function [err, averageVals] = CalcAverages(params, order, opts, calcOpts, statPanel)
%% CalcAverages m-file for Search and the Sources of Lifetime Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


% if testopts.treated == 'y'
%     for k=1:(nargin-6)
%         varargin{k} = varargin{k}(varargin{k}.Treated==1,:);
%     end
% end

meanVals = zeros(size(statPanel,2),1);
varVals = zeros(size(statPanel,2),1);
meanPDVVals = zeros(size(statPanel,2),1);
varPDVVals = zeros(size(statPanel,2),1);
meanInitVals = zeros(size(statPanel,2),1);
varInitVals = zeros(size(statPanel,2),1);

err = 0;
temp = grpstats(statPanel.LRInc,statPanel.Age,{'mean'});
A = size(temp,1);
disc = (1 + r).^(T./A)-1;

tmpPanel = zeros(size(statPanel));



for i = 2:size(statPanel,2)
    if isa(table2array(statPanel(:,i)),'double') == true
        tmpPanel(:,i) = table2array(statPanel(:,i));
    else
        tmpPanel(:,i) = NaN;
    end
end

tmpPanel = array2table(tmpPanel,'VariableNames',statPanel.Properties.VariableNames);

if strcmpi(calcOpts.qtile,'Wealth')
    tmpPanel.Wealth_qtileSort = statPanel.Wealth_qtile;
    meanVals = repmat(meanVals.',5,1);
    varVals = repmat(varVals.',5,1);
    meanPDVVals = repmat(meanPDVVals.',5,1);
    varPDVVals = repmat(varPDVVals.',5,1);
    meanInitVals = repmat(meanInitVals.',5,1);
    varInitVals = repmat(varInitVals.',5,1);
    try
        tmpvals = grpstats(tmpPanel,{'Wealth_qtileSort'},{'nanmean'});
        meanVals = table2array(tmpvals(:,3:end));
        tmpvals = grpstats(tmpPanel,{'Wealth_qtileSort'},{'nanvar'});
        varVals = table2array(tmpvals(:,3:end));
        tmpPanel.AgeSort = tmpPanel.Age;
        tmpvals = grpstats(tmpPanel,{'AgeSort','Wealth_qtileSort'},{'nanmean'});
        meanPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        meanInitVals = table2array(tmpvals(1:5,4:end));
        tmpvals = grpstats(tmpPanel,{'AgeSort','Wealth_qtileSort'},{'nanvar'});
        varPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        varInitVals = table2array(tmpvals(1:5,4:end));
    catch
        err = 1;
    end
    averageVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),reshape(varVals,1,size(varVals,1),size(varVals,2)),reshape(meanPDVVals,1,size(meanPDVVals,1),size(meanPDVVals,2)),reshape(varPDVVals,1,size(varPDVVals,1),size(varPDVVals,2)),reshape(meanInitVals,1,size(meanInitVals,1),size(meanInitVals,2)),reshape(varInitVals,1,size(varInitVals,1),size(varInitVals,2)));
elseif strcmpi(calcOpts.qtile,'HumanCap')
    tmpPanel.HumanCap_qtileSort = statPanel.HumanCap_qtile;
    meanVals = repmat(meanVals.',5,1);
    varVals = repmat(varVals.',5,1);
    meanPDVVals = repmat(meanPDVVals.',5,1);
    varPDVVals = repmat(varPDVVals.',5,1);
    meanInitVals = repmat(meanInitVals.',5,1);
    varInitVals = repmat(varInitVals.',5,1);
    try
        tmpvals = grpstats(tmpPanel,{'HumanCap_qtileSort'},{'nanmean'});
        meanVals = table2array(tmpvals(:,3:end));
        tmpvals = grpstats(tmpPanel,{'HumanCap_qtileSort'},{'nanvar'});
        varVals = table2array(tmpvals(:,3:end));
        tmpPanel.AgeSort = tmpPanel.Age;
        tmpvals = grpstats(tmpPanel,{'AgeSort','HumanCap_qtileSort'},{'nanmean'});
        meanPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        meanInitVals = table2array(tmpvals(1:5,4:end));
        tmpvals = grpstats(tmpPanel,{'AgeSort','HumanCap_qtileSort'},{'nanvar'});
        varPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        varInitVals = table2array(tmpvals(1:5,4:end));
    catch
        err = 1;
    end
    averageVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),reshape(varVals,1,size(varVals,1),size(varVals,2)),reshape(meanPDVVals,1,size(meanPDVVals,1),size(meanPDVVals,2)),reshape(varPDVVals,1,size(varPDVVals,1),size(varPDVVals,2)),reshape(meanInitVals,1,size(meanInitVals,1),size(meanInitVals,2)),reshape(varInitVals,1,size(varInitVals,1),size(varInitVals,2)));
elseif strcmpi(calcOpts.qtile,'Learn')
    tmpPanel.Learn_qtileSort = statPanel.Learn_qtile;
    meanVals = repmat(meanVals.',5,1);
    varVals = repmat(varVals.',5,1);
    meanPDVVals = repmat(meanPDVVals.',5,1);
    varPDVVals = repmat(varPDVVals.',5,1);
    meanInitVals = repmat(meanInitVals.',5,1);
    varInitVals = repmat(varInitVals.',5,1);
    try
        tmpvals = grpstats(tmpPanel,{'Learn_qtileSort'},{'nanmean'});
        meanVals = table2array(tmpvals(:,3:end));
        tmpvals = grpstats(tmpPanel,{'Learn_qtileSort'},{'nanvar'});
        varVals = table2array(tmpvals(:,3:end));
        tmpPanel.AgeSort = tmpPanel.Age;
        tmpvals = grpstats(tmpPanel,{'AgeSort','Learn_qtileSort'},{'nanmean'});
        meanPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        meanInitVals = table2array(tmpvals(1:5,4:end));
        tmpvals = grpstats(tmpPanel,{'AgeSort','Learn_qtileSort'},{'nanvar'});
        varPDVVals = squeeze(geosum2(disc,reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),A));
        varInitVals = table2array(tmpvals(1:5,4:end));
    catch
        err = 1;
    end
    averageVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),reshape(varVals,1,size(varVals,1),size(varVals,2)),reshape(meanPDVVals,1,size(meanPDVVals,1),size(meanPDVVals,2)),reshape(varPDVVals,1,size(varPDVVals,1),size(varPDVVals,2)),reshape(meanInitVals,1,size(meanInitVals,1),size(meanInitVals,2)),reshape(varInitVals,1,size(varInitVals,1),size(varInitVals,2)));
else
    try
        meanVals = nanmean(table2array(tmpPanel),1);
        varVals = nanvar(table2array(tmpPanel),1);
        tmpPanel.AgeSort = tmpPanel.Age;
        tmpvals = grpstats(tmpPanel,{'AgeSort'},{'nanmean'});
        meanPDVVals = squeeze(geosum2(disc,table2array(tmpvals(:,3:end)).',A)).';
        meanInitVals = table2array(tmpvals(1,3:end));
        tmpvals = grpstats(tmpPanel,{'AgeSort'},{'nanvar'});
        varPDVVals = squeeze(geosum2(disc,table2array(tmpvals(:,3:end)).',A)).';
        varInitVals = table2array(tmpvals(1,3:end));
    catch
        err = 1;
    end
    averageVals = cat(1,meanVals,varVals,meanPDVVals,varPDVVals,meanInitVals,varInitVals);
end



end

