function [ssr, err] = CalcError(moments, weights, modelests, j, opts, nparams, params, order)

err = 0;

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


modelmomentnames={'NetLiq.Quintile1XLogofUI','NetLiq.Quintile2XLogofUI', ...
                  'Age','NetLiq.Q2','NetLiq.Q3','NetLiq.Q4','NetLiq.Q5', ...
                  'LiquidWealth','LastLogWageXNetLiq.Q1', ...
                  'LogWageSplineQ2XNetLiq.Q2','ConstantSIPP', ...
                  strjoin({sprintf('AveAge%1.0f,',25:53),'AveAge54'}), ...
                  strjoin({sprintf('VarAge%1.0f,',25:53),'VarAge54'}), ...
                  strjoin({sprintf('Growth%1.0f,',1:9),'Growth10'}), ...
                  strjoin({sprintf('CovGrowth1x%1.0f,',1:9),'CovGrowth1x10'}), ...
                  strjoin({sprintf('CovGrowth2x%1.0f,',2:9),'CovGrowth2x10'}), ...
                  strjoin({sprintf('CovGrowth3x%1.0f,',3:9),'CovGrowth3x10'}), ...
                  strjoin({sprintf('CovGrowth4x%1.0f,',4:9),'CovGrowth4x10'}), ...
                  strjoin({sprintf('CovGrowth5x%1.0f,',5:9),'CovGrowth5x10'}), ...
                  strjoin({sprintf('CovGrowth6x%1.0f,',6:9),'CovGrowth6x10'}), ...
                  strjoin({sprintf('CovGrowth7x%1.0f,',7:9),'CovGrowth7x10'}), ...
                  strjoin({sprintf('CovGrowth8x%1.0f,',8:9),'CovGrowth8x10'}), ...
                  strjoin({'CovGrowth9x9,','CovGrowth9x10'}),'CovGrowth10x10', ...
                  'Cons30thAFQT','Cons50thAFQT', ...
                  'Cons70thAFQT','Cons90thAFQT','AgeNLSY', ...
                  'Slope30thAFQT','Slope50thAFQT','Slope70thAFQT', ...
                  'Slope90thAFQT','AgeAgeGrp2NLSY', ...
                  'SlopeAgeGrp230thAFQT','SlopeAgeGrp250thAFQT','SlopeAgeGrp270thAFQT', ...
                  'SlopeAgeGrp290thAFQT','ConstantNLSY','Cons30thWealth','Cons50thWealth', ...
                  'Cons70thWealth','Cons90thWealth','AgePSID', ...
                  'Slope30thWealth','Slope50thWealth','Slope70thWealth', ...
                  'Slope90thWealth','AgeAgeGrp2PSID', ...
                  'SlopeAgeGrp230thWealth','SlopeAgeGrp250thWealth','SlopeAgeGrp270thWealth', ...
                  'SlopeAgeGrp290thWealth','ConstantPSID', ...
                  strjoin({sprintf('init_earnings%1.0f,',1:9),'init_earnings10'}), ...
                  strjoin({sprintf('init_wealth%1.0f,',1:9),'init_wealth10'}), ...
                  strjoin({sprintf('NLSYsameJobAgeGrp%1.0f,',1:5),'NLSYsameJobAgeGrp6'})};


modelmoments = ((1/S).*sum(modelests,1)).';

if size(modelmoments) == size(moments)
    diff = modelmoments - moments;
    W = weights;
    ssr = diff'*W*diff
else
    diff = NaN;
    ssr = NaN;
    err = 1;
end

if isnan(ssr)
    ssr = NaN
    err = 1
end

if j < S
    ssr = NaN
    err = 1
end

if exist(fullfile(pwd,opts.II_path,'II.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'II.csv'),cat(2,opts.simulation_directory_num,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'II.csv'),cat(2,'Num,','ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'II.csv'),cat(2,opts.simulation_directory_num,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SSR.csv'), 'file')
    dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,opts.simulation_directory_num,ssr,diff',params(1:nparams)'),'-append','precision',8);
else
    dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,'Num,','ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
    dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,opts.simulation_directory_num,ssr,diff',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'II_Sims.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,'Num,''ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SSR_Sims.csv'), 'file')
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
else
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,'Num,''ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
end

end
