function [ssr, err] = CalcFinalError(moments, weights, modelests, SEests, opts, nparams, params, order)

err = 0;
    
[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


modelmomentnames={'NetLiq.1stQuintile2Wage','LnAvgUIWage', ...
                  'NetLiq.1stQuintile2XLnAvgUIWage','AgeWage', ...
                  'LnLastWageWage','NetLiq.1stQuintile2XLnLastWageWage','ConstantSIPP', ...
                  'NetLiq.1stQuintile1XLnAvgUIHazard','NetLiq.2ndQuintile2XLogofUIHazard', ...
                  'AgeHazard','LnLastWageHazard' ...
                  strjoin({sprintf('AveAge%1.0f,',25:53),'AveAge54'}), ...
                  strjoin({sprintf('VarAge%1.0f,',25:53),'VarAge54'}), ...
                  strjoin({sprintf('Growth%1.0f,',1:2),'Growth3'}), ...
                  strjoin({sprintf('CovGrowth1x%1.0f,',1:2),'CovGrowth1x3'}), ...
                  'CovGrowth2x2','CovGrowth2x3','CovGrowth3x3', ...
                  'AgeNLSY','Cons30thAFQT','Cons50thAFQT', ...
                  'Cons70thAFQT','Cons90thAFQT','Slope30thAFQT','Slope50thAFQT', ...
                  'Slope70thAFQT','Slope90thAFQT','ConsAgeGrp210thAFQT', ...
                  'ConsAgeGrp230thAFQT','ConsAgeGrp250thAFQT','ConsAgeGrp270thAFQT', ...
                  'ConsAgeGrp290thAFQT','AgeAgeGrp2NLSY', ...
                  'SlopeAgeGrp230thAFQT','SlopeAgeGrp250thAFQT','SlopeAgeGrp270thAFQT', ...
                  'SlopeAgeGrp290thAFQT','ConstantNLSY','AgePSID','Cons30thWealth', ...
                  'Cons50thWealth','Cons70thWealth','Cons90thWealth', ...
                  'Slope30thWealth','Slope50thWealth','Slope70thWealth', ...
                  'Slope90thWealth','ConsAgeGrp210thWealth', ...
                  'ConsAgeGrp230thWealth','ConsAgeGrp250thWealth','ConsAgeGrp270thWealth', ...
                  'ConsAgeGrp290thWealth','AgeAgeGrp2PSID', ...
                  'SlopeAgeGrp230thWealth','SlopeAgeGrp250thWealth','SlopeAgeGrp270thWealth', ...
                  'SlopeAgeGrp290thWealth','ConstantPSID', ...
                  strjoin({sprintf('init_earnings%1.0f,',1:9),'init_earnings10'}), ...
                  strjoin({sprintf('init_wealth%1.0f,',1:9),'init_wealth10'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp1x%1.0f,',1:4),'NLSYJ2JRateAgeGrp1x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp2x%1.0f,',1:4),'NLSYJ2JRateAgeGrp2x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp3x%1.0f,',1:4),'NLSYJ2JRateAgeGrp3x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp4x%1.0f,',1:4),'NLSYJ2JRateAgeGrp4x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp5x%1.0f,',1:4),'NLSYJ2JRateAgeGrp5x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp6x%1.0f,',1:4),'NLSYJ2JRateAgeGrp6x5'}), ...
                 'UnempRate'};

if isempty(SEests)
    SEests = csvread(fullfile(pwd,opts.II_path,'SE_FinalSims.csv'),1,0);
end

if isempty(modelests)
    modelests = csvread(fullfile(pwd,opts.II_path,'II_FinalSims.csv'),1,0);
end


if opts.calcMoments == 'y' & ~isempty(modelests)
    modelmoments = ((1/S).*sum(modelests,1)).';
else
    modelmoments = csvread(fullfile(pwd,opts.II_path,'FinalMoments.csv'),1,0).';
    % modelmoments = modelmoments(2:end-nparams,end);
end
if opts.calcMoments == 'y' & ~isempty(SEests)
    modelSEs = ((1/S).*sum(SEests,1)).';
else
    modelSEs = csvread(fullfile(pwd,opts.II_path,'FinalSE.csv'),1,0).';
    % modelSEs = modelSEs(2:end-nparams,end);
end

ssr = modelmoments(1);

modelmoments = modelmoments(2:end-length(params));
modelSEs = modelSEs(2:end-length(params));

    % Initial Distribution Moments
    init_earnings_moments_weights = csvread(fullfile(opts.project_path,opts.input_path,'LRInc_qtiles_weighting.csv'));
    init_earnings_moments_weights = init_earnings_moments_weights.^(1/2);
    init_wealth_moments_weights = csvread(fullfile(opts.project_path,opts.input_path,'RLiqWealth_qtiles_weighting.csv'));
    init_wealth_moments_weights = init_wealth_moments_weights.^(1/2);
    
    % Life-Cycle PSID Profile Moments
    lifecycle_ave_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'LifeCycleProfiles_AveragePSID_Weighting.csv'),'n');
    lifecycle_ave_moments_weights = diag(lifecycle_ave_moments_weights).^(1/2);
    lifecycle_var_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'LifeCycleProfilesHVY_VariancePSID_Weighting.csv'),'n');
    lifecycle_var_moments_weights = diag(lifecycle_var_moments_weights).^(1/2);
    
    
    % Growth Rates PSID Moments
    lifecyclegrowth_ave_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'LifeCycleGrowth_AveragePSID_Weighting.csv'),'n');
    lifecyclegrowth_ave_moments_weights = lifecyclegrowth_ave_moments_weights.^(1/2);
    lifecyclegrowth_covmat_moments_weights = triu(tabconv(fullfile(opts.project_path,opts.input_path,'LifeCycleGrowth_VariancePSID_Weighting.csv'),'n')).';
    lifecyclegrowth_covmat_moments_weights = lifecyclegrowth_covmat_moments_weights(:);
    lifecyclegrowth_covmat_moments_weights(lifecyclegrowth_covmat_moments_weights==0) = [];
    lifecyclegrowth_covmat_moments_weights = lifecyclegrowth_covmat_moments_weights.^(1/2);
    
    % Life-Cycle PSID Slope-Intercept Moments
    slope_wealth_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'SlopesRLiqWealthOLogitPSID_Weighting.csv'),'n');
    slope_wealth_moments_weights = diag(slope_wealth_moments_weights).^(1/2);
    
    % Life-Cycle NLSY Slope-Intercept Moments
    slope_ability_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'SlopesAFQTNLSY_Weighting.csv'),'n');
    slope_ability_moments_weights = diag(slope_ability_moments_weights).^(1/2);

    % Re-Emp Elasticity SIPP Moments
    wageelasticity_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'WageReEmploymentElasticities_SIPP_Weighting.csv'),'n');
    wageelasticity_moments_weights = diag(wageelasticity_moments_weights).^(1/2);

    % Re-Emp Elasticity SIPP Moments
    hazardelasticity_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'HazardReEmploymentElasticities_SIPP_Weighting.csv'),'n');
    hazardelasticity_moments_weights = diag(hazardelasticity_moments_weights).^(1/2);
    
    % Job Change Rates by Wealth NLSY    
    lifecycleJ2JRate_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'JobChangeRate_AverageNLSY_Weighting.csv'),'n');    
    lifecycleJ2JRate_moments_weights = diag(lifecycleJ2JRate_moments_weights).^(1/2);

    % Unemployment Rate PSID    
    unempRate_moments_weights = tabconv(fullfile(opts.project_path,opts.input_path,'UnempRatePSID_Weighting.csv'),'n');    
    unempRate_moments_weights = unempRate_moments_weights.^(1/2);

    dataSEs = cat(1,wageelasticity_moments_weights,hazardelasticity_moments_weights, ...
                                        lifecycle_ave_moments_weights,lifecycle_var_moments_weights, ...
                                        lifecyclegrowth_ave_moments_weights,lifecyclegrowth_covmat_moments_weights, ...
                                        slope_ability_moments_weights,slope_wealth_moments_weights, ...
                                        init_earnings_moments_weights,init_wealth_moments_weights, ...
                                        lifecycleJ2JRate_moments_weights,unempRate_moments_weights);


% dataSEs = diag(weights);

% dataSEs = ones(size(dataSEs))./(dataSEs.^(1/2));

% dataSEs = csvread(fullfile(pwd,opts.II_path,'DataSEs.csv'),1,0).';

teststats = -abs((moments - modelmoments)./(sqrt(modelSEs.^2 + dataSEs.^2)));

PVals = normcdf(teststats,0,1);

% if size(modelmoments) == size(moments)
%     diff = modelmoments - moments;
%     W = weights;
%     ssr = diff'*W*diff
% else
%     diff = NaN;
%     ssr = NaN;
%     err = 1;
% end

% if isnan(ssr)
%     ssr = NaN
%     err = 1
% end


% nparams = length(params);

if exist(fullfile(pwd,opts.II_path,'SimsFinalModelMoments.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelMoments.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelMoments.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelMoments.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SimsFinalModelSE.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelSE.csv'),cat(2,ssr,modelSEs',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelSE.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalModelSE.csv'),cat(2,ssr,modelSEs',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SimsFinalDataMoments.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataMoments.csv'),cat(2,ssr,moments',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataMoments.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataMoments.csv'),cat(2,ssr,moments',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SimsFinalDataSE.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataSE.csv'),cat(2,ssr,dataSEs',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataSE.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SimsFinalDataSE.csv'),cat(2,ssr,dataSEs',params(1:nparams)'),'-append','precision',8);
end


if exist(fullfile(pwd,opts.II_path,'SimsPVals.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SimsPVals.csv'),cat(2,ssr,PVals',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SimsPVals.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SimsPVals.csv'),cat(2,ssr,PVals',params(1:nparams)'),'-append','precision',8);
end

dlmwrite(fullfile(pwd,opts.II_path,'FinalModelMoments.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
dlmwrite(fullfile(pwd,opts.II_path,'FinalModelMoments.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);

dlmwrite(fullfile(pwd,opts.II_path,'FinalModelSE.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
dlmwrite(fullfile(pwd,opts.II_path,'FinalModelSE.csv'),cat(2,ssr,modelSEs',params(1:nparams)'),'-append','precision',8);

dlmwrite(fullfile(pwd,opts.II_path,'FinalDataMoments.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
dlmwrite(fullfile(pwd,opts.II_path,'FinalDataMoments.csv'),cat(2,ssr,moments',params(1:nparams)'),'-append','precision',8);

dlmwrite(fullfile(pwd,opts.II_path,'FinalDataSE.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
dlmwrite(fullfile(pwd,opts.II_path,'FinalDataSE.csv'),cat(2,ssr,dataSEs',params(1:nparams)'),'-append','precision',8);


dlmwrite(fullfile(pwd,opts.II_path,'PVals.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
dlmwrite(fullfile(pwd,opts.II_path,'PVals.csv'),cat(2,ssr,PVals',params(1:nparams)'),'-append','precision',8);


% if exist(fullfile(pwd,opts.II_path,'SSR.csv'), 'file')
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
% else 
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
% end

% if exist(fullfile(pwd,opts.II_path,'II_Sims.csv'), 'file')
%   dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
% else
%   dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
%   dlmwrite(fullfile(pwd,opts.II_path,'II_Sims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
% end

% if exist(fullfile(pwd,opts.II_path,'SSR_Sims.csv'), 'file')
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
% else 
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
%     dlmwrite(fullfile(pwd,opts.II_path,'SSR_Sims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
% end


paramests = csvread(fullfile(pwd,opts.II_path,'II.csv'),1,0);
paramests = paramests(:,end-nparams+1:end);

ParamSEs = std(paramests,1)./size(paramests,1);

ParamCIs = zeros(nparams,2);

for i = 1:nparams
    ParamCIs(i,1) = params(find(strcmp(order, order(i))))-2*ParamSEs(i);
    ParamCIs(i,2) = params(find(strcmp(order, order(i))))+2*ParamSEs(i);
end

if exist(fullfile(pwd,opts.II_path,'ParamLCI.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'ParamLCI.csv'),cat(2,ssr,ParamCIs(:,1)',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'ParamLCI.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'ParamLCI.csv'),cat(2,ssr,ParamCIs(:,1)',params(1:nparams)'),'-append','precision',8);
end


if exist(fullfile(pwd,opts.II_path,'ParamUCI.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'ParamUCI.csv'),cat(2,ssr,ParamCIs(:,1)',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'ParamUCI.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'ParamUCI.csv'),cat(2,ssr,ParamCIs(:,1)',params(1:nparams)'),'-append','precision',8);
end


end