function [err, betaests, SEests] = CalcFinalMoments(params, order, opts, moments, weights, NumObs, NObsNames, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles)

err = 0;

[r,ddelta,eeta,ggamma,bl,gg,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,RRnodes,MuRR,SigRR,StdRR,SigXi,exitProb,errtol] = Parameters(params, order, opts);

dataopts.fullpanel = 'n';

%%Auxiliary Model 1: SIPP Moments
%SIPP Moment selections:
%Age > 21, Sex = Male, UI Receipt = Yes, Censor Duration at 1 year


dataopts.dataset = 'SIPP';
dataopts.datasubset = 'Wages';
[SIPPSpellsPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

linearmodel = ['lnAppStrat ~ lnActUIAmt + netliq_1stq:lnActUIAmt + netliq_1stq + Age + lnlastannwg + netliq_1stq:lnlastannwg + lnLastHumanCap +  netliq_1stq:lnLastHumanCap'];

linearmodel = strcat(linearmodel);

try
    lm = fitlm(SIPPSpellsPanel,linearmodel);
catch
    lm.NumCoefficients = NaN;
    lm.NumEstimatedCoefficients = 0;
    err = 1;
end

try
    if lm.NumCoefficients == lm.NumEstimatedCoefficients
        betasLMUIAmt1 = lm.Coefficients.Estimate('lnActUIAmt');
        betasLMUIAmt2 = lm.Coefficients.Estimate('lnActUIAmt:netliq_1stq_2');
        SEsLMUIAmt1 = lm.Coefficients.SE('lnActUIAmt');
        SEsLMUIAmt2 = lm.Coefficients.SE('lnActUIAmt:netliq_1stq_2');
    else
        betasLMUIAmt1 = NaN;
        betasLMUIAmt2 = NaN;
        SEsLMUIAmt1 = NaN;
        SEsLMUIAmt2 = NaN;
    end
catch
    betasLMUIAmt1 = NaN;
    betasLMUIAmt2 = NaN;
    SEsLMUIAmt1 = NaN;
    SEsLMUIAmt2 = NaN;

    err = 1;
end

linearmodel = ['lnnextqwage ~ Wealth + netliq_1stq:Wealth + netliq_1stq + Age + lnlastannwg + netliq_1stq:lnlastannwg'];

linearmodel = strcat(linearmodel);

try
    lm = fitlm(SIPPSpellsPanel,linearmodel);
catch
    lm.NumCoefficients = NaN;
    lm.NumEstimatedCoefficients = 0;
    err = 1;
end

try
    if lm.NumCoefficients == lm.NumEstimatedCoefficients
        betasLMCons2 = lm.Coefficients.Estimate('netliq_1stq_2');
        betasLMAge = lm.Coefficients.Estimate('Age');
        betasLMlastwg1 = lm.Coefficients.Estimate('lnlastannwg');
        betasLMlastwg2 = lm.Coefficients.Estimate('lnlastannwg:netliq_1stq_2');
        betasLMCons1 = lm.Coefficients.Estimate('(Intercept)');
        SEsLMCons2 = lm.Coefficients.SE('netliq_1stq_2');
        SEsLMAge = lm.Coefficients.SE('Age');
        SEsLMlastwg1 = lm.Coefficients.SE('lnlastannwg');
        SEsLMlastwg2 = lm.Coefficients.SE('lnlastannwg:netliq_1stq_2');
        SEsLMCons1 = lm.Coefficients.SE('(Intercept)');
    else
        betasLMCons1 = NaN;
        betasLMCons2 = NaN;
        betasLMlastwg1 = NaN;
        betasLMlastwg2 = NaN;
        betasLMAge = NaN;
        SEsLMCons1 = NaN;
        SEsLMCons2 = NaN;
        SEsLMlastwg1 = NaN;
        SEsLMlastwg2 = NaN;
        SEsLMAge = NaN;
    end
catch
    betasLMCons1 = NaN;
    betasLMCons2 = NaN;
    betasLMlastwg1 = NaN;
    betasLMlastwg2 = NaN;
    betasLMAge = NaN;
    SEsLMCons1 = NaN;
    SEsLMCons2 = NaN;
    SEsLMlastwg1 = NaN;
    SEsLMlastwg2 = NaN;
    SEsLMAge = NaN;
    err = 1;
end

betasLM = [betasLMCons1;betasLMUIAmt1;betasLMUIAmt2;betasLMAge;betasLMlastwg1;betasLMlastwg2;betasLMCons2];
SEsLM = [SEsLMCons1;SEsLMUIAmt1;SEsLMUIAmt2;SEsLMAge;SEsLMlastwg1;SEsLMlastwg2;SEsLMCons2];

try
    [betasCox,~,~,statsCox] = coxphfit(cat(2,SIPPSpellsPanel.lnUIAmt+normrnd(0,0.1,size(SIPPSpellsPanel.lnUIAmt)),SIPPSpellsPanel.netliq_1stq2XlnUIAmt+SIPPSpellsPanel.netliq_1stq2.*normrnd(0,0.1,size(SIPPSpellsPanel.lnUIAmt)),SIPPSpellsPanel.Age,SIPPSpellsPanel.lnlastannwg,SIPPSpellsPanel.lnLastHumanCap),SIPPSpellsPanel.expDur,'Strata',double(SIPPSpellsPanel.netliq_1stq));
    betasCox = betasCox(1:4);
    SEsCox = statsCox.se(1:4);
catch
    betasCox = NaN(4,1);
    SEsCox = NaN(4,1);
    err = 1;
end

clear SIPPSpellsPanel lm linearmodel;

%%Auxiliary Models 2-7: PSID Moments
%Outline: Load sampling data, Construct panel, Impose Sample Restrictions

dataopts.dataset = 'PSID';
dataopts.datasubset = 'InitWealth';
[PSIDInitWealthPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

%Initial Wealth Quintiles
% try
%     RWealth_qtiles = quantile(PSIDInitWealthPanel,10).';
% catch
%     RWealth_qtiles = NaN(10,1);
%     err = 1;
% end
%% use this so that I can get SEs
try
    RWealth_dist = ceil(10*tiedrank(PSIDInitWealthPanel)/length(PSIDInitWealthPanel));
    RWealth_dist = cat(2,PSIDInitWealthPanel,RWealth_dist);
    G = findgroups(RWealth_dist(:,2));
    SERWealth_qtiles = splitapply(@std,RWealth_dist(:,1),G);
catch
    SERWealth_qtiles = NaN;
end


%%PSID Moment Calculations
%Initial Wealth Sub-Sampling

dataopts.datasubset = 'InitEarn';
[PSIDInitEarnPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

% try
%     RInc_qtiles = quantile(PSIDInitEarnPanel,10).';
% catch
%     RInc_qtiles = NaN(10,1);
%     err = 1;
% end
%% use this so that I can get SEs
try
    RInc_dist = ceil(10*tiedrank(PSIDInitEarnPanel)/length(PSIDInitEarnPanel));
    RInc_dist = cat(2,PSIDInitEarnPanel,RInc_dist);
    G = findgroups(RInc_dist(:,2));
    SERInc_qtiles = splitapply(@std,RInc_dist(:,1),G);
catch
    SERInc_qtiles = NaN;
end


%%Auxiliary Models 4-7: PSID Life-cycle moments
%PSID Moment selections:
%Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
%Age >30: Hours Worked in [520,5280] and Inc >=9750
%Marginal distribution of initial wealth, averaged over 3 years

dataopts.datasubset = 'LifeCycle';
[PSIDLifeCyclePanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

try
    lmslopePSIDWealth = fitlm(PSIDLifeCyclePanel,'LRIncHVY_3~RLiqWealth_qtile + Age + RLiqWealth_qtile:Age + RLiqWealth_qtile1XAgeGrp2 + RLiqWealth_qtile:AgeGrp + RLiqWealth_qtile1XAgeXAgeGrp2 + RLiqWealth_qtile:Age:AgeGrp');
    SlopeYoungPSIDWealth1 = lmslopePSIDWealth.Coefficients.Estimate('Age');
    SlopeYoungPSIDWealth2 = lmslopePSIDWealth.Coefficients.Estimate('Age:RLiqWealth_qtile_2');
    SlopeYoungPSIDWealth3 = lmslopePSIDWealth.Coefficients.Estimate('Age:RLiqWealth_qtile_3');
    SlopeYoungPSIDWealth4 = lmslopePSIDWealth.Coefficients.Estimate('Age:RLiqWealth_qtile_4');
    SlopeYoungPSIDWealth5 = lmslopePSIDWealth.Coefficients.Estimate('Age:RLiqWealth_qtile_5');
    SlopeOldPSIDWealth1 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile1XAgeXAgeGrp2');
    SlopeOldPSIDWealth2 = lmslopePSIDWealth.Coefficients.Estimate('Age:AgeGrp_2:RLiqWealth_qtile_2');
    SlopeOldPSIDWealth3 = lmslopePSIDWealth.Coefficients.Estimate('Age:AgeGrp_2:RLiqWealth_qtile_3');
    SlopeOldPSIDWealth4 = lmslopePSIDWealth.Coefficients.Estimate('Age:AgeGrp_2:RLiqWealth_qtile_4');
    SlopeOldPSIDWealth5 = lmslopePSIDWealth.Coefficients.Estimate('Age:AgeGrp_2:RLiqWealth_qtile_5');
    ConsPSIDWealth1 = lmslopePSIDWealth.Coefficients.Estimate('(Intercept)');
    ConsPSIDWealth2 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile_2');
    ConsPSIDWealth3 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile_3');
    ConsPSIDWealth4 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile_4');
    ConsPSIDWealth5 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile_5');
    ConsOldPSIDWealth1 = lmslopePSIDWealth.Coefficients.Estimate('RLiqWealth_qtile1XAgeGrp2');
    ConsOldPSIDWealth2 = lmslopePSIDWealth.Coefficients.Estimate('AgeGrp_2:RLiqWealth_qtile_2');
    ConsOldPSIDWealth3 = lmslopePSIDWealth.Coefficients.Estimate('AgeGrp_2:RLiqWealth_qtile_3');
    ConsOldPSIDWealth4 = lmslopePSIDWealth.Coefficients.Estimate('AgeGrp_2:RLiqWealth_qtile_4');
    ConsOldPSIDWealth5 = lmslopePSIDWealth.Coefficients.Estimate('AgeGrp_2:RLiqWealth_qtile_5');

    SESlopeYoungPSIDWealth1 = lmslopePSIDWealth.Coefficients.SE('Age');
    SESlopeYoungPSIDWealth2 = lmslopePSIDWealth.Coefficients.SE('Age:RLiqWealth_qtile_2');
    SESlopeYoungPSIDWealth3 = lmslopePSIDWealth.Coefficients.SE('Age:RLiqWealth_qtile_3');
    SESlopeYoungPSIDWealth4 = lmslopePSIDWealth.Coefficients.SE('Age:RLiqWealth_qtile_4');
    SESlopeYoungPSIDWealth5 = lmslopePSIDWealth.Coefficients.SE('Age:RLiqWealth_qtile_5');
    SESlopeOldPSIDWealth1 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile1XAgeXAgeGrp2');
    SESlopeOldPSIDWealth2 = lmslopePSIDWealth.Coefficients.SE('Age:AgeGrp_2:RLiqWealth_qtile_2');
    SESlopeOldPSIDWealth3 = lmslopePSIDWealth.Coefficients.SE('Age:AgeGrp_2:RLiqWealth_qtile_3');
    SESlopeOldPSIDWealth4 = lmslopePSIDWealth.Coefficients.SE('Age:AgeGrp_2:RLiqWealth_qtile_4');
    SESlopeOldPSIDWealth5 = lmslopePSIDWealth.Coefficients.SE('Age:AgeGrp_2:RLiqWealth_qtile_5');
    SEConsPSIDWealth1 = lmslopePSIDWealth.Coefficients.SE('(Intercept)');
    SEConsPSIDWealth2 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile_2');
    SEConsPSIDWealth3 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile_3');
    SEConsPSIDWealth4 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile_4');
    SEConsPSIDWealth5 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile_5');
    SEConsOldPSIDWealth1 = lmslopePSIDWealth.Coefficients.SE('RLiqWealth_qtile1XAgeGrp2');
    SEConsOldPSIDWealth2 = lmslopePSIDWealth.Coefficients.SE('AgeGrp_2:RLiqWealth_qtile_2');
    SEConsOldPSIDWealth3 = lmslopePSIDWealth.Coefficients.SE('AgeGrp_2:RLiqWealth_qtile_3');
    SEConsOldPSIDWealth4 = lmslopePSIDWealth.Coefficients.SE('AgeGrp_2:RLiqWealth_qtile_4');
    SEConsOldPSIDWealth5 = lmslopePSIDWealth.Coefficients.SE('AgeGrp_2:RLiqWealth_qtile_5');
catch
    SlopeYoungPSIDWealth1 = NaN;
    SlopeYoungPSIDWealth2 = NaN;
    SlopeYoungPSIDWealth3 = NaN;
    SlopeYoungPSIDWealth4 = NaN;
    SlopeYoungPSIDWealth5 = NaN;
    SlopeOldPSIDWealth1 = NaN;
    SlopeOldPSIDWealth2 = NaN;
    SlopeOldPSIDWealth3 = NaN;
    SlopeOldPSIDWealth4 = NaN;
    SlopeOldPSIDWealth5 = NaN;
    ConsPSIDWealth1 = NaN;
    ConsPSIDWealth2 = NaN;
    ConsPSIDWealth3 = NaN;
    ConsPSIDWealth4 = NaN;
    ConsPSIDWealth5 = NaN;
    ConsOldPSIDWealth1 = NaN;
    ConsOldPSIDWealth2 = NaN;
    ConsOldPSIDWealth3 = NaN;
    ConsOldPSIDWealth4 = NaN;
    ConsOldPSIDWealth5 = NaN;

    SESlopeYoungPSIDWealth1 = NaN;
    SESlopeYoungPSIDWealth2 = NaN;
    SESlopeYoungPSIDWealth3 = NaN;
    SESlopeYoungPSIDWealth4 = NaN;
    SESlopeYoungPSIDWealth5 = NaN;
    SESlopeOldPSIDWealth1 = NaN;
    SESlopeOldPSIDWealth2 = NaN;
    SESlopeOldPSIDWealth3 = NaN;
    SESlopeOldPSIDWealth4 = NaN;
    SESlopeOldPSIDWealth5 = NaN;
    SEConsPSIDWealth1 = NaN;
    SEConsPSIDWealth2 = NaN;
    SEConsPSIDWealth3 = NaN;
    SEConsPSIDWealth4 = NaN;
    SEConsPSIDWealth5 = NaN;
    SEConsOldPSIDWealth1 = NaN;
    SEConsOldPSIDWealth2 = NaN;
    SEConsOldPSIDWealth3 = NaN;
    SEConsOldPSIDWealth4 = NaN;
    SEConsOldPSIDWealth5 = NaN;
    err = 1;
end

try
    lmprofilePSID = fitlm(PSIDLifeCyclePanel,'ResponseVar','LRIncHVY_3','PredictorVars',{'Age'},'CategoricalVar',{'Age'});
    LRIncHVY_3Pred = predict(lmprofilePSID,PSIDLifeCyclePanel);
    tabVar = array2table([PSIDLifeCyclePanel.Age,LRIncHVY_3Pred],'VariableNames',{'Age','LRIncHVY_3Pred'});
    LifeCycleAve = grpstats(tabVar,'Age','mean','DataVars',{'LRIncHVY_3Pred'});
    LifeCycleAve = table2array(LifeCycleAve(:,3));
    SELifeCycleAve = grpstats(tabVar,'Age','var','DataVars',{'LRIncHVY_3Pred'});
    SELifeCycleAve = (table2array(SELifeCycleAve(:,3))).^(1/2);
    clear tabVar;
    LRIncHVY_3ResidSq = (PSIDLifeCyclePanel.LRIncHVY_3 - LRIncHVY_3Pred).^2;
    tabVar = array2table([PSIDLifeCyclePanel.Age,LRIncHVY_3ResidSq],'VariableNames',{'Age','LRIncHVY_3ResidSq'});
    LifeCycleVar = grpstats(tabVar,'Age','mean','DataVars',{'LRIncHVY_3ResidSq'});
    LifeCycleVar = table2array(LifeCycleVar(:,3));
    SELifeCycleVar = grpstats(tabVar,'Age','var','DataVars',{'LRIncHVY_3ResidSq'});
    SELifeCycleVar = (table2array(SELifeCycleVar(:,3))).^(1/2);
    clear tabVar;
catch
    LifeCycleAve = repmat(NaN,30,1);
    LifeCycleVar = repmat(NaN,30,1);
    err = 1;
end

try
    UnempRate = nanmean(PSIDLifeCyclePanel.UnempIntInd);
    UnempRateSE = nanvar(PSIDLifeCyclePanel.UnempIntInd).^(1/2);
catch
    UnempRate = NaN;
    UnempRateSE = NaN;
    err = 1;
end

dataopts.datasubset = 'OldGrowth';
[PSIDGrowthPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

try
    LRIncGrowthAve = zeros(3,1);
    LRIncGrowthCovMat = zeros(3,3);
    tempmat = table2array(PSIDGrowthPanel(PSIDGrowthPanel.Age2ndGrp=='1'&PSIDGrowthPanel.UnempAnInd==0,sprintfc('LRIncGrowth%1.0f',1:3)));
    LRIncGrowthAve = nanmean(tempmat,1).';
    SELRIncGrowthAve = (nanvar(tempmat,1).').^(1/2);
    LRIncGrowthCovMat = triu(nancov(tempmat,1)).';
    LRIncGrowthCovMat = LRIncGrowthCovMat(:);
    LRIncGrowthCovMat(LRIncGrowthCovMat==0) = [];
    SELRIncGrowthCovMat = (LRIncGrowthCovMat).^(1/2);
    clear tempmat;
catch
    LRIncGrowthAve = repmat(NaN,3,1);
    SELRIncGrowthAve = repmat(NaN,3,1);
    LRIncGrowthCovMat = triu(repmat(NaN,3,3));
    LRIncGrowthCovMat = LRIncGrowthCovMat(:);
    LRIncGrowthCovMat(LRIncGrowthCovMat==0) = [];
    SELRIncGrowthCovMat = (LRIncGrowthCovMat).^(1/2);
    err = 1;
end

betasWealth = [SlopeYoungPSIDWealth1;ConsPSIDWealth2;ConsPSIDWealth3;ConsPSIDWealth4;ConsPSIDWealth5;...
             SlopeYoungPSIDWealth2;SlopeYoungPSIDWealth3;SlopeYoungPSIDWealth4;SlopeYoungPSIDWealth5; ...
             ConsOldPSIDWealth1;ConsOldPSIDWealth2;ConsOldPSIDWealth3;ConsOldPSIDWealth4;ConsOldPSIDWealth5;SlopeOldPSIDWealth1;...
             SlopeOldPSIDWealth2;SlopeOldPSIDWealth3;SlopeOldPSIDWealth4;SlopeOldPSIDWealth5;ConsPSIDWealth1];

SEsWealth = [SESlopeYoungPSIDWealth1;SEConsPSIDWealth2;SEConsPSIDWealth3;SEConsPSIDWealth4;SEConsPSIDWealth5;...
             SESlopeYoungPSIDWealth2;SESlopeYoungPSIDWealth3;SESlopeYoungPSIDWealth4;SESlopeYoungPSIDWealth5; ...
             SEConsOldPSIDWealth1;SEConsOldPSIDWealth2;SEConsOldPSIDWealth3;SEConsOldPSIDWealth4;SEConsOldPSIDWealth5;SESlopeOldPSIDWealth1; ...
             SESlopeOldPSIDWealth2;SESlopeOldPSIDWealth3;SESlopeOldPSIDWealth4;SESlopeOldPSIDWealth5;SEConsPSIDWealth1];


clear PSIDLifeCyclePanel PSIDInitWealthPanel PSIDInitEarnPanel lmslopePSIDWealth ConsPSIDWealth2 ConsPSIDWealth3 ConsPSIDWealth4 ConsPSIDWealth5 SlopeYoungPSIDWealth1 ...
             SlopeYoungPSIDWealth2 SlopeYoungPSIDWealth3 SlopeYoungPSIDWealth4 SlopeYoungPSIDWealth5 SlopeOldPSIDWealth1 ...
             SlopeOldPSIDWealth2 SlopeOldPSIDWealth3 SlopeOldPSIDWealth4 SlopeOldPSIDWealth5 ConsPSIDWealth1;

%%NLSY Life-Cycle Moments
%NLSY Moment selections:
%Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
%Age >30: Hours Worked in [520,5280] and Inc >=9750, averaged over 3 years

dataopts.dataset = 'NLSY';
dataopts.datasubset = [];
[NLSYSubPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, [], [], E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);

try
    lmslopeNLSY = fitlm(NLSYSubPanel,'LRIncHVY_3~AFQT_qtile + Age + AFQT_qtile:Age + AFQT_qtile1XAgeGrp2 + AFQT_qtile:AgeGrp + AFQT_qtile1XAgeXAgeGrp2 + AFQT_qtile:Age:AgeGrp');
    SlopeYoungNLSYAFQT1 = lmslopeNLSY.Coefficients.Estimate('Age');
    SlopeYoungNLSYAFQT2 = lmslopeNLSY.Coefficients.Estimate('Age:AFQT_qtile_2');
    SlopeYoungNLSYAFQT3 = lmslopeNLSY.Coefficients.Estimate('Age:AFQT_qtile_3');
    SlopeYoungNLSYAFQT4 = lmslopeNLSY.Coefficients.Estimate('Age:AFQT_qtile_4');
    SlopeYoungNLSYAFQT5 = lmslopeNLSY.Coefficients.Estimate('Age:AFQT_qtile_5');
    SlopeOldNLSYAFQT1 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile1XAgeXAgeGrp2');
    SlopeOldNLSYAFQT2 = lmslopeNLSY.Coefficients.Estimate('Age:AgeGrp_2:AFQT_qtile_2');
    SlopeOldNLSYAFQT3 = lmslopeNLSY.Coefficients.Estimate('Age:AgeGrp_2:AFQT_qtile_3');
    SlopeOldNLSYAFQT4 = lmslopeNLSY.Coefficients.Estimate('Age:AgeGrp_2:AFQT_qtile_4');
    SlopeOldNLSYAFQT5 = lmslopeNLSY.Coefficients.Estimate('Age:AgeGrp_2:AFQT_qtile_5');
    ConsNLSYAFQT1 = lmslopeNLSY.Coefficients.Estimate('(Intercept)');
    ConsNLSYAFQT2 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile_2');
    ConsNLSYAFQT3 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile_3');
    ConsNLSYAFQT4 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile_4');
    ConsNLSYAFQT5 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile_5');
    ConsOldNLSYAFQT1 = lmslopeNLSY.Coefficients.Estimate('AFQT_qtile1XAgeGrp2');
    ConsOldNLSYAFQT2 = lmslopeNLSY.Coefficients.Estimate('AgeGrp_2:AFQT_qtile_2');
    ConsOldNLSYAFQT3 = lmslopeNLSY.Coefficients.Estimate('AgeGrp_2:AFQT_qtile_3');
    ConsOldNLSYAFQT4 = lmslopeNLSY.Coefficients.Estimate('AgeGrp_2:AFQT_qtile_4');
    ConsOldNLSYAFQT5 = lmslopeNLSY.Coefficients.Estimate('AgeGrp_2:AFQT_qtile_5');

    SESlopeYoungNLSYAFQT1 = lmslopeNLSY.Coefficients.SE('Age');
    SESlopeYoungNLSYAFQT2 = lmslopeNLSY.Coefficients.SE('Age:AFQT_qtile_2');
    SESlopeYoungNLSYAFQT3 = lmslopeNLSY.Coefficients.SE('Age:AFQT_qtile_3');
    SESlopeYoungNLSYAFQT4 = lmslopeNLSY.Coefficients.SE('Age:AFQT_qtile_4');
    SESlopeYoungNLSYAFQT5 = lmslopeNLSY.Coefficients.SE('Age:AFQT_qtile_5');
    SESlopeOldNLSYAFQT1 = lmslopeNLSY.Coefficients.SE('AFQT_qtile1XAgeXAgeGrp2');
    SESlopeOldNLSYAFQT2 = lmslopeNLSY.Coefficients.SE('Age:AgeGrp_2:AFQT_qtile_2');
    SESlopeOldNLSYAFQT3 = lmslopeNLSY.Coefficients.SE('Age:AgeGrp_2:AFQT_qtile_3');
    SESlopeOldNLSYAFQT4 = lmslopeNLSY.Coefficients.SE('Age:AgeGrp_2:AFQT_qtile_4');
    SESlopeOldNLSYAFQT5 = lmslopeNLSY.Coefficients.SE('Age:AgeGrp_2:AFQT_qtile_5');
    SEConsNLSYAFQT1 = lmslopeNLSY.Coefficients.SE('(Intercept)');
    SEConsNLSYAFQT2 = lmslopeNLSY.Coefficients.SE('AFQT_qtile_2');
    SEConsNLSYAFQT3 = lmslopeNLSY.Coefficients.SE('AFQT_qtile_3');
    SEConsNLSYAFQT4 = lmslopeNLSY.Coefficients.SE('AFQT_qtile_4');
    SEConsNLSYAFQT5 = lmslopeNLSY.Coefficients.SE('AFQT_qtile_5');
    SEConsOldNLSYAFQT1 = lmslopeNLSY.Coefficients.SE('AFQT_qtile1XAgeGrp2');
    SEConsOldNLSYAFQT2 = lmslopeNLSY.Coefficients.SE('AgeGrp_2:AFQT_qtile_2');
    SEConsOldNLSYAFQT3 = lmslopeNLSY.Coefficients.SE('AgeGrp_2:AFQT_qtile_3');
    SEConsOldNLSYAFQT4 = lmslopeNLSY.Coefficients.SE('AgeGrp_2:AFQT_qtile_4');
    SEConsOldNLSYAFQT5 = lmslopeNLSY.Coefficients.SE('AgeGrp_2:AFQT_qtile_5');
catch
    SlopeYoungNLSYAFQT1 = NaN;
    SlopeYoungNLSYAFQT2 = NaN;
    SlopeYoungNLSYAFQT3 = NaN;
    SlopeYoungNLSYAFQT4 = NaN;
    SlopeYoungNLSYAFQT5 = NaN;
    SlopeOldNLSYAFQT1 = NaN;
    SlopeOldNLSYAFQT2 = NaN;
    SlopeOldNLSYAFQT3 = NaN;
    SlopeOldNLSYAFQT4 = NaN;
    SlopeOldNLSYAFQT5 = NaN;
    ConsNLSYAFQT1 = NaN;
    ConsNLSYAFQT2 = NaN;
    ConsNLSYAFQT3 = NaN;
    ConsNLSYAFQT4 = NaN;
    ConsNLSYAFQT5 = NaN;
    ConsOldNLSYAFQT1 = NaN;
    ConsOldNLSYAFQT2 = NaN;
    ConsOldNLSYAFQT3 = NaN;
    ConsOldNLSYAFQT4 = NaN;
    ConsOldNLSYAFQT5 = NaN;

    SESlopeYoungNLSYAFQT1 = NaN;
    SESlopeYoungNLSYAFQT2 = NaN;
    SESlopeYoungNLSYAFQT3 = NaN;
    SESlopeYoungNLSYAFQT4 = NaN;
    SESlopeYoungNLSYAFQT5 = NaN;
    SESlopeOldNLSYAFQT1 = NaN;
    SESlopeOldNLSYAFQT2 = NaN;
    SESlopeOldNLSYAFQT3 = NaN;
    SESlopeOldNLSYAFQT4 = NaN;
    SESlopeOldNLSYAFQT5 = NaN;
    SEConsNLSYAFQT1 = NaN;
    SEConsNLSYAFQT2 = NaN;
    SEConsNLSYAFQT3 = NaN;
    SEConsNLSYAFQT4 = NaN;
    SEConsNLSYAFQT5 = NaN;
    SEConsOldNLSYAFQT1 = NaN;
    SEConsOldNLSYAFQT2 = NaN;
    SEConsOldNLSYAFQT3 = NaN;
    SEConsOldNLSYAFQT4 = NaN;
    SEConsOldNLSYAFQT5 = NaN;

    err = 1;
end

betasAFQT = [SlopeYoungNLSYAFQT1;ConsNLSYAFQT2;ConsNLSYAFQT3;ConsNLSYAFQT4;ConsNLSYAFQT5;...
             SlopeYoungNLSYAFQT2;SlopeYoungNLSYAFQT3;SlopeYoungNLSYAFQT4;SlopeYoungNLSYAFQT5; ...
             ConsOldNLSYAFQT1;ConsOldNLSYAFQT2;ConsOldNLSYAFQT3;ConsOldNLSYAFQT4;ConsOldNLSYAFQT5;SlopeOldNLSYAFQT1;...
             SlopeOldNLSYAFQT2;SlopeOldNLSYAFQT3;SlopeOldNLSYAFQT4;SlopeOldNLSYAFQT5;ConsNLSYAFQT1];

SEsAFQT = [SESlopeYoungNLSYAFQT1;SEConsNLSYAFQT2;SEConsNLSYAFQT3;SEConsNLSYAFQT4;SEConsNLSYAFQT5;...
             SESlopeYoungNLSYAFQT2;SESlopeYoungNLSYAFQT3;SESlopeYoungNLSYAFQT4;SESlopeYoungNLSYAFQT5; ...
             SEConsOldNLSYAFQT1;SEConsOldNLSYAFQT2;SEConsOldNLSYAFQT3;SEConsOldNLSYAFQT4;SEConsOldNLSYAFQT5;SESlopeOldNLSYAFQT1; ...
             SESlopeOldNLSYAFQT2;SESlopeOldNLSYAFQT3;SESlopeOldNLSYAFQT4;SESlopeOldNLSYAFQT5;SEConsNLSYAFQT1];


try
    lmJ2JNLSY = grpstats(NLSYSubPanel(NLSYSubPanel.UnempAnInd==0,:),{'Age2ndGrp','RLiqWealth_qtile'},{'mean','sem'},'DataVars',{'J2JInd'});
    betasNLSYJ2JRate = lmJ2JNLSY.mean_J2JInd;
    SEsNLSYJ2JRate = lmJ2JNLSY.sem_J2JInd;
catch
    betasNLSYJ2JRate = zeros(30,1);
    SEsNLSYJ2JRate = zeros(30,1);
    err = 1;
end


clear NLSYSubPanel lmslopeNLSY ConsNLSYAFQT2 ConsNLSYAFQT3 ConsNLSYAFQT4 ConsNLSYAFQT5 SlopeNLSYAFQT1 ...
    SlopeNLSYAFQT2 SlopeNLSYAFQT3 SlopeNLSYAFQT4 SlopeNLSYAFQT5 ConsNLSYAFQT1 NLSYGrowthAgeGrp1 ...
    NLSYGrowthAgeGrp2 NLSYGrowthAgeGrp3 NLSYGrowthAgeGrp4 NLSYGrowthAgeGrp5 NLSYsameJobAgeGrp1 ...
    NLSYsameJobAgeGrp2 NLSYsameJobAgeGrp3 NLSYsameJobAgeGrp4 NLSYsameJobAgeGrp5;


modelmomentnames={'NetLiq.1stQuintile2Wage','LnAvgUIWage', ...
                  'NetLiq.1stQuintile2XLnAvgUIWage','AgeWage', ...
                  'LnLastWageWage','NetLiq.1stQuintile2XLnLastWageWage','ConstantSIPP', ...
                  'NetLiq.1stQuintile1XLnAvgUIHazard','NetLiq.2ndQuintile2XLogofUIHazard', ...
                  'AgeHazard','LnLastWageHazard' ...
                  strjoin({sprintf('AveAge%1.0f,',25:53),'AveAge54'}), ...
                  strjoin({sprintf('VarAge%1.0f,',25:53),'VarAge54'}), ...
                  strjoin({sprintf('Growth%1.0f,',1:2),'Growth3'}), ...
                  strjoin({sprintf('CovGrowth1x%1.0f,',1:2),'CovGrowth1x3'}), ...
                  'CovGrowth2x2','CovGrowth2x3','CovGrowth3x3', ...
                  'AgeNLSY','Cons30thAFQT','Cons50thAFQT', ...
                  'Cons70thAFQT','Cons90thAFQT','Slope30thAFQT','Slope50thAFQT', ...
                  'Slope70thAFQT','Slope90thAFQT','ConsAgeGrp210thAFQT', ...
                  'ConsAgeGrp230thAFQT','ConsAgeGrp250thAFQT','ConsAgeGrp270thAFQT', ...
                  'ConsAgeGrp290thAFQT','AgeAgeGrp2NLSY', ...
                  'SlopeAgeGrp230thAFQT','SlopeAgeGrp250thAFQT','SlopeAgeGrp270thAFQT', ...
                  'SlopeAgeGrp290thAFQT','ConstantNLSY','AgePSID','Cons30thWealth', ...
                  'Cons50thWealth','Cons70thWealth','Cons90thWealth', ...
                  'Slope30thWealth','Slope50thWealth','Slope70thWealth', ...
                  'Slope90thWealth','ConsAgeGrp210thWealth', ...
                  'ConsAgeGrp230thWealth','ConsAgeGrp250thWealth','ConsAgeGrp270thWealth', ...
                  'ConsAgeGrp290thWealth','AgeAgeGrp2PSID', ...
                  'SlopeAgeGrp230thWealth','SlopeAgeGrp250thWealth','SlopeAgeGrp270thWealth', ...
                  'SlopeAgeGrp290thWealth','ConstantPSID', ...
                  strjoin({sprintf('init_earnings%1.0f,',1:9),'init_earnings10'}), ...
                  strjoin({sprintf('init_wealth%1.0f,',1:9),'init_wealth10'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp1x%1.0f,',1:4),'NLSYJ2JRateAgeGrp1x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp2x%1.0f,',1:4),'NLSYJ2JRateAgeGrp2x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp3x%1.0f,',1:4),'NLSYJ2JRateAgeGrp3x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp4x%1.0f,',1:4),'NLSYJ2JRateAgeGrp4x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp5x%1.0f,',1:4),'NLSYJ2JRateAgeGrp5x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp6x%1.0f,',1:4),'NLSYJ2JRateAgeGrp6x5'}), ...
                 'UnempRate'};

modelmoments = [betasLM;betasCox;LifeCycleAve;LifeCycleVar;LRIncGrowthAve;LRIncGrowthCovMat;betasAFQT;betasWealth;RInc_qtiles;RWealth_qtiles;betasNLSYJ2JRate;UnempRate];

modelSEs = [SEsLM;SEsCox;SELifeCycleAve;SELifeCycleVar;SELRIncGrowthAve;SELRIncGrowthCovMat;SEsAFQT;SEsWealth;SERInc_qtiles;SERWealth_qtiles;SEsNLSYJ2JRate;UnempRateSE];


clear betasLM betasAFQT betasWealth betasNLSYsamejob RInc_qtiles RWealth_qtiles var_model UnempRate LifeCycleAve LifeCycleVar LRIncGrowthAve LRIncGrowthCovMat;

if size(modelmoments) == size(moments)
    diff = modelmoments - moments;
    W = weights;
    ssr = diff'*W*diff;
else
    diff = NaN;
    ssr = NaN;
    err = 1;
end

if isnan(ssr)
    err = 1;
end

ssr
err

nparams = length(params);

if exist(fullfile(pwd,opts.II_path,'II_FinalSims.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'II_FinalSims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'II_FinalSims.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'II_FinalSims.csv'),cat(2,ssr,modelmoments',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SE_FinalSims.csv'), 'file')
  dlmwrite(fullfile(pwd,opts.II_path,'SE_FinalSims.csv'),cat(2,ssr,modelSEs',params(1:nparams)'),'-append','precision',8);
else
  dlmwrite(fullfile(pwd,opts.II_path,'SE_FinalSims.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
  dlmwrite(fullfile(pwd,opts.II_path,'SE_FinalSims.csv'),cat(2,ssr,modelSEs',params(1:nparams)'),'-append','precision',8);
end

if exist(fullfile(pwd,opts.II_path,'SSR_FinalSims.csv'), 'file')
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_FinalSims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
else
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_FinalSims.csv'),cat(2,'ssr,',strjoin(modelmomentnames,','),',',sprintf('%s,',order{1:nparams})),'');
    dlmwrite(fullfile(pwd,opts.II_path,'SSR_FinalSims.csv'),cat(2,ssr,diff',params(1:nparams)'),'-append','precision',8);
end

betaests = modelmoments.';
SEests = modelSEs.';
clear modelmoments modelSEs ssr diff W;
end
