function [ssr, err] = CalcPlotMomentsFinal(params, order, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, earnings_profile, earnings_variance)
%% EMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);
    
    err = 0;
    exists = 1;
    i = 0;
    while exists ~= 0
        if isequal(exist(fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(i))),'dir'),7)
            exists = 1;
            i = i + 1;
        else
            opts.simulation_graphics_path = fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(i)));
            mkdir(opts.simulation_graphics_path);
            exists = 0;
        end
    end

    rng(9);
    maxiter = 2*S;
    randseed = datasample((1:maxiter).', maxiter,'Replace',false);

    if opts.momentsolve == 'y'
        Model(params, order, opts);
    end
    beta_ests = zeros(S,length(moments));
    SE_ests = zeros(S,length(moments));
    
    j = 1;
    i = 0;
    err = 0;
    fprintf('Entering Simulations\n');
    if opts.momentsim == 'y'
        while i < maxiter
            i = i + 1;
            fprintf('Performing Simulation %g, %g \n', i, j);
            if j <= S
                opts.savesim = 'n';
                [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, RR] = Simulation(params,order,opts, randseed(i));
                EE = gather(EE);
                UU = gather(UU);
                WW = gather(WW);
                AA = gather(AA);
                BB = gather(BB);
                CC = gather(CC);
                UB = gather(UB);
                MU = gather(MU);
                HH = gather(HH);
                TT = gather(TT);
                UT = gather(UT);
                E2E= gather(E2E);
                ET = gather(ET);
                LL = gather(LL);
                ZZ = gather(ZZ);
                WPrime = gather(WPrime);
                ThetaPrime = gather(ThetaPrime);
                TreatedInd = gather(TreatedInd);
                PInitHat = gather(PInitHat);
                RR = gather(RR);

                EE = EE(:,2:end);
                UU = UU(:,2:end);
                WW = WW(:,2:end);
                AA = AA(:,1:end-1);
                BB = BB(:,2:end);
                CC = CC(:,1:end-1);
                UB = UB(:,2:end);
                MU = MU(:,1:end-1);
                HH = HH(:,1:end-1);
                RR = RR(:,1:end-1);
                TT = TT(:,2:end);
                UT = UT(:,2:end);
                E2E= E2E(:,2:end);
                ET = ET(:,2:end);
                ZZ = ZZ(:,2:end);
                WPrime = WPrime(:,2:end);
                ThetaPrime = ThetaPrime(:,2:end);
                TreatedInd = TreatedInd(:,2:end);

                [err, esttemp, SEesttemp] = CalcFinalMoments(params, order, opts, nparams, moments, weights, NumObs, NObsNames, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, RR, TreatedInd, init_assets, init_earnings);
                clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;
                if err == 0
                    beta_ests(j,:) = esttemp;
                    SE_ests(j,:) = SEesttemp;
                    j = j + 1;
                else
                    fprintf('There was an error\n');
                end
            elseif j > S
                i = maxiter;
            end
        end
    

        fprintf('Saving Moments');
        [ssr, err] = CalcFinalError(moments, weights, beta_ests, SE_ests, j, opts, nparams, params, order);
    
    else
        fprintf('Saving Moments');
        [ssr, err] = CalcFinalError(moments, weights, beta_ests, SE_ests, 100, opts, nparams, params, order);
    end
    
    % PlotNonTargeted(moments, weights, beta_ests, j, opts, nparams, params, order);

end
