function [err, profileVals] = CalcProfiles(params, order, opts, calcOpts, statPanel)
%% CalcAverages m-file for Search and the Sources of Lifetime Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


% if testopts.treated == 'y'
%     for k=1:(nargin-6)
%         varargin{k} = varargin{k}(varargin{k}.Treated==1,:);
%     end
% end

if calcOpts.qtrly == 'y'
    meanVals = zeros(size(statPanel,2),T);
    varVals = zeros(size(statPanel,2),T);
else
    meanVals = zeros(size(statPanel,2),T./freq);
    varVals = zeros(size(statPanel,2),T./freq);
end
err = 0;

tmpPanel = zeros(size(statPanel));



for i = 2:size(statPanel,2)
    if isa(table2array(statPanel(:,i)),'double') == true
        tmpPanel(:,i) = table2array(statPanel(:,i));
    else
        tmpPanel(:,i) = NaN;
    end
end

tmpPanel = array2table(tmpPanel,'VariableNames',statPanel.Properties.VariableNames);


if strcmpi(calcOpts.qtile,'Wealth')
    tmpPanel.Wealth_qtileSort = statPanel.Wealth_qtile;
    tmpPanel.AgeSort = tmpPanel.Age;
    meanVals = repmat(reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),5,1,1);
    varVals = repmat(reshape(varVals,1,size(varVals,1),size(varVals,2)),5,1,1);
    try
        tmpvals = grpstats(tmpPanel,{'AgeSort','Wealth_qtileSort'},{'nanmean'});
        meanVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        tmpvals = grpstats(tmpPanel,{'AgeSort','Wealth_qtileSort'},{'nanvar'});
        varVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        clear tmpvals;
    catch
        err = 1;
    end
    profileVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2),size(meanVals,3)),reshape(varVals,1,size(varVals,1),size(varVals,2),size(varVals,3)));
elseif strcmpi(calcOpts.qtile,'HumanCap')
    tmpPanel.HumanCap_qtileSort = statPanel.HumanCap_qtile;
    tmpPanel.AgeSort = tmpPanel.Age;
    meanVals = repmat(reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),5,1,1);
    varVals = repmat(reshape(varVals,1,size(varVals,1),size(varVals,2)),5,1,1);
    try
        tmpvals = grpstats(tmpPanel,{'AgeSort','HumanCap_qtileSort'},{'nanmean'});
        meanVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        tmpvals = grpstats(tmpPanel,{'AgeSort','HumanCap_qtileSort'},{'nanvar'});
        varVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        clear tmpvals;
    catch
        err = 1;
    end
    profileVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2),size(meanVals,3)),reshape(varVals,1,size(varVals,1),size(varVals,2),size(varVals,3)));
elseif strcmpi(calcOpts.qtile,'Learn')
    tmpPanel.Learn_qtileSort = statPanel.Learn_qtile;
    tmpPanel.AgeSort = tmpPanel.Age;
    meanVals = repmat(reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),5,1,1);
    varVals = repmat(reshape(varVals,1,size(varVals,1),size(varVals,2)),5,1,1);
    try
        tmpvals = grpstats(tmpPanel,{'AgeSort','Learn_qtileSort'},{'nanmean'});
        meanVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        tmpvals = grpstats(tmpPanel,{'AgeSort','Learn_qtileSort'},{'nanvar'});
        varVals = permute(reshape(table2array(tmpvals(:,4:end)),5,size(tmpvals,1)./5,[]),[1,3,2]);
        clear tmpvals;
    catch
        err = 1;
    end
    profileVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2),size(meanVals,3)),reshape(varVals,1,size(varVals,1),size(varVals,2),size(varVals,3)));
else
    tmpPanel.AgeSort = tmpPanel.Age;
    try
        tmpvals = grpstats(tmpPanel,{'AgeSort'},{'nanmean'});
        meanVals = table2array(tmpvals(:,3:end)).';
        tmpvals = grpstats(tmpPanel,{'AgeSort'},{'nanvar'});
        varVals = table2array(tmpvals(:,3:end)).';
        clear tmpvals;
    catch
        err = 1;
    end
    profileVals = cat(1,reshape(meanVals,1,size(meanVals,1),size(meanVals,2)),reshape(varVals,1,size(varVals,1),size(varVals,2)));
end




end

