function [ScarAve,err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel)

err = 0;

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


%%Auxiliary Model 1: SIPP Moments
%SIPP Moment selections:
%Age > 21, Sex = Male, UI Receipt = Yes, Censor Duration at 1 year

if strcmpi(calcOpts.scarTest,'Unemp')
    % ScarringPanel.ScarSubset = ScarringPanel.UnempScarSubset;
    if strcmpi(calcOpts.qtile,'Wealth')
        linearmodelRInc = [' ~ Wealth_Presentqtile + J2UTreat + Wealth_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile + J2UTreat + Wealth_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile + J2UTreat + Wealth_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile + J2UTreat + Wealth_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat','J2UTreat:Wealth_Presentqtile_2','J2UTreat:Wealth_Presentqtile_3','J2UTreat:Wealth_Presentqtile_4','J2UTreat:Wealth_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'HumanCap')
        linearmodelRInc = [' ~ HumanCap_Presentqtile + J2UTreat + HumanCap_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ HumanCap_Presentqtile + J2UTreat + HumanCap_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ HumanCap_Presentqtile + J2UTreat + HumanCap_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ HumanCap_Presentqtile + J2UTreat + HumanCap_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat','J2UTreat:HumanCap_Presentqtile_2','J2UTreat:HumanCap_Presentqtile_3','J2UTreat:HumanCap_Presentqtile_4','J2UTreat:HumanCap_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'Learn')
        linearmodelRInc = [' ~ Learn_Presentqtile + J2UTreat + Learn_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Learn_Presentqtile + J2UTreat + Learn_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Learn_Presentqtile + J2UTreat + Learn_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Learn_Presentqtile + J2UTreat + Learn_Presentqtile:J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat','J2UTreat:Learn_Presentqtile_2','J2UTreat:Learn_Presentqtile_3','J2UTreat:Learn_Presentqtile_4','J2UTreat:Learn_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'Comp')
        linearmodelRInc = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat','J2UTreat:Wealth_Presentqtile2_1'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'CompFE')
        linearmodelRInc = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J + (1|IndID)'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J + (1|IndID)'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J + (1|IndID)'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J + (1|IndID)'];
        coefNames = {'J2UTreat','J2UTreat:Wealth_Presentqtile2_1'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'CompHrs')
        linearmodelRInc = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile2 + J2UTreat + Wealth_Presentqtile2:J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat','J2UTreat:Wealth_Presentqtile2_1'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    else
        linearmodelRInc = [' ~ J2UTreat + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ J2UTreat + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ J2UTreat + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ J2UTreat + Age + AgeSq + J2J'];
        coefNames = {'J2UTreat'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.J2UTreat));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    end
elseif strcmpi(calcOpts.scarTest,'Emp')
    % ScarringPanel.ScarSubset = ScarringPanel.EmpScarSubset;
    if strcmpi(calcOpts.qtile,'Wealth')
        linearmodelRInc = [' ~ Wealth_Presentqtile + EmpRisk + Wealth_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile + EmpRisk + Wealth_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile + EmpRisk + Wealth_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile + EmpRisk + Wealth_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile_2','EmpRisk:Wealth_Presentqtile_3','EmpRisk:Wealth_Presentqtile_4','EmpRisk:Wealth_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.LRInc1));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'HumanCap')
        linearmodelRInc = [' ~ HumanCap_Presentqtile + EmpRisk + HumanCap_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ HumanCap_Presentqtile + EmpRisk + HumanCap_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ HumanCap_Presentqtile + EmpRisk + HumanCap_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ HumanCap_Presentqtile + EmpRisk + HumanCap_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        coefNames = {'EmpRisk','EmpRisk:HumanCap_Presentqtile_2','EmpRisk:HumanCap_Presentqtile_3','EmpRisk:HumanCap_Presentqtile_4','EmpRisk:HumanCap_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.LRInc1));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'Learn')
        linearmodelRInc = [' ~ Learn_Presentqtile + EmpRisk + Learn_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Learn_Presentqtile + EmpRisk + Learn_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Learn_Presentqtile + EmpRisk + Learn_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Learn_Presentqtile + EmpRisk + Learn_Presentqtile:EmpRisk + Age + AgeSq + J2J'];
        coefNames = {'EmpRisk','EmpRisk:Learn_Presentqtile_2','EmpRisk:Learn_Presentqtile_3','EmpRisk:Learn_Presentqtile_4','EmpRisk:Learn_Presentqtile_5'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.LRInc1));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'CompEmp')
        linearmodelRInc = [' ~ Wealth_Presentqtile2 + EmpRisk + Wealth_Presentqtile2:EmpRisk + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile2 + EmpRisk + Wealth_Presentqtile2:EmpRisk + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile2 + EmpRisk + Wealth_Presentqtile2:EmpRisk + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile2 + EmpRisk + Wealth_Presentqtile2:EmpRisk + Age + AgeSq + J2J'];
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile2_1'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.LRInc1));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>0) = 1;
        % ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    elseif strcmpi(calcOpts.qtile,'CompUnemp')
        linearmodelRInc = [' ~ Wealth_Presentqtile2 + UnempRisk + Wealth_Presentqtile2:UnempRisk + Age + AgeSq + J2J'];
        linearmodelHumanCap = [' ~ Wealth_Presentqtile2 + UnempRisk + Wealth_Presentqtile2:UnempRisk + Age + AgeSq + J2J'];
        linearmodelPieceRate = [' ~ Wealth_Presentqtile2 + UnempRisk + Wealth_Presentqtile2:UnempRisk + Age + AgeSq + J2J'];
        linearmodelProdTime = [' ~ Wealth_Presentqtile2 + UnempRisk + Wealth_Presentqtile2:UnempRisk + Age + AgeSq + J2J'];
        coefNames = {'UnempRisk','UnempRisk:Wealth_Presentqtile2_1'};
        ScarringPanel.SubsetInd = zeros(size(ScarringPanel.LRInc1));
        ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>0) = 1;
        % ScarringPanel.SubsetInd(ScarringPanel.HrsWrked>520&ScarringPanel.RInc>=2375) = 1;
    end
end


if ~strcmpi(calcOpts.qtile,'CompFE')
    try

        ScarPSIDYear1 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc1',linearmodelRInc));
        ScarPSIDYear1Ave = reshape(ScarPSIDYear1.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear2 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc2',linearmodelRInc));
        ScarPSIDYear2Ave = reshape(ScarPSIDYear2.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear3 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc3',linearmodelRInc));
        ScarPSIDYear3Ave = reshape(ScarPSIDYear3.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear4 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc4',linearmodelRInc));
        ScarPSIDYear4Ave = reshape(ScarPSIDYear4.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear5 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc5',linearmodelRInc));
        ScarPSIDYear5Ave = reshape(ScarPSIDYear5.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear6 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc6',linearmodelRInc));
        ScarPSIDYear6Ave = reshape(ScarPSIDYear6.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear7 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc7',linearmodelRInc));
        ScarPSIDYear7Ave = reshape(ScarPSIDYear7.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear8 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc8',linearmodelRInc));
        ScarPSIDYear8Ave = reshape(ScarPSIDYear8.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear9 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc9',linearmodelRInc));
        ScarPSIDYear9Ave = reshape(ScarPSIDYear9.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear10 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc10',linearmodelRInc));
        ScarPSIDYear10Ave = reshape(ScarPSIDYear10.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear11 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc11',linearmodelRInc));
        ScarPSIDYear11Ave = reshape(ScarPSIDYear11.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear12 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc12',linearmodelRInc));
        ScarPSIDYear12Ave = reshape(ScarPSIDYear12.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear13 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc13',linearmodelRInc));
        ScarPSIDYear13Ave = reshape(ScarPSIDYear13.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear14 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc14',linearmodelRInc));
        ScarPSIDYear14Ave = reshape(ScarPSIDYear14.Coefficients.Estimate(coefNames),1,[]);
        ScarPSIDYear15 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc15',linearmodelRInc));
        ScarPSIDYear15Ave = reshape(ScarPSIDYear15.Coefficients.Estimate(coefNames),1,[]);


        ScarPieceRatePSIDYear1 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate1',linearmodelRInc));
        ScarPieceRatePSIDYear1Ave = reshape(ScarPieceRatePSIDYear1.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear2 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate2',linearmodelRInc));
        ScarPieceRatePSIDYear2Ave = reshape(ScarPieceRatePSIDYear2.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear3 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate3',linearmodelRInc));
        ScarPieceRatePSIDYear3Ave = reshape(ScarPieceRatePSIDYear3.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear4 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate4',linearmodelRInc));
        ScarPieceRatePSIDYear4Ave = reshape(ScarPieceRatePSIDYear4.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear5 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate5',linearmodelRInc));
        ScarPieceRatePSIDYear5Ave = reshape(ScarPieceRatePSIDYear5.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear6 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate6',linearmodelRInc));
        ScarPieceRatePSIDYear6Ave = reshape(ScarPieceRatePSIDYear6.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear7 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate7',linearmodelRInc));
        ScarPieceRatePSIDYear7Ave = reshape(ScarPieceRatePSIDYear7.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear8 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate8',linearmodelRInc));
        ScarPieceRatePSIDYear8Ave = reshape(ScarPieceRatePSIDYear8.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear9 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate9',linearmodelRInc));
        ScarPieceRatePSIDYear9Ave = reshape(ScarPieceRatePSIDYear9.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear10 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate10',linearmodelRInc));
        ScarPieceRatePSIDYear10Ave = reshape(ScarPieceRatePSIDYear10.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear11 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate11',linearmodelRInc));
        ScarPieceRatePSIDYear11Ave = reshape(ScarPieceRatePSIDYear11.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear12 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate12',linearmodelRInc));
        ScarPieceRatePSIDYear12Ave = reshape(ScarPieceRatePSIDYear12.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear13 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate13',linearmodelRInc));
        ScarPieceRatePSIDYear13Ave = reshape(ScarPieceRatePSIDYear13.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear14 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate14',linearmodelRInc));
        ScarPieceRatePSIDYear14Ave = reshape(ScarPieceRatePSIDYear14.Coefficients.Estimate(coefNames),1,[]);
        ScarPieceRatePSIDYear15 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate15',linearmodelRInc));
        ScarPieceRatePSIDYear15Ave = reshape(ScarPieceRatePSIDYear15.Coefficients.Estimate(coefNames),1,[]);


        ScarHumanCapPSIDYear1 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap1',linearmodelRInc));
        ScarHumanCapPSIDYear1Ave = reshape(ScarHumanCapPSIDYear1.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear2 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap2',linearmodelRInc));
        ScarHumanCapPSIDYear2Ave = reshape(ScarHumanCapPSIDYear2.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear3 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap3',linearmodelRInc));
        ScarHumanCapPSIDYear3Ave = reshape(ScarHumanCapPSIDYear3.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear4 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap4',linearmodelRInc));
        ScarHumanCapPSIDYear4Ave = reshape(ScarHumanCapPSIDYear4.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear5 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap5',linearmodelRInc));
        ScarHumanCapPSIDYear5Ave = reshape(ScarHumanCapPSIDYear5.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear6 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap6',linearmodelRInc));
        ScarHumanCapPSIDYear6Ave = reshape(ScarHumanCapPSIDYear6.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear7 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap7',linearmodelRInc));
        ScarHumanCapPSIDYear7Ave = reshape(ScarHumanCapPSIDYear7.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear8 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap8',linearmodelRInc));
        ScarHumanCapPSIDYear8Ave = reshape(ScarHumanCapPSIDYear8.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear9 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap9',linearmodelRInc));
        ScarHumanCapPSIDYear9Ave = reshape(ScarHumanCapPSIDYear9.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear10 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap10',linearmodelRInc));
        ScarHumanCapPSIDYear10Ave = reshape(ScarHumanCapPSIDYear10.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear11 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap11',linearmodelRInc));
        ScarHumanCapPSIDYear11Ave = reshape(ScarHumanCapPSIDYear11.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear12 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap12',linearmodelRInc));
        ScarHumanCapPSIDYear12Ave = reshape(ScarHumanCapPSIDYear12.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear13 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap13',linearmodelRInc));
        ScarHumanCapPSIDYear13Ave = reshape(ScarHumanCapPSIDYear13.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear14 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap14',linearmodelRInc));
        ScarHumanCapPSIDYear14Ave = reshape(ScarHumanCapPSIDYear14.Coefficients.Estimate(coefNames),1,[]);
        ScarHumanCapPSIDYear15 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap15',linearmodelRInc));
        ScarHumanCapPSIDYear15Ave = reshape(ScarHumanCapPSIDYear15.Coefficients.Estimate(coefNames),1,[]);


        ScarProdTimePSIDYear1 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime1',linearmodelRInc));
        ScarProdTimePSIDYear1Ave = reshape(ScarProdTimePSIDYear1.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear2 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime2',linearmodelRInc));
        ScarProdTimePSIDYear2Ave = reshape(ScarProdTimePSIDYear2.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear3 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime3',linearmodelRInc));
        ScarProdTimePSIDYear3Ave = reshape(ScarProdTimePSIDYear3.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear4 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime4',linearmodelRInc));
        ScarProdTimePSIDYear4Ave = reshape(ScarProdTimePSIDYear4.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear5 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime5',linearmodelRInc));
        ScarProdTimePSIDYear5Ave = reshape(ScarProdTimePSIDYear5.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear6 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime6',linearmodelRInc));
        ScarProdTimePSIDYear6Ave = reshape(ScarProdTimePSIDYear6.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear7 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime7',linearmodelRInc));
        ScarProdTimePSIDYear7Ave = reshape(ScarProdTimePSIDYear7.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear8 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime8',linearmodelRInc));
        ScarProdTimePSIDYear8Ave = reshape(ScarProdTimePSIDYear8.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear9 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime9',linearmodelRInc));
        ScarProdTimePSIDYear9Ave = reshape(ScarProdTimePSIDYear9.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear10 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime10',linearmodelRInc));
        ScarProdTimePSIDYear10Ave = reshape(ScarProdTimePSIDYear10.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear11 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime11',linearmodelRInc));
        ScarProdTimePSIDYear11Ave = reshape(ScarProdTimePSIDYear11.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear12 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime12',linearmodelRInc));
        ScarProdTimePSIDYear12Ave = reshape(ScarProdTimePSIDYear12.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear13 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime13',linearmodelRInc));
        ScarProdTimePSIDYear13Ave = reshape(ScarProdTimePSIDYear13.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear14 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime14',linearmodelRInc));
        ScarProdTimePSIDYear14Ave = reshape(ScarProdTimePSIDYear14.Coefficients.Estimate(coefNames),1,[]);
        ScarProdTimePSIDYear15 = fitlm(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime15',linearmodelRInc));
        ScarProdTimePSIDYear15Ave = reshape(ScarProdTimePSIDYear15.Coefficients.Estimate(coefNames),1,[]);

    catch
        ScarPSIDYear1Ave =  NaN;
        ScarPSIDYear2Ave =  NaN;
        ScarPSIDYear3Ave =  NaN;
        ScarPSIDYear4Ave =  NaN;
        ScarPSIDYear5Ave =  NaN;
        ScarPSIDYear6Ave =  NaN;
        ScarPSIDYear7Ave =  NaN;
        ScarPSIDYear8Ave =  NaN;
        ScarPSIDYear9Ave =  NaN;
        ScarPSIDYear10Ave =  NaN;
        ScarPSIDYear11Ave =  NaN;
        ScarPSIDYear12Ave =  NaN;
        ScarPSIDYear13Ave =  NaN;
        ScarPSIDYear14Ave =  NaN;
        ScarPSIDYear15Ave =  NaN;

        ScarHumanCapPSIDYear1Ave =  NaN;
        ScarHumanCapPSIDYear2Ave =  NaN;
        ScarHumanCapPSIDYear3Ave =  NaN;
        ScarHumanCapPSIDYear4Ave =  NaN;
        ScarHumanCapPSIDYear5Ave =  NaN;
        ScarHumanCapPSIDYear6Ave =  NaN;
        ScarHumanCapPSIDYear7Ave =  NaN;
        ScarHumanCapPSIDYear8Ave =  NaN;
        ScarHumanCapPSIDYear9Ave =  NaN;
        ScarHumanCapPSIDYear10Ave =  NaN;
        ScarHumanCapPSIDYear11Ave =  NaN;
        ScarHumanCapPSIDYear12Ave =  NaN;
        ScarHumanCapPSIDYear13Ave =  NaN;
        ScarHumanCapPSIDYear14Ave =  NaN;
        ScarHumanCapPSIDYear15Ave =  NaN;

        ScarPieceRatePSIDYear1Ave =  NaN;
        ScarPieceRatePSIDYear2Ave =  NaN;
        ScarPieceRatePSIDYear3Ave =  NaN;
        ScarPieceRatePSIDYear4Ave =  NaN;
        ScarPieceRatePSIDYear5Ave =  NaN;
        ScarPieceRatePSIDYear6Ave =  NaN;
        ScarPieceRatePSIDYear7Ave =  NaN;
        ScarPieceRatePSIDYear8Ave =  NaN;
        ScarPieceRatePSIDYear9Ave =  NaN;
        ScarPieceRatePSIDYear10Ave =  NaN;
        ScarPieceRatePSIDYear11Ave =  NaN;
        ScarPieceRatePSIDYear12Ave =  NaN;
        ScarPieceRatePSIDYear13Ave =  NaN;
        ScarPieceRatePSIDYear14Ave =  NaN;
        ScarPieceRatePSIDYear15Ave =  NaN;

        ScarProdTimePSIDYear1Ave =  NaN;
        ScarProdTimePSIDYear2Ave =  NaN;
        ScarProdTimePSIDYear3Ave =  NaN;
        ScarProdTimePSIDYear4Ave =  NaN;
        ScarProdTimePSIDYear5Ave =  NaN;
        ScarProdTimePSIDYear6Ave =  NaN;
        ScarProdTimePSIDYear7Ave =  NaN;
        ScarProdTimePSIDYear8Ave =  NaN;
        ScarProdTimePSIDYear9Ave =  NaN;
        ScarProdTimePSIDYear10Ave =  NaN;
        ScarProdTimePSIDYear11Ave =  NaN;
        ScarProdTimePSIDYear12Ave =  NaN;
        ScarProdTimePSIDYear13Ave =  NaN;
        ScarProdTimePSIDYear14Ave =  NaN;
        ScarProdTimePSIDYear15Ave =  NaN;
    end
else
    try
        ScarPSIDYear1 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc1',linearmodelRInc));
        ScarPSIDYear1Ave = reshape(ScarPSIDYear1.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear1.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear2 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc2',linearmodelRInc));
        ScarPSIDYear2Ave = reshape(ScarPSIDYear2.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear2.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear3 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc3',linearmodelRInc));
        ScarPSIDYear3Ave = reshape(ScarPSIDYear3.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear3.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear4 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc4',linearmodelRInc));
        ScarPSIDYear4Ave = reshape(ScarPSIDYear4.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear4.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear5 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc5',linearmodelRInc));
        ScarPSIDYear5Ave = reshape(ScarPSIDYear5.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear5.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear6 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc6',linearmodelRInc));
        ScarPSIDYear6Ave = reshape(ScarPSIDYear6.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear6.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear7 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc7',linearmodelRInc));
        ScarPSIDYear7Ave = reshape(ScarPSIDYear7.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear7.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear8 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc8',linearmodelRInc));
        ScarPSIDYear8Ave = reshape(ScarPSIDYear8.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear8.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear9 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc9',linearmodelRInc));
        ScarPSIDYear9Ave = reshape(ScarPSIDYear9.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear9.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear10 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc10',linearmodelRInc));
        ScarPSIDYear10Ave = reshape(ScarPSIDYear10.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear10.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear11 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc11',linearmodelRInc));
        ScarPSIDYear11Ave = reshape(ScarPSIDYear11.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear11.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear12 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc12',linearmodelRInc));
        ScarPSIDYear12Ave = reshape(ScarPSIDYear12.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear12.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear13 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc13',linearmodelRInc));
        ScarPSIDYear13Ave = reshape(ScarPSIDYear13.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear13.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear14 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc14',linearmodelRInc));
        ScarPSIDYear14Ave = reshape(ScarPSIDYear14.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear14.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPSIDYear15 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LRInc15',linearmodelRInc));
        ScarPSIDYear15Ave = reshape(ScarPSIDYear15.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPSIDYear15.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);


        ScarPieceRatePSIDYear1 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate1',linearmodelRInc));
        ScarPieceRatePSIDYear1Ave = reshape(ScarPieceRatePSIDYear1.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear1.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear2 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate2',linearmodelRInc));
        ScarPieceRatePSIDYear2Ave = reshape(ScarPieceRatePSIDYear2.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear2.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear3 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate3',linearmodelRInc));
        ScarPieceRatePSIDYear3Ave = reshape(ScarPieceRatePSIDYear3.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear3.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear4 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate4',linearmodelRInc));
        ScarPieceRatePSIDYear4Ave = reshape(ScarPieceRatePSIDYear4.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear4.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear5 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate5',linearmodelRInc));
        ScarPieceRatePSIDYear5Ave = reshape(ScarPieceRatePSIDYear5.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear5.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear6 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate6',linearmodelRInc));
        ScarPieceRatePSIDYear6Ave = reshape(ScarPieceRatePSIDYear6.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear6.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear7 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate7',linearmodelRInc));
        ScarPieceRatePSIDYear7Ave = reshape(ScarPieceRatePSIDYear7.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear7.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear8 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate8',linearmodelRInc));
        ScarPieceRatePSIDYear8Ave = reshape(ScarPieceRatePSIDYear8.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear8.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear9 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate9',linearmodelRInc));
        ScarPieceRatePSIDYear9Ave = reshape(ScarPieceRatePSIDYear9.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear9.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear10 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate10',linearmodelRInc));
        ScarPieceRatePSIDYear10Ave = reshape(ScarPieceRatePSIDYear10.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear10.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear11 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate11',linearmodelRInc));
        ScarPieceRatePSIDYear11Ave = reshape(ScarPieceRatePSIDYear11.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear11.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear12 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate12',linearmodelRInc));
        ScarPieceRatePSIDYear12Ave = reshape(ScarPieceRatePSIDYear12.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear12.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear13 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate13',linearmodelRInc));
        ScarPieceRatePSIDYear13Ave = reshape(ScarPieceRatePSIDYear13.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear13.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear14 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate14',linearmodelRInc));
        ScarPieceRatePSIDYear14Ave = reshape(ScarPieceRatePSIDYear14.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear14.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarPieceRatePSIDYear15 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LPieceRate15',linearmodelRInc));
        ScarPieceRatePSIDYear15Ave = reshape(ScarPieceRatePSIDYear15.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarPieceRatePSIDYear15.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);


        ScarHumanCapPSIDYear1 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap1',linearmodelRInc));
        ScarHumanCapPSIDYear1Ave = reshape(ScarHumanCapPSIDYear1.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear1.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear2 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap2',linearmodelRInc));
        ScarHumanCapPSIDYear2Ave = reshape(ScarHumanCapPSIDYear2.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear2.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear3 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap3',linearmodelRInc));
        ScarHumanCapPSIDYear3Ave = reshape(ScarHumanCapPSIDYear3.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear3.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear4 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap4',linearmodelRInc));
        ScarHumanCapPSIDYear4Ave = reshape(ScarHumanCapPSIDYear4.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear4.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear5 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap5',linearmodelRInc));
        ScarHumanCapPSIDYear5Ave = reshape(ScarHumanCapPSIDYear5.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear5.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear6 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap6',linearmodelRInc));
        ScarHumanCapPSIDYear6Ave = reshape(ScarHumanCapPSIDYear6.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear6.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear7 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap7',linearmodelRInc));
        ScarHumanCapPSIDYear7Ave = reshape(ScarHumanCapPSIDYear7.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear7.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear8 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap8',linearmodelRInc));
        ScarHumanCapPSIDYear8Ave = reshape(ScarHumanCapPSIDYear8.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear8.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear9 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap9',linearmodelRInc));
        ScarHumanCapPSIDYear9Ave = reshape(ScarHumanCapPSIDYear9.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear9.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear10 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap10',linearmodelRInc));
        ScarHumanCapPSIDYear10Ave = reshape(ScarHumanCapPSIDYear10.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear10.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear11 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap11',linearmodelRInc));
        ScarHumanCapPSIDYear11Ave = reshape(ScarHumanCapPSIDYear11.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear11.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear12 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap12',linearmodelRInc));
        ScarHumanCapPSIDYear12Ave = reshape(ScarHumanCapPSIDYear12.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear12.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear13 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap13',linearmodelRInc));
        ScarHumanCapPSIDYear13Ave = reshape(ScarHumanCapPSIDYear13.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear13.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear14 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap14',linearmodelRInc));
        ScarHumanCapPSIDYear14Ave = reshape(ScarHumanCapPSIDYear14.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear14.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarHumanCapPSIDYear15 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LHumanCap15',linearmodelRInc));
        ScarHumanCapPSIDYear15Ave = reshape(ScarHumanCapPSIDYear15.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarHumanCapPSIDYear15.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);


        ScarProdTimePSIDYear1 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime1',linearmodelRInc));
        ScarProdTimePSIDYear1Ave = reshape(ScarProdTimePSIDYear1.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear1.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear2 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime2',linearmodelRInc));
        ScarProdTimePSIDYear2Ave = reshape(ScarProdTimePSIDYear2.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear2.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear3 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime3',linearmodelRInc));
        ScarProdTimePSIDYear3Ave = reshape(ScarProdTimePSIDYear3.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear3.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear4 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime4',linearmodelRInc));
        ScarProdTimePSIDYear4Ave = reshape(ScarProdTimePSIDYear4.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear4.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear5 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime5',linearmodelRInc));
        ScarProdTimePSIDYear5Ave = reshape(ScarProdTimePSIDYear5.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear5.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear6 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime6',linearmodelRInc));
        ScarProdTimePSIDYear6Ave = reshape(ScarProdTimePSIDYear6.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear6.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear7 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime7',linearmodelRInc));
        ScarProdTimePSIDYear7Ave = reshape(ScarProdTimePSIDYear7.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear7.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear8 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime8',linearmodelRInc));
        ScarProdTimePSIDYear8Ave = reshape(ScarProdTimePSIDYear8.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear8.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear9 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime9',linearmodelRInc));
        ScarProdTimePSIDYear9Ave = reshape(ScarProdTimePSIDYear9.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear9.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear10 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime10',linearmodelRInc));
        ScarProdTimePSIDYear10Ave = reshape(ScarProdTimePSIDYear10.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear10.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear11 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime11',linearmodelRInc));
        ScarProdTimePSIDYear11Ave = reshape(ScarProdTimePSIDYear11.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear11.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear12 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime12',linearmodelRInc));
        ScarProdTimePSIDYear12Ave = reshape(ScarProdTimePSIDYear12.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear12.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear13 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime13',linearmodelRInc));
        ScarProdTimePSIDYear13Ave = reshape(ScarProdTimePSIDYear13.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear13.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear14 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime14',linearmodelRInc));
        ScarProdTimePSIDYear14Ave = reshape(ScarProdTimePSIDYear14.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear14.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);
        ScarProdTimePSIDYear15 = fitglme(ScarringPanel(ScarringPanel.SubsetInd==1,:),strcat('LProdTime15',linearmodelRInc));
        ScarProdTimePSIDYear15Ave = reshape(ScarProdTimePSIDYear15.Coefficients.Estimate(cell2mat(cellfun(@(c) find(strcmpi(ScarProdTimePSIDYear15.CoefficientNames,c)), coefNames,'UniformOutput',false))),1,[]);

    catch
        ScarPSIDYear1Ave =  NaN;
        ScarPSIDYear2Ave =  NaN;
        ScarPSIDYear3Ave =  NaN;
        ScarPSIDYear4Ave =  NaN;
        ScarPSIDYear5Ave =  NaN;
        ScarPSIDYear6Ave =  NaN;
        ScarPSIDYear7Ave =  NaN;
        ScarPSIDYear8Ave =  NaN;
        ScarPSIDYear9Ave =  NaN;
        ScarPSIDYear10Ave =  NaN;
        ScarPSIDYear11Ave =  NaN;
        ScarPSIDYear12Ave =  NaN;
        ScarPSIDYear13Ave =  NaN;
        ScarPSIDYear14Ave =  NaN;
        ScarPSIDYear15Ave =  NaN;

        ScarHumanCapPSIDYear1Ave =  NaN;
        ScarHumanCapPSIDYear2Ave =  NaN;
        ScarHumanCapPSIDYear3Ave =  NaN;
        ScarHumanCapPSIDYear4Ave =  NaN;
        ScarHumanCapPSIDYear5Ave =  NaN;
        ScarHumanCapPSIDYear6Ave =  NaN;
        ScarHumanCapPSIDYear7Ave =  NaN;
        ScarHumanCapPSIDYear8Ave =  NaN;
        ScarHumanCapPSIDYear9Ave =  NaN;
        ScarHumanCapPSIDYear10Ave =  NaN;
        ScarHumanCapPSIDYear11Ave =  NaN;
        ScarHumanCapPSIDYear12Ave =  NaN;
        ScarHumanCapPSIDYear13Ave =  NaN;
        ScarHumanCapPSIDYear14Ave =  NaN;
        ScarHumanCapPSIDYear15Ave =  NaN;

        ScarPieceRatePSIDYear1Ave =  NaN;
        ScarPieceRatePSIDYear2Ave =  NaN;
        ScarPieceRatePSIDYear3Ave =  NaN;
        ScarPieceRatePSIDYear4Ave =  NaN;
        ScarPieceRatePSIDYear5Ave =  NaN;
        ScarPieceRatePSIDYear6Ave =  NaN;
        ScarPieceRatePSIDYear7Ave =  NaN;
        ScarPieceRatePSIDYear8Ave =  NaN;
        ScarPieceRatePSIDYear9Ave =  NaN;
        ScarPieceRatePSIDYear10Ave =  NaN;
        ScarPieceRatePSIDYear11Ave =  NaN;
        ScarPieceRatePSIDYear12Ave =  NaN;
        ScarPieceRatePSIDYear13Ave =  NaN;
        ScarPieceRatePSIDYear14Ave =  NaN;
        ScarPieceRatePSIDYear15Ave =  NaN;

        ScarProdTimePSIDYear1Ave =  NaN;
        ScarProdTimePSIDYear2Ave =  NaN;
        ScarProdTimePSIDYear3Ave =  NaN;
        ScarProdTimePSIDYear4Ave =  NaN;
        ScarProdTimePSIDYear5Ave =  NaN;
        ScarProdTimePSIDYear6Ave =  NaN;
        ScarProdTimePSIDYear7Ave =  NaN;
        ScarProdTimePSIDYear8Ave =  NaN;
        ScarProdTimePSIDYear9Ave =  NaN;
        ScarProdTimePSIDYear10Ave =  NaN;
        ScarProdTimePSIDYear11Ave =  NaN;
        ScarProdTimePSIDYear12Ave =  NaN;
        ScarProdTimePSIDYear13Ave =  NaN;
        ScarProdTimePSIDYear14Ave =  NaN;
        ScarProdTimePSIDYear15Ave =  NaN;
    end
end

    ScarPSIDAve = [ScarPSIDYear1Ave;ScarPSIDYear2Ave;ScarPSIDYear3Ave;ScarPSIDYear4Ave; ...
                        ScarPSIDYear5Ave;ScarPSIDYear6Ave;ScarPSIDYear7Ave;ScarPSIDYear8Ave; ...
                        ScarPSIDYear9Ave;ScarPSIDYear10Ave;ScarPSIDYear11Ave;ScarPSIDYear12Ave; ...
                        ScarPSIDYear13Ave;ScarPSIDYear14Ave;ScarPSIDYear15Ave];


    ScarHumanCapPSIDAve = [ScarHumanCapPSIDYear1Ave;ScarHumanCapPSIDYear2Ave;ScarHumanCapPSIDYear3Ave;ScarHumanCapPSIDYear4Ave; ...
                        ScarHumanCapPSIDYear5Ave;ScarHumanCapPSIDYear6Ave;ScarHumanCapPSIDYear7Ave;ScarHumanCapPSIDYear8Ave; ...
                        ScarHumanCapPSIDYear9Ave;ScarHumanCapPSIDYear10Ave;ScarHumanCapPSIDYear11Ave;ScarHumanCapPSIDYear12Ave; ...
                        ScarHumanCapPSIDYear13Ave;ScarHumanCapPSIDYear14Ave;ScarHumanCapPSIDYear15Ave];

    ScarPieceRatePSIDAve = [ScarPieceRatePSIDYear1Ave;ScarPieceRatePSIDYear2Ave;ScarPieceRatePSIDYear3Ave;ScarPieceRatePSIDYear4Ave; ...
                        ScarPieceRatePSIDYear5Ave;ScarPieceRatePSIDYear6Ave;ScarPieceRatePSIDYear7Ave;ScarPieceRatePSIDYear8Ave; ...
                        ScarPieceRatePSIDYear9Ave;ScarPieceRatePSIDYear10Ave;ScarPieceRatePSIDYear11Ave;ScarPieceRatePSIDYear12Ave; ...
                        ScarPieceRatePSIDYear13Ave;ScarPieceRatePSIDYear14Ave;ScarPieceRatePSIDYear15Ave];

    ScarProdTimePSIDAve = [ScarProdTimePSIDYear1Ave;ScarProdTimePSIDYear2Ave;ScarProdTimePSIDYear3Ave;ScarProdTimePSIDYear4Ave; ...
                        ScarProdTimePSIDYear5Ave;ScarProdTimePSIDYear6Ave;ScarProdTimePSIDYear7Ave;ScarProdTimePSIDYear8Ave; ...
                        ScarProdTimePSIDYear9Ave;ScarProdTimePSIDYear10Ave;ScarProdTimePSIDYear11Ave;ScarProdTimePSIDYear12Ave; ...
                        ScarProdTimePSIDYear13Ave;ScarProdTimePSIDYear14Ave;ScarProdTimePSIDYear15Ave];


if strcmpi(calcOpts.qtile,'n')
    ScarAve = cat(1,ScarPSIDAve.',ScarPieceRatePSIDAve.',ScarHumanCapPSIDAve.',ScarProdTimePSIDAve.');
else
    ScarAve = cat(2,reshape(ScarPSIDAve.',size(ScarPSIDAve,2),1,size(ScarPSIDAve,1)),reshape(ScarPieceRatePSIDAve.',size(ScarPieceRatePSIDAve,2),1,size(ScarPieceRatePSIDAve,1)),reshape(ScarHumanCapPSIDAve.',size(ScarHumanCapPSIDAve,2),1,size(ScarHumanCapPSIDAve,1)),reshape(ScarProdTimePSIDAve.',size(ScarProdTimePSIDAve,2),1,size(ScarProdTimePSIDAve,1)));
end

end
