function [Z,Zpdf,Zcdf] = CompTrapIntegration(nodes,MMu,SSig,SStd)
%%CompTrapIntegration  m-file for Borrowing Constraints, Search, and Life-Cycle Inequality
%Author: Ben Griffy
%Date: Apr., 2017
%
%Purpose:    Approximate an iid Normal shock
%
%Format:     {Z, Zpdf, Zcdf} = iidShocks(N,mu,sigma,m)
%
%Input:      N       scalar, number of nodes for Z
%            mu      scalar, unconditional mean of process
%            sigma   scalar, std. dev. of epsilons
%            m       max +- std. devs.
%
%Output:     Z       N*1 vector, nodes for Z
%            ZPDF   N*1 matrix, probabilities
%
%


Z     = zeros(nodes,1);
Zpdf = zeros(nodes,1);

Z(nodes)  = MMu + SStd*sqrt(SSig^2);
Z(1)  = MMu - SStd*sqrt(SSig^2);
zstep = (Z(nodes) - Z(1))/(nodes - 1);

for i=2:(nodes-1)
    Z(i) = Z(1) + zstep*(i - 1);
end 

for k = 1:nodes
    if k == 1
        Zpdf(k,1) = normcdf((Z(1) + (zstep/2)),MMu,SSig);
        Zcdf(k,1) = Zpdf(k,1);
    elseif k == nodes
        Zpdf(k,1) = 1 - normcdf((Z(k) - (zstep/2)),MMu,SSig);
        Zcdf(k,1) = 1;
    else
        Zpdf(k,1) = normcdf((Z(k) + (zstep/2)),MMu,SSig) - ...
            normcdf((Z(k) - (zstep/2)),MMu,SSig);
        Zcdf(k,1) = normcdf((Z(k) + (zstep/2)),MMu,SSig);
    end
end


function c = cdf_normal(x)
    c = 0.5 * erfc(-x/sqrt(2));

