function [Panel,err] = DataPanels(params, order, opts, NumObs, NObsNames, DD, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, ThetaPrimeHat, TreatedInd, PInitHat, initQtiles, dataopts)
%%DataPanels m-File for Borrowing Constraints, Search, and Life-Cycle Inequality
% This file creates panels identical to those in the data for indirect inference
% Author: Ben Griffy, Sept., 2017
err = 0;

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

% rng('shuffle');

%rng(140);

alb = geosum(r,bl,T);
% $$$ w0 = (w0/freq);
if ~strcmpi(dataopts.dataset,'ScarringPanel') & ~strcmpi(dataopts.dataset,'EmpRiskPanel')
    if ~isempty(WW)&&~isempty(EE)
        IW = WW.*EE;
        IWAn = reshape(sum(reshape(IW.',freq,N*(T/freq)),1),T/freq,N).';
        IWAn = IWAn.*w0;
    end
    if ~isempty(WW)&&~isempty(EE)&&~isempty(TT)
        EW = WW.*(1 - TT).*EE;
        MeasErr = normrnd(0,SigXi,size(EW));
        LastMeasErr = normrnd(0,SigXi,size(EW));
        EW = exp(MeasErr).*EW;
        EWAn = reshape(sum(reshape(EW.',freq,N*(T/freq)),1),T/freq,N).';
        EWAn = EWAn.*w0;
        MeasErrAn = reshape(sum(reshape(MeasErr.',freq,N*(T/freq)),1),T/freq,N).';
        LastMeasErrAn = reshape(sum(reshape(LastMeasErr.',freq,N*(T/freq)),1),T/freq,N).';
    end
    if ~isempty(MU)
        MUAn = reshape(sum(reshape(MU.',freq,N*(T/freq)),1),T/freq,N).';
        MWAn = MUAn.*w0;
        MUAn = MUAn./freq;
        MUAn = MU;
        MUAn(EE==0) = NaN;
        MUAn = reshape(nanmean(reshape(MUAn.',freq,N*(T/freq)),1),T/freq,N).';
    end
    if ~isempty(TT)
        TTAn = reshape(sum(reshape(TT.',freq,N*(T/freq)),1),T/freq,N).';
        TTAn = TTAn./freq;
        if ~isempty(EE)
            TW = TT.*EE;
            TWAn = reshape(sum(reshape(TW.',freq,N*(T/freq)),1),T/freq,N).';
            TWProdAn = TWAn.*w0;
            TWAn = TWAn./freq;
        end
    end
    if ~isempty(EE)
        EEAn = reshape(sum(reshape(EE.',freq,N*(T/freq)),1),T/freq,N).';
        ETAn = EEAn./freq;
        EEAnInd = EEAn;
        EEAnInd(EEAnInd>0) = 1;
    end
    if ~isempty(UU)
        UUAn = reshape(sum(reshape(UU.',freq,N*(T/freq)),1),T/freq,N).';
        UTAn = UUAn./freq;
        UUAnInd = UUAn;
        UUAnInd(UUAnInd>0) = 1;
        UnempIntInd = UU(:,1:freq:end);
    end
    if ~isempty(BB)
        BBAn = reshape(sum(reshape(BB.',freq,N*(T/freq)),1),T/freq,N).';
        BTAn = BBAn./freq;
    end
    if ~isempty(CC)
        CCAn = reshape(sum(reshape(CC.',freq,N*(T/freq)),1),T/freq,N).';
        CCAn = CCAn.*w0;
        if ~isempty(WW)&&~isempty(EE)
            MPCAn = CCAn./EWAn;
        end
    end
    if ~isempty(HH)
        HHAn = HH(:,1:freq:end);
        ProdAn = HHAn.*w0;
    end
    if ~isempty(AA)
        AAAn = AA(:,1:freq:end);
        LiqAn = AAAn.*w0;
    end
    if ~isempty(ET)
        TenAn = ET(:,1:freq:end);
    end
    if ~isempty(UT)
        DurAn = reshape(sum(reshape(UT.',freq,N*(T/freq)),1),T/freq,N).';
        IntDur = UT(:,1:freq:end);
        UnempAnInd = (DurAn>0);
    end
    if ~isempty(UE)
        UEAn = reshape(sum(reshape(UE(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
        UEAnInd = UEAn;
        UEAnInd(UEAnInd>0) = 1;
    end
    if ~isempty(EU)
        EUAn = reshape(sum(reshape(EU(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
        EUAnInd = EUAn;
        EUAnInd(EUAnInd>0) = 1;
    end
    if ~isempty(E2E)
        E2EAn = reshape(sum(reshape(E2E.',freq,N*(T/freq)),1),T/freq,N).';
        E2EAnInd = E2EAn;
        E2EAnInd(E2EAnInd>0) = 1;
        if ~isempty(UU)&~isempty(EE)
            sameJob = EEAnInd;
            sameJob(E2EAnInd==1|UUAnInd==1) = 0;
        end
    end
    if ~isempty(UB)
        UBAn = reshape(sum(reshape(UB.',freq,N*(T/freq)),1),T/freq,N).';
        UBAn = UBAn.*w0;
    end
    if ~isempty(WW)&&~isempty(EE)&&~isempty(AA)&&~isempty(BB)&&~isempty(UU)
        Budget = EWAn + AAAn + UBAn + (UUAn - BBAn).*bl - bl./(1 + r);
        if ~isempty(CC)
            MPCBAn = CCAn./Budget;
        end
    end
    if ~isempty(LL)
        LLt = reshape(LL,N,1);
        AFQT  = LL;
    end
    if ~isempty(WPrime)
        WPrimeAn = reshape(sum(reshape(WPrime.',freq,N*(T/freq)),1),T/freq,N).';
        WPrimeAn = WPrimeAn./freq;
    end
    if ~isempty(ThetaPrime)
        ThetaPrimeAn = reshape(sum(reshape(ThetaPrime.',freq,N*(T/freq)),1),T/freq,N).';
        ThetaPrimeAn = ThetaPrimeAn./freq;
        PPrimeAn = reshape(sum(reshape(p(ThetaPrime).',freq,N*(T/freq)),1),T/freq,N).';
        PPrimeAn = PPrimeAn./freq;
    end
    if ~isempty(ZZ)
        ZZAn = reshape(sum(reshape(ZZ.',freq,N*(T/freq)),1),T/freq,N).';
        ZZProdAn = ZZAn.*w0;
    end
else
    if ~isempty(WW)&&~isempty(EE)&&~isempty(TT)
        EW = WW(:,2:end,:).*(1 - TT(:,2:end,:)).*EE(:,2:end,:);
        MeasErr = normrnd(0,SigXi,size(EW));
        LastMeasErr = normrnd(0,SigXi,size(EW));
        EW = exp(MeasErr).*EW;
        EWAn = squeeze(sum(reshape(EW,2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(MU)
        MUAn = MU(:,2:end,:);
        MUAn(EE(:,2:end,:)==0) = NaN;
        MUAn = squeeze(nanmean(reshape(MUAn,2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(TT)
        TTAn = TT(:,2:end,:);
        TTAn = squeeze(nanmean(reshape(TTAn,2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(EE)
        EEAn = squeeze(sum(reshape(EE(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        ETAn = EEAn./freq;
        EEAnInd = EEAn;
        EEAnInd(EEAnInd>0) = 1;
    end
    if ~isempty(UU)
        UUAn = squeeze(sum(reshape(UU(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        UTAn = UUAn./freq;
        UUAnInd = UUAn;
        UUAnInd(UUAnInd>0) = 1;
        UnempIntInd = UU(:,1:freq:end,:);
    end
    if ~isempty(BB)
        BBAn = squeeze(sum(reshape(BB(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        BBAnInd(BBAn>0) = 1;
    end
    if ~isempty(CC)
        CCAn = squeeze(sum(reshape(CC(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(HH)
        HHAn = HH(:,1:freq:end,:);
    end
    if ~isempty(AA)
        AAAn = AA(:,1:freq:end,:);
    end
    if ~isempty(ET)
        TenAn = ET(:,1:freq:end,:);
    end
    if ~isempty(UT)
        DurAn = squeeze(sum(reshape(UT(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        IntDur = UT(:,1:freq:end,:);
        UnempAnInd = (DurAn>0);
    end
    if ~isempty(UE)
        UEAn = squeeze(sum(reshape(UE(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        UEAnInd = UEAn;
        UEAnInd(UEAnInd>0) = 1;
    end
    if ~isempty(EU)
        EUAn = squeeze(sum(reshape(EU(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        EUAnInd = EUAn;
        EUAnInd(EUAnInd>0) = 1;
    end
    if ~isempty(E2E)
        E2EAn = squeeze(sum(reshape(E2E(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        E2EAnInd = E2EAn;
        E2EAnInd(E2EAnInd>0) = 1;
    end
    if ~isempty(UB)
        UBAn = squeeze(sum(reshape(UB(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(WPrime)
        WPrimeAn = squeeze(nanmean(reshape(WPrime(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(ThetaPrime)
        ThetaPrimeAn = squeeze(sum(reshape(ThetaPrime(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        PPrimeAn = squeeze(sum(reshape(p(ThetaPrime(:,2:end,:)),2*NScar,freq,TScar./freq,T-TScar+1),2));
        UnempProbAn = squeeze(prod(reshape(1-p(ThetaPrime(:,2:end,:)),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(ThetaPrimeHat)
        PPrimeHat = p(ThetaPrimeHat(:,2:end,:));
        UnempProbHat = 1 - PPrimeHat;
        UnempProbHatAn = squeeze(prod(reshape(UnempProbHat,2*NScar,freq,TScar./freq,T-TScar+1),2));
        ThetaPrimeHatAn = squeeze(sum(reshape(ThetaPrimeHat(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
        PPrimeAn = squeeze(sum(reshape(p(ThetaPrimeHat(:,2:end,:)),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
    if ~isempty(ZZ)
        ZZAn = squeeze(sum(reshape(ZZ(:,2:end,:),2*NScar,freq,TScar./freq,T-TScar+1),2));
    end
end


if strcmpi(dataopts.dataset,'SIPP')

    %%Auxiliary Model 1: SIPP Moments
    %SIPP Moment selections:
    %Age > 23, Sex = Male, UI Receipt = Yes, Censor Duration at 1 year
    %nobsAux1 = tabconv(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1),'y');

    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A));
    nobsAux1A = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A_1));
    nobsAux1A_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A_2));
    nobsAux1A_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A_3));
    nobsAux1A_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A_4));
    nobsAux1A_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1A_5));
    nobsAux1A_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1B));
    nobsAux1B = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux1C));
    nobsAux1C = temp;
    clear temp;

    Agepanel = floor(23 + (0:T-1)./freq);
    Agepanel = ones(N,1)*Agepanel;

    Freqpanel = (1:T);
    Freqpanel = ones(N,1)*Freqpanel;

    IndID = 1:NumObs.SIPP;
    IndID = IndID'*ones(1,T);

    panel = cat(2,reshape(IndID.',[],1), reshape(Agepanel(1:NumObs.SIPP,:).',[],1), reshape(Freqpanel(1:NumObs.SIPP,:).',[],1), ...
                reshape(EE(1:NumObs.SIPP,:).',[],1), reshape(UU(1:NumObs.SIPP,:).',[],1), reshape((AA(1:NumObs.SIPP,:).*w0).',[],1), ...
                reshape(BB(1:NumObs.SIPP,:).',[],1), reshape((UB(1:NumObs.SIPP,:).*w0).',[],1), ...
                reshape((EW(1:NumObs.SIPP,:).*w0).',[],1), reshape((52./freq)*UT(1:NumObs.SIPP,:).',[],1), reshape(TT(1:NumObs.SIPP,:).',[],1), ...
                reshape(HH(1:NumObs.SIPP,:).',[],1));

    %panel: 1:IndID, 2:Age, 3:Panel Date, 4:Employment EOP status, 5:Unemployment EOP status,
    %6:Wealth Scaled Annually, 7:Benefits Status, 8:Benefits Amount Scaled to Freq,
    %9:Wage Scaled to Freq, %10:Unemployment Duration in Freq Units,
    %11:Human Capital



    temp = zeros(size(panel(:,10)));
    temp(find(panel(:,10)>0),:) = 1;
    temp = reshape(temp,T,NumObs.SIPP);
    dur  = UT(1:NumObs.SIPP,:)';

    spell = ones(size(temp));
    for i=2:T
        spell(i,:) = spell(i-1,:) + temp(i,:).*min((1 - temp(i-1,:).*(dur(i,:) - dur(i-1,:))),1);
    end

    spell = spell.*temp;
    spellstart = spell;
    spellstart(2:end,:) = max(min(spellstart(2:end,:)-spellstart(1:end-1,:),1),0);

    lastwage = zeros(size(EW(1:NumObs.SIPP,:).'));
    lastwage(2:end,:) = (EW(1:NumObs.SIPP,1:end-1).*w0).'.*spellstart(2:end,:);
    lastwage(lastwage == 0) = NaN;
    lastwage = fillmissing(lastwage,'previous');

    % should average over previous year rather than last wage. will reduce bias from time spent learning.
    %lastwage = (EW(1:NumObs.SIPP,:).*w0).'.*(1 - temp.*(1 - temp2));
    %lastwage(lastwage == 0) = NaN;
    %lastwage(temp==1&temp2==1&spellstart~=1) = NaN;
    %lastwage = reshape(repmat(nanmean(reshape(lastwage,freq,NumObs.SIPP*(T/freq)),1),freq,1),T,NumObs.SIPP);
    lastwage = fillmissing(lastwage,'previous');
    lastwage(isnan(lastwage)) = 0;
    annwage = lastwage*freq;

    lasthumancap = zeros(size(HH(1:NumObs.SIPP,:).'));
    lasthumancap = (HH(1:NumObs.SIPP,:)).'.*spellstart;
    lasthumancap(lasthumancap == 0) = NaN;
    lasthumancap = fillmissing(lasthumancap,'previous');
    lasthumancap(isnan(lasthumancap)) = 0;

    nexthumancap = zeros(size(HH(1:NumObs.SIPP,:).'));
    nexthumancap(1:end-1,:) = (HH(1:NumObs.SIPP,2:end)).'.*(1 - temp(1:end-1,:));
    nexthumancap(nexthumancap == 0) = NaN;
    nexthumancap = fillmissing(nexthumancap,'next');
    nexthumancap(isnan(nexthumancap)) = 0;

    netliqstart = zeros(size(AA(1:NumObs.SIPP,:).'));
    netliqstart = (AA(1:NumObs.SIPP,:).*w0).'.*spellstart;
    netliqstart(netliqstart == 0) = NaN;
    netliqstart = fillmissing(netliqstart,'previous');
    netliqstart(isnan(netliqstart)) = 0;

    netliqend = zeros(size(HH(1:NumObs.SIPP,:).'));
    netliqend(1:end-1,:) = (AA(1:NumObs.SIPP,2:end).*w0).'.*(1 - temp(1:end-1,:));
    netliqend(netliqend == 0) = NaN;
    netliqend = fillmissing(netliqend,'next');
    netliqend(isnan(netliqend)) = 0;


    panel(:,13) = reshape(temp,[],1);
    panel(:,14) = reshape(spell,[],1);

    G = findgroups(panel(:,1),panel(:,14));
    temp = splitapply(@max,panel(:,8),G);
    panel(:,15) = reshape(spellstart,[],1);
    % are these shaped correctly??????
    panel(:,16) = reshape(lastwage,[],1);
    panel(:,17) = reshape(annwage,[],1);
    panel(:,18) = reshape(netliqstart,[],1);
    panel(:,19) = zeros(size(panel(:,10)));
    panel(:,19) = G;
    panel(:,20) = reshape(lasthumancap,[],1);
    panel(:,21) = reshape(nexthumancap,[],1);
    panel(:,22) = reshape(netliqend,[],1);
    panel(:,23) = 13./reshape(p(ThetaPrime(1:NumObs.SIPP,:)).',[],1);
    panel(:,24) = reshape(WPrime(1:NumObs.SIPP,:).',[],1);
    idu = unique(G);

    %TabPanel = table(panel,'VariableNames',{'IndID','Age','Time','Employment Status (EOP)', ...
    %    'Unemployment Status (EOP)','Wealth','UI_yn','UIAmt','
    FullPanel = array2table(panel,'VariableNames',{'IndID','Age','Time','EmpStatEOP', ...
                        'UnempStatEOP','Wealth','UI_yn','UIAmt','Wage','dur', ...
                        'LearningTime','HumanCap','Unemp','Spell', ...
                        'SpellStart','LastWage','LastAnnWg','netliqStart','SpellID','lastHumanCap','nextHumanCap','netliq','expDur','AppStrat'});

    temp = [idu temp];
    temp = array2table(temp,'VariableNames',{'SpellID','MaxUI'});
    FullPanel = join(FullPanel,temp,'Keys','SpellID');
    temp = splitapply(@max,panel(:,7),G);
    temp = [idu temp];
    temp = array2table(temp,'VariableNames',{'SpellID','UI_yn2'});
    FullPanel = join(FullPanel,temp,'Keys','SpellID');
    FullPanel.SpellEnd = FullPanel.EmpStatEOP.*FullPanel.Unemp;
    Nextqwage = FullPanel.Wage;
    Nextqwage = reshape(repmat(sum(reshape(Nextqwage.',freq./4,NumObs.SIPP*((4*T)/freq)),1),freq./4,1),T,NumObs.SIPP).';
    FullPanel.MeasErr = reshape(MeasErr(1:NumObs.SIPP,:).',[],1);
    NextMeasErr = FullPanel.MeasErr;
    NextMeasErr = reshape(repmat(sum(reshape(NextMeasErr.',freq./4,NumObs.SIPP*((4*T)/freq)),1),freq./4,1),T,NumObs.SIPP).';
    FullPanel.LastMeasErr = reshape(LastMeasErr(1:NumObs.SIPP,:).',[],1);
    FullPanel.Nextqwage = reshape(Nextqwage.',[],1);
    FullPanel.MeasErr = reshape(MeasErr(1:NumObs.SIPP,:).',[],1);
    FullPanel.lnwage = log(FullPanel.Wage);
    FullPanel.lnnextqwage = log(FullPanel.Nextqwage);
    FullPanel.lnlastwage = log(FullPanel.LastWage);
    FullPanel.lnlastannwg = log(FullPanel.LastAnnWg);
    FullPanel.lnActmaxwba = log(FullPanel.MaxUI);
    FullPanel.lnActUIAmt = log(FullPanel.UIAmt);
    FullPanel.lnmaxwba = log(FullPanel.MaxUI./FullPanel.LastWage) + FullPanel.lnlastwage;
    FullPanel.lnUIAmt = log(FullPanel.UIAmt./FullPanel.LastWage) + FullPanel.lnlastwage;
    FullPanel.lnAppStrat = log(FullPanel.AppStrat);

    netliqAll = ceil(100*tiedrank(netliqstart(:))/length(netliqstart(:)));
    netliqstart = reshape(ceil(5*tiedrank(netliqstart(:))/length(netliqstart(:))),NumObs.SIPP,T);

    %Find indices for randomly dropped households
    MissRepAux1A = zeros(size(netliqstart));
    MissRepAux1A_1 = nobsAux1A_1./NumObs.SIPP;
    MissRepAux1A_1 = repmat(reshape(repmat(MissRepAux1A_1,1,freq),[],1),1,NumObs.SIPP).';
    MissRepAux1A(netliqstart==1) = MissRepAux1A_1(netliqstart==1);
    MissRepAux1A_2 = nobsAux1A_2./NumObs.SIPP;
    MissRepAux1A_2 = repmat(reshape(repmat(MissRepAux1A_2,1,freq),[],1),1,NumObs.SIPP).';
    MissRepAux1A(netliqstart==2) = MissRepAux1A_2(netliqstart==2);
    MissRepAux1A_3 = nobsAux1A_3./NumObs.SIPP;
    MissRepAux1A_3 = repmat(reshape(repmat(MissRepAux1A_3,1,freq),[],1),1,NumObs.SIPP).';
    MissRepAux1A(netliqstart==3) = MissRepAux1A_3(netliqstart==3);
    MissRepAux1A_4 = nobsAux1A_4./NumObs.SIPP;
    MissRepAux1A_4 = repmat(reshape(repmat(MissRepAux1A_4,1,freq),[],1),1,NumObs.SIPP).';
    MissRepAux1A(netliqstart==4) = MissRepAux1A_4(netliqstart==4);
    MissRepAux1A_5 = nobsAux1A_5./NumObs.SIPP;
    MissRepAux1A_5 = repmat(reshape(repmat(MissRepAux1A_5,1,freq),[],1),1,NumObs.SIPP).';
    MissRepAux1A(netliqstart==5) = MissRepAux1A_5(netliqstart==5);
    MissRepAux1B = zeros(size(netliqAll));
    MissRepAux1C = zeros(size(netliqAll));
    for i=1:100
        MissRepAux1C(netliqAll==i) = nobsAux1C(i);
        MissRepAux1B(netliqAll==i) = nobsAux1B(i)./sum(nobsAux1B);
    end
    FullPanel = sortrows(FullPanel,{'IndID','Age'});


    FullPanel.MissRepAux1A = reshape(MissRepAux1A.',[],1);
    FullPanel.MissRepAux1A(FullPanel.MissRepAux1A<=0) = 0;
    FullPanel.MissRepAux1B = MissRepAux1B;
    FullPanel.MissRepAux1B(FullPanel.MissRepAux1B<=0) = 0;
    FullPanel.MissRepAux1C = MissRepAux1C;
    FullPanel.MissRepAux1C(FullPanel.MissRepAux1C<=0) = 0;
    FullPanel.MissRepAux1 = FullPanel.MissRepAux1A.*FullPanel.MissRepAux1B;
    FullPanel.MissRepAux1(FullPanel.MissRepAux1<=0) = 0;

    Panel = FullPanel(FullPanel.SpellEnd==1&FullPanel.UI_yn2==1&FullPanel.Nextqwage>0&FullPanel.lnlastannwg>0&FullPanel.Age<=60,:);
    if strcmpi(dataopts.datasubset,'Wages')
        Panel = Panel(Panel.UIAmt>nanmin(Panel.UIAmt),:);
    end
    Panel.MissRepAux1A = Panel.MissRepAux1A./sum(Panel.MissRepAux1A);
    Panel.MissRepAux1B = Panel.MissRepAux1B./sum(Panel.MissRepAux1B);
    Panel.MissRepAux1C = Panel.MissRepAux1C./sum(Panel.MissRepAux1C);
    Panel.MissRepAux11 = Panel.MissRepAux1A.*Panel.MissRepAux1B;
    Panel.MissRepAux12 = Panel.MissRepAux1A.*Panel.MissRepAux1C;
    Panel.MissRepAux13 = Panel.MissRepAux1A.*Panel.MissRepAux1B.*Panel.MissRepAux1C;
    Panel = sortrows(Panel,{'IndID','Age'});
    SampSizeAux1 = nobsAux1A;
    if size(Panel,1) < SampSizeAux1
        SampSizeAux1 = size(Panel,1);
    end
    if SampSizeAux1 > 0
        try
            [~,idx] = datasample(Panel,SampSizeAux1,'Weights',Panel.MissRepAux11(:),'Replace',false);
            Panel = Panel(idx,:);
        catch
            err = 1;
        end
    else
        err = 1;
    end

    if err == 0
        Panel.lnLastHumanCap = log(Panel.lastHumanCap);
        Panel.lnNextHumanCap = log(Panel.nextHumanCap);
        Panel.lnDiffHumanCap = Panel.lnNextHumanCap - Panel.lnLastHumanCap;
        Panel.PotentialDur = Panel.lnDiffHumanCap./MuEps;
        Panel.lnStateUI = ones(size(Panel.lnlastwage))*(log(b) + nanmean(Panel.lnlastwage));
        Panel.netliq_pctile = ceil(100*tiedrank(Panel.netliq)/length(Panel.netliq));
        Panel.lnWealth = log(Panel.Wealth - min(Panel.Wealth) + 1);
        Panel.Ed = ceil(4*tiedrank(Panel.lnNextHumanCap)/length(Panel.lnNextHumanCap));
        Panel.netliq_q(Panel.netliq_pctile<=10) = 1;
        Panel.netliq_q(Panel.netliq_pctile>10&Panel.netliq_pctile<=40) = 2;
        Panel.netliq_q(Panel.netliq_pctile>40&Panel.netliq_pctile<=60) = 3;
        Panel.netliq_q(Panel.netliq_pctile>60&Panel.netliq_pctile<=80) = 4;
        Panel.netliq_q(Panel.netliq_pctile>80) = 5;
        Panel.netliq_1stq = Panel.netliq_q;
        Panel.netliq_1stq(Panel.netliq_1stq>1) = 2;
        Panel.netliq_pctile = [];

        for i=1:5
            Panel = [Panel array2table(Panel.netliq_q==i,'VariableNames',{strcat('netliq_q',int2str(i))})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.PotentialDur,'VariableNames',{strcat('netliq_q',int2str(i),'XPotentialDur')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnStateUI,'VariableNames',{strcat('netliq_q',int2str(i),'XlnStateUI')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnWealth,'VariableNames',{strcat('netliq_q',int2str(i),'XlnWealth')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnUIAmt,'VariableNames',{strcat('netliq_q',int2str(i),'XlnUIAmt')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnmaxwba,'VariableNames',{strcat('netliq_q',int2str(i),'Xlnmaxwba')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnlastannwg,'VariableNames',{strcat('netliq_q',int2str(i),'Xl_annwg')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnlastwage,'VariableNames',{strcat('netliq_q',int2str(i),'Xl_wg')})];
            Panel = [Panel array2table((Panel.netliq_q==i).*Panel.lnLastHumanCap,'VariableNames',{strcat('netliq_q',int2str(i),'XlnHumanCap')})];
        end

        for i=1:2
            Panel = [Panel array2table(Panel.netliq_1stq==i,'VariableNames',{strcat('netliq_1stq',int2str(i))})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.PotentialDur,'VariableNames',{strcat('netliq_1stq',int2str(i),'XPotentialDur')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.Wealth,'VariableNames',{strcat('netliq_1stq',int2str(i),'XWealth')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnStateUI,'VariableNames',{strcat('netliq_1stq',int2str(i),'XlnStateUI')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnWealth,'VariableNames',{strcat('netliq_1stq',int2str(i),'XlnWealth')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnUIAmt,'VariableNames',{strcat('netliq_1stq',int2str(i),'XlnUIAmt')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnmaxwba,'VariableNames',{strcat('netliq_1stq',int2str(i),'Xlnmaxwba')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnlastannwg,'VariableNames',{strcat('netliq_1stq',int2str(i),'Xl_annwg')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnlastwage,'VariableNames',{strcat('netliq_1stq',int2str(i),'Xl_wg')})];
            Panel = [Panel array2table((Panel.netliq_1stq==i).*Panel.lnLastHumanCap,'VariableNames',{strcat('netliq_1stq',int2str(i),'XlnHumanCap')})];
        end

        Panel.netliq_q = categorical(Panel.netliq_q);
        Panel.netliq_1stq = categorical(Panel.netliq_1stq);
    end
    clear SampSizeAux1 temp temp2 G dur idu netliqstart lastwage annwage spell IndID panel;

elseif strcmpi(dataopts.dataset,'PSID')

    %%Auxiliary Models 2-7: PSID Moments
    %Outline: Load sampling data, Construct panel, Impose Sample Restrictions
% $$$     nobsAux2 = tabconv(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux2),'y');
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux2));
    nobsAux2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux3));
    nobsAux3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux3HVY));
    nobsAux3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4));
    nobsAux4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_1));
    nobsAux4_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_2));
    nobsAux4_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_3));
    nobsAux4_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_4));
    nobsAux4_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_5));
    nobsAux4_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_1HVY));
    nobsAux4_1HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_2HVY));
    nobsAux4_2HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_3HVY));
    nobsAux4_3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_4HVY));
    nobsAux4_4HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_5HVY));
    nobsAux4_5HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4OldAve));
    nobsAux4OldAve = temp;
    clear temp;

    AgepanelAn = 23:(23+T/freq-1);
    AgepanelAn = repmat(AgepanelAn,N,1);
    IndID = 1:N;
    IndID = IndID'*ones(1,T/freq);
    HrsWrkedAnSubSample = 40.*(52.*ones(size(UUAn)) - 13.*UUAn - 52.*TTAn);

    if dataopts.fullpanel == 'y'
        panelPSID = cat(2,reshape(IndID.',[],1), reshape(AgepanelAn.',[],1),reshape(EWAn.',[],1),reshape(EEAn.',[],1),reshape(UUAn.',[],1),reshape(repmat(AFQT,1,T/freq).',[],1), ...
                          reshape(UTAn.',[],1),reshape(DurAn.',[],1),reshape(HHAn.',[],1),reshape(AAAn.',[],1),reshape(LiqAn.',[],1),reshape(E2EAn.',[],1),reshape(UBAn.',[],1), ...
                          reshape(ProdAn.',[],1),reshape(repmat(LLt,1,T/freq).',[],1),reshape(MUAn.',[],1),reshape(MWAn.',[],1),reshape(TTAn.',[],1), ...
                          reshape(ETAn.',[],1),reshape(TenAn.',[],1),reshape(BBAn.',[],1),reshape(BTAn.',[],1),reshape(TWAn.',[],1),reshape(TWProdAn.',[],1), ...
                          reshape(UUAnInd.',[],1),reshape(EEAnInd.',[],1),reshape(ZZAn.',[],1),reshape(ZZProdAn.',[],1),reshape(CCAn.',[],1),reshape(MPCAn.',[],1), ...
                          reshape(Budget.',[],1),reshape(MPCBAn.',[],1),reshape(UUAnWks.',[],1),reshape(HrsWrkedAn.',[],1),reshape(WPrimeAn.',[],1),reshape(PPrimeAn.',[],1),reshape(MeasErrAn.',[],1),reshape(UnempIntInd.',[],1));


        %PSID Panel
        FullPanel = array2table(panelPSID,'VariableNames',{'IndID','Age','RInc','Emp','Unemp','AFQT','UnempScaled','UnempDur','HumanCap','AA','RLiqWealth', ...
                                'E2E','UIAmt','Prod','LearnAb','PieceRateShare','PieceRate','LearnTime','EmpScaled','Tenure','UI_yn','UIDur','LearnTimeEmp', ...
                                'LearnTimeProd','UnempInd','EmpInd','ZZPctShocks','ZZProdShocks','Cons','MPC','Budget','MPCB','UnempWks','HrsWkred', ...
                                'ApplicationStrategy','EmploymentProbability','MeasErrAn','UnempIntInd'});
    else
        panelPSID = cat(2,reshape(IndID.',[],1), reshape(AgepanelAn.',[],1),reshape(EWAn.',[],1), reshape(LiqAn.',[],1), ...
                    reshape(UUAn.',[],1),reshape(HrsWrkedAnSubSample.',[],1),reshape(MeasErrAn.',[],1),reshape(TTAn.',[],1),reshape(UnempAnInd.',[],1),reshape(UnempIntInd.',[],1));

        %PSID Panel
        FullPanel = array2table(panelPSID,'VariableNames',{'IndID','Age','RInc','RLiqWealth','UnempWks','HrsWrked','MeasErrAn','LearnTime','UnempAnInd','UnempIntInd'});
    end

    LRInc = log(EWAn);
    AgepanelAn = 23:64;
    AgepanelAn = repmat(AgepanelAn,N,1);


    for i=1:5
        LRIncGrowthTemp = LRInc(:,i+1:end);
        LRIncGrowthTemp = LRIncGrowthTemp - LRInc(:,1:end-i);
        LRIncGrowthTemp = [LRIncGrowthTemp zeros(size(LRIncGrowthTemp,1),i)];
        LRIncGrowthTemp(~isfinite(LRIncGrowthTemp)) = NaN;
        LRIncGrowthTemp(LRIncGrowthTemp==0) = NaN;
        LRIncGrowthTemp(AgepanelAn<50) = NaN;
        FullPanel = [FullPanel array2table(reshape(LRIncGrowthTemp.',[],1),'VariableNames',{strcat('LRIncGrowth',int2str(i))})];
    end


    FullPanel(FullPanel.IndID<=NumObs.SIPP|(FullPanel.IndID>=NumObs.SIPP+NumObs.PSIDTotal+1),:) = [];
    AgepanelAn = 23:64;
    AgepanelAn = repmat(AgepanelAn,NumObs.PSIDTotal,1);
    AgeGrp = zeros(size(AgepanelAn));
    AgeGrp(AgepanelAn<=40) = 1;
    AgeGrp(AgepanelAn>40) = 2;
    Age2ndGrp = zeros(size(AgepanelAn));
    Age2ndGrp(AgepanelAn<50) = 0;
    Age2ndGrp(AgepanelAn>=50) = 1;
    FullPanel.AgeGrp = reshape(AgeGrp.',[],1);
    FullPanel.Age2ndGrp = reshape(Age2ndGrp.',[],1);

    for i=1:2
        FullPanel = [FullPanel array2table(FullPanel.AgeGrp==i,'VariableNames',{strcat('AgeGrp',int2str(i))})];
    end
    FullPanel.AgeGrp = categorical(FullPanel.AgeGrp);
    FullPanel.Age2ndGrp = categorical(FullPanel.Age2ndGrp);
    IndID = 1:NumObs.PSIDTotal;
    IndID = IndID'*ones(1,T/freq);
    FullPanel.IndID = reshape(IndID.',[],1);
    FullPanel.Age = reshape(AgepanelAn.',[],1);
    FullPanel.RLiqWealth_pred = FullPanel.RLiqWealth;
    FullPanel.RLiqWealth(FullPanel.IndID<NumObs.PSIDInitEarn-NumObs.PSIDInitOverlap|FullPanel.IndID>NumObs.PSIDInitEarn+NumObs.PSIDInitWealth) = NaN;
    IndID = reshape(FullPanel.IndID,T/freq,NumObs.PSIDTotal).';
    AgepanelAn = reshape(FullPanel.Age,T/freq,NumObs.PSIDTotal).';


    %Global Restrictions
    %Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
    %Age >30: Hours Worked in [520,5280] and Inc >=9750, averaged over 3 years
    FullPanel.LRInc = log(FullPanel.RInc);
    FullPanel.RIncHVY = FullPanel.RInc;
    FullPanel.RIncHVY(FullPanel.Age<=30&(FullPanel.RInc<4750|FullPanel.HrsWrked<=260)) = NaN;
    FullPanel.RIncHVY(FullPanel.Age>30&(FullPanel.RInc<9500|FullPanel.HrsWrked<=520)) = NaN;
    FullPanel.LRIncHVY = log(FullPanel.RIncHVY);

    %%Auxiliary Models 2-3: PSID Initial Conditions Moments
    %PSID Initial Wealth Restrictions:
    %Male, Age 23, No Full-Time Work Experience
    MissRepAux2 = nobsAux2(1)./NumObs.PSIDInitWealth;
    MissRepAux2 = repmat(MissRepAux2,1,NumObs.PSIDTotal).';
    temp = [IndID(:,1) MissRepAux2];
    temp = array2table(temp,'VariableNames',{'IndID','MissRepAux2'});
    FullPanel = join(FullPanel,temp,'Keys','IndID');
    %Assign zero weight to out of sample observations
    FullPanel.MissRepAux2(isnan(FullPanel.RLiqWealth)) = 0;
    FullPanel.MissRepAux2(FullPanel.Age>23) = 0;
    SampSizeAux2 = nobsAux2(1);
    %PSID Initial Earnings Restrictions:
    %Male, Ages 23-24, No Full-Time Work Experience
    MissRepAux3 = nobsAux3(1)./NumObs.PSIDInitEarn;
    MissRepAux3 = repmat(MissRepAux3,1,NumObs.PSIDTotal).';
    temp = [IndID(:,1) MissRepAux3];
    temp = array2table(temp,'VariableNames',{'IndID','MissRepAux3'});
    FullPanel = join(FullPanel,temp,'Keys','IndID');
    %Assign zero weight to out of sample observations
    FullPanel.MissRepAux3(isnan(FullPanel.RInc)|(FullPanel.Age>24)|(FullPanel.IndID>NumObs.PSIDInitEarn)|(FullPanel.RInc<=0)) = 0;
    SampSizeAux3 = nobsAux3(1);
    SampSizeAux3DropNaN = NumObs.PSIDInitEarn - sum(FullPanel.MissRepAux3(FullPanel.Age<=24&FullPanel.IndID<=NumObs.PSIDInitEarn)==0);
    if SampSizeAux3 > SampSizeAux3DropNaN
        SampSizeAux3 = SampSizeAux3DropNaN;
    end

    %Load missing observation percentage


    %%PSID Moment Calculations
    %Initial Wealth Sub-Sampling
    try
        [AA_init_dist,~] = datasample(FullPanel.RLiqWealth,SampSizeAux2,'Weights',FullPanel.MissRepAux2(:),'Replace',false);
    catch
        AA_init_dist = FullPanel.RLiqWealth(FullPanel.Age==23);
        err = 1;
    end

    %%PSID Moment Calculations
    %Initial Wealth Sub-Sampling
    try
        [EW_init_dist,~] = datasample(FullPanel.LRInc,SampSizeAux3,'Weights',FullPanel.MissRepAux3(:),'Replace',false);
    catch
        EW_init_dist = FullPanel.LRInc(FullPanel.Age<=24&FullPanel.IndID<=NumObs.PSIDInitEarn);
        err = 1;
    end


    %%Auxiliary Models 4-7: PSID Life-cycle moments
    %PSID Moment selections:
    %Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
    %Age >30: Hours Worked in [520,5280] and Inc >=9750
    %Marginal distribution of initial wealth, averaged over 3 years

    AA_dist = FullPanel.RLiqWealth_pred(FullPanel.Age==23);

    %Classify households without observed wealth as in data
    initwlthqtile = zeros(NumObs.PSIDTotal,1);
    initwlthqtile(AA_dist <= quantile(AA_init_dist,0.2),:) = 1;
    initwlthqtile(AA_dist > quantile(AA_init_dist,0.2) & AA_dist <= quantile(AA_init_dist,0.4),:) = 2;
    initwlthqtile(AA_dist > quantile(AA_init_dist,0.4) & AA_dist <= quantile(AA_init_dist,0.6),:) = 3;
    initwlthqtile(AA_dist > quantile(AA_init_dist,0.6) & AA_dist <= quantile(AA_init_dist,0.8),:) = 4;
    initwlthqtile(AA_dist >= quantile(AA_init_dist,0.8),:) = 5;
    initwlthqtile = repmat(initwlthqtile,1,T/freq);
    FullPanel.RLiqWealth_qtile = reshape(initwlthqtile.',[],1);

    for i=1:5
        FullPanel = [FullPanel array2table((FullPanel.RLiqWealth_qtile==i).*(FullPanel.AgeGrp=='2'),'VariableNames',{strcat('RLiqWealth_qtile',int2str(i),'XAgeGrp2')})];
        FullPanel = [FullPanel array2table((FullPanel.RLiqWealth_qtile==i).*(FullPanel.AgeGrp=='2').*FullPanel.Age,'VariableNames',{strcat('RLiqWealth_qtile',int2str(i),'XAgeXAgeGrp2')})];
    end


    %Find indices for randomly dropped households
    MissRepAux4 = zeros(size(AgepanelAn(:,(TYoung/freq+1):(T - TOld)/freq)));
    MissRepAux4_1 = (nobsAux4_1-nobsAux4_1HVY)./NumObs.PSIDTotal;
    MissRepAux4_1 = repmat(MissRepAux4_1,1,NumObs.PSIDTotal).';
    MissRepAux4_1(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=1) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==1) = MissRepAux4_1;
    MissRepAux4_2 = (nobsAux4_2-nobsAux4_2HVY)./NumObs.PSIDTotal;
    MissRepAux4_2 = repmat(MissRepAux4_2,1,NumObs.PSIDTotal).';
    MissRepAux4_2(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=2) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==2) = MissRepAux4_2;
    MissRepAux4_3 = (nobsAux4_3-nobsAux4_3HVY)./NumObs.PSIDTotal;
    MissRepAux4_3 = repmat(MissRepAux4_3,1,NumObs.PSIDTotal).';
    MissRepAux4_3(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=3) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==3) = MissRepAux4_3;
    MissRepAux4_4 = (nobsAux4_4-nobsAux4_4HVY)./NumObs.PSIDTotal;
    MissRepAux4_4 = repmat(MissRepAux4_4,1,NumObs.PSIDTotal).';
    MissRepAux4_4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=4) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==4) = MissRepAux4_4;
    MissRepAux4_5 = (nobsAux4_5-nobsAux4_5HVY)./NumObs.PSIDTotal;
    MissRepAux4_5 = repmat(MissRepAux4_5,1,NumObs.PSIDTotal).';
    MissRepAux4_5(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=5) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==5) = MissRepAux4_5;
    FullPanel = sortrows(FullPanel,{'IndID','Age'});
    RInc_3 = reshape(movmean(reshape(FullPanel.RInc,T/freq,NumObs.PSIDTotal),[1 1],'includenan'),[],1);
    FullPanel.RInc_3 = RInc_3;
    LearnTime_3 = reshape(movmean(reshape(FullPanel.LearnTime,T/freq,NumObs.PSIDTotal),[1 1],'includenan'),[],1);
    FullPanel.LNHrs = log(1 - FullPanel.LearnTime);
    FullPanel.LNHrs_3 = log(1 - LearnTime_3);
    RIncHVY_3 = reshape(movmean(reshape(FullPanel.RIncHVY,T/freq,NumObs.PSIDTotal),[1 1],'includenan'),[],1);
    FullPanel.RIncHVY_3 = RIncHVY_3;
    MeasErrAn_3 = reshape(movmean(reshape(FullPanel.MeasErrAn,T/freq,NumObs.PSIDTotal),[1 1],'omitnan'),[],1);
    FullPanel.MeasErrAn_3 = MeasErrAn_3;
    MissRepAux4(isnan(reshape(FullPanel.RIncHVY(FullPanel.Age>=25&FullPanel.Age<=54),(T - TYoung - TOld)/freq,NumObs.PSIDTotal).')) = 0;
    MissRepAux4(isnan(reshape(FullPanel.RLiqWealth_qtile(FullPanel.Age>=25&FullPanel.Age<=54),(T - TYoung - TOld)/freq,NumObs.PSIDTotal).')) = 0;

    SampSizeAux4DropNaN = NumObs.PSIDTotal*((T - TYoung - TOld)/freq) - sum(sum(MissRepAux4<=0));
    MissRepAux4 = cat(2,zeros(NumObs.PSIDTotal,TYoung/freq),MissRepAux4,zeros(NumObs.PSIDTotal,TOld/freq));
    SampSizeAux4 = sum(nobsAux4,1);

    if SampSizeAux4 > SampSizeAux4DropNaN
        SampSizeAux4 = SampSizeAux4DropNaN;
    end

    MissRepAux4Old = repmat(nobsAux4OldAve./sum(nobsAux4OldAve),1,NumObs.PSIDTotal).';
    MissRepAux4Old = cat(2,zeros(size(AgepanelAn(:,(TYoung/freq+1):(T - TOld + 20)/freq))),MissRepAux4Old,zeros(NumObs.PSIDTotal,1));
    FullPanel.MissRepAux4Old = reshape(MissRepAux4Old.',[],1);
    FullPanel.MissRepAux4Old(FullPanel.MissRepAux4Old<=0) = 0;
    FullPanel.MissRepAux4Old(FullPanel.Age<=57) = 0;
    FullPanel = sortrows(FullPanel,{'IndID','Age'});
    [TabGrowthPanel,~] = datasample(FullPanel,sum(nobsAux4OldAve),'Weights',FullPanel.MissRepAux4Old(:),'Replace',false);

    FullPanel.MissRepAux4 = reshape(MissRepAux4.',[],1);
    FullPanel.MissRepAux4(FullPanel.MissRepAux4<=0) = 0;
    FullPanel.RLiqWealth_qtile = categorical(FullPanel.RLiqWealth_qtile);
    FullPanel = sortrows(FullPanel,{'IndID','Age'});
    try
        [~,idx] = datasample(FullPanel,SampSizeAux4,'Weights',FullPanel.MissRepAux4(:),'Replace',false);
        TabSlopePanel = FullPanel;
        TabSlopePanel.temp = NaN(size(TabSlopePanel.RInc));
        TabSlopePanel.temp(idx,:) = TabSlopePanel.RInc(idx,:);
        TabSlopePanel.RInc = TabSlopePanel.temp;
        TabSlopePanel.LRInc_3 = log(TabSlopePanel.RInc_3);
        TabSlopePanel.temp = NaN(size(TabSlopePanel.RIncHVY));
        TabSlopePanel.temp(idx,:) = TabSlopePanel.RIncHVY(idx,:);
        TabSlopePanel.RIncHVY = TabSlopePanel.temp;
        TabSlopePanel.temp = [];
        TabSlopePanel.LRIncHVY_3 = log(TabSlopePanel.RIncHVY_3);
        TabSlopePanel = TabSlopePanel(idx,:);
    catch
        err = 1;
        TabSlopePanel = FullPanel;
        TabSlopePanel.LRInc_3 = log(TabSlopePanel.RInc_3);
        TabSlopePanel.LRIncHVY_3 = log(TabSlopePanel.RIncHVY_3);
    end

    if strcmpi(dataopts.datasubset,'InitWealth')
        Panel = AA_init_dist;
    elseif strcmpi(dataopts.datasubset,'InitEarn')
        Panel = EW_init_dist;
    elseif strcmpi(dataopts.datasubset,'LifeCycle')
        Panel = TabSlopePanel;
    elseif strcmpi(dataopts.datasubset,'OldGrowth')
        Panel = TabGrowthPanel;
    end

    clear FullPanel TabPanel TabSlopePanel SampSizeAux2 SampSizeAux3 initwlthqtile temp MissRepAux2 MissRepAux3 G EW_init_dist AA_init_dist ...
        MissRepAux4_1 MissRepAux4_2 MissRepAux4_3 MissRepAux4_4 MissRepAux4_5 MissRepAux4 IndID panelPSID RInc_3 nobsAux3HVY ...
        MissRepAux4_1HVY MissRepAux4_2HVY MissRepAux4_3HVY MissRepAux4_4HVY MissRepAux4_5HVY AgepanelAn AAAn_dist UUAn ...
        HrsWrkedAnSubSample SampSizeAux4DropNaN SampSizeAux4 SampSizeAux3DropNaN AFQT;

elseif strcmpi(dataopts.dataset,'NLSY')

    %%NLSY Life-Cycle Moments
    %NLSY Moment selections:
    %Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
    %Age >30: Hours Worked in [520,5280] and Inc >=9750, averaged over 3 years

    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5));
    nobsAux5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_1));
    nobsAux5_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_2));
    nobsAux5_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_3));
    nobsAux5_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_4));
    nobsAux5_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_5));
    nobsAux5_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_1HVY));
    nobsAux5_1HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_2HVY));
    nobsAux5_2HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_3HVY));
    nobsAux5_3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_4HVY));
    nobsAux5_4HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_5HVY));
    nobsAux5_5HVY = temp;
    clear temp;


    AgepanelAn = 23:(23+T/freq-1);
    AgepanelAn = repmat(AgepanelAn,NumObs.NLSY,1);
    IndID = 1:NumObs.NLSY;
    IndID = IndID'*ones(1,T/freq);
    EWAnSubSample = EWAn;
    EWAnSubSample(1:NumObs.SIPP+NumObs.PSIDTotal,:) = [];
    AFQT = LL;
    AFQT(1:NumObs.SIPP+NumObs.PSIDTotal) = [];
    UUAnSubSample = UUAn;
    UUAnSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    TTAnSubSample = TTAn;
    TTAnSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    HrsWrkedAnSubSample = 40.*(52.*ones(size(UUAnSubSample)) - 13.*UUAnSubSample - 52.*TTAnSubSample);
    E2EAnSubSample = E2EAn;
    E2EAnSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    E2EAnIndSubSample = E2EAnInd;
    E2EAnIndSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    sameJobSubSample = sameJob;
    sameJobSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    UUAnIndSubSample = UUAnInd;
    UUAnIndSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    UnempAnIndSubSample = UnempAnInd;
    UnempAnIndSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    MeasErrAnIndSubSample = UUAnInd;
    MeasErrAnIndSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    LearnTimeAnSubSample = TTAn;
    LearnTimeAnSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];
    RLiqWealthSubSample = LiqAn;
    RLiqWealthSubSample(1:NumObs.SIPP + NumObs.PSIDTotal,:) = [];



    %Classify households without observed wealth as in data
    wlthqtile = zeros(size(RLiqWealthSubSample));
    wlthqtile(RLiqWealthSubSample <= quantile(RLiqWealthSubSample,0.2)) = 1;
    wlthqtile(RLiqWealthSubSample > quantile(RLiqWealthSubSample,0.2) & RLiqWealthSubSample <= quantile(RLiqWealthSubSample,0.4)) = 2;
    wlthqtile(RLiqWealthSubSample > quantile(RLiqWealthSubSample,0.4) & RLiqWealthSubSample <= quantile(RLiqWealthSubSample,0.6)) = 3;
    wlthqtile(RLiqWealthSubSample > quantile(RLiqWealthSubSample,0.6) & RLiqWealthSubSample <= quantile(RLiqWealthSubSample,0.8)) = 4;
    wlthqtile(RLiqWealthSubSample >= quantile(RLiqWealthSubSample,0.8)) = 5;



    panelNLSY = cat(2,reshape(IndID.',[],1), reshape(AgepanelAn.',[],1),reshape(EWAnSubSample.',[],1), reshape(repmat(AFQT,1,T/freq).',[],1), ...
                    reshape(UUAnSubSample.',[],1),reshape(HrsWrkedAnSubSample.',[],1),reshape(EWAnSubSample.',[],1),reshape(E2EAnSubSample.',[],1), ...
                    reshape(E2EAnIndSubSample.',[],1),reshape(sameJobSubSample.',[],1),reshape(UUAnIndSubSample.',[],1),reshape(MeasErrAnIndSubSample.',[],1),reshape(LearnTimeAnSubSample.',[],1),reshape(RLiqWealthSubSample.',[],1),reshape(wlthqtile.',[],1),reshape(UnempAnIndSubSample.',[],1));

    %NLSY Panel
    FullPanel = array2table(panelNLSY,'VariableNames',{'IndID','Age','RIncHVY','AFQT','UnempWks','HrsWrked','RInc','J2J','J2JInd','sameJob','UnempInd','MeasErrAn','LearnTime','RLiqWealth','RLiqWealth_qtile','UnempAnInd'});

    %Global Restrictions
    %Male, Ages 25-54, Age <=30: Hours Worked in [260,5280] and Inc >=4750,
    %Age >30: Hours Worked in [520,5280] and Inc >=9750, averaged over 3 years
    FullPanel = sortrows(FullPanel,{'IndID','Age'});
    FullPanel.RIncHVY(FullPanel.Age<=30&(FullPanel.RInc<4750|FullPanel.HrsWrked<=260)) = NaN;
    FullPanel.RIncHVY(FullPanel.Age>30&(FullPanel.RInc<9500|FullPanel.HrsWrked<=520)) = NaN;
    FullPanel.LRInc = log(FullPanel.RInc);
    FullPanel.LRIncHVY = log(FullPanel.RIncHVY);
    AgeGrp = zeros(size(AgepanelAn));
    AgeGrp(AgepanelAn<=40) = 1;
    AgeGrp(AgepanelAn>40) = 2;
    Age2ndGrp = zeros(size(AgepanelAn));
    Age2ndGrp(AgepanelAn<25) = 0;
    Age2ndGrp(AgepanelAn>=25 & AgepanelAn<=29) = 1;
    Age2ndGrp(AgepanelAn>=30 & AgepanelAn<=34) = 2;
    Age2ndGrp(AgepanelAn>=35 & AgepanelAn<=39) = 3;
    Age2ndGrp(AgepanelAn>=40 & AgepanelAn<=44) = 4;
    Age2ndGrp(AgepanelAn>=45 & AgepanelAn<=49) = 5;
    Age2ndGrp(AgepanelAn>=50 & AgepanelAn<=54) = 6;
    FullPanel.AgeGrp = reshape(AgeGrp.',[],1);
    FullPanel.Age2ndGrp = reshape(Age2ndGrp.',[],1);

    for i=1:2
        FullPanel = [FullPanel array2table(FullPanel.AgeGrp==i,'VariableNames',{strcat('AgeGrp',int2str(i))})];
    end
    for i=1:5
        FullPanel = [FullPanel array2table(FullPanel.Age2ndGrp==i,'VariableNames',{strcat('Age2ndGrp',int2str(i))})];
    end
    AFQT = exp(log(AFQT) + normrnd(0,0.05,size(AFQT)));
    AFQTqtile = zeros(NumObs.NLSY,1);
    AFQTqtile(AFQT <= quantile(AFQT,0.2)) = 1;
    AFQTqtile(AFQT > quantile(AFQT,0.2) & AFQT <= quantile(AFQT,0.4)) = 2;
    AFQTqtile(AFQT > quantile(AFQT,0.4) & AFQT <= quantile(AFQT,0.6)) = 3;
    AFQTqtile(AFQT > quantile(AFQT,0.6) & AFQT <= quantile(AFQT,0.8)) = 4;
    AFQTqtile(AFQT >= quantile(AFQT,0.8),:) = 5;
    AFQTqtile = repmat(AFQTqtile,1,T/freq);
    FullPanel.AFQT_qtile = reshape(AFQTqtile.',[],1);
    FullPanel.AgeGrp = categorical(FullPanel.AgeGrp);
    FullPanel.Age2ndGrp = categorical(FullPanel.Age2ndGrp);

    for i=1:5
        FullPanel = [FullPanel array2table((FullPanel.AFQT_qtile==i).*(FullPanel.AgeGrp=='2'),'VariableNames',{strcat('AFQT_qtile',int2str(i),'XAgeGrp2')})];
        FullPanel = [FullPanel array2table((FullPanel.AFQT_qtile==i).*(FullPanel.AgeGrp=='2').*FullPanel.Age,'VariableNames',{strcat('AFQT_qtile',int2str(i),'XAgeXAgeGrp2')})];
    end

    %Find indices for randomly dropped households
    MissRepAux5 = zeros(size(AgepanelAn(:,(TYoung/freq+1):(T - TOld)/freq)));
    MissRepAux5_1 = (nobsAux5_1-nobsAux5_1HVY)./NumObs.NLSY;
    MissRepAux5_1 = repmat(MissRepAux5_1,1,NumObs.NLSY).';
    MissRepAux5_1(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=1) = [];
    MissRepAux5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)==1) = MissRepAux5_1;
    MissRepAux5_2 = (nobsAux5_2-nobsAux5_2HVY)./NumObs.NLSY;
    MissRepAux5_2 = repmat(MissRepAux5_2,1,NumObs.NLSY).';
    MissRepAux5_2(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=2) = [];
    MissRepAux5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)==2) = MissRepAux5_2;
    MissRepAux5_3 = (nobsAux5_3-nobsAux5_3HVY)./NumObs.NLSY;
    MissRepAux5_3 = repmat(MissRepAux5_3,1,NumObs.NLSY).';
    MissRepAux5_3(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=3) = [];
    MissRepAux5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)==3) = MissRepAux5_3;
    MissRepAux5_4 = (nobsAux5_4-nobsAux5_4HVY)./NumObs.NLSY;
    MissRepAux5_4 = repmat(MissRepAux5_4,1,NumObs.NLSY).';
    MissRepAux5_4(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=4) = [];
    MissRepAux5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)==4) = MissRepAux5_4;
    MissRepAux5_5 = (nobsAux5_5-nobsAux5_5HVY)./NumObs.NLSY;
    MissRepAux5_5 = repmat(MissRepAux5_5,1,NumObs.NLSY).';
    MissRepAux5_5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=5) = [];
    MissRepAux5(AFQTqtile(:,(TYoung/freq+1):(T - TOld)/freq)==5) = MissRepAux5_5;
    FullPanel = sortrows(FullPanel,{'IndID','Age'});
    RInc_3 = reshape(movmean(reshape(FullPanel.RInc,T/freq,NumObs.NLSY),[1 1],'includenan'),[],1);
    FullPanel.RInc_3 = RInc_3;
    LearnTime_3 = reshape(movmean(reshape(FullPanel.LearnTime,T/freq,NumObs.NLSY),[1 1],'includenan'),[],1);
    FullPanel.LNHrs = log(1 - FullPanel.LearnTime);
    FullPanel.LNHrs_3 = log(1 - LearnTime_3);
    RIncHVY_3 = reshape(movmean(reshape(FullPanel.RIncHVY,T/freq,NumObs.NLSY),[1 1],'includenan'),[],1);
    FullPanel.RIncHVY_3 = RIncHVY_3;
    MeasErrAn_3 = reshape(movmean(reshape(FullPanel.MeasErrAn,T/freq,NumObs.NLSY),[1 1],'omitnan'),[],1);
    FullPanel.MeasErrAn_3 = MeasErrAn_3;
    MissRepAux5(isnan(reshape(FullPanel.RIncHVY(FullPanel.Age>=25&FullPanel.Age<=54),(T - TYoung - TOld)/freq,NumObs.NLSY).')) = 0;
    MissRepAux5(isnan(reshape(FullPanel.AFQT_qtile(FullPanel.Age>=25&FullPanel.Age<=54),(T - TYoung - TOld)/freq,NumObs.NLSY).')) = 0;

    SampSizeAux5DropNaN = NumObs.NLSY*((T - TYoung - TOld)/freq) - sum(sum(MissRepAux5<=0));
    MissRepAux5 = cat(2,zeros(NumObs.NLSY,TYoung/freq),MissRepAux5,zeros(NumObs.NLSY,TOld/freq));
    SampSizeAux5 = sum(nobsAux5,1);

    if SampSizeAux5 > SampSizeAux5DropNaN
        SampSizeAux5 = SampSizeAux5DropNaN;
    end

    FullPanel.MissRepAux5 = reshape(MissRepAux5.',[],1);
    FullPanel.MissRepAux5(FullPanel.MissRepAux5<=0) = 0;
    FullPanel.AFQT_qtile = categorical(FullPanel.AFQT_qtile);
    FullPanel.AgeGrp = categorical(FullPanel.AgeGrp);



    try
        [~,idx] = datasample(FullPanel,SampSizeAux5,'Weights',FullPanel.MissRepAux5,'Replace',false);
        Panel = FullPanel;
        Panel.temp = NaN(size(Panel.RInc));
        Panel.temp(idx,:) = Panel.RInc(idx,:);
        Panel.RInc = Panel.temp;
        Panel.LRInc_3 = log(Panel.RInc_3);
        Panel.temp = NaN(size(Panel.RIncHVY));
        Panel.temp(idx,:) = Panel.RIncHVY(idx,:);
        Panel.RIncHVY = Panel.temp;
        Panel.temp = [];
        Panel.LRIncHVY_3 = log(Panel.RIncHVY_3);
        LRIncHVY_3 = reshape(Panel.LRIncHVY_3,T/freq,NumObs.NLSY);
        LRIncHVY_3Growth = LRIncHVY_3(2:end,:) - LRIncHVY_3(1:end-1,:);
        LRIncHVY_3Growth = cat(1,LRIncHVY_3(1,:),LRIncHVY_3Growth);
        Panel.LRIncHVY_3Growth = reshape(LRIncHVY_3Growth,[],1);
        HrsWrkedAn = reshape(Panel.HrsWrked,T/freq,NumObs.NLSY);
        HrsWrked_Growth = HrsWrkedAn(2:end,:) - HrsWrkedAn(1:end-1,:);
        HrsWrked_Growth = cat(1,HrsWrkedAn(1,:),HrsWrked_Growth);
        Panel.HrsWrked_Growth = reshape(HrsWrked_Growth,[],1);
        Panel = Panel(idx,:);
    catch
        err = 1;
        Panel = FullPanel;
        Panel.LRInc_3 = log(Panel.RInc_3);
        Panel.LRIncHVY_3 = log(Panel.RIncHVY_3);
        LRIncHVY_3 = reshape(Panel.LRIncHVY_3,T/freq,NumObs.NLSY);
        LRIncHVY_3Growth = LRIncHVY_3(2:end,:) - LRIncHVY_3(1:end-1,:);
        LRIncHVY_3Growth = cat(1,LRIncHVY_3(1,:),LRIncHVY_3Growth);
        Panel.LRIncHVY_3Growth = reshape(LRIncHVY_3Growth,[],1);
        HrsWrkedAn = reshape(Panel.HrsWrked,T/freq,NumObs.NLSY);
        HrsWrked_Growth = HrsWrkedAn(2:end,:) - HrsWrkedAn(1:end-1,:);
        HrsWrked_Growth = cat(1,HrsWrkedAn(1,:),HrsWrked_Growth);
        Panel.HrsWrked_Growth = reshape(HrsWrked_Growth,[],1);
    end

    clear FullPanel SampSizeAux5 AFQTqtile IWAnSubSample AFQT MissRepAux5_1 MissRepAux5_2 MissRepAux5_3 MissRepAux5_4 MissRepAux5_5 ...
        MissRepAux5 IndID panelNLSY RInc_3 nobsAux3HVY MissRepAux5_1HVY MissRepAux5_2HVY MissRepAux5_3HVY MissRepAux5_4HVY ...
        MissRepAux5_5HVY AgepanelAn UUAn UUAnSubSample HrsWrkedAnSubSample SampSizeAux5DropNaN RInc_3 RIncHVY_3 LRIncHVY_3 ...
        LRIncHVY_3Growth AgeGrp HrsWrkedAn HrsWrked_Growth;


elseif strcmpi(dataopts.dataset,'FullLifeCycle')

    %%Auxiliary Models 2-7: PSID Moments
    %Outline: Load sampling data, Construct panel, Impose Sample Restrictions
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux2));
    nobsAux2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux3));
    nobsAux3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux3HVY));
    nobsAux3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4));
    nobsAux4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_1));
    nobsAux4_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_2));
    nobsAux4_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_3));
    nobsAux4_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_4));
    nobsAux4_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_5));
    nobsAux4_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_1HVY));
    nobsAux4_1HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_2HVY));
    nobsAux4_2HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_3HVY));
    nobsAux4_3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_4HVY));
    nobsAux4_4HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux4_5HVY));
    nobsAux4_5HVY = temp;
    %%Auxliary Model 8: NLSY Moments
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5));
    nobsAux5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_1));
    nobsAux5_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_2));
    nobsAux5_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_3));
    nobsAux5_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_4));
    nobsAux5_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_5));
    nobsAux5_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_1HVY));
    nobsAux5_1HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_2HVY));
    nobsAux5_2HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_3HVY));
    nobsAux5_3HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_4HVY));
    nobsAux5_4HVY = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Aux5_5HVY));
    nobsAux5_5HVY = temp;
    clear temp;

    AgepanelAn = 23:64;
    AgepanelAn = repmat(AgepanelAn,N,1);
    IndID = 1:N;
    IndID = IndID'*ones(1,T/freq);
    UUAnWks = 13.*UUAn;
    HrsWrkedAn = 40.*(52.*ones(size(UUAnWks)) - UUAnWks);

    lifecycleArray = cat(2,reshape(IndID.',[],1), reshape(AgepanelAn.',[],1),reshape(EWAn.',[],1),reshape(EEAn.',[],1),reshape(UUAn.',[],1),reshape(repmat(AFQT,1,T/freq).',[],1), ...
                         reshape(UTAn.',[],1),reshape(DurAn.',[],1),reshape(HHAn.',[],1),reshape(AAAn.',[],1),reshape(LiqAn.',[],1),reshape(E2EAn.',[],1),reshape(UBAn.',[],1), ...
                         reshape(ProdAn.',[],1),reshape(repmat(LLt,1,T/freq).',[],1),reshape(MUAn.',[],1),reshape(MWAn.',[],1),reshape(TTAn.',[],1), ...
                         reshape(ETAn.',[],1),reshape(TenAn.',[],1),reshape(BBAn.',[],1),reshape(BTAn.',[],1),reshape(TWAn.',[],1),reshape(TWProdAn.',[],1), ...
                         reshape(UUAnInd.',[],1),reshape(EEAnInd.',[],1),reshape(ZZAn.',[],1),reshape(ZZProdAn.',[],1),reshape(CCAn.',[],1),reshape(MPCAn.',[],1), ...
                         reshape(Budget.',[],1),reshape(MPCBAn.',[],1),reshape(UUAnWks.',[],1),reshape(HrsWrkedAn.',[],1),reshape(WPrimeAn.',[],1),reshape(PPrimeAn.',[],1), ...
                         reshape(ThetaPrimeAn.',[],1),reshape(MeasErrAn.',[],1),reshape(repmat(initQtiles.Wealth,1,T/freq).',[],1), ...
                         reshape(repmat(initQtiles.HumanCap,1,T/freq).',[],1),reshape(repmat(initQtiles.Learn,1,T/freq).',[],1));

    Panel = array2table(lifecycleArray,'VariableNames',{'IndID','Age','RInc','Emp','Unemp','AFQT','UnempScaled','UnempDur','HumanCap','AA','RLiqWealth', ...
                        'E2E','UIAmt','Prod','LearnAb','PieceRateShare','PieceRate','LearnTime','EmpScaled','Tenure','UI_yn','UIDur','LearnTimeEmp', ...
                        'LearnTimeProd','UnempInd','EmpInd','ZZPctShocks','ZZProdShocks','Cons','MPC','Budget','MPCB','UnempWks','HrsWkred', ...
                        'ApplicationStrategy','EmploymentProbability','SubmarketTightness','MeasErrAn','RLiqWealth_qtile','HumanCap_qtile','AFQT_qtile'});


    AgeGrp = zeros(size(AgepanelAn));
    AgeGrp(AgepanelAn<=40) = 1;
    AgeGrp(AgepanelAn>40) = 2;
    Panel.AgeGrp = reshape(AgeGrp.',[],1);

    for i=1:2
        Panel = [Panel array2table(Panel.AgeGrp==i,'VariableNames',{strcat('AgeGrp',int2str(i))})];
    end

    Panel.RInc(Panel.RInc<=0|Panel.Emp<=0) = NaN;
    Panel.RIncHVY = Panel.RInc;
    Panel.RIncHVY(Panel.Age<=30&(Panel.RInc<4750)) = NaN;
    Panel.RIncHVY(Panel.Age>30&(Panel.RInc<9500)) = NaN;
    Panel.HVYInd = zeros(size(Panel.Age));
    Panel.HVYInd(~isnan(Panel.RIncHVY)) = 1;
    RInc_3 = reshape(movmean(reshape(Panel.RInc,T/freq,N),[1 1],'omitnan'),[],1);
    RIncHVY_3 = reshape(movmean(reshape(Panel.RIncHVY,T/freq,N),[1 1],'omitnan'),[],1);
    MeasErrAn_3 = reshape(movmean(reshape(Panel.MeasErrAn,T/freq,N),[1 1],'omitnan'),[],1);
    Panel.MeasErrAn_3 = MeasErrAn_3;
    Panel.RInc_3 = RInc_3;
    Panel.RIncHVY_3 = RIncHVY_3;
    Panel.LRInc = log(Panel.RInc);
    Panel.LHumanCap = log(Panel.HumanCap);
    Panel.LPieceRate = log(Panel.PieceRateShare);
    Panel.LLearnTime = log(Panel.LearnTime);
    Panel.LLearnTime(Panel.LearnTime==0) = NaN;
    Panel.LProdTime = (1 - log(Panel.LearnTime));
    Panel.LProdTime(Panel.LearnTime==1) = NaN;
    Panel.LProdTime(Panel.Emp==0) = NaN;
    Panel.LRInc_3 = log(Panel.RInc_3);
    Panel.LRIncHVY = log(Panel.RIncHVY);
    Panel.LRIncHVY_3 = log(Panel.RIncHVY_3);
    LRIncHVY_3 = reshape(Panel.LRIncHVY_3,T/freq,N);
    LRIncHVY_3Growth = LRIncHVY_3(2:end,:) - LRIncHVY_3(1:end-1,:);
    LRIncHVY_3Growth = cat(1,LRIncHVY_3(1,:),LRIncHVY_3Growth);
    Panel.LRIncHVY_3Growth = reshape(LRIncHVY_3Growth,[],1);

    if opts.II == 'y'
        initwlthqtile = zeros(N,1);
        initwlthqtile(LiqAn(:,1) <= quantile(LiqAn(:,1),0.2),:) = 1;
        initwlthqtile(LiqAn(:,1) > quantile(LiqAn(:,1),0.2) & LiqAn(:,1) <= quantile(LiqAn(:,1),0.4),:) = 2;
        initwlthqtile(LiqAn(:,1) > quantile(LiqAn(:,1),0.4) & LiqAn(:,1) <= quantile(LiqAn(:,1),0.6),:) = 3;
        initwlthqtile(LiqAn(:,1) > quantile(LiqAn(:,1),0.6) & LiqAn(:,1) <= quantile(LiqAn(:,1),0.8),:) = 4;
        initwlthqtile(LiqAn(:,1) >= quantile(LiqAn(:,1),0.8),:) = 5;
        initwlthqtile = repmat(initwlthqtile,1,T/freq);
        Panel.RLiqWealth_qtile = reshape(initwlthqtile.',[],1);
    else
        initwlthqtile = repmat(initQtiles.Wealth,1,T/freq);
        % Panel.RLiqWealth_qtile = reshape(initwlthqtile.',[],1);

    end

    if opts.II == 'y'
        learnqtile = zeros(N,1);
        learnqtile(LLt <= quantile(LLt,0.2),:) = 1;
        learnqtile(LLt > quantile(LLt,0.2) & LLt <= quantile(LLt,0.4),:) = 2;
        learnqtile(LLt > quantile(LLt,0.4) & LLt <= quantile(LLt,0.6),:) = 3;
        learnqtile(LLt > quantile(LLt,0.6) & LLt <= quantile(LLt,0.8),:) = 4;
        learnqtile(LLt >= quantile(LLt,0.8),:) = 5;
        learnqtile = repmat(learnqtile,1,T/freq);
        Panel.Learn_qtile = reshape(learnqtile.',[],1);
    else
        learnqtile = repmat(initQtiles.Learn,1,T/freq);
        % Panel.Learn_qtile = reshape(learnqtile.',[],1);

    end

    %Find indices for randomly dropped households
    MissRepAux4 = zeros(size(AgepanelAn(:,(TYoung/freq+1):(T - TOld)/freq)));
    MissRepAux4_1 = ((nobsAux4_1-nobsAux4_1HVY)./NumObs.PSIDTotal);
    MissRepAux4_1 = repmat(MissRepAux4_1,1,N).';
    MissRepAux4_1(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=1) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==1) = MissRepAux4_1;
    MissRepAux4_2 = (nobsAux4_2-nobsAux4_2HVY)./NumObs.PSIDTotal;
    MissRepAux4_2 = repmat(MissRepAux4_2,1,N).';
    MissRepAux4_2(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=2) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==2) = MissRepAux4_2;
    MissRepAux4_3 = (nobsAux4_3-nobsAux4_3HVY)./NumObs.PSIDTotal;
    MissRepAux4_3 = repmat(MissRepAux4_3,1,N).';
    MissRepAux4_3(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=3) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==3) = MissRepAux4_3;
    MissRepAux4_4 = (nobsAux4_4-nobsAux4_4HVY)./NumObs.PSIDTotal;
    MissRepAux4_4 = repmat(MissRepAux4_4,1,N).';
    MissRepAux4_4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=4) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==4) = MissRepAux4_4;
    MissRepAux4_5 = (nobsAux4_5-nobsAux4_5HVY)./NumObs.PSIDTotal;
    MissRepAux4_5 = repmat(MissRepAux4_5,1,N).';
    MissRepAux4_5(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=5) = [];
    MissRepAux4(initwlthqtile(:,(TYoung/freq+1):(T - TOld)/freq)==5) = MissRepAux4_5;
    MissRepAux4(isnan(reshape(Panel.RIncHVY(Panel.Age>=25&Panel.Age<=54),N,(T - TYoung - TOld)/freq))) = 0;
    MissRepAux4(isnan(reshape(Panel.RLiqWealth_qtile(Panel.Age>=25&Panel.Age<=54),N,(T - TYoung - TOld)/freq))) = 0;

    MissRepAux4 = cat(2,zeros(N,TYoung/freq),MissRepAux4,zeros(N,TOld/freq));
    Panel.MissRepAux4 = reshape(MissRepAux4.',[],1);
    Panel.MissRepAux4(Panel.MissRepAux4<=0) = 0;


    if opts.II == 'y'
        AFQTqtile = zeros(N,1);
        AFQT = exp(log(AFQT) + normrnd(0,0.05,size(AFQT)));
        AFQTqtile(AFQT <= quantile(AFQT,0.2),:) = 1;
        AFQTqtile(AFQT > quantile(AFQT,0.2) & AFQT <= quantile(AFQT,0.4),:) = 2;
        AFQTqtile(AFQT > quantile(AFQT,0.4) & AFQT <= quantile(AFQT,0.6),:) = 3;
        AFQTqtile(AFQT > quantile(AFQT,0.6) & AFQT <= quantile(AFQT,0.8),:) = 4;
        AFQTqtile(AFQT >= quantile(AFQT,0.8),:) = 5;
        AFQTqtile = repmat(AFQTqtile,1,T/freq);
        Panel.AFQT_qtile = reshape(AFQTqtile.',[],1);
    else
        AFQTqtile = repmat(initQtiles.Learn,1,T/freq);
        % Panel.AFQT_qtile = reshape(AFQTqtile.',[],1);
    end



    %Find indices for randomly dropped households
    MissRepAux5 = zeros(size(AgepanelAn(:,(TYoung/freq+1):(T - TOld)/freq)));
    MissRepAux5_1 = (nobsAux5_1-nobsAux5_1HVY)./NumObs.NLSY;
    MissRepAux5_1 = repmat(MissRepAux5_1,1,N).';
    MissRepAux5_1(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=1) = [];
    MissRepAux5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)==1) = MissRepAux5_1;
    MissRepAux5_2 = (nobsAux5_2-nobsAux5_2HVY)./NumObs.NLSY;
    MissRepAux5_2 = repmat(MissRepAux5_2,1,N).';
    MissRepAux5_2(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=2) = [];
    MissRepAux5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)==2) = MissRepAux5_2;
    MissRepAux5_3 = (nobsAux5_3-nobsAux5_3HVY)./NumObs.NLSY;
    MissRepAux5_3 = repmat(MissRepAux5_3,1,N).';
    MissRepAux5_3(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=3) = [];
    MissRepAux5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)==3) = MissRepAux5_3;
    MissRepAux5_4 = (nobsAux5_4-nobsAux5_4HVY)./NumObs.NLSY;
    MissRepAux5_4 = repmat(MissRepAux5_4,1,N).';
    MissRepAux5_4(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=4) = [];
    MissRepAux5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)==4) = MissRepAux5_4;
    MissRepAux5_5 = (nobsAux5_5-nobsAux5_5HVY)./NumObs.NLSY;
    MissRepAux5_5 = repmat(MissRepAux5_5,1,N).';
    MissRepAux5_5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)~=5) = [];
    MissRepAux5(afqtqtile(:,(TYoung/freq+1):(T - TOld)/freq)==5) = MissRepAux5_5;
    MissRepAux5(isnan(reshape(Panel.RIncHVY(Panel.Age>=25&Panel.Age<=54),N,(T - TYoung - TOld)/freq))) = 0;
    MissRepAux5(isnan(reshape(Panel.AFQT_qtile(Panel.Age>=25&Panel.Age<=54),N,(T - TYoung - TOld)/freq))) = 0;

    MissRepAux5 = cat(2,zeros(N,TYoung/freq),MissRepAux5,zeros(N,TOld/freq));
    Panel.MissRepAux5 = reshape(MissRepAux5.',[],1);
    Panel.MissRepAux5(Panel.MissRepAux5<=0) = 0;
    Panel.Wealth_qtile = categorical(Panel.RLiqWealth_qtile);
    Panel.HumanCap_qtile = categorical(Panel.HumanCap_qtile);
    Panel.Learn_qtile = categorical(Panel.AFQT_qtile);

    clear AgepanelAn IndID UUAnWks AFQT HrsWrkedAn AFQTQtile initwlthqtile learnqtile MissRepAux2 MissRepAux3 G IW_init_dist AA_init_dist ...
        MissRepAux4_1 MissRepAux4_2 MissRepAux4_3 MissRepAux4_4 MissRepAux4_5 MissRepAux4 RInc_3 nobsAux3HVY ...
        MissRepAux4_1HVY MissRepAux4_2HVY MissRepAux4_3HVY MissRepAux4_4HVY MissRepAux4_5HVY MissRepAux4 MissRepAux5 ...
        RInc_3 RIncHVY_3 IWAnYoung IWAnOld IWAnHVY AFQTqtile AFQT learnqtile initwealthqtile;

elseif strcmpi(dataopts.dataset,'ScarringPanel')

    %%Unemployment Scarring Samples
    %Outline: Load sampling data, Construct panel, Impose Sample Restrictions
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1));
    nobsScar1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2));
    nobsScar2 = temp;
    clear temp;


    AgepanelAn = 23:50;
    AgepanelAn = repmat(AgepanelAn,4,1);
    AgepanelAn = reshape(AgepanelAn,1,[]);
    AgepanelAn(end-2:end) = [];
    AgepanelAn = repmat(AgepanelAn,NScar,1);
    AgepanelAn = repmat(AgepanelAn,2,1);

    IndID = 1:NScar;
    IndID = bsxfun(@plus,IndID.',NScar*reshape(0:(T-TScar),1,(T-TScar+1)));
    IndID = repmat(IndID,2,1);

    J2UTreated = cat(1,zeros(NScar,T-TScar+1),ones(NScar,T-TScar+1));

    HrsWrkedAn = 52.*EEAn.*40.*(1 - TTAn);

    scarringArray = cat(2,reshape(IndID,[],1),reshape(AgepanelAn,[],1),reshape(squeeze(AAAn(:,1,:)).*w0,[],1),reshape(squeeze(HHAn(:,1,:)),[],1), ...
                        reshape(repmat(LL,1,T-TScar+1),[],1),reshape(J2UTreated,[],1),reshape(E2EAnInd(:,1,:),[],1),reshape(HrsWrkedAn(:,1,:),[],1));

    Panel = array2table(scarringArray,'VariableNames',{'IndID','Age','RLiqWealth','HumanCap','AFQT','J2UTreat','J2J','HrsWrked'});

    Panel.AgeSq = Panel.Age.^2;


    RInc = EWAn.*w0;
    RInc(RInc<=0|EEAn<=0) = NaN;
    LRInc = log(RInc);
    PieceRate = MUAn;
    PieceRate(MUAn==0|EEAn<=0) = NaN;
    LPieceRate = log(PieceRate);
    LHumanCap = log(HHAn);
    LHumanCapEmp = log(HHAn);
    LHumanCapEmp(EEAn<=0) = NaN;
    ProdTime = 1 - TTAn;
    LProdTime = log(ProdTime);
    LProdTime(ProdTime==0|EEAn<=0) = NaN;
    LearnTime = TTAn;
    LLearnTime = log(LearnTime);

    Panel.RInc = reshape(RInc(:,1,:),[],1);


    for i=1:TScar./freq
        Panel = [Panel array2table(reshape(LRInc(:,i,:),[],1),'VariableNames',{strcat('LRInc',int2str(i))})];
        Panel = [Panel array2table(reshape(EEAn(:,i,:),[],1),'VariableNames',{strcat('Emp',int2str(i))})];
        Panel = [Panel array2table(reshape(WPrimeAn(:,i,:),[],1),'VariableNames',{strcat('AppStrat',int2str(i))})];
        Panel = [Panel array2table(reshape(LearnTime(:,i,:),[],1),'VariableNames',{strcat('LearnTime',int2str(i))})];
        Panel = [Panel array2table(reshape(ProdTime(:,i,:),[],1),'VariableNames',{strcat('ProdTime',int2str(i))})];
        Panel = [Panel array2table(reshape(LPieceRate(:,i,:),[],1),'VariableNames',{strcat('LPieceRate',int2str(i))})];
        Panel = [Panel array2table(reshape(LHumanCap(:,i,:),[],1),'VariableNames',{strcat('LHumanCap',int2str(i))})];
        Panel = [Panel array2table(reshape(LProdTime(:,i,:),[],1),'VariableNames',{strcat('LProdTime',int2str(i))})];
        Panel = [Panel array2table(reshape(LLearnTime(:,i,:),[],1),'VariableNames',{strcat('LLearnTime',int2str(i))})];
        Panel = [Panel array2table(reshape(HrsWrkedAn(:,i,:),[],1),'VariableNames',{strcat('HrsWrked',int2str(i))})];
    end

    wlthqtile = zeros(2*NScar,(T-TScar+1));

    for i = 1:(T-TScar+1)
        wlthqtile(:,i) = repmat(reshape(ceil(5*tiedrank(reshape(AAAn(1:NScar,1,i),[],1))/length(reshape(AAAn(1:NScar,1,i),[],1))),NScar,1),2,1);
    end


    Panel.Wealth_Presentqtile = reshape(wlthqtile,[],1);
    humancapqtile = reshape(ceil(5*tiedrank(reshape(Panel.HumanCap,[],1))/length(reshape(Panel.HumanCap,[],1))),2*NScar,(T-TScar+1));
    Panel.HumanCap_Presentqtile = reshape(humancapqtile,[],1);
    learnqtile = reshape(ceil(5*tiedrank(reshape(Panel.AFQT,[],1))/length(reshape(Panel.AFQT,[],1))),2*NScar,(T-TScar+1));
    Panel.Learn_qtile = reshape(learnqtile,[],1);
    Panel.Wealth_Presentqtile2 = zeros(size(Panel.Wealth_Presentqtile));
    Panel.Wealth_Presentqtile2(Panel.Wealth_Presentqtile==1) = 0;
    Panel.Wealth_Presentqtile2(Panel.Wealth_Presentqtile>1) = 1;

    Panel.Wealth_Presentqtile = categorical(Panel.Wealth_Presentqtile);
    Panel.Wealth_Presentqtile2 = categorical(Panel.Wealth_Presentqtile2);
    Panel.HumanCap_Presentqtile = categorical(Panel.HumanCap_Presentqtile);
    Panel.Learn_qtile = categorical(Panel.Learn_qtile);


    clear AgepanelAn IndID UUAnWks AFQT HrsWrkedAn AFQTQtile initwlthqtile learnqtile MissRepAux2 MissRepAux3 G IW_init_dist AA_init_dist ...
        MissRepAux4_1 MissRepAux4_2 MissRepAux4_3 MissRepAux4_4 MissRepAux4_5 MissRepAux4 RInc_3 nobsAux3HVY ...
        MissRepAux4_1HVY MissRepAux4_2HVY MissRepAux4_3HVY MissRepAux4_4HVY MissRepAux4_5HVY MissRepAux4 MissRepAux5 ...
        RInc_3 RIncHVY_3 IWAnYoung IWAnOld IWAnHVY;

elseif strcmpi(dataopts.dataset,'EmpRiskPanel')

    %%Unemployment Scarring Samples
    %Outline: Load sampling data, Construct panel, Impose Sample Restrictions
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1));
    nobsScar1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2));
    nobsScar2 = temp;
    clear temp;


    AgepanelAn = 23:50;
    AgepanelAn = repmat(AgepanelAn,4,1);
    AgepanelAn = reshape(AgepanelAn,1,[]);
    AgepanelAn(end-2:end) = [];
    AgepanelAn = repmat(AgepanelAn,2*NScar,1);

    IndID = 1:2*NScar;
    IndID = bsxfun(@plus,IndID.',2*NScar*reshape(0:(T-TScar),1,(T-TScar+1)));

    HrsWrkedAn = 52.*40.*EEAn;

    scarringArray = cat(2,reshape(IndID,[],1),reshape(AgepanelAn,[],1),reshape(squeeze(AAAn(:,1,:)).*w0,[],1),reshape(squeeze(HHAn(:,1,:)),[],1), ...
                        reshape(repmat(LL,1,T-TScar+1),[],1),reshape(DD,[],1),reshape(E2EAnInd(:,1,:),[],1),reshape(HrsWrkedAn(:,1,:),[],1),reshape(UnempProbAn(:,1,:),[],1));

    Panel = array2table(scarringArray,'VariableNames',{'IndID','Age','RLiqWealth','HumanCap','AFQT','SepRisk','J2J','HrsWrked','UnempProb'});

    Panel.UnempRisk = (Panel.SepRisk-0.03)*100;

    Panel.EmpRisk = (Panel.SepRisk-0.03).*(Panel.UnempProb-nanmean(Panel.UnempProb)).*100;

    Panel.AgeSq = Panel.Age.^2;


    RInc = EWAn.*w0;
    RInc(RInc<=0|EEAn<=0) = NaN;
    LRInc = log(RInc);
    PieceRate = MUAn;
    PieceRate(MUAn==0|EEAn<=0) = NaN;
    LPieceRate = log(PieceRate);
    LHumanCap = log(HHAn);
    LHumanCapEmp = log(HHAn);
    LHumanCapEmp(EEAn<=0) = NaN;
    ProdTime = 1 - TTAn;
    LProdTime = log(ProdTime);
    LProdTime(ProdTime==0|EEAn<=0) = NaN;
    LearnTime = TTAn;
    LLearnTime = log(LearnTime);

   Panel.RInc = reshape(RInc(:,1,:),[],1);


    for i=1:TScar./freq
        Panel = [Panel array2table(reshape(LRInc(:,i,:),[],1),'VariableNames',{strcat('LRInc',int2str(i))})];
        Panel = [Panel array2table(reshape(EEAn(:,i,:),[],1),'VariableNames',{strcat('Emp',int2str(i))})];
        Panel = [Panel array2table(reshape(WPrimeAn(:,i,:),[],1),'VariableNames',{strcat('AppStrat',int2str(i))})];
        Panel = [Panel array2table(reshape(LearnTime(:,i,:),[],1),'VariableNames',{strcat('LearnTime',int2str(i))})];
        Panel = [Panel array2table(reshape(ProdTime(:,i,:),[],1),'VariableNames',{strcat('ProdTime',int2str(i))})];
        Panel = [Panel array2table(reshape(LPieceRate(:,i,:),[],1),'VariableNames',{strcat('LPieceRate',int2str(i))})];
        Panel = [Panel array2table(reshape(LHumanCap(:,i,:),[],1),'VariableNames',{strcat('LHumanCap',int2str(i))})];
        Panel = [Panel array2table(reshape(LProdTime(:,i,:),[],1),'VariableNames',{strcat('LProdTime',int2str(i))})];
        Panel = [Panel array2table(reshape(LLearnTime(:,i,:),[],1),'VariableNames',{strcat('LLearnTime',int2str(i))})];
    end

    wlthqtile = zeros(2*NScar,(T-TScar+1));

    for i = 1:(T-TScar+1)
        wlthqtile(:,i) = reshape(ceil(5*tiedrank(reshape(AAAn(1:2*NScar,1,i),[],1))/length(reshape(AAAn(1:2*NScar,1,i),[],1))),2*NScar,1);
    end


    Panel.Wealth_Presentqtile = reshape(wlthqtile,[],1);
    humancapqtile = reshape(ceil(5*tiedrank(reshape(Panel.HumanCap,[],1))/length(reshape(Panel.HumanCap,[],1))),2*NScar,(T-TScar+1));
    Panel.HumanCap_Presentqtile = reshape(humancapqtile,[],1);
    learnqtile = reshape(ceil(5*tiedrank(reshape(Panel.AFQT,[],1))/length(reshape(Panel.AFQT,[],1))),2*NScar,(T-TScar+1));
    Panel.Learn_qtile = reshape(learnqtile,[],1);
    Panel.Wealth_Presentqtile2 = zeros(size(Panel.Wealth_Presentqtile));
    Panel.Wealth_Presentqtile2(Panel.Wealth_Presentqtile==1) = 0;
    Panel.Wealth_Presentqtile2(Panel.Wealth_Presentqtile>1) = 1;



    %Find indices for randomly dropped households
    MissRepScar1 = nobsScar1;
    MissRepScar2 = nobsScar2;


    Panel.Wealth_Presentqtile = categorical(Panel.Wealth_Presentqtile);
    Panel.Wealth_Presentqtile2 = categorical(Panel.Wealth_Presentqtile2);
    Panel.HumanCap_Presentqtile = categorical(Panel.HumanCap_Presentqtile);
    Panel.Learn_qtile = categorical(Panel.Learn_qtile);


    clear AgepanelAn IndID UUAnWks AFQT HrsWrkedAn AFQTQtile initwlthqtile learnqtile MissRepAux2 MissRepAux3 G IW_init_dist AA_init_dist ...
        MissRepAux4_1 MissRepAux4_2 MissRepAux4_3 MissRepAux4_4 MissRepAux4_5 MissRepAux4 RInc_3 nobsAux3HVY ...
        MissRepAux4_1HVY MissRepAux4_2HVY MissRepAux4_3HVY MissRepAux4_4HVY MissRepAux4_5HVY MissRepAux4 MissRepAux5 ...
        RInc_3 RIncHVY_3 IWAnYoung IWAnOld IWAnHVY;

end


clear alb IW IWAn w0 MUAn MWAn TTAn TW TWAn TWProdAn EEAn ETAn EEAInd UUAn BBAn CCAn MPCAn UTAn UUAnInd HHAn AAAn TenAn DurAn UBAn ProdAn LiqAn Learn ZZAn ZZProdAn;

end
% LocalWords:  MissRepAux
