function [Panel,err] = DataPanelsScarring(params, order, opts, NumObs, NObsNames, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, dataopts)
%%DataPanels m-File for Borrowing Constraints, Search, and Life-Cycle Inequality
% This file creates panels identical to those in the data for indirect inference
% Author: Ben Griffy, Sept., 2017
err = 0;

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

% rng('shuffle');

%rng(140);

% alb = geosum(r,bl,T);
% % $$$ w0 = (w0/freq);
% if ~isempty(WW)&&~isempty(EE)
%     IW = WW.*EE;
%     IWAn = reshape(sum(reshape(IW.',freq,N*(T/freq)),1),T/freq,N).';
%     IWAn = IWAn.*w0;
% end
% if ~isempty(WW)&&~isempty(EE)&&~isempty(TT)
%     EW = WW.*(1 - TT).*EE;
%     MeasErr = normrnd(0,SigXi,size(EW));
%     LastMeasErr = normrnd(0,SigXi,size(EW));
%     EW = exp(MeasErr).*EW;
%     EWAn = reshape(sum(reshape(EW.',freq,N*(T/freq)),1),T/freq,N).';
%     EWAn = EWAn.*w0;
%     MeasErrAn = reshape(sum(reshape(MeasErr.',freq,N*(T/freq)),1),T/freq,N).';
%     LastMeasErrAn = reshape(sum(reshape(LastMeasErr.',freq,N*(T/freq)),1),T/freq,N).';
% end
% if ~isempty(MU)
%     MUAn = reshape(sum(reshape(MU.',freq,N*(T/freq)),1),T/freq,N).';
%     MWAn = MUAn.*w0;
%     MUAn = MUAn./freq;
%     MUAn = MU;
%     MUAn(EE==0) = NaN;
%     MUAn = reshape(nanmean(reshape(MUAn.',freq,N*(T/freq)),1),T/freq,N).';
% end
% if ~isempty(TT)
%     TTAn = reshape(sum(reshape(TT.',freq,N*(T/freq)),1),T/freq,N).';
%     TTAn = TTAn./freq;
%     if ~isempty(EE)
%         TW = TT.*EE;
%         TWAn = reshape(sum(reshape(TW.',freq,N*(T/freq)),1),T/freq,N).';
%         TWProdAn = TWAn.*w0;
%         TWAn = TWAn./freq;
%     end
% end
% if ~isempty(EE)
%     EEAn = reshape(sum(reshape(EE.',freq,N*(T/freq)),1),T/freq,N).';
%     ETAn = EEAn./freq;
%     EEAnInd = EEAn;
%     EEAnInd(EEAnInd>0) = 1;
% end
% if ~isempty(UU)
%     UUAn = reshape(sum(reshape(UU.',freq,N*(T/freq)),1),T/freq,N).';
%     UTAn = UUAn./freq;
%     UUAnInd = UUAn;
%     UUAnInd(UUAnInd>0) = 1;
%     UnempIntInd = UU(:,1:freq:end);
% end
% if ~isempty(BB)
%     BBAn = reshape(sum(reshape(BB.',freq,N*(T/freq)),1),T/freq,N).';
%     BTAn = BBAn./freq;
% end
% if ~isempty(CC)
%     CCAn = reshape(sum(reshape(CC.',freq,N*(T/freq)),1),T/freq,N).';
%     CCAn = CCAn.*w0;
%     if ~isempty(WW)&&~isempty(EE)
%         MPCAn = CCAn./EWAn;
%     end
% end
% if ~isempty(HH)
%     HHAn = HH(:,1:freq:end);
%     ProdAn = HHAn.*w0;
% end
% if ~isempty(AA)
%     AAAn = AA(:,1:freq:end);
%     LiqAn = AAAn.*w0;
% end
% if ~isempty(ET)
%     TenAn = ET(:,1:freq:end);
% end
% if ~isempty(UT)
%     DurAn = reshape(sum(reshape(UT.',freq,N*(T/freq)),1),T/freq,N).';
%     IntDur = UT(:,1:freq:end);
%     UnempAnInd = (DurAn>0);
% end
% if ~isempty(UE)
%     UEAn = reshape(sum(reshape(UE(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
%     UEAnInd = UEAn;
%     UEAnInd(UEAnInd>0) = 1;
% end
% if ~isempty(EU)
%     EUAn = reshape(sum(reshape(EU(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
%     EUAnInd = EUAn;
%     EUAnInd(EUAnInd>0) = 1;
% end
% if ~isempty(E2E)
%     E2EAn = reshape(sum(reshape(E2E.',freq,N*(T/freq)),1),T/freq,N).';
%     E2EAnInd = E2EAn;
%     E2EAnInd(E2EAnInd>0) = 1;
%     if ~isempty(UU)&~isempty(EE)
%         sameJob = EEAnInd;
%         sameJob(E2EAnInd==1|UUAnInd==1) = 0;
%     end
% end
% if ~isempty(UB)
%     UBAn = reshape(sum(reshape(UB.',freq,N*(T/freq)),1),T/freq,N).';
%     UBAn = UBAn.*w0;
% end
% if ~isempty(WW)&&~isempty(EE)&&~isempty(AA)&&~isempty(BB)&&~isempty(UU)
%     Budget = EWAn + AAAn + UBAn + (UUAn - BBAn).*bl - bl./(1 + r);
%     if ~isempty(CC)
%         MPCBAn = CCAn./Budget;
%     end
% end
% if ~isempty(LL)
%     LLt = reshape(LL,N,1);
%     AFQT  = LL;
% end
% if ~isempty(WPrime)
%     WPrimeAn = reshape(sum(reshape(WPrime.',freq,N*(T/freq)),1),T/freq,N).';
%     WPrimeAn = WPrimeAn./freq;
% end
% if ~isempty(ThetaPrime)
%     ThetaPrimeAn = reshape(sum(reshape(ThetaPrime.',freq,N*(T/freq)),1),T/freq,N).';
%     ThetaPrimeAn = ThetaPrimeAn./freq;
%     PPrimeAn = reshape(sum(reshape(p(ThetaPrime).',freq,N*(T/freq)),1),T/freq,N).';
%     PPrimeAn = PPrimeAn./freq;
% end
% if ~isempty(ZZ)
%     ZZAn = reshape(sum(reshape(ZZ.',freq,N*(T/freq)),1),T/freq,N).';
%     ZZProdAn = ZZAn.*w0;
% end


if ~isempty(WW)&&~isempty(EE)
    IW = WW.*EE;
    IWAn = reshape(sum(reshape(IW.',freq,N*(T/freq)),1),T/freq,N).';
    IWAn = IWAn.*w0;
end
if ~isempty(WW)&&~isempty(EE)&&~isempty(TT)
    EW = WW.*(1 - TT).*EE;
    MeasErr = normrnd(0,SigXi,size(EW));
    LastMeasErr = normrnd(0,SigXi,size(EW));
    EW = exp(MeasErr).*EW;
    EWAn = reshape(sum(reshape(EW.',freq,N*(T/freq)),1),T/freq,N).';
    EWAn = EWAn.*w0;
    MeasErrAn = reshape(sum(reshape(MeasErr.',freq,N*(T/freq)),1),T/freq,N).';
    LastMeasErrAn = reshape(sum(reshape(LastMeasErr.',freq,N*(T/freq)),1),T/freq,N).';
end
if ~isempty(MU)
    MUAn = reshape(sum(reshape(MU.',freq,N*(T/freq)),1),T/freq,N).';
    MWAn = MUAn.*w0;
    MUAn = MUAn./freq;
    MUAn = MU;
    MUAn(EE==0) = NaN;
    MUAn = reshape(nanmean(reshape(MUAn.',freq,N*(T/freq)),1),T/freq,N).';
end
if ~isempty(TT)
    TTAn = reshape(sum(reshape(TT.',freq,N*(T/freq)),1),T/freq,N).';
    TTAn = TTAn./freq;
    if ~isempty(EE)
        TW = TT.*EE;
        TWAn = reshape(sum(reshape(TW.',freq,N*(T/freq)),1),T/freq,N).';
        TWProdAn = TWAn.*w0;
        TWAn = TWAn./freq;
    end
end
if ~isempty(EE)
    EEAn = reshape(sum(reshape(EE.',freq,N*(T/freq)),1),T/freq,N).';
    ETAn = EEAn./freq;
    EEAnInd = EEAn;
    EEAnInd(EEAnInd>0) = 1;
end
if ~isempty(UU)
    UUAn = reshape(sum(reshape(UU.',freq,N*(T/freq)),1),T/freq,N).';
    UTAn = UUAn./freq;
    UUAnInd = UUAn;
    UUAnInd(UUAnInd>0) = 1;
    UnempIntInd = UU(:,1:freq:end);
end
if ~isempty(BB)
    BBAn = reshape(sum(reshape(BB.',freq,N*(T/freq)),1),T/freq,N).';
    BTAn = BBAn./freq;
end
if ~isempty(CC)
    CCAn = reshape(sum(reshape(CC.',freq,N*(T/freq)),1),T/freq,N).';
    CCAn = CCAn.*w0;
    if ~isempty(WW)&&~isempty(EE)
        MPCAn = CCAn./EWAn;
    end
end
if ~isempty(HH)
    HHAn = HH(:,1:freq:end);
    ProdAn = HHAn.*w0;
end
if ~isempty(AA)
    AAAn = AA(:,1:freq:end);
    LiqAn = AAAn.*w0;
end
if ~isempty(ET)
    TenAn = ET(:,1:freq:end);
end
if ~isempty(UT)
    DurAn = reshape(sum(reshape(UT.',freq,N*(T/freq)),1),T/freq,N).';
    IntDur = UT(:,1:freq:end);
    UnempAnInd = (DurAn>0);
end
if ~isempty(UE)
    UEAn = reshape(sum(reshape(UE(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
    UEAnInd = UEAn;
    UEAnInd(UEAnInd>0) = 1;
end
if ~isempty(EU)
    EUAn = reshape(sum(reshape(EU(:,2:end).',freq,N*(T/freq)),1),T/freq,N).';
    EUAnInd = EUAn;
    EUAnInd(EUAnInd>0) = 1;
end
if ~isempty(E2E)
    E2EAn = reshape(sum(reshape(E2E.',freq,N*(T/freq)),1),T/freq,N).';
    E2EAnInd = E2EAn;
    E2EAnInd(E2EAnInd>0) = 1;
    if ~isempty(UU)&~isempty(EE)
        sameJob = EEAnInd;
        sameJob(E2EAnInd==1|UUAnInd==1) = 0;
    end
end
if ~isempty(UB)
    UBAn = reshape(sum(reshape(UB.',freq,N*(T/freq)),1),T/freq,N).';
    UBAn = UBAn.*w0;
end
if ~isempty(WW)&&~isempty(EE)&&~isempty(AA)&&~isempty(BB)&&~isempty(UU)
    Budget = EWAn + AAAn + UBAn + (UUAn - BBAn).*bl - bl./(1 + r);
    if ~isempty(CC)
        MPCBAn = CCAn./Budget;
    end
end
if ~isempty(LL)
    LLt = reshape(LL,N,1);
    AFQT  = LL;
end
if ~isempty(WPrime)
    WPrimeAn = reshape(sum(reshape(WPrime.',freq,N*(T/freq)),1),T/freq,N).';
    WPrimeAn = WPrimeAn./freq;
end
if ~isempty(ThetaPrime)
    ThetaPrimeAn = reshape(sum(reshape(ThetaPrime.',freq,N*(T/freq)),1),T/freq,N).';
    ThetaPrimeAn = ThetaPrimeAn./freq;
    PPrimeAn = reshape(sum(reshape(p(ThetaPrime).',freq,N*(T/freq)),1),T/freq,N).';
    PPrimeAn = PPrimeAn./freq;
end
if ~isempty(ZZ)
    ZZAn = reshape(sum(reshape(ZZ.',freq,N*(T/freq)),1),T/freq,N).';
    ZZProdAn = ZZAn.*w0;
end


if strcmpi(dataopts.dataset,'ScarringPanel')

    %%Unemployment Scarring Samples
    %Outline: Load sampling data, Construct panel, Impose Sample Restrictions
    % load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Scar1));
    % nobsScar1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_1));
    nobsScar1_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_2));
    nobsScar1_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_3));
    nobsScar1_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_4));
    nobsScar1_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_5));
    nobsScar1_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_11stYN));
    nobsScar1_11stYN = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.UnempScar1_21stYN));
    nobsScar1_21stYN = temp;
    %%Auxliary Model 8: NLSY Moments
    % load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.Scar2));
    % nobsScar2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_1));
    nobsScar2_1 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_2));
    nobsScar2_2 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_3));
    nobsScar2_3 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_4));
    nobsScar2_4 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_5));
    nobsScar2_5 = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_11stYN));
    nobsScar2_11stYN = temp;
    load(fullfile(opts.project_path,opts.input_path,'/',NObsNames.EmpScar2_21stYN));
    nobsScar2_21stYN = temp;
    clear temp;

    AgepanelAn = 23:64;
    AgepanelAn = repmat(AgepanelAn,N,1);
    IndID = 1:N;
    IndID = IndID'*ones(1,T/freq);
    UUAnWks = 13.*UUAn;
    HrsWrkedAn = 40.*(52.*ones(size(UUAnWks)) - UUAnWks);

    lifecycleArray = cat(2,reshape(IndID.',[],1),reshape(AgepanelAn.',[],1),reshape(EWAn.',[],1),reshape(EEAn.',[],1),reshape(UUAn.',[],1),reshape(repmat(AFQT,1,T/freq).',[],1), ...
                         reshape(UTAn.',[],1),reshape(DurAn.',[],1),reshape(HHAn.',[],1),reshape(AAAn.',[],1),reshape(LiqAn.',[],1),reshape(UEAnInd.',[],1), ...
                         reshape(EUAnInd.',[],1),reshape(E2EAnInd.',[],1),reshape(UBAn.',[],1),reshape(MUAn.',[],1),reshape(TTAn.',[],1), ...
                         reshape(ETAn.',[],1),reshape(TenAn.',[],1),reshape(BBAn.',[],1),reshape(BTAn.',[],1),reshape(TWAn.',[],1),reshape(HrsWrkedAn.',[],1), ...
                         reshape(UUAnInd.',[],1),reshape(EEAnInd.',[],1),reshape(ZZAn.',[],1),reshape(CCAn.',[],1),reshape(UUAnWks.',[],1),reshape(HrsWrkedAn.',[],1), ...
                         reshape(WPrimeAn.',[],1),reshape(PPrimeAn.',[],1),reshape(ThetaPrimeAn.',[],1),reshape(MeasErrAn.',[],1));

    Panel = array2table(lifecycleArray,'VariableNames',{'IndID','Age','RInc','Emp','Unemp','AFQT','UnempScaled','UnempDur','HumanCap','AA','RLiqWealth', ...
                        'U2J','J2U','J2J','UIAmt','PieceRate','LearnTime','EmpScaled','Tenure','UI_yn','UIDur','LearnTimeEmp','HrsWrked', ...
                        'UnempInd','EmpInd','ZZPctShocks','Cons','UnempWks','HrsWkred','ApplicationStrategy','EmploymentProbability','SubmarketTightness','MeasErrAn'});


    Panel.J2UAlt = zeros(size(Panel.J2U));
    Panel.J2UAlt(Panel.J2U==1&Panel.UnempInd==1) = 1;

    AgeGrp = zeros(size(AgepanelAn));
    AgeGrp(AgepanelAn<=40) = 1;
    AgeGrp(AgepanelAn>40) = 2;
    Panel.AgeGrp = reshape(AgeGrp.',[],1);
    Panel.AgeSq = Panel.Age.^2;

    Panel.RInc(Panel.RInc<=0|Panel.Emp<=0) = NaN;
    Panel.RIncHVY = Panel.RInc;
    Panel.RIncHVY(Panel.Age<=30&(Panel.RInc<4750)) = NaN;
    Panel.RIncHVY(Panel.Age>30&(Panel.RInc<9500)) = NaN;
    Panel.HVYInd = zeros(size(Panel.Age));
    Panel.HVYInd(~isnan(Panel.RIncHVY)) = 1;

    Panel.LRInc = log(Panel.RInc);
    RInc = reshape(Panel.RInc,T./freq,N).';
    Emp = reshape(Panel.Emp,T./freq,N).';
    AppStrat = reshape(Panel.ApplicationStrategy,T./freq,N).';
    LRInc = reshape(Panel.LRInc,T./freq,N).';
    LHumanCap = log(Panel.HumanCap);
    LHumanCap = reshape(LHumanCap,T./freq,N).';
    LPieceRate = log(Panel.PieceRate);
    LPieceRate = reshape(LPieceRate,T./freq,N).';
    LProdTime = log(1 - Panel.LearnTimeEmp);
    LProdTime = reshape(LProdTime,T./freq,N).';

    LRIncMat = zeros(N,T./freq,15);
    EmpMat = zeros(N,T./freq,15);
    AppStratMat = zeros(N,T./freq,15);
    LHumanCapMat = zeros(N,T./freq,15);
    LPieceRateMat = zeros(N,T./freq,15);
    LProdTimeMat = zeros(N,T./freq,15);

    for i = 1:27
        LRIncMat(:,i,:) = LRInc(:,i+1:i+15);
        AppStratMat(:,i,:) = AppStrat(:,i+1:i+15);
        EmpMat(:,i,:) = Emp(:,i+1:i+15);
        LHumanCapMat(:,i,:) = LHumanCap(:,i+1:i+15);
        LPieceRateMat(:,i,:) = LPieceRate(:,i+1:i+15);
        LProdTimeMat(:,i,:) = LProdTime(:,i+1:i+15);
    end


    LRIncMat(:,28,1:end-1) = LRInc(:,29:42);
    EmpMat(:,28,1:end-1) = Emp(:,29:42);
    AppStratMat(:,28,1:end-1) = AppStrat(:,29:42);
    LHumanCapMat(:,28,1:end-1) = LHumanCap(:,29:42);
    LPieceRateMat(:,28,1:end-1) = LPieceRate(:,29:42);
    LProdTimeMat(:,28,1:end-1) = LProdTime(:,29:42);

    RIncPrev1 = zeros(N,T./freq);
    EmpPrev1 = zeros(N,T./freq);
    LRIncPrev1 = zeros(N,T./freq);
    LHumanCapPrev1 = zeros(N,T./freq);
    LPieceRatePrev1 = zeros(N,T./freq);
    LProdTimePrev1 = zeros(N,T./freq);

    for i = 2:28
        RIncPrev1(:,i) = RInc(:,i-1);
        EmpPrev1(:,i) = Emp(:,i-1);
        LRIncPrev1(:,i) = LRInc(:,i-1);
        LHumanCapPrev1(:,i) = LHumanCap(:,i-1);
        LPieceRatePrev1(:,i) = LPieceRate(:,i-1);
        LProdTimePrev1(:,i) = LProdTime(:,i-1);
    end

    LRIncMat = reshape(permute(LRIncMat,[2,1,3]),[],15);
    EmpMat = reshape(permute(EmpMat,[2,1,3]),[],15);
    AppStratMat = reshape(permute(AppStratMat,[2,1,3]),[],15);
    LHumanCapMat = reshape(permute(LHumanCapMat,[2,1,3]),[],15);
    LPieceRateMat = reshape(permute(LPieceRateMat,[2,1,3]),[],15);
    LProdTimeMat = reshape(permute(LProdTimeMat,[2,1,3]),[],15);


    for i=1:15
        Panel = [Panel array2table(LRIncMat(:,i),'VariableNames',{strcat('LRInc',int2str(i))})];
        Panel = [Panel array2table(EmpMat(:,i),'VariableNames',{strcat('Emp',int2str(i))})];
        Panel = [Panel array2table(AppStratMat(:,i),'VariableNames',{strcat('AppStrat',int2str(i))})];
        Panel = [Panel array2table(LHumanCapMat(:,i),'VariableNames',{strcat('LHumanCap',int2str(i))})];
        Panel = [Panel array2table(LPieceRateMat(:,i),'VariableNames',{strcat('LPieceRate',int2str(i))})];
        Panel = [Panel array2table(LProdTimeMat(:,i),'VariableNames',{strcat('LProdTime',int2str(i))})];
    end

    Panel = [Panel array2table(cat(2,reshape(LRIncPrev1.',[],1),reshape(LHumanCapPrev1.',[],1),reshape(LPieceRatePrev1.',[],1),reshape(LProdTimePrev1.',[],1),reshape(EmpPrev1.',[],1)),'VariableNames',{'LRIncPrev1','LHumanCapPrev1','LPieceRatePrev1','LProdTimePrev1','EmpPrev1'})];

    Panel = [Panel array2table(reshape(RIncPrev1.',[],1),'VariableNames',{'RIncPrev1'})];

    wlthqtile = reshape(ceil(5*tiedrank(reshape(LiqAn(:),[],1))/length(reshape(LiqAn(:),[],1))),N,T./freq);
    Panel.RLiqWealth_Presentqtile = reshape(wlthqtile.',[],1);

    humancapqtile = reshape(ceil(5*tiedrank(reshape(HHAn(:),[],1))/length(reshape(HHAn(:),[],1))),N,T./freq);
    learnqtile = repmat(ceil(5*tiedrank(reshape(LL(:),[],1))/length(reshape(LL(:),[],1))),1,T./freq);

    Panel.HumanCap_Presentqtile = reshape(humancapqtile.',[],1);
    Panel.AFQT_qtile = reshape(learnqtile.',[],1);
    clear wlthqtile humancapqtile;
    initwlthqtile = repmat(ceil(5*tiedrank(reshape(AA(:,1),[],1))/length(reshape(AA(:,1),[],1))),1,T./freq);
    inithumancapqtile = repmat(ceil(5*tiedrank(reshape(HH(:,1),[],1))/length(reshape(HH(:,1),[],1))),1,T./freq);
    Panel.RLiqWealth_qtile = reshape(initwlthqtile.',[],1);
    Panel.HumanCap_qtile = reshape(inithumancapqtile.',[],1);
    Panel.Wealth_Presentqtile2 = zeros(size(Panel.RLiqWealth_Presentqtile));
    Panel.Wealth_Presentqtile2(Panel.RLiqWealth_Presentqtile==1) = 0;
    Panel.Wealth_Presentqtile2(Panel.RLiqWealth_Presentqtile>1) = 1;



    %Find indices for randomly dropped households
    % MissRepScar1 = zeros(5,51-24);
    % MissRepScar1(1,:) = nobsScar1_1;
    % MissRepScar1(2,:) = nobsScar1_2;
    % MissRepScar1(3,:) = nobsScar1_3;
    % MissRepScar1(4,:) = nobsScar1_4;
    % MissRepScar1(5,:) = nobsScar1_5;

    % MissRepScar1_1stYN = zeros(2,51-24);
    % MissRepScar1_1stYN(1,:) = nobsScar1_11stYN;
    % MissRepScar1_1stYN(2,:) = nobsScar1_21stYN;


    % MissRepScar2 = zeros(5,51-24);
    % MissRepScar2(1,:) = nobsScar2_1;
    % MissRepScar2(2,:) = nobsScar2_2;
    % MissRepScar2(3,:) = nobsScar2_3;
    % MissRepScar2(4,:) = nobsScar2_4;
    % MissRepScar2(5,:) = nobsScar2_5;

    % MissRepScar2_1stYN = zeros(2,51-24);
    % MissRepScar2_1stYN(1,:) = nobsScar2_11stYN;
    % MissRepScar2_1stYN(2,:) = nobsScar2_21stYN;


    Panel.EmpScarSubset = zeros(size(Panel.LRInc));
    Panel.EmpScarSubset(Panel.RInc>=4750 & Panel.EmpInd==1 & Panel.J2J==0 & Panel.J2U==0 & Panel.Age >= 23 & Panel.Age<=50) = 1;

    Panel.UnempScarSubset = zeros(size(Panel.LRInc));
    Panel.UnempScarSubset(Panel.RInc>=2375 & Panel.Age>=23 & Panel.Age<=50) = 1;

    UnempScarSubset = reshape(Panel.UnempScarSubset,T./freq,N);
    UnempScarSubset(2:end,:) = UnempScarSubset(1:end-1,:);
    UnempScarSubset(1,:) = 0;
    Panel.UnempScarSubset = reshape(UnempScarSubset,[],1);


    Panel.Wealth_qtile = categorical(Panel.RLiqWealth_qtile);
    Panel.HumanCap_qtile = categorical(Panel.HumanCap_qtile);
    Panel.Learn_qtile = categorical(Panel.AFQT_qtile);

    Panel.Wealth_Presentqtile = categorical(Panel.RLiqWealth_Presentqtile);
    Panel.Wealth_Presentqtile2 = categorical(Panel.Wealth_Presentqtile2);
    Panel.HumanCap_Presentqtile = categorical(Panel.HumanCap_Presentqtile);

    % SampSizeAux4DropNaN = NumObs.PSIDTotal*((T - TYoung - TOld)/freq) - sum(sum(MissRepAux4<=0));
    % MissRepAux4 = cat(2,zeros(NumObs.PSIDTotal,TYoung/freq),MissRepAux4,zeros(NumObs.PSIDTotal,TOld/freq));
    % SampSizeScar1 = sum(MissRepScar1(:),1);
    % SampSizeScar2 = sum(MissRepScar2(:),1);


    % Panel.UnempScar1Weight = zeros(size(Panel.RLiqWealth_Presentqtile));
    % Panel.UnempScar11stYNWeight = zeros(size(Panel.RLiqWealth_Presentqtile));
    % Panel.EmpScar2Weight = zeros(size(Panel.RLiqWealth_Presentqtile));
    % Panel.EmpScar21stYNWeight = zeros(size(Panel.RLiqWealth_Presentqtile));

    % for i = 1:(51-24)
    %     for j = 1:5
    %         Panel.UnempScar1Weight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar1(j,i);
    %         Panel.EmpScar2Weight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar2(j,i);
    %         if j >=2
    %             Panel.UnempScar11stYNWeight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar1_1stYN(2,i);
    %             Panel.EmpScar21stYNWeight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar2_1stYN(2,i);
    %         else
    %             Panel.UnempScar11stYNWeight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar1_1stYN(1,i);
    %             Panel.EmpScar21stYNWeight(Panel.Age==i+23&Panel.Wealth_Presentqtile==int2str(j)) = MissRepScar2_1stYN(1,i);
    %         end
    %     end
    % end


    % try
    %     [~,idx] = datasample(Panel,SampSizeScar1,'Weights',Panel.UnempScar1Weight(:),'Replace',true);
    %     Panel = Panel;
    %     Panel = Panel(idx,:);
    % catch
    %     err = 1;
    %     Panel = Panel;
    % end

    % Panel.J2U(Panel.Emp~=4&Panel.J2U==0) = -1;

    % Panel(Panel.Age>50|Panel.Age==23,:) = [];

    Panel.AgeCat = categorical(Panel.Age);

    clear AgepanelAn IndID UUAnWks AFQT HrsWrkedAn AFQTQtile initwlthqtile learnqtile MissRepAux2 MissRepAux3 G IW_init_dist AA_init_dist ...
        MissRepAux4_1 MissRepAux4_2 MissRepAux4_3 MissRepAux4_4 MissRepAux4_5 MissRepAux4 RInc_3 nobsAux3HVY ...
        MissRepAux4_1HVY MissRepAux4_2HVY MissRepAux4_3HVY MissRepAux4_4HVY MissRepAux4_5HVY MissRepAux4 MissRepAux5 ...
        RInc_3 RIncHVY_3 IWAnYoung IWAnOld IWAnHVY;

end

clear alb IW IWAn w0 MUAn MWAn TTAn TW TWAn TWProdAn EEAn ETAn EEAInd UUAn BBAn CCAn MPCAn UTAn UUAnInd HHAn AAAn TenAn DurAn UBAn ProdAn LiqAn Learn ZZAn ZZProdAn;

end
% LocalWords:  MissRepAux
