function [J0,Theta,R,Rub,V,aprimee1,thate1,hhate1,hgrid,lgrid,ttgrid,hmesh,lmesh,xxigrid,Epsgrid,EpsPDF] = GridsNoSearch(params, order, opts)

%% Initialize Matrices and Guesses in Model with state (w,a) and contractible assets

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

% Initialize Value (J0(w,a)) of a Job 

if opts.gpu == 'y'
    [Epsgrid, EpsPDF, ~] = CompTrapInt(Epsnodes,MuEps,SigEps,StdEps);
    Epsgrid = gpuArray(Epsgrid);
    EpsPDF = gpuArray(EpsPDF);
    J0       = zeros(Na,Nh,Nl,'gpuArray');        % fliplr(wgrid')'*agrid'

    % Initialize Market Tightness (Theta(v,a))

    Theta = zeros(Na,Nh,Nl,'gpuArray');

    % Initialize Returns to Search Worker (R0(w,a),Ru0(a))

    R     = zeros(Na,Nh,Nl,'gpuArray');      % Employed Worker
    Rub    = zeros(Na,Nh,Nl,'gpuArray');       % Unemployed Worker

    % Initialize Value Function Worker (V0(w,a),Vu0(a))

    V     = zeros(Na,Nh,Nl,'gpuArray');      % Employed Worker

    % Store Value Functions and Decision Rules

    aprimee1    = zeros(Na,Nh,Nl,'gpuArray');           % Optimal search policy employed worker (assets)
    thate1    = zeros(Na,Nh,Nl,'gpuArray');
    hhate1    = zeros(Na,Nh,Nl,'gpuArray');

    
    ca     = 3;                                          % Curvature of the agrid
    cw     = 2;                                          % Curvature of the agrid
    %ch     = 2;
    %wgrid  = gpuArray(linspace(lb.w.^(1/cw),ub.w.^(1/cw),Nw).^cw);
    hgrid  = gpuArray(linspace(lb.h,ub.h,Nh));
    lgrid  = gpuArray(linspace(lb.l,ub.l,Nl));
    ttgrid  = gpuArray(linspace(lb.t,ub.t,nt));
    
    [hmesht,lmesht,tmesht] = ndgrid(hgrid,lgrid,linspace(lb.t,ub.t,nt));
    xxigrid = max(min(xxi(hmesht,lmesht,tmesht),ub.h),lb.h);
    clear lmesht hmesht tmesht;
    
    [~,hmesh,lmesh] = ndgrid((linspace(lb.a.^(1/ca),ub.a.^(1/ca),Na).^ca),hgrid,lgrid);
    hmesh = gpuArray(hmesh);
    lmesh = gpuArray(lmesh);
else
    [Epsgrid, EpsPDF, ~] = CompTrapInt(Epsnodes,MuEps,SigEps,StdEps);
    [RRgrid, RRPDF, ~] = CompTrapInt(RRnodes,RRnodes,MuRR,SigRR,StdRR);

    J0       = zeros(Na,Nh,Nl);        % fliplr(wgrid')'*agrid'

    % Initialize Market Tightness (Theta(v,a))

    Theta = zeros(Na,Nh,Nl);

    % Initialize Returns to Search Worker (R0(w,a),Ru0(a))

    R     = zeros(Na,Nh,Nl);      % Employed Worker
    Rub    = zeros(Nb,Na,Nh,Nl);       % Unemployed Worker
    Rubl    = zeros(Na,Nh,Nl);       % Unemployed Worker

    % Initialize Value Function Worker (V0(w,a),Vu0(a))

    V     = zeros(Na,Nh,Nl);      % Employed Worker

    % Store Value Functions and Decision Rules

    wprimee1    = zeros(Na,Nh,Nl);           % Optimal search policy employed worker (wage)
    aprimee1    = zeros(Na,Nh,Nl);           % Optimal search policy employed worker (assets)
    thate1    = zeros(Na,Nh,Nl);
    hhate1    = zeros(Na,Nh,Nl);

    wprimeu1b    = zeros(Nb,Na,Nh,Nl);       % Optimal search policy unemployed worker (value)
    ca     = 3;                                          % Curvature of the agrid
    wgrid  = linspace(lb.w,ub.w,Nw);          % Grid for wages
    hgrid  = linspace(lb.h,ub.h,Nh);
    lgrid  = linspace(lb.l,ub.l,Nl);
    bgrid  = linspace(lb.b,ub.b,Nb);
    wugrid  = linspace(lb.w,ub.w,nw);
    ttgrid  = linspace(lb.t,ub.t,nt);
    wwgrid = zeros(Nw,nw);
    for iw = 1:Nw
        wwgrid(iw,:) = linspace(wgrid(iw),ub.w,nw);
    end

    [hmesht,lmesht,tmesht] = ndgrid(linspace(lb.h,ub.h,Nh),linspace(lb.l,ub.l,Nl),linspace(lb.t,ub.t,nt));
    xxigrid = max(min(xxi(hmesht,lmesht,tmesht),ub.h),lb.h);
    clear lmesht hmesht tmesht;
    
    [wmesh,~,hmesh,lmesh] = ndgrid(linspace(lb.w,ub.w,Nw),(linspace(lb.a.^(1/ca),ub.a.^(1/ca),Na).^ca),linspace(lb.h,ub.h,Nh),linspace(lb.l,ub.l,Nl));
end








