function HeterogeneityAverageStats(params, order, opts, testopts, statNames, YLabs, statArrayNames, statArray)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,testopts.dir);
    model_results_table_path = fullfile(results_table_path,testopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

% StatArray: 1: TimeVar, 2: LRInc, 3: RInc, 4: RIncEmp, 5: HumanCap, 6: HumanCapEmp, 7: HumanCapUnemp, 8: HumanCapUnempwUI, 9: HumanCapUnempwoUI, 10: RLiqWealth, 11: RLiqWealthEmp, 12: RLiqWealthUnemp, 13: RLiqWealthUnempwUI, 14: RLiqWealthUnempwoUI, 15: Emp, 16: Unemp, 17: UnempwUI, 18: Ten, 19: TenEmp, 20: Cons, 21: ConsEmp, 22: ConsUnemp, 23: ConsUnempwUI, 24: ConsUnempwoUI, 25: PieceRate, 26: AppStrat, 27: AppStratEmp, 28: AppStratUnemp, 29: AppStratUnempwUI, 30: AppStratUnempwoUI, 31: EmpProb, 32: EmpProbEmp, 33: EmpProbUnemp, 34: EmpProbUnempwUI, 35: EmpProbUnempwoUI, 36: SubTightness, 37: SubTightnessEmp, 38: SubTightnessUnemp, 39: SubTightnessUnempwUI, 40: SubTightnessUnempwoUI, 41: LearnTime, 42: LearnTimeEmp, 43: UnempDur



%%Statistics
% Time Series: Income

for i = 1:size(statArray,1)
    TableArray = cat(2,squeeze(statArray(i,1,:)),squeeze(statArray(i,2,:)),squeeze(statArray(i,3,:)),squeeze(statArray(i,4,:)),squeeze(statArray(i,5,:)));
    TableArrayNames = cat(1,statNames,statNames,statNames,statNames,statNames).';
    TableArrayNames = strcat(strtrim(TableArrayNames),cat(2,repmat({'_1'},length(statNames),1),repmat({'_2'},length(statNames),1),repmat({'_3'},length(statNames),1),repmat({'_4'},length(statNames),1),repmat({'_5'},length(statNames),1)));
    TableArray = reshape(TableArray.',[],1);
    TableArrayNames = reshape(TableArrayNames.',[],1);    
    fid = fopen(strcat(results_table_path,statArrayNames{i},'Averages',testopts.('name'),'.csv'), 'w');
    fprintf(fid, 'Ave,');
    fprintf(fid, 'Value\n');
    fclose(fid);
    fid = fopen(strcat(results_table_path,statArrayNames{i},'Averages',testopts.('name'),'.csv'), 'a+');
    if fid>0
        for k=1:size(TableArray,1)
            fprintf(fid,'%s,%f\n',TableArrayNames{k},TableArray(k));
        end
        fclose(fid);
    end
end
    


% LRInc Total Difference

for i = 1:size(statArray,1)
    TableArray = cat(2,squeeze(statArray(i,2,:))./squeeze(statArray(i,1,:)),squeeze(statArray(i,3,:))./squeeze(statArray(i,1,:)),squeeze(statArray(i,4,:))./squeeze(statArray(i,1,:)),squeeze(statArray(i,5,:))./squeeze(statArray(i,1,:)));
    TableArrayNames = cat(1,statNames,statNames,statNames,statNames).';
    TableArrayNames = strcat(strtrim(TableArrayNames),cat(2,repmat({'_12'},length(statNames),1),repmat({'_13'},length(statNames),1),repmat({'_14'},length(statNames),1),repmat({'_15'},length(statNames),1)));    
    TableArray = reshape(TableArray.',[],1);
    TableArrayNames = reshape(TableArrayNames.',[],1);    
    fid = fopen(strcat(results_table_path,statArrayNames{i},'Ratios',testopts.('name'),'.csv'), 'w');
    fprintf(fid, 'Ratio,');
    fprintf(fid, 'Value\n');
    fclose(fid);
    fid = fopen(strcat(results_table_path,statArrayNames{i},'Ratios',testopts.('name'),'.csv'), 'a+');
    if fid>0
        for k=1:size(TableArray,1)
            fprintf(fid,'%s,%f\n',TableArrayNames{k},TableArray(k));
        end
        fclose(fid);
    end
end
    


for i = 1:size(statArray,1)
    TableArray = cat(2,(squeeze(statArray(i,2,:))./squeeze(statArray(i,1,:))-1)*100,(squeeze(statArray(i,3,:))./squeeze(statArray(i,1,:))-1)*100,(squeeze(statArray(i,4,:))./squeeze(statArray(i,1,:))-1)*100,(squeeze(statArray(i,5,:))./squeeze(statArray(i,1,:))-1)*100);
    TableArrayNames = cat(1,statNames,statNames,statNames,statNames).';
    TableArrayNames = strcat(strtrim(TableArrayNames),cat(2,repmat({'_12'},length(statNames),1),repmat({'_13'},length(statNames),1),repmat({'_14'},length(statNames),1),repmat({'_15'},length(statNames),1)));    
    TableArray = reshape(TableArray.',[],1);
    TableArrayNames = reshape(TableArrayNames.',[],1);    
    fid = fopen(strcat(results_table_path,statArrayNames{i},'PctChange',testopts.('name'),'.csv'), 'w');
    fprintf(fid, 'Ratio,');
    fprintf(fid, 'Value\n');
    fclose(fid);
    fid = fopen(strcat(results_table_path,statArrayNames{i},'PctChange',testopts.('name'),'.csv'), 'a+');
    if fid>0
        for k=1:size(TableArray,1)
            fprintf(fid,'%s,%f\n',TableArrayNames{k},TableArray(k));
        end
        fclose(fid);
    end
end

end