function HeterogeneityPlots(params, order, opts, plotopts, StatName, YLabs, lifetime_earnings, lifetime_variance, StatArray, nStats, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,b,MaxUI,bRet,kkappa,ssigma,nnu,aalphah,T,TYoung,TOld,TSim,TTotSim,TChunks,MinAge,llambu,llambe,eepsilon,lb,ub,delt,MPS,Na,Nz,Nb,Nw,Nh,Nl, ...
 na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEpsE,SigEpsE,MuEpsU,SigEpsU,StdEps,SigXi,MuZ,SigZ,StdZ,rhoZ,errtol,exitProb] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

% StatArray: 1: TimeVar, 2: LRInc, 3: RInc, 4: RIncEmp, 5: HumanCap, 6: HumanCapEmp, 7: HumanCapUnemp, 8: HumanCapUnempwUI, 9: HumanCapUnempwoUI, 10: RLiqWealth, 11: RLiqWealthEmp, 12: RLiqWealthUnemp, 13: RLiqWealthUnempwUI, 14: RLiqWealthUnempwoUI, 15: Emp, 16: Unemp, 17: UnempwUI, 18: Ten, 19: TenEmp, 20: Cons, 21: ConsEmp, 22: ConsUnemp, 23: ConsUnempwUI, 24: ConsUnempwoUI, 25: PieceRate, 26: AppStrat, 27: AppStratEmp, 28: AppStratUnemp, 29: AppStratUnempwUI, 30: AppStratUnempwoUI, 31: EmpProb, 32: EmpProbEmp, 33: EmpProbUnemp, 34: EmpProbUnempwUI, 35: EmpProbUnempwoUI, 36: SubTightness, 37: SubTightnessEmp, 38: SubTightnessUnemp, 39: SubTightnessUnempwUI, 40: SubTightnessUnempwoUI, 41: LearnTime, 42: LearnTimeEmp, 43: UnempDur


[ColorSet2,~,~] = brewermap(24,'RdYlBu');
[ColorSet3,~,~] = brewermap(24,'BrBG');
[ColorSet4,~,~] = brewermap(24,'PRGn');
[ColorSet1,~,~] = brewermap(24,'RdYlBu');
[ColorSet5,~,~] = brewermap(12,'Paired');

FormatOpts1 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                     'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts2 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                     'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts3 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                     'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts4 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                     'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts5 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                     'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,6,4]);


%%Plots
% Time Series: Loop over StatNames above

if dataopts.norm == 'y'
    for i = 2:length(statNames)
        [f01, p1] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i))./repmat(squeeze(StatArray(:,1,i)),1,T./freq),FormatOpts1,ColorSet1(3,:),'y');
        hold on;
        [~, p2] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+1*nStats))./repmat(squeeze(StatArray(:,1,i+1*nStats)),1,TSim+1),FormatOpts2,ColorSet1(8,:),'n');
        [~, p3] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+2*nStats))./repmat(squeeze(StatArray(:,1,i+2*nStats)),1,TSim+1),FormatOpts3,ColorSet1(22,:),'n');
        [~, p4] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+3*nStats))./repmat(squeeze(StatArray(:,1,i+3*nStats)),1,TSim+1),FormatOpts4,ColorSet4(3,:),'n');
        [~, p5] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+4*nStats))./repmat(squeeze(StatArray(:,1,i+4*nStats)),1,TSim+1),FormatOpts5,ColorSet4(22,:),'n');
        yLims = get(gca,'ylim');
        % pt = patch([RecessionShade flip(RecessionShade)],[min(yLims) min(yLims) max(yLims) max(yLims)],[0.5 0.5 0.5]);
        % pt.FaceAlpha = 0.4;
        % pt.EdgeColor = 'none';
        % ylim([min(yLims) max(yLims)]);
        % uistack(pt,'top')
        xlabel('Age')
        ylabel(YLabs{i})
        hleg1 = legend([p1,p2,p3,p4,p5],'Q1','Q2','Q3','Q4','Q5');
        set(hleg1,'Location','bestoutside');
        figfile = fullfile(results_graphics_path,strcat(StatName{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
    end
else
    for i = 2:length(statNames)
        [f01, p1] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i)),FormatOpts1,ColorSet1(3,:),'y');
        hold on;
        [~, p2] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+1*nStats)),FormatOpts2,ColorSet1(8,:),'n');
        [~, p3] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+2*nStats)),FormatOpts3,ColorSet1(22,:),'n');
        [~, p4] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+3*nStats)),FormatOpts4,ColorSet4(3,:),'n');
        [~, p5] = PlotFun(squeeze(StatArray(1,:,1)),squeeze(StatArray(:,:,i+4*nStats)),FormatOpts5,ColorSet4(22,:),'n');
        yLims = get(gca,'ylim');
        % pt = patch([RecessionShade flip(RecessionShade)],[min(yLims) min(yLims) max(yLims) max(yLims)],[0.5 0.5 0.5]);
        % pt.FaceAlpha = 0.4;
        % pt.EdgeColor = 'none';
        % ylim([min(yLims) max(yLims)]);
        % uistack(pt,'top')
        xlabel('Age')
        ylabel(YLabs{i})
        hleg1 = legend([p1,p2,p3,p4,p5],'Q1','Q2','Q3','Q4','Q5');
        set(hleg1,'Location','bestoutside');
        figfile = fullfile(results_graphics_path,strcat(StatName{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
    end
end

end