function HeterogeneityStats(params, order, opts, testopts, StatName, YLabs, StatArray, nStats)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,b,MaxUI,bRet,kkappa,ssigma,nnu,aalphah,T,TYoung,TOld,TSim,TTotSim,TChunks,MinAge,llambu,llambe,eepsilon,lb,ub,delt,MPS,Na,Nz,Nb,Nw,Nh,Nl, ...
 na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEpsE,SigEpsE,MuEpsU,SigEpsU,StdEps,SigXi,MuZ,SigZ,StdZ,rhoZ,errtol,exitProb] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,testopts.dir);
    model_results_table_path = fullfile(results_table_path,testopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

% StatArray: 1: TimeVar, 2: LRInc, 3: RInc, 4: RIncEmp, 5: HumanCap, 6: HumanCapEmp, 7: HumanCapUnemp, 8: HumanCapUnempwUI, 9: HumanCapUnempwoUI, 10: RLiqWealth, 11: RLiqWealthEmp, 12: RLiqWealthUnemp, 13: RLiqWealthUnempwUI, 14: RLiqWealthUnempwoUI, 15: Emp, 16: Unemp, 17: UnempwUI, 18: Ten, 19: TenEmp, 20: Cons, 21: ConsEmp, 22: ConsUnemp, 23: ConsUnempwUI, 24: ConsUnempwoUI, 25: PieceRate, 26: AppStrat, 27: AppStratEmp, 28: AppStratUnemp, 29: AppStratUnempwUI, 30: AppStratUnempwoUI, 31: EmpProb, 32: EmpProbEmp, 33: EmpProbUnemp, 34: EmpProbUnempwUI, 35: EmpProbUnempwoUI, 36: SubTightness, 37: SubTightnessEmp, 38: SubTightnessUnemp, 39: SubTightnessUnempwUI, 40: SubTightnessUnempwoUI, 41: LearnTime, 42: LearnTimeEmp, 43: UnempDur



%%Statistics
% Time Series: Income

% LRInc Total Difference

LRInc_21 = sum(squeeze(nanmean(StatArray(:,:,2+1*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_31 = sum(squeeze(nanmean(StatArray(:,:,2+2*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_41 = sum(squeeze(nanmean(StatArray(:,:,2+3*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_51 = sum(squeeze(nanmean(StatArray(:,:,2+4*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,2),1)));
TableArray = [LRInc_21;LRInc_31;LRInc_41;LRInc_51];
TableArrayNames = {'LRInc_21','LRInc_31','LRInc_41','LRInc_51'};
clear LRInc_21 LRInc_31 LRInc_41 LRInc_51;

for i = 3:(nStats+1)
    Stat_21 = sum(squeeze(nanmean(StatArray(:,:,i+1*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_31 = sum(squeeze(nanmean(StatArray(:,:,i+2*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_41 = sum(squeeze(nanmean(StatArray(:,:,i+3*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_51 = sum(squeeze(nanmean(StatArray(:,:,i+4*nStats),1)))./sum(squeeze(nanmean(StatArray(:,:,i),1)));
    TableArray = [TableArray;Stat_21;Stat_31;Stat_41;Stat_51];
    TableArrayNames(end+1:end+4) = {sprintf('%s_21',StatName{i}),sprintf('%s_31',StatName{i}),sprintf('%s_41',StatName{i}),sprintf('%s_51',StatName{i})};
end

RatArray = [reshape(TableArrayNames,[],1) num2cell(TableArray)];
fid = fopen(strcat(results_table_path,'Ratios',testopts.('name'),'.csv'), 'w');
fprintf(fid, 'Ratio,');
fprintf(fid, 'Value\n');
fclose(fid);
fid = fopen(strcat(results_table_path,'Ratios',testopts.('name'),'.csv'), 'a+');
if fid>0
     for k=1:size(RatArray,1)
         fprintf(fid,'%s,%f\n',RatArray{k,:});
     end
     fclose(fid);
end


% LRInc Total Difference

LRInc_21 = sum(squeeze(nanmean(StatArray(:,:,2+1*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_31 = sum(squeeze(nanmean(StatArray(:,:,2+2*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_41 = sum(squeeze(nanmean(StatArray(:,:,2+3*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_51 = sum(squeeze(nanmean(StatArray(:,:,2+4*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,2),1)));
TableArray = [LRInc_21;LRInc_31;LRInc_41;LRInc_51];
TableArrayNames = {'LRInc_21','LRInc_31','LRInc_41','LRInc_51'};
clear LRInc_21 LRInc_31 LRInc_41 LRInc_51;

for i = 3:(nStats+1)
    Stat_21 = sum(squeeze(nanmean(StatArray(:,:,i+1*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_31 = sum(squeeze(nanmean(StatArray(:,:,i+2*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_41 = sum(squeeze(nanmean(StatArray(:,:,i+3*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_51 = sum(squeeze(nanmean(StatArray(:,:,i+4*nStats),1))) - sum(squeeze(nanmean(StatArray(:,:,i),1)));
    TableArray = [TableArray;Stat_21;Stat_31;Stat_41;Stat_51];
    TableArrayNames(end+1:end+4) = {sprintf('%s_21',StatName{i}),sprintf('%s_31',StatName{i}),sprintf('%s_41',StatName{i}),sprintf('%s_51',StatName{i})};
end

RatArray = [reshape(TableArrayNames,[],1) num2cell(TableArray)];
fid = fopen(strcat(results_table_path,'DiffSum',testopts.('name'),'.csv'), 'w');
fprintf(fid, 'Diff,');
fprintf(fid, 'Value\n');
fclose(fid);
fid = fopen(strcat(results_table_path,'DiffSum',testopts.('name'),'.csv'), 'a+');
if fid>0
     for k=1:size(RatArray,1)
         fprintf(fid,'%s,%f\n',RatArray{k,:});
     end
     fclose(fid);
end


% LRInc Total Difference

LRInc_21 = nanmean(squeeze(nanmean(StatArray(:,:,2+1*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_31 = nanmean(squeeze(nanmean(StatArray(:,:,2+2*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_41 = nanmean(squeeze(nanmean(StatArray(:,:,2+3*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,2),1)));
LRInc_51 = nanmean(squeeze(nanmean(StatArray(:,:,2+4*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,2),1)));
TableArray = [LRInc_21;LRInc_31;LRInc_41;LRInc_51];
TableArrayNames = {'LRInc_21','LRInc_31','LRInc_41','LRInc_51'};
clear LRInc_21 LRInc_31 LRInc_41 LRInc_51;

for i = 3:(nStats+1)
    Stat_21 = nanmean(squeeze(nanmean(StatArray(:,:,i+1*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_31 = nanmean(squeeze(nanmean(StatArray(:,:,i+2*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_41 = nanmean(squeeze(nanmean(StatArray(:,:,i+3*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,i),1)));
    Stat_51 = nanmean(squeeze(nanmean(StatArray(:,:,i+4*nStats),1))) - nanmean(squeeze(nanmean(StatArray(:,:,i),1)));
    TableArray = [TableArray;Stat_21;Stat_31;Stat_41;Stat_51];
    TableArrayNames(end+1:end+4) = {sprintf('%s_21',StatName{i}),sprintf('%s_31',StatName{i}),sprintf('%s_41',StatName{i}),sprintf('%s_51',StatName{i})};
end

RatArray = [reshape(TableArrayNames,[],1) num2cell(TableArray)];
fid = fopen(strcat(results_table_path,'DiffAve',testopts.('name'),'.csv'), 'w');
fprintf(fid, 'Diff,');
fprintf(fid, 'Value\n');
fclose(fid);
fid = fopen(strcat(results_table_path,'DiffAve',testopts.('name'),'.csv'), 'a+');
if fid>0
     for k=1:size(RatArray,1)
         fprintf(fid,'%s,%f\n',RatArray{k,:});
     end
     fclose(fid);
end





end