function [ssr, err] = II(params, order, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, earnings_profile, earnings_variance, ResultsSeries)
%% EMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    opts.test = 'n';
[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    err = 0;
    exists = 1;
    dirnum = 0;
    while exists ~= 0
        if isequal(exist(fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(dirnum))),'dir'),7)
            exists = 1;
            dirnum = dirnum + 1;
        else
            opts.simulation_directory_num = dirnum;
            opts.simulation_graphics_path = fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(dirnum)));
            mkdir(opts.simulation_graphics_path);
            exists = 0;
        end
    end

    rng(9);
    maxiter = 2*S;
    randseed = datasample((1:maxiter).', maxiter,'Replace',false);

    if opts.solve == 'y'
        Model(params, order, opts);
    end
    beta_ests = zeros(S,length(moments));

    j = 1;
    i = 0;
    err = 0;
    fprintf('Entering Simulations\n');
    while i < maxiter
        i = i + 1;
        fprintf('Performing Simulation %g, %g \n', i, j);
        if i - j > 5
            i = maxiter;
        end
        if j <= S
            err = 0;
            opts.savesim = 'n';
            [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles] = Simulation(params, order, opts, randseed(i));
            EE = gather(EE);
            UU = gather(UU);
            WW = gather(WW);
            AA = gather(AA);
            BB = gather(BB);
            CC = gather(CC);
            UB = gather(UB);
            MU = gather(MU);
            HH = gather(HH);
            TT = gather(TT);
            UT = gather(UT);
            UE= gather(UE);
            EU= gather(EU);
            E2E= gather(E2E);
            ET = gather(ET);
            LL = gather(LL);
            ZZ = gather(ZZ);
            WPrime = gather(WPrime);
            ThetaPrime = gather(ThetaPrime);
            TreatedInd = gather(TreatedInd);
            PInitHat = gather(PInitHat);
            initQtiles = gather(initQtiles);

            EE = EE(:,2:end);
            UU = UU(:,2:end);
            WW = WW(:,2:end);
            AA = AA(:,1:end-1);
            BB = BB(:,2:end);
            CC = CC(:,1:end-1);
            UB = UB(:,2:end);
            MU = MU(:,1:end-1);
            HH = HH(:,1:end-1);
            TT = TT(:,2:end);
            UT = UT(:,2:end);
            E2E= E2E(:,2:end);
            ET = ET(:,2:end);
            ZZ = ZZ(:,2:end);
            WPrime = WPrime(:,2:end);
            ThetaPrime = ThetaPrime(:,2:end);
            TreatedInd = TreatedInd(:,2:end);

            [err, esttemp] = CalcMoments(params, order, opts, moments, weights, NumObs, NObsNames, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles);
            clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;
            if err == 0
                beta_ests(j,:) = esttemp;
                j = j + 1;
            else
                fprintf('There was an error\n');
            end
        elseif j > S
            i = maxiter;
        end
    end

    fprintf('Saving Moments');
    [ssr, err] = CalcError(moments, weights, beta_ests, j, opts, nparams, params, order);

    if opts.II == 'y'
        if err ~= 1
            opts.savesim = 'y';
            [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles] = Simulation(params, order, opts, randseed(101));
            EE = gather(EE);
            UU = gather(UU);
            WW = gather(WW);
            AA = gather(AA);
            BB = gather(BB);
            CC = gather(CC);
            UB = gather(UB);
            MU = gather(MU);
            HH = gather(HH);
            TT = gather(TT);
            UT = gather(UT);
            UE= gather(UE);
            EU= gather(EU);
            E2E= gather(E2E);
            ET = gather(ET);
            LL = gather(LL);
            ZZ = gather(ZZ);
            WPrime = gather(WPrime);
            ThetaPrime = gather(ThetaPrime);
            TreatedInd = gather(TreatedInd);
            PInitHat = gather(PInitHat);
            initQtiles = gather(initQtiles);

            EE = EE(:,2:end);
            UU = UU(:,2:end);
            WW = WW(:,2:end);
            AA = AA(:,1:end-1);
            BB = BB(:,2:end);
            CC = CC(:,1:end-1);
            UB = UB(:,2:end);
            MU = MU(:,1:end-1);
            HH = HH(:,1:end-1);
            TT = TT(:,2:end);
            UT = UT(:,2:end);
            E2E= E2E(:,2:end);
            ET = ET(:,2:end);
            ZZ = ZZ(:,2:end);
            WPrime = WPrime(:,2:end);
            ThetaPrime = ThetaPrime(:,2:end);
            TreatedInd = TreatedInd(:,2:end);

            set(0,'defaultFigureVisible','off');
            fprintf('Plotting Results\n');
            dataopts.dataset = 'FullLifeCycle';
            Plots(params, order, opts, [], NumObs, NObsNames, init_earnings, init_assets, earnings_profile, earnings_variance, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles, dataopts);
        end
    end

end
