function [X, phat] = LNRndCopula( Mu , Sigma , CorrMat , Simulations  )
%RndCopula
% Generate correlated draw from a log-normal distribution using a copula.
% CorrMat contains the correlations between the variables along the off-diagonals
% Simulations contains the number of draws
% Mu and Sigma are the mean and standard deviation of the marginal distribution of log-normals, respectively.
% Author: Ben Griffy

Z = mvnrnd( zeros(size(Mu)) , CorrMat , Simulations );
U = normcdf(Z,0,1);
X = logninv(U,Mu,Sigma);
p = normpdf(Z,0,1);

phat = p(:,1).*p(:,2).*p(:,3);

clear U Z p;

end