%%Main m-file for published version of Search and the Sources of Life-Cycle Inequality
%Author: Ben Griffy
%Date: Sept., 2018
%Description: Main file for setting options to solve and estimate model from "Search and the Sources of Life-Cycle Inequality."


clear all
close all
clc

%------------------%
%Set Paths
%------------------%
externrun = 'n';
codedir = pwd;
compnum = 1;

% Set main paths
if externrun == 'n' % if running on local computer, set project dir and data directory
    if compnum == 1
        projdir    = fileparts(fileparts(fileparts(fileparts(codedir))));
        input_path = '/data/modeluse_data';
    elseif compnum == 2 % set up to run on multiple computers with different directory structures
        projdir    = fileparts(fileparts(fileparts(fileparts(codedir))));
        input_path = '/data/modeluse_data';
    end
else % for use on clusters
    projdir    = codedir;
    input_path = '../data/';
end

% Set Paths
output_path = fileparts('/output/');
results_path = fileparts('/results/');
graphics_path = fileparts('/graphics/');
II_path = fileparts('/II/');

%------------------%
%Options
%------------------%
opts = struct('gpu','y', ... % use GPU, y/n
              'gpunum',1,... % which GPU to use
              'parallel','y', ... % if not using GPU, run in parallel, y/n
              'save_polfuns','y', ... % save policy functions
              'save_diagplots','n', ... % save diagnostic plots during model solution
              'concave_check','n', ... % under some parametrizations, the app strat. loses concavity due to coarseness. This ensures it doesn't happen.
              'params','n', ... % load previous SSR minimizing parameters (opts: 'load_IIparams','approxparams','n')
              'disp_plots','n', ... % pop-up plots during solution and simulation?
              'otjs','y', ... % turn OTJS on or off y/n
              'ret','y', ...% solve the model including retirement?
              'solve','n', ... % solve model
              'solveAddl','n', ... % solve model
              'simulate','y', ... % simulate model?
              'subsim','n', ... % Resimulate initial condition experiments
              'II','n', ... % estimate model (only option: indirect inference), y/n. Note, II = 'y' invalidates solve and simulate options
              'solver','SA', ... % which solution technique for estimation? (SA: Simulated Annealing, PS: Pattern Search, DR: DiRect)
              'ProfilePlots','n', ... % Plot simulation results for baseline
              'ProfileAverages','n', ... % Plot simulation results for baseline
              'ProfileSubPlots','n', ... % Plot simulation results for experiments
              'ProfileSubAverages','n', ... % Plot simulation results for baseline
              'SpecificPlots','n', ... % Plot specific results for paper
              'CompPlots','n', ...% Comparison plots
              'CompAverages','y', ...% Comparison averages
              'CalcFinalMoments','n', ... % Calculate values of final moments at current parameters
              'SaveParams','n', ...% Save final params in table for paper
              'FindParamSEs','n', ... % Solve for parameter standard errors (currently not working)
              'PlotDecisionRules','n', ... % Plot decision rules from simulations
              'CompNonTargeted','n', ... % Plot decision rules from simulations
              'CompNonTargetedLBD','n', ... % Plot decision rules from simulations
              'CompNonTargetedBaselineLBD','n', ...% Show that LBD doesn't match non-targeted
              'FinalStats','n', ... % Calculate final stats for paper
              'StdErrCalc','n', ...
              'PlotEmpiricalEvidence','n', ... % Plot decision rules from simulations
              'CompareInitConds','n', ... % Compare outcomes from initial condition experiments
              'VarianceDecomp','n', ...% Compute variance decomposition
              'VarianceDecompMed','n', ...% Compute variance decomposition using median worker
              'HVYComp','n', ...% Compare model to HVY results with full distribution
              'HVYCompMed','n', ...% Compare model to HVY results with median worker
              'MeanPresSpread','n', ...% Calculate effect of mean-preserving spread
              'PolicyExperiments','y', ...% Conduct policy experiments
              'BaseDecomp','n', ...% Do baseline decomposition
              'LBDDecomp','n', ...% Do LB decomposition
              'LBDDecompLearnDiffs','n', ...% 
              'NoSearchDecomp','n', ...% Do no search decomposition
              'UIExperiment','y', ...% Do UI experiment from policy experiments
              'ReEmpOutcomes','n', ...% Calculate any re-employment outcomes
              'EmpRisk','n', ...% Solve employment risk model
              'calcMoments','n', ...% Calculate moments
              'calcAverages','y', ...% Calculate averages across variables of interest for all simulations
              'calcProfiles','y', ...% Calculate profiles for all variables of interest for all simulations
              'calcScarring','n', ...% Calculate scarring effects for any re-employment outcomes of interest
              'calcUnempScarring','n', ...% Calculate unemployment scarring
              'calcEmpRisk','n', ...% Calculate the effect of employment risk on subsequent outcomes
              'wealthQtiles','y', ...% Calculate additional results for all calculations by wealth quintiles
              'humancapQtiles','n', ...% Calculate additional results for all calculations by human capital quintiles
              'learnQtiles','n', ...% Calculate additional results for all calculations by learning quintiles
              'humancapQtilesScarring','n', ... % calculate scarring results by initial human capital quintiles
              'learnQtilesScarring','n', ... % calculate scarring results by learning ability quintiles
              'saveSim','n', ...
              'savePanel','n', ...
              'momentsim','n', ... %
              'momentsolve','n', ... %
              'treated','n', ...
              'nsamples',5000, ...
              'burnin',500, ...
              'project_path',projdir, ... % path to project
              'graphics_path',graphics_path, ... % path to graphics
              'results_path',results_path, ... % path to results
              'output_path',output_path, ... % path to saving decision rules
              'II_path',II_path, ... % path to saving indirect inference outcomes
              'input_path',input_path); % input files

%------------------%
%Load Data
%------------------%

[moments,weights,results_data] = get_data(projdir,input_path);

[results_data] = save_data(projdir,input_path,results_data,opts);

TotSimN = results_data.MomentObs.NLSY + results_data.MomentObs.PSIDTotal + results_data.MomentObs.SIPP;

%------------------%
%Model Parameters 
%------------------%

default_params = struct('NumYears',42, ... % Total number of years
                        'NumYearsYoung',2, ... % Number of years before matching moments
                        'NumYearsOld',10, ... % Number of years after matching moments
                        'NumYearsScar',15, ... % Number of years after matching moments                        
                        'r',0.012, ... % preset risk-free rate
                        'ddelta',0.03, ... % J2U quarterly rate
                        'ggamma',0.54, ... % UI expected duration
                        'gg',0.0, ... % Exogenous earnings growth (discarded)
                        'b',0.42, ... % UI expected duration
                        'eepsilon',0.00000005, ... % boundary check
                        'ssigma',2.0, ... % risk aversion parameter
                        'llambu',1.0, ... % search efficiency
                        'MaxUI',46800, ... % UI cap
                        'MaxUIUITest',72800, ... % UI cap
                        'bUITest',0.7, ...% Experiment replacement rate
                        'blDeltUITest',1800, ...
                        'bbarUITest',10400, ...
                        'bbar',0, ...
                        'ggammaUITest',0.33, ...
                        'ubi',12000, ... % UI cap
                        'EITCSlopeA',0.34, ... % UI cap
                        'EITCSlopeB',0.1598, ... % UI cap
                        'maxEITC',34001, ... % UI cap
                        'minEITC',0, ... % UI cap
                        'flatEITCA',8050, ... % UI cap
                        'flatEITCB',16800, ... % UI cap
                        'EITCCap',2747, ... % UI cap
                        'lba',0, ... % asset lower bound
                        'uba',40, ... % asset upper bound
                        'lbw',0, ... % wages lower bound
                        'ubw',1, ... % wages upper bound
                        'lbh',0, ... % human capital lower bound
                        'ubh',10, ... % human capital upper bound
                        'lbl',0, ... % learning ability lower bound
                        'ubl',25, ... % learning ability upper bound
                        'lbb',0, ... % per-period benefits lower bound
                        'ubb',1, ... % per-period benefits upper bound
                        'lbt',0, ... % minimum learning time
                        'ubt',1, ... % maximum learning time
                        'lbd',0.01, ... % minimum separation risk
                        'ubd',0.05, ... % maximum separation risk
                        'cons_pen',-realmax, ... % consumption penalty in default
                        'Norm',1, ...
                        'wsize',20, ... % wage grid size
                        'asize',50, ... % asset grid size
                        'hsize',10, ... % human capital grid size
                        'lsize',8, ... % learning grid size
                        'dsize',9, ... % wage grid size
                        'UIsize',12, ...
                        'wwsize',2e3, ...
                        'aasize',3e2, ...
                        'ttsize',3e2, ...
                        'N',TotSimN, ...
                        'NScar',1000, ...
                        'S',100, ...
                        'errtol',1e-5, ...
                        'exitProb',0.02, ...
                        'bRet',16800, ...
                        'llambe',0.58851144, ... % OTJ search efficiency
                        'aalphah',0.56874481, ... % curvature of HC production
                        'ddelth',2.6050476, ... % HC distribution shift
                        'ddeltl',0.087537836, ... % Learning distribution shift
                        'bl',0.020395941, ...
                        'eeta',0.432538, ... % matching function elasticity
                        'kkappa',1.7884011, ... % cost of vacancy
                        'nnu',0.0, ...
                        'MuA',0.2310508, ...
                        'MuH',-0.51284114, ...
                        'MuL',1.4900016, ...
                        'Epsnodes',7, ...
                        'MuEps',-0.024870335, ...
                        'SigEps',0.062066473, ...
                        'StdEps',3, ...
                        'SigA',0.90164876, ...
                        'SigH',1.3503635, ...
                        'SigL',0.55562365, ...
                        'SigAH',0.32526952, ...
                        'SigAL',0.4642467, ...
                        'SigHL',0.69147516, ...
                        'SigXi',0.12884678, ...
                        'MPIncreaseSA',1.1, ...
                        'MPDecreaseSA',0.9, ...
                        'MPIncreaseSH',1.1, ...
                        'MPDecreaseSH',0.9, ...
                        'MPIncreaseSL',1.1, ...
                        'MPDecreaseSL',0.9, ...                        
                        'freq',4);



II_params = cellstr({'bl','eeta','kkappa','MuEps','SigEps','MuA','MuH','MuL','SigA','SigH','SigL','SigAH','SigAL','SigHL','aalphah','llambe','ddelth','ddeltl','SigXi'}); % set the parameters to estimate. need to change bounds in main_wrapper file


params = get_params(II_path, II_params, default_params, opts); % either load best fit parameters or return default parameters

%------------------%
% Run Program with Options
%------------------%

max_params = Main_Wrapper(params,opts,II_params,moments,weights, ...
                          results_data.MomentObs,results_data.MomentObsNames, ...
                          results_data.Initial_Earnings,results_data.Initial_Wealth, ...
                          results_data.earnNorm,results_data.earnNormVar, ...
                          results_data.Earnings_Profile,results_data.Variance_Profile,results_data)


