function MainFindings(params, order, II_params, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance,ResultsSeries)
%% Results m-file for Borrowing Constraints, Search, and Life-Cycle Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    opts.test = 'n';
    [r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    if ~isequal(exist(fullfile(pwd,opts.graphics_path,'Results/'),'dir'),7)
        mkdir(fullfile(pwd,opts.graphics_path,'Results/'));
    end


    % These are the moments used to calibrate the model. I use this struct multiple times, so I define it here rather than redefining it in subsequent files.
    momentNames={'NetLiq.1stQuintile2Wage','LnAvgUIWage', ...
                  'NetLiq.1stQuintile2XLnAvgUIWage','AgeWage', ...
                  'LnLastWageWage','NetLiq.1stQuintile2XLnLastWageWage','ConstantSIPP', ...
                  'NetLiq.1stQuintile1XLnAvgUIHazard','NetLiq.2ndQuintile2XLogofUIHazard', ...
                  'AgeHazard','LnLastWageHazard' ...
                  strjoin({sprintf('AveAge%1.0f,',25:53),'AveAge54'}), ...
                  strjoin({sprintf('VarAge%1.0f,',25:53),'VarAge54'}), ...
                  strjoin({sprintf('Growth%1.0f,',1:2),'Growth3'}), ...
                  strjoin({sprintf('CovGrowth1x%1.0f,',1:2),'CovGrowth1x3'}), ...
                  'CovGrowth2x2','CovGrowth2x3','CovGrowth3x3', ...
                  'Cons30thAFQT','Cons50thAFQT', ...
                  'Cons70thAFQT','Cons90thAFQT','AgeNLSY', ...
                  'Slope30thAFQT','Slope50thAFQT','Slope70thAFQT', ...
                  'Slope90thAFQT','ConsAgeGrp210thAFQT', ...
                  'ConsAgeGrp230thAFQT','ConsAgeGrp250thAFQT','ConsAgeGrp270thAFQT', ...
                  'ConsAgeGrp290thAFQT','AgeAgeGrp2NLSY', ...
                  'SlopeAgeGrp230thAFQT','SlopeAgeGrp250thAFQT','SlopeAgeGrp270thAFQT', ...
                  'SlopeAgeGrp290thAFQT','ConstantNLSY','Cons30thWealth','Cons50thWealth', ...
                  'Cons70thWealth','Cons90thWealth','AgePSID', ...
                  'Slope30thWealth','Slope50thWealth','Slope70thWealth', ...
                  'Slope90thWealth','ConsAgeGrp210thWealth', ...
                  'ConsAgeGrp230thWealth','ConsAgeGrp250thWealth','ConsAgeGrp270thWealth', ...
                  'ConsAgeGrp290thWealth','AgeAgeGrp2PSID', ...
                  'SlopeAgeGrp230thWealth','SlopeAgeGrp250thWealth','SlopeAgeGrp270thWealth', ...
                  'SlopeAgeGrp290thWealth','ConstantPSID', ...
                  strjoin({sprintf('init_earnings%1.0f,',1:9),'init_earnings10'}), ...
                  strjoin({sprintf('init_wealth%1.0f,',1:9),'init_wealth10'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp1x%1.0f,',1:4),'NLSYJ2JRateAgeGrp1x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp2x%1.0f,',1:4),'NLSYJ2JRateAgeGrp2x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp3x%1.0f,',1:4),'NLSYJ2JRateAgeGrp3x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp4x%1.0f,',1:4),'NLSYJ2JRateAgeGrp4x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp5x%1.0f,',1:4),'NLSYJ2JRateAgeGrp5x5'}), ...
                  strjoin({sprintf('NLSYJ2JRateAgeGrp6x%1.0f,',1:4),'NLSYJ2JRateAgeGrp6x5'}), ...
                 'UnempRate'};

    statNames = {'IndID','Age','RInc','Emp','Unemp','AFQT','UnempScaled','UnempDur','HumanCap','AA','RLiqWealth','E2E','UIAmt', ...
                 'Prod','LearnAb','PieceRateShare','PieceRate','LearnTime','EmpScaled','Tenure','UI_yn','UIDur', ...
                 'LearnTimeEmp','LearnTimeProd','UnempInd','EmpInd','ZZPctShocks','ZZProdShocks','Cons','MPC', ...
                 'Budget','MPCB','UnempWks','HrsWkred','ApplicationStrategy','EmploymentProbability','SubmarketTightness', ...
                 'MeasErrAn','RLiqWealth_qtile','AFQT_qtile','HumanCap_qtile','AgeGrp','AgeGrp1','AgeGrp2', ...
                 'RIncHVY','HVYInd','MeasErrAn_3','RInc_3','RIncHVY_3','LRInc','LHumanCap','LPieceRate','LLearnTime','LProdTime', ...
                 'LRInc_3','LRIncHVY','LRIncHVY_3','LRIncHVY_3Growth','MissRepAux4','MissRepAux5','Wealth_qtile','Learn_qtile'};

    YLabs = {'IndID','Age','Income (2011\$s)','Emp.','Unemp.','AFQT','Unemp. Rate','Unemp. Dur. (Qtrs.)','Human Capital','Wealth (unscaled)','Wealth (2011\$s)','J2J Rate','UI Benefits (2011\$s)', ...
             'Productivity','Learning Ability','Piece Rate','Piece Rate (2011\$s)','Learning Time','Emp. Rate','Tenure','UI Rate (y/n)','UI Ben. Dur.', ...
             'Learning Time (Emp)','Learning Time (2011\$s)','Unemp. Rate','Emp. Rate','ZZPctShocks','ZZProdShocks','Cons.','MPC', ...
             'Budget','MPC out of Budget','Unemp. Dur. (Wks.)','Hours Worked','App. Strat.','Job-Find Rate','Mkt. Tightness', ...
             'MeasErrAn','RLiqWealthqtile','AFQTqtile','HumanCapqtile','AgeGrp','AgeGrp1','AgeGrp2','Income (2011\$s)','HVYInd','MeasErrAn3', ...
             'Income (2011\$s)','Income (2011\$s)','log(Income)','log(Human Cap.)','log(Piece Rate)','log(Learn Time)','log(Prod. Time)', ...
             'log(Income)','log(Income)','log(Income)','log(Income) Growth','MissRepAux4','MissRepAux5','Wealthqtile','Learnqtile'};

    aveNames = {'Ave','Var','AvePDV','VarPDV','AveInit','VarInit'};

    scarringStatNames = {'LRInc','LMU','LHC','LProdTime'};

    scarringYLabs = {'TimeVar','Log Earnings','Log Piece-Rate','Log Human Capital','Productive Time'};



    rng(9);
    maxiter = 2*S;
    randseed = datasample((1:maxiter).', maxiter,'Replace',false);



    if opts.solve == 'y'
        Model(params, order, opts);
    end

    if opts.EmpRisk == 'y'
        opts.test = 'EmpRiskWealth';
        output_pathInit = opts.output_path;
        ddeltaInit = params(find(strcmp(order, 'ddelta')));
        opts.output_path = '/output/EmpRisk/';
        if opts.solveAddl == 'y'
            ModelEmpRisk(params, order, opts);
        end
        opts.output_path = output_pathInit;
        opts.test = 'n';
    end
    if opts.NoSearchDecomp == 'y'
        opts.test = 'NoSearchDecomp';
        output_pathInit = opts.output_path;
        opts.output_path = '/output/NoSearch/';
        if opts.solveAddl == 'y'
            ModelNoSearch(params, order, opts);
        end
        opts.output_path = output_pathInit;
    end

    if opts.LBDDecomp == 'y'
        opts.test = 'LBDDecomp';
        output_pathInit = opts.output_path;
        opts.output_path = '/output/LBD/';
        if opts.solveAddl == 'y'
            ModelLBD(params, order, statNames, opts);
        end
        opts.output_path = output_pathInit;
        if opts.calcEmpRisk == 'y'
            opts.test = 'LBDDecompEmpRisk';
            output_pathInit = opts.output_path;
            ddeltaInit = params(find(strcmp(order, 'ddelta')));
            opts.output_path = '/output/LBDEmpRisk/';
            if opts.solveAddl == 'y'
                ModelLBDEmpRisk(params, order, statNames, opts);
            end
            opts.output_path = output_pathInit;
            opts.test = 'n';
        end
    end

    if opts.LBDDecompLearnDiffs == 'y'
        opts.test = 'LBDDecompLearnDiffs';
        output_pathInit = opts.output_path;
        opts.output_path = '/output/LBDLearnDiffs/';
        if opts.solveAddl == 'y'
            ModelLBD(params, order, statNames, opts);
        end
        opts.output_path = output_pathInit;
        if opts.calcEmpRisk == 'y'
            opts.test = 'LBDDecompLearnDiffsEmpRisk';
            output_pathInit = opts.output_path;
            ddeltaInit = params(find(strcmp(order, 'ddelta')));
            opts.output_path = '/output/LBDLearnDiffsEmpRisk/';
            if opts.solveAddl == 'y'
                ModelLBDEmpRisk(params, order, statNames, opts);
            end
            opts.output_path = output_pathInit;
            opts.test = 'n';
        end
    end

    if opts.UIExperiment == 'y'
        opts.test = 'UIExperiment1';
        output_pathInit = opts.output_path;
        bInit = params(find(strcmp(order, 'b')));
        bbarInit = params(find(strcmp(order, 'bbar')));
        MaxUIInit = params(find(strcmp(order, 'MaxUI')));
        ggammaInit = params(find(strcmp(order, 'ggamma')));
        params(find(strcmp(order, 'b'))) = bUITest;
        % params(find(strcmp(order, 'bbar'))) = bbarUITest;
        params(find(strcmp(order, 'MaxUI'))) = MaxUIUITest;
        params(find(strcmp(order, 'ggamma'))) = ggammaUITest;
        opts.output_path = '/output/UIExperiment1/';
        if opts.solveAddl == 'y'
            Model(params, order, opts);
        end
        opts.output_path = output_pathInit;
        params(find(strcmp(order, 'b'))) = bInit;
        params(find(strcmp(order, 'bbar'))) = bbarInit;
        params(find(strcmp(order, 'MaxUI'))) = MaxUIInit;
        params(find(strcmp(order, 'ggamma'))) = ggammaInit;
        opts.test = 'n';

        opts.test = 'UIExperiment2';
        output_pathInit = opts.output_path;
        bInit = params(find(strcmp(order, 'b')));
        bbarInit = params(find(strcmp(order, 'bbar')));
        MaxUIInit = params(find(strcmp(order, 'MaxUI')));
        ggammaInit = params(find(strcmp(order, 'ggamma')));
        % params(find(strcmp(order, 'b'))) = bUITest;
        params(find(strcmp(order, 'bbar'))) = bbarUITest;
        params(find(strcmp(order, 'MaxUI'))) = MaxUIUITest;
        params(find(strcmp(order, 'ggamma'))) = ggammaUITest;
        opts.output_path = '/output/UIExperiment2/';
        if opts.solveAddl == 'y'
            Model(params, order, opts);
        end
        opts.output_path = output_pathInit;
        params(find(strcmp(order, 'b'))) = bInit;
        params(find(strcmp(order, 'bbar'))) = bbarInit;
        params(find(strcmp(order, 'MaxUI'))) = MaxUIInit;
        params(find(strcmp(order, 'ggamma'))) = ggammaInit;
        opts.test = 'n';

    end


    set(0,'defaultFigureVisible','off');
    opts.simfile = 'Simulation_Standard.mat';
    opts.saveSims = 'n';
    if opts.simulate == 'y'
        opts.test = 'n';
        opts.simName = 'Standard';
        opts.fancySimName = 'Standard';
        Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
    end

    if opts.subsim == 'y'
        if opts.VarianceDecomp == 'y'
            opts.simName = 'Cons';
            opts.fancySimName = 'All Constant';
            opts.test = 'Cons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'ACons';
            opts.fancySimName = 'Wealth Constant';
            opts.test = 'ACons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HCons';
            opts.fancySimName = 'Human Capital Constant';
            opts.test = 'HCons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'LCons';
            opts.fancySimName = 'Wealth Constant';
            opts.test = 'LCons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'AHCons';
            opts.fancySimName = 'Wealth Constant';
            opts.test = 'AHCons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'ALCons';
            opts.fancySimName = 'Wealth Constant';
            opts.test = 'ALCons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HLCons';
            opts.fancySimName = 'Wealth Constant';
            opts.test = 'HLCons';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
        end


        if opts.VarianceDecompMed == 'y'
            opts.simName = 'HLMed';
            opts.fancySimName = 'Wealth Median';
            opts.test = 'HLMed';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
        end

        if opts.HVYCompMed == 'y'
            opts.simName = 'Med';
            opts.fancySimName = 'All Median';
            opts.test = 'Med';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'AUpHVY';
            opts.fancySimName = 'Wealth +1 SD';
            opts.test = 'AUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HUpHVY';
            opts.fancySimName = 'Human Capital +1 SD';
            opts.test = 'HUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'LUpHVY';
            opts.fancySimName = 'Learning Ability +1 SD';
            opts.test = 'LUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'AHUpHVY';
            opts.fancySimName = 'Wealth, Human Capital +1 SD';
            opts.test = 'AHUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'ALUpHVY';
            opts.fancySimName = 'Wealth, Learning Ability +1 SD';
            opts.test = 'ALUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HLUpHVY';
            opts.fancySimName = 'Human Capital, Learning Ability +1 SD';
            opts.test = 'HLUpHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);


            opts.simName = 'ADownHVY';
            opts.fancySimName = 'Wealth -1 SD';
            opts.test = 'ADownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HDownHVY';
            opts.fancySimName = 'Human Capital -1 SD';
            opts.test = 'HDownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'LDownHVY';
            opts.fancySimName = 'Learning Ability -1 SD';
            opts.test = 'LDownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'AHDownHVY';
            opts.fancySimName = 'Wealth, Human Capital -1 SD';
            opts.test = 'AHDownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'ALDownHVY';
            opts.fancySimName = 'Wealth, Learning Ability -1 SD';
            opts.test = 'ALDownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HLDownHVY';
            opts.fancySimName = 'Human Capital, Learning Ability -1 SD';
            opts.test = 'HLDownHVY';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
        end


        if opts.MeanPresSpread == 'y'
            opts.simName = 'AMPIncreaseS';
            opts.fancySimName = 'Wealth Spread Increase';
            opts.test = 'AMPIncreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HMPIncreaseS';
            opts.fancySimName = 'Human Capital Spread Increase';
            opts.test = 'HMPIncreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'LMPIncreaseS';
            opts.fancySimName = 'Learn Spread Increase';
            opts.test = 'LMPIncreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'AMPDecreaseS';
            opts.fancySimName = 'Wealth Spread Decrease';
            opts.test = 'AMPDecreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'HMPDecreaseS';
            opts.fancySimName = 'Human Capital Spread Decrease';
            opts.test = 'HMPDecreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.simName = 'LMPDecreaseS';
            opts.fancySimName = 'Learn Spread Decrease';
            opts.test = 'LMPDecreaseS';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
        end

        if opts.PolicyExperiments == 'y'
            opts.test = 'UIExperiment1';
            output_pathInit = opts.output_path;
            bInit = params(find(strcmp(order, 'b')));
            bbarInit = params(find(strcmp(order, 'bbar')));
            MaxUIInit = params(find(strcmp(order, 'MaxUI')));
            ggammaInit = params(find(strcmp(order, 'ggamma')));
            params(find(strcmp(order, 'b'))) = bUITest;
            params(find(strcmp(order, 'MaxUI'))) = MaxUIUITest;
            params(find(strcmp(order, 'ggamma'))) = ggammaUITest;
            opts.output_path = '/output/';
            opts.simName = 'UIExperiment1B';
            opts.fancySimName = 'UI Experiment 1';
            opts.test = 'UI Experiment 1';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
            opts.output_path = output_pathInit;
            params(find(strcmp(order, 'b'))) = bInit;
            params(find(strcmp(order, 'bbar'))) = bbarInit;
            params(find(strcmp(order, 'MaxUI'))) = MaxUIInit;
            params(find(strcmp(order, 'ggamma'))) = ggammaInit;
            opts.test = 'n';

            opts.test = 'UIExperiment2';
            output_pathInit = opts.output_path;
            bInit = params(find(strcmp(order, 'b')));
            bbarInit = params(find(strcmp(order, 'bbar')));
            MaxUIInit = params(find(strcmp(order, 'MaxUI')));
            ggammaInit = params(find(strcmp(order, 'ggamma')));
            params(find(strcmp(order, 'bbar'))) = bbarUITest;
            params(find(strcmp(order, 'MaxUI'))) = MaxUIUITest;
            params(find(strcmp(order, 'ggamma'))) = ggammaUITest;
            opts.output_path = '/output/';
            opts.simName = 'UIExperiment2B';
            opts.fancySimName = 'UI Experiment 2';
            opts.test = 'UI Experiment 2';
            Simulation_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
            opts.output_path = output_pathInit;
            params(find(strcmp(order, 'b'))) = bInit;
            params(find(strcmp(order, 'bbar'))) = bbarInit;
            params(find(strcmp(order, 'MaxUI'))) = MaxUIInit;
            params(find(strcmp(order, 'ggamma'))) = ggammaInit;
            opts.test = 'n';
        end

        if opts.LBDDecomp == 'y'
            output_pathInit = opts.output_path;
            opts.output_path = '/output/LBD/';
            opts.test = 'LBDDecomp';
            opts.simName = 'LBDDecomp';
            opts.fancySimName = 'LBD Decomp.';
            SimulationLBDDecomp_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
            opts.output_path = output_pathInit;
        end

        if opts.LBDDecompLearnDiffs == 'y'
            output_pathInit = opts.output_path;
            opts.output_path = '/output/LBDLearnDiffs/';
            opts.test = 'LBDDecompLearnDiffs';
            opts.simName = 'LBDDecompLearnDiffs';
            opts.fancySimName = 'LBD Decomp. Learn Diffs';
            SimulationLBDDecomp_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
            opts.output_path = output_pathInit;
        end


        if opts.BaseDecomp == 'y'
            opts.test = 'BaseDecomp1';
            opts.simName = 'BaseDecomp1';
            opts.fancySimName = 'Baseline Decomp. Test 1';
            SimulationBaseDecomp_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);
        end

        if opts.NoSearchDecomp == 'y'
            output_pathInit = opts.output_path;
            opts.output_path = '/output/NoSearch/';

            opts.test = 'NoSearchDecompBase';
            opts.simName = 'NoSearchDecompBase';
            opts.fancySimName = 'No Search Decomp. Baseline';
            SimulationNoSearch_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.test = 'NoSearchDecomp1';
            opts.simName = 'NoSearchDecomp1';
            opts.fancySimName = 'No Search Decomp. Test 1';
            SimulationNoSearch_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames);

            opts.output_path = output_pathInit;
        end

    end


    if opts.PlotDecisionRules == 'y'
        plotopts = 'standard';
        dataopts.dataset = 'FullLifeCycle';
        PlotDecisionRules(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts, randseed(1));
    end

    if opts.ProfilePlots == 'y' % plot profiles and compare with data
        plotopts = 'standard';
        dataopts.dataset = 'FullLifeCycle';
        panelNames = {'Standard'};
        ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
    end
    if opts.ProfileSubPlots == 'y'
        plotopts = 'standard';
        dataopts.dataset = 'FullLifeCycle';
        if opts.HVYComp == 'y'
            panelNames = {'Standard','AUp','HUp','LUp','ADown','HDown','LDown'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end
        if opts.HVYCompMed == 'y'
            panelNames = {'Med','AUpHVY','HUpHVY','LUpHVY','ADownHVY','HDownHVY','LDownHVY'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.VarianceDecomp == 'y'
            panelNames = {'Cons','ACons','HCons','LCons','AHCons','ALCons','HLCons'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.VarianceDecompMed == 'y'
            panelNames = {'HLMed'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.MeanPresSpread == 'y'
            panelNames = {'AMPIncreaseS','HMPIncreaseS','LMPIncreaseS','AMPDecreaseS','HMPDecreaseS','LMPDecreaseS'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.PolicyExperiments == 'y'
            panelNames = {'Standard','UIExperiment1','UIExperiment2','UIExperiment3'};
            ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end
    end

    if opts.ProfileAverages == 'y'
        plotopts = 'standard';
        dataopts.dataset = 'FullLifeCycle';
        panelNames = {'Standard'};
        ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
    end
    if opts.ProfileSubAverages == 'y'
        dataopts.dataset = 'FullLifeCycle';
        if opts.HVYComp == 'y'
            panelNames = {'Standard','AUp','HUp','LUp','ADown','HDown','LDown'};
            ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end
        if opts.HVYCompMed == 'y'
            panelNames = {'Med','AUpHVY','HUpHVY','LUpHVY','ADownHVY','HDownHVY','LDownHVY'};
            ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end
        if opts.VarianceDecomp == 'y'
            panelNames = {'Cons','ACons','HCons','LCons','AHCons','ALCons','HLCons'};
            ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.MeanPresSpread == 'y'
            panelNames = {'AMPIncreaseS','HMPIncreaseS','LMPIncreaseS','AMPDecreaseS','HMPDecreaseS','LMPDecreaseS'};
            ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

        if opts.PolicyExperiments == 'y'
            panelNames = {'Standard','UIExperiment1','UIExperiment2','UIExperiment3'};
            ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
        end

    end


    if opts.CompNonTargeted == 'y'
        plotopts = 'standard';
        dataopts.dataset = 'FullLifeCycle';
        panelNames = {'Standard'};
        NonTargeted_Wrapper(params, order, opts, panelNames, scarringStatNames, scarringYLabs, ResultsSeries, dataopts);
    end


    if opts.CompNonTargetedLBD == 'y'
        plotopts = 'LBDDecompLearnDiffs';
        dataopts.dataset = 'FullLifeCycle';
        panelNames = {'LBDDecompLearnDiffs'};
        NonTargeted_Wrapper(params, order, opts, panelNames, scarringStatNames, scarringYLabs, ResultsSeries, dataopts);
    end


    if opts.CompNonTargetedBaselineLBD == 'y'
        plotopts = 'LBDDecomp';
        dataopts.dataset = 'FullLifeCycle';
        dataopts.name = 'CompBaselineLBD';
        panelNames = {'Standard','LBDDecomp'};
        NonTargetedModelComp_Wrapper(params, order, opts, panelNames, scarringStatNames, scarringYLabs, ResultsSeries, dataopts);

        plotopts = 'LBDDecompLearnDiffs';
        dataopts.dataset = 'FullLifeCycle';
        dataopts.name = 'CompBaselineLBDLearnDiffs';
        panelNames = {'Standard','LBDDecompLearnDiffs'};
        NonTargetedModelComp_Wrapper(params, order, opts, panelNames, scarringStatNames, scarringYLabs, ResultsSeries, dataopts);
    end



    if opts.SpecificPlots == 'y'
        dataopts.dataset = 'FullLifeCycle';
        panelNames = {'Standard'};
        SpecificPlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts);
    end

    if opts.CompPlots == 'y'
        if opts.VarianceDecomp == 'y'
            testname = 'VarianceDecomp';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','ACons','HCons','LCons','Cons'};
            panelLegend = {'Baseline','$a_{0} = E[a_{0}]$','$h_{0} = E[h_{0}]$','$\ell = E[\ell]$','$\Psi = E[\Psi]$'};
            MainFindingsPlots_Wrapper(params, order, opts, testname, panelNames, panelLegend, statNames, YLabs);

            testname = 'VarianceDecompACons';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Baseline','ACons'};
            panelLegend = {'Baseline','$a_{0} = E[a_{0}]$'};
            MainFindingsPlots_Wrapper(params, order, opts, testname, panelNames, panelLegend, statNames, YLabs);
        end

        if opts.UIExperiment == 'y'
            testname = 'UIExperiment';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','UIExperiment1','UIExperiment2'};
            panelLegend = {'Baseline','UI Experiment 1 UI Experiment 2'};
            MainFindingsPlots_Wrapper(params, order, opts, testname, panelNames, panelLegend, statNames, YLabs);
        end

        if opts.HVYCompMed == 'y'
            testname = 'HVYCompMed';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Med','AUpHVY','HUpHVY','LUpHVY','ADownHVY','HDownHVY','LDownHVY'};
            panelLegend = {'Median','Med. + Std. Wealth','Med. - Std. Wealth','Med. + Std. Human Capital','Med. - Std. Human Capital','Med. + Std. Learning','Med. - Std. Learning'};
            MainFindingsPlots_Wrapper(params, order, opts, testname, panelNames, panelLegend, statNames, YLabs);
        end

        if opts.MeanPresSpread == 'y'
            testname = 'MPS';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','MPIncreaseSA','MPDecreaseSA','MPIncreaseSH','MPDecreaseSH','MPIncreaseSL','MPDecreaseSL'};
            panelLegend = {'Baseline','Wealth Spread Increase','Wealth Spread Decrease','Human Capital Spread Increase','Human Capital Spread Decrease','Learning Ability Spread Increase','Learning Ability Spread Decrease'};
            MainFindingsPlots_Wrapper(params, order, opts, testname, panelNames, panelLegend, statNames, YLabs);
        end
    end



    if opts.CompAverages == 'y'
        if opts.VarianceDecomp == 'y'
            testname = 'VarianceDecomp';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','ACons','HCons','LCons','Cons'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end

        if opts.HVYCompMed == 'y'
            testname = 'HVYCompMed';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Med','AUpHVY','HUpHVY','LUpHVY','ADownHVY','HDownHVY','LDownHVY'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end

        if opts.MeanPresSpread == 'y'
            testname = 'MPS';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','AMPIncreaseS','HMPIncreaseS','LMPIncreaseS','AMPDecreaseS','HMPDecreaseS','LMPDecreaseS'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end

        if opts.UIExperiment == 'y'
            testname = 'UIExperimentB';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','UIExperiment1','UIExperiment1B','UIExperiment2','UIExperiment2B'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end

        if opts.BaseDecomp == 'y'
            testname = 'BaseDecompFull';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','BaseDecomp1'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end


        if opts.NoSearchDecomp == 'y'
            testname = 'NoSearchDecompBase';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'Standard','NoSearchDecompBase'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);

            testname = 'NoSearchDecompFull';
            testopts.treated = 'n';
            testopts.difference = 'n';
            testopts.initconds = 'y';
            testopts.PDV = 'y';
            panelNames = {'NoSearchDecompBase','NoSearchDecomp1'};
            MainFindingsAverages_Wrapper(params, order, opts, testname, panelNames, statNames, YLabs, aveNames);
        end

    end

    if opts.SaveParams == 'y'

        SaveFinalParams(params, order, opts);

    end
    if opts.FinalStats == 'y'

        [ssr, err] = CalcFinalError(moments, weights, [], [], opts, nparams, params, order);

    end

end
