function MainFindingsAverages_Wrapper(params, order, opts, testName, panelNames, statNames, YLabs, aveNames)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    matfile = fullfile(pwd,sprintf('AveragesCalc_%s.mat',panelNames{1}));
    load(matfile);
    FullPanel = reshape(modelAveragesFinal,[1,size(modelAveragesFinal)]);
    clear modelAveragesFinal;
    for i = 2:length(panelNames)
        matfile = fullfile(pwd,sprintf('AveragesCalc_%s.mat',panelNames{i}));
        load(matfile);
        FullPanel = cat(1,FullPanel,reshape(modelAveragesFinal,[1,size(modelAveragesFinal)]));
    end


    tempopts.dir = sprintf('/%s/',testName);
    tempopts.name = sprintf('_%s',testName);
    MainFindingsAveragesStats(params, order, opts, tempopts, panelNames, statNames, YLabs, aveNames, FullPanel);
    if opts.wealthQtiles == 'y'
        matfile = fullfile(pwd,sprintf('AveragesWealthCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelAveragesWealthFinal,[1,size(modelAveragesWealthFinal)]);
        clear modelAveragesWealthFinal;
        for i = 2:length(panelNames)
            matfile = fullfile(pwd,sprintf('AveragesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelAveragesWealthFinal,[1,size(modelAveragesWealthFinal)]));
        end            
        tempopts.dir = sprintf('/%s_wealth/',testName);
        tempopts.name = sprintf('_%s',testName);
        MainFindingsHeterogeneityAveragesStats(params, order, opts, tempopts, panelNames, statNames, YLabs, aveNames, FullPanel);
    end
    if opts.learnQtiles == 'y'
        matfile = fullfile(pwd,sprintf('AveragesLearnCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelAveragesLearnFinal,[1,size(modelAveragesLearnFinal)]);
        clear modelAveragesLearnFinal;
        for i = 2:length(panelNames)
            matfile = fullfile(pwd,sprintf('AveragesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelAveragesLearnFinal,[1,size(modelAveragesLearnFinal)]));
        end            
        tempopts.dir = sprintf('/%s_learn/',testName);
        tempopts.name = sprintf('_%s',testName);
        MainFindingsHeterogeneityAveragesStats(params, order, opts, tempopts, panelNames, statNames, YLabs, aveNames, FullPanel);
    end
    if opts.humancapQtiles == 'y'
        matfile = fullfile(pwd,sprintf('AveragesHumanCapCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelAveragesHumanCapFinal,[1,size(modelAveragesHumanCapFinal)]);
        clear modelAveragesHumanCapFinal;
        for i = 2:length(panelNames)
            matfile = fullfile(pwd,sprintf('AveragesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelAveragesHumanCapFinal,[1,size(modelAveragesHumanCapFinal)]));
        end            
        tempopts.dir = sprintf('/%s_humancap/',testName);
        tempopts.name = sprintf('_%s',testName);
        MainFindingsHeterogeneityAveragesStats(params, order, opts, tempopts, panelNames, statNames, YLabs, aveNames, FullPanel);
    end
clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;

end