function MainFindingsHeterogeneityPlots(params, order, opts, plotopts, testname, panelnames, varargin)
%% SMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);
 
if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,testname);
    model_results_table_path = fullfile(results_table_path,testname);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;


%Color Scheme
[QtileColors1,~,~] = brewermap(24,'RdYlBu');
[QtileColors2,~,~] = brewermap(24,'BrBG');
[QtileColors3,~,~] = brewermap(24,'PRGn');
[EmpColors,~,~] = brewermap(24,'RdYlBu');
[CompareColors,~,~] = brewermap(12,'Paired');

Q1EmpColor = QtileColors1(3,:);
Q1UnempUIColor = QtileColors1(7,:);
Q1UnempNoUIColor = QtileColors1(22,:);
MedEmpColor = QtileColors2(3,:);
MedUnempUIColor = QtileColors2(7,:);
MedUnempNoUIColor = QtileColors2(22,:);
TestEmpColor = QtileColors3(3,:);
TestUnempUIColor = QtileColors3(7,:);
TestUnempNoUIColor = QtileColors3(22,:);

startInd = 1;

if plotopts.treated == 'y'
    for k=1:(nargin-6)
        varargin{k} = varargin{k}(varargin{k}.Treated==1,:);
    end
end

if plotopts.difference == 'y'
    for k=2:(nargin-6)
        tempAge = varargin{k}.Age;
        tempEmp = varargin{k}.Emp;
        tempIndID = varargin{k}.IndID;
        tempLRInc = varargin{k}.LRInc;
        var = varargin{k}.Properties.VariableNames;
        for ii=var
            try
                varargin{k}.(ii{1}) = (varargin{k}.(ii{1}) - varargin{1}.(ii{1}))./varargin{1}.(ii{1});
            end
        end
        varargin{k}.LRInc = tempLRInc - varargin{1}.LRInc;
        varargin{k}.Age = tempAge;
        varargin{k}.IndID = tempIndID;
        varargin{k}.Emp_yn = tempEmp;
    end
    startInd = 2;
else
    for k=1:(nargin-6)
        varargin{k}.Emp_yn = varargin{k}.Emp;
    end
end

quintilenames = ['1st Quintile','2nd Quintile','3rd Quintile','4th Quintile','5th Quintile'];

for i = 1:5
    for k = startInd:(nargin-6)
        panelheterogeneitynames = strcat(panelnames{k},' ',quintilenames{i});
    end
end


%Plot Options
Q1EmpOpts = struct('Color',QtileColors1(3,:),'CI_yn','n','CI',0.05,'LS',[]);
Q1UnempUIOpts = struct('Color',QtileColors1(7,:),'CI_yn','n','CI',0.05,'LS','--');
Q1UnempNoUIOpts = struct('Color',QtileColors1(22,:),'CI_yn','n','CI',0.05,'LS','-.');
MedEmpOpts = struct('Color',QtileColors2(3,:),'CI_yn','n','CI',0.05,'LS','-.');
MedUnempUIOpts = struct('Color',QtileColors2(7,:),'CI_yn','n','CI',0.05,'LS','--');
MedUnempNoUIOpts = struct('Color',QtileColors2(2,:),'CI_yn','n','CI',0.05,'LS','-.');
TestEmpOpts = struct('Color',QtileColors3(3,:),'CI_yn','n','CI',0.05,'LS','--');
TestUnempUIOpts = struct('Color',QtileColors3(8,:),'CI_yn','n','CI',0.05,'LS','--');
TestUnempNoUIOpts = struct('Color',QtileColors3(19,:),'CI_yn','n','CI',0.05,'LS','-.');
TestA1050EmpOpts = struct('Color','red','CI_yn','n','CI',0.05,'LS',[]);
TestH1050Opts = struct('Color','blue','CI_yn','n','CI',0.05,'LS',[]);
TestL1050Opts = struct('Color','purple','CI_yn','n','CI',0.05,'LS',[]);

MainPlotOpts = {Q1EmpOpts,Q1UnempUIOpts,Q1UnempNoUIOpts,MedEmpOpts,MedUnempUIOpts,MedUnempNoUIOpts,TestEmpOpts,TestUnempUIOpts,TestUnempNoUIOpts};

%Q1EmpOpts.Color = cat(1,0, 0, 255)./255;
%MedEmpOpts.Color = cat(1,148,0,211)./255;
%TestEmpOpts.Color = cat(1,255, 0, 0)./255;

%% Average Plots
% Earnings Profile Comparisons

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.LRInc(varargin{k}.Age>=25&varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{k}.Age>=25&varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Annual Income (logs)')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LRInc';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.LRInc(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Annual Income (logs)')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LRIncFull';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Consumption
temp = [];
f01=figure('name','Cons_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Consumption')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'Cons';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Liquid Wealth
temp = [];
f01=figure('name','Cons_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Consumption')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'Wealth';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;


%% Human Capital
temp = [];
f01=figure('name','HumanCap_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'HumanCap';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Piece Rate
temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Average Piece Rate')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'PieceRate';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Learning Time
temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LearnTime';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.LearnTimeEmp(varargin{k}.Emp_yn>=1)(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{k}.Emp_yn>=1),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LearnTimeEmp';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Employment
temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.Emp./freq(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Employment Rate')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'Employment';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(1-varargin{k}.Emp./freq(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Unemployment Rate')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'Unemployment';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(min(varargin{k}.E2E,1)(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'mean',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Job-to-Job Transition Rate')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'JobtoJob';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Variance Plots
% Income
temp = [];
f01=figure('name','LRInc_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.LRInc(varargin{k}.Age>=25&varargin{1}.RLiqWealth_qtile==i,:)(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{k}.Age>=25&varargin{1}.RLiqWealth_qtile==i,:),'var',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Income Inequality (Variance)')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LRIncVar';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

% Human Capital
temp = [];
f01=figure('name','HumanCap_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'var',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Human Capital Inequality (Variance)')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'HumanCapVar';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

% Consumption
temp = [];
f01=figure('name','Cons_Compare');
hold on;
for i=1:5
for k=startInd:(nargin-6)
    temp = [temp,GrpStatsPlotFun(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'var',MainPlotOpts{k})];
end
end
alpha(0.25)
xlabel('Age')
ylabel('Consumption Inequality')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'ConsVar';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

%% Learning Time
temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i,:),'var',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LearnTimeVar';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;

temp = [];
f01=figure('name','LRInc_Compare');
hold on;
if nargin-5>0
    for i=1:5
for k=startInd:(nargin-6)
        temp = [temp,GrpStatsPlotFun(varargin{k}.LearnTimeEmp(varargin{k}.Emp_yn>=1)(varargin{1}.RLiqWealth_qtile==i,:),varargin{k}.Age(varargin{k}.Emp_yn>=1),'var',MainPlotOpts{k})];
    end
end
end
alpha(0.25)
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend(temp,panelnames(startInd:end));
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = 'LearnTimeEmpVar';
saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'png');
if opts.II == 'n'
    saveas(gcf,fullfile(results_graphics_path,strcat(testname,'_',figfile)),'epsc');
    GrpStatsSavecsv(temp,fullfile(results_table_path,strcat(testname,'_',figfile)),strjoin(panelnames,','));
end
close;
hold off;


end
