function MainFindingsHeterogeneityRatios(params, order, opts, testopts, testname, panelnames, varargin)
%% SMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,testname);
    model_results_table_path = fullfile(results_table_path,testname);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

if testopts.treated == 'y'
    for k=1:(nargin-6)
        varargin{k} = varargin{k}(varargin{k}.Treated==1,:);
    end
end

fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'.csv'), 'w');
fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
fclose(fid);
%temp = zeros(size(panelnames,1),8);
%temp(:,1) = panelnames.';
fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'.csv'), 'a+');
if fid>0
    for i=1:5
        for k=2:(nargin-6)
            vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f,%f',[(nanmean(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.LRInc)-nanmean(varargin{1}.LRInc))*100, ... 
                                (nanmean(varargin{k}.LNInc)-nanmean(varargin{1}.LNInc))*100, ... 
                                (nanmean(varargin{k}.LNHumanCap)-nanmean(varargin{1}.LNHumanCap))*100,(nanmean(varargin{k}.LNPieceRate)-nanmean(varargin{1}.LNPieceRate))*100, ...
                                (nanmean(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanmean(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))-1)*100]);
            fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
            fprintf(fid,'\n');
            vals = '';
        end
    end
    fclose(fid);
end

fid = fopen(strcat(model_results_table_path,'/VarianceExplainedbyWealthQtiles',testname,'.csv'), 'w');
fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
fclose(fid);
%temp = zeros(size(panelnames,1),8);
%temp(:,1) = panelnames.';
fid = fopen(strcat(model_results_table_path,'/VarianceExplainedbyWealthQtiles',testname,'.csv'), 'a+');
if fid>0
    for i=1:5
        for k=2:(nargin-6)
            vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f,%f',[(1 - nanvar(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RLiqWealth))*100, ...
                                (1 - nanvar(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.HumanCap))*100, ...
                                (1 - nanvar(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnAb))*100, ...
                                (1 - nanvar(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.Cons))*100,(-(nanvar(varargin{k}.LRInc)-nanvar(varargin{1}.LRInc))*100), ... 
                                (-(nanvar(varargin{k}.LNInc)-nanvar(varargin{1}.LNInc))*100), ... 
                                (-(nanvar(varargin{k}.LNHumanCap)-nanvar(varargin{1}.LNHumanCap))*100),(-(nanvar(varargin{k}.LNPieceRate)-nanvar(varargin{1}.LNPieceRate))*100), ...
                                (1 - nanvar(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RInc))*100, ... 
                                (1 - nanvar(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.PieceRate))*100, ...
                                (1 - nanvar(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnTimeEmp))*100, ...
                                (1 - nanvar(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.ApplicationStrategy))*100]);
            fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
            fprintf(fid,'\n');
            vals = '';
        end
    end
    fclose(fid);
end


fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'.csv'), 'w');
fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
fclose(fid);
%temp = zeros(size(panelnames,1),8);
%temp(:,1) = panelnames.';
fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'.csv'), 'a+');
if fid>0
    for i=1:5
        for k=2:(nargin-6)
            vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f,%f',[(nanvar(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.LRInc)-nanvar(varargin{1}.LRInc))*100, ... 
                                (nanvar(varargin{k}.LNInc)-nanvar(varargin{1}.LNInc))*100, ... 
                                (nanvar(varargin{k}.LNHumanCap)-nanvar(varargin{1}.LNHumanCap))*100,(nanvar(varargin{k}.LNPieceRate)-nanvar(varargin{1}.LNPieceRate))*100, ...
                                (nanvar(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                (nanvar(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))-1)*100]);
            fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
            fprintf(fid,'\n');
            vals = '';
        end
    end
    fclose(fid);
end


if testopts.PDV == 'y'
    
    temp = grpstats(varargin{1}.LRInc,varargin{1}.Age,{'mean'});
    A = size(temp,1);
    disc = (1 + r).^(T./A)-1;
    
    fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'PDV.csv'), 'w');
    fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
    fclose(fid);
    %temp = zeros(size(panelnames,1),8);
    %temp(:,1) = panelnames.';
    fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'PDV.csv'), 'a+');
    if fid>0
        for i=1:5
            for k=2:(nargin-6)
                vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f',[(geosum2(disc,grpstats(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A) - geosum2(disc,grpstats(varargin{1}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A) - geosum2(disc,grpstats(varargin{1}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A) - geosum2(disc,grpstats(varargin{1}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A) - geosum2(disc,grpstats(varargin{1}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)./geosum2(disc,grpstats(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanmean'}).',A)-1)*100]);
                fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
                fprintf(fid,'\n');
                vals = '';
            end
        end
        fclose(fid);
    end

    fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'PDV.csv'), 'w');
    fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
    fclose(fid);
    %temp = zeros(size(panelnames,1),8);
    %temp(:,1) = panelnames.';
    fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'PDV.csv'), 'a+');
    if fid>0
        for i=1:5
            for k=2:(nargin-6)
                vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f',[(geosum2(disc,grpstats(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (geosum2(disc,grpstats(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100]);
                fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
                fprintf(fid,'\n');
                vals = '';
            end
        end
        fclose(fid);
    end
    
    fid = fopen(strcat(model_results_table_path,'/VarianceExplainedbyWealthQtiles',testname,'PDV.csv'), 'w');
    fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
    fclose(fid);
    %temp = zeros(size(panelnames,1),8);
    %temp(:,1) = panelnames.';
    fid = fopen(strcat(model_results_table_path,'/VarianceExplainedbyWealthQtiles',testname,'PDV.csv'), 'a+');
    if fid>0
        for i=1:5
            for k=2:(nargin-6)
                vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f',[(1-geosum2(disc,grpstats(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LRInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNHumanCap(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LNPieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100, ...
                                    (1-geosum2(disc,grpstats(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{k}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A)./geosum2(disc,grpstats(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i),varargin{1}.Age(varargin{1}.RLiqWealth_qtile==i),{'nanvar'}).',A))*100]);
                fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
                fprintf(fid,'\n');
                vals = '';
            end
        end
        fclose(fid);
    end    

end

if testopts.initconds == 'y'
    for k=1:(nargin-6)
        varargin{k} = varargin{k}(varargin{k}.Age==23,:);
    end

    fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'Init.csv'), 'w');
    fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
    fclose(fid);
    %temp = zeros(size(panelnames,1),8);
    %temp(:,1) = panelnames.';
    fid = fopen(strcat(model_results_table_path,'/PctChangebyWealthQtiles',testname,'Init.csv'), 'a+');
    if fid>0
        for i=1:5
            for k=2:(nargin-6)
                vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f,%f',[(nanmean(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanmean(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanmean(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanmean(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanmean(varargin{k}.LRInc)-nanmean(varargin{1}.LRInc))*100, ...
                                    (nanmean(varargin{k}.LNInc)-nanmean(varargin{1}.LNInc))*100, ...
                                    (nanmean(varargin{k}.LNHumanCap)-nanmean(varargin{1}.LNHumanCap))*100,(nanmean(varargin{k}.LNPieceRate)-nanmean(varargin{1}.LNPieceRate))*100, ...
                                    (nanmean(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanmean(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanmean(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanmean(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))./nanmean(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))-1)*100]);
                fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
                fprintf(fid,'\n');
                vals = '';
            end
        end
        fclose(fid);
    end

    fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'Init.csv'), 'w');
    fprintf(fid,'Panel,RliqWealth,HumanCap,LearnAb,Cons,LRInc,LNInc,LNHumanCap,LNPieceRate,RInc,PieceRate,LearnTime,AppStrat\n');
    fclose(fid);
    %temp = zeros(size(panelnames,1),8);
    %temp(:,1) = panelnames.';
    fid = fopen(strcat(model_results_table_path,'/VariancePctChangebyWealthQtiles',testname,'Init.csv'), 'a+');
    if fid>0
        for i=1:5
            for k=2:(nargin-6)
                vals = sprintf(',%f,%f,%f,%f,%f,%f,%f,%f,%f',[(nanvar(varargin{k}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RLiqWealth(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanvar(varargin{k}.HumanCap(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.HumanCap(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanvar(varargin{k}.LearnAb(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnAb(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanvar(varargin{k}.Cons(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.Cons(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanvar(varargin{k}.LRInc)-nanvar(varargin{1}.LRInc))*100, ...
                                    (nanvar(varargin{k}.LNInc)-nanvar(varargin{1}.LNInc))*100, ...
                                    (nanvar(varargin{k}.LNHumanCap)-nanvar(varargin{1}.LNHumanCap))*100,(nanvar(varargin{k}.LNPieceRate)-nanvar(varargin{1}.LNPieceRate))*100, ...
                                    (nanvar(varargin{k}.RInc(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.RInc(varargin{1}.RLiqWealth_qtile==i))-1)*100,(nanvar(varargin{k}.PieceRate(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.PieceRate(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanvar(varargin{k}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.LearnTimeEmp(varargin{1}.RLiqWealth_qtile==i))-1)*100, ...
                                    (nanvar(varargin{k}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))./nanvar(varargin{1}.ApplicationStrategy(varargin{1}.RLiqWealth_qtile==i))-1)*100]);
                fprintf(fid,'%s,%s,%f',[panelnames{k},int2str(i),vals]);
                fprintf(fid,'\n');
                vals = '';
            end
        end
        fclose(fid);
    end

end

end

