function MainFindingsPlots(params, order, opts, plotopts, dataopts, panelLegend, statNames, YLabs, statArray)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

% statArray: 1: TimeVar, 2: LRInc, 3: RInc, 4: RIncEmp, 5: HumanCap, 6: HumanCapEmp, 7: HumanCapUnemp, 8: HumanCapUnempwUI, 9: HumanCapUnempwoUI, 10: RLiqWealth, 11: RLiqWealthEmp, 12: RLiqWealthUnemp, 13: RLiqWealthUnempwUI, 14: RLiqWealthUnempwoUI, 15: Emp, 16: Unemp, 17: UnempwUI, 18: Ten, 19: TenEmp, 20: Cons, 21: ConsEmp, 22: ConsUnemp, 23: ConsUnempwUI, 24: ConsUnempwoUI, 25: PieceRate, 26: AppStrat, 27: AppStratEmp, 28: AppStratUnemp, 29: AppStratUnempwUI, 30: AppStratUnempwoUI, 31: EmpProb, 32: EmpProbEmp, 33: EmpProbUnemp, 34: EmpProbUnempwUI, 35: EmpProbUnempwoUI, 36: SubTightness, 37: SubTightnessEmp, 38: SubTightnessUnemp, 39: SubTightnessUnempwUI, 40: SubTightnessUnempwoUI, 41: LearnTime, 42: LearnTimeEmp, 43: UnempDur


% [ColorSet2,~,~] = brewermap(24,'RdYlBu');
% [ColorSet3,~,~] = brewermap(24,'BrBG');
% [ColorSet4,~,~] = brewermap(24,'PRGn');
% [ColorSet1,~,~] = brewermap(24,'RdYlBu');
% [ColorSet5,~,~] = brewermap(12,'Paired');

FormatOpts1 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'FontSize'    , 12        , ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts2 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'FontSize'    , 12        , ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts3 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'FontSize'    , 12        , ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts4 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'FontSize'    , 12        , ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,6,4]);

FormatOpts5 = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'FontSize'    , 12        , ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,6,4]);


startInd = 1;

if dataopts.diff == 'y' | dataopts.pct == 'y'
    for j = 1:length(panelLegend)
        statArray(j,:,:) = statArray(j,:,:) - statArray(1,:,:);
    end
    startInd = 2;
end

if dataopts.pct == 'y'
    dataopts.norm = 'y';
end

ColorSet1 = distinguishable_colors(length(panelLegend)+1-startInd);
LineStyleSet1 = ['-',':','--','-.'];
MarkerSet1 = ['s','o','^','p','','*'];


if length(ColorSet1) > 4
    LineStyleSet1 = repmat(LineStyleSet1,ceil(length(ColorSet1)/length(LineStyleSet1)),1);
    MarkerSet1 = repmat(MarkerSet1,ceil(length(ColorSet1)/length(MarkerSet1)),1);
end

%%Plots
% Time Series: Loop over statNamess above

if dataopts.norm == 'y'
    for i = 2:length(statNames)
        temp = [];
        hold on;
        for j = startInd:length(panelLegend)
            temp = [temp,plot(squeeze(statArray(j,2,:)),squeeze(statArray(j,i,:))./repmat(squeeze(statArray(j,i,1)),T./freq,1),'color',ColorSet1(j+1-startInd,:),'LineWidth',FormatOpts1.LW,'LineStyle',LineStyleSet1(j+1-startInd),'Marker',MarkerSet1(j+1-startInd))];
        end
        yLims = get(gca,'ylim');
        xlabel('Age','Interpreter','latex')
        ylabel(YLabs{i},'Interpreter','latex')
        set(gca, ...
            'GridLineStyle'         , '--'     , ...
            'Box'         , 'off'     , ...
            'TickDir'     , 'out'     , ...
            'TickLength'  , [.02 .02] , ...
            'XMinorTick'  , 'on'      , ...
            'YMinorTick'  , 'on'      , ...
            'XGrid'       , 'on'      , ...
            'YGrid'       , 'on'      , ...
            'XColor'      , [.3 .3 .3], ...
            'YColor'      , [.3 .3 .3], ...
            'FontSize'    , 12        , ...
            'LineWidth'   , 1         );
        hleg1 = legend(temp,panelLegend(startInd:end),'Interpreter','latex');
        set(hleg1,'Location','best');
        figfile = fullfile(results_graphics_path,strcat(statNames{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
        clear temp;
        close;
    end
else
    for i = 2:length(statNames)
        temp = [];
        hold on;
        for j = startInd:length(panelLegend)
            temp = [temp,plot(squeeze(statArray(j,2,:)),squeeze(statArray(j,i,:)),'color',ColorSet1(j+1-startInd,:),'LineWidth',FormatOpts1.LW,'LineStyle',LineStyleSet1(j+1-startInd),'Marker',MarkerSet1(j+1-startInd))];
        end
        yLims = get(gca,'ylim');
        xlabel('Age','Interpreter','latex')
        ylabel(YLabs{i},'Interpreter','latex')
        set(gca, ...
            'GridLineStyle'         , '--'     , ...
            'Box'         , 'off'     , ...
            'TickDir'     , 'out'     , ...
            'TickLength'  , [.02 .02] , ...
            'XMinorTick'  , 'on'      , ...
            'YMinorTick'  , 'on'      , ...
            'XGrid'       , 'on'      , ...
            'YGrid'       , 'on'      , ...
            'XColor'      , [.3 .3 .3], ...
            'YColor'      , [.3 .3 .3], ...
            'FontSize'    , 12        , ...
            'LineWidth'   , 1         );
        hleg1 = legend(temp,panelLegend(startInd:end),'Interpreter','latex');
        set(hleg1,'Location','best');
        figfile = fullfile(results_graphics_path,strcat(statNames{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
        clear temp;
        close;
    end
end

end
