function MainFindingsPlots_Wrapper(params, order, opts, testName, panelNames, panelLegend, statNames, YLabs)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{1}));
    load(matfile);
    FullPanel = reshape(modelProfilesFinal,[1,size(modelProfilesFinal)]);
    clear modelProfilesFinal;
    for i = 2:length(panelNames)
        matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{i}));
        load(matfile);
        FullPanel = cat(1,FullPanel,reshape(modelProfilesFinal,[1,size(modelProfilesFinal)]));
    end


        
    tempopts.dir = sprintf('/%s/',testName);
    tempopts.name = sprintf('_%s_Ave',testName);
    dataopts.norm = 'n';
    dataopts.diff = 'n';
    dataopts.pct = 'n';
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,1,:,:)));
    tempopts.name = sprintf('_%s_Var',testName);
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,2,:,:)));

    tempopts.name = sprintf('_%s_AveNorm',testName);        
    dataopts.norm = 'y';
    dataopts.diff = 'n';
    dataopts.pct = 'n';
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,1,:,:)));
    tempopts.name = sprintf('_%s_VarNorm',testName);
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,2,:,:)));


    tempopts.name = sprintf('_%s_AveDiff',testName);        
    dataopts.norm = 'n';
    dataopts.diff = 'y';
    dataopts.pct = 'n';
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,1,:,:)));
    tempopts.name = sprintf('_%s_VarDiff',testName);
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,2,:,:)));


    tempopts.name = sprintf('_%s_AvePct',testName);
    dataopts.norm = 'n';
    dataopts.diff = 'n';
    dataopts.pct = 'y';
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,1,:,:)));    
    tempopts.name = sprintf('_%s_VarPct',testName);
    MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(FullPanel(:,2,:,:)));


    clear FullPanel;
    if opts.wealthQtiles == 'y'
        matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelProfilesWealthFinal,[1,size(modelProfilesWealthFinal)]);
        clear modelProfilesWealthFinal;
        for i = 1:length(panelNames)
            matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelProfilesWealthFinal,[1,size(modelProfilesWealthFinal)]));
        end
        tempopts.dir = sprintf('/%s_wealth/',testName);
        for i = 1:5

            tempFullPanel = squeeze(FullPanel(:,:,i,:,:));
            
            tempopts.name = sprintf('_%s_Ave_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_Var_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveNorm_qtile%s',testName,int2str(i));
            dataopts.norm = 'y';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarNorm_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveDiff_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'y';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarDiff_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AvePct_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'y';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarPct_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));
            clear tempFullPanel;
        end
    end

    if opts.humancapQtiles == 'y'
        matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelProfilesHumanCapFinal,[1,size(modelProfilesHumanCapFinal)]);
        clear modelProfilesHumanCapFinal;
        for i = 1:length(panelNames)
            matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelProfilesHumanCapFinal,[1,size(modelProfilesHumanCapFinal)]));
        end            
        tempopts.dir = sprintf('/%s_humancap/',testName);
        for i = 1:5

            tempFullPanel = squeeze(FullPanel(:,:,i,:,:));
            
            tempopts.name = sprintf('_%s_Ave_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_Var_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveNorm_qtile%s',testName,int2str(i));
            dataopts.norm = 'y';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarNorm_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveDiff_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'y';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarDiff_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AvePct_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'y';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarPct_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));
            clear tempFullPanel;
        end
    end
    
    if opts.learnQtiles == 'y'
        matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{1}));
        load(matfile);
        FullPanel = reshape(modelProfilesLearnFinal,[1,size(modelProfilesLearnFinal)]);
        clear modelProfilesLearnFinal;
        for i = 1:length(panelNames)
            matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            FullPanel = cat(1,FullPanel,reshape(modelProfilesLearnFinal,[1,size(modelProfilesLearnFinal)]));
        end
        tempopts.dir = sprintf('/%s_learn/',testName);
        for i = 1:5

            tempFullPanel = squeeze(FullPanel(:,:,i,:,:));
            
            tempopts.name = sprintf('_%s_Ave_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_Var_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveNorm_qtile%s',testName,int2str(i));
            dataopts.norm = 'y';
            dataopts.diff = 'n';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarNorm_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AveDiff_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'y';
            dataopts.pct = 'n';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarDiff_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));

            tempopts.name = sprintf('_%s_AvePct_qtile%s',testName,int2str(i));
            dataopts.norm = 'n';
            dataopts.diff = 'n';
            dataopts.pct = 'y';
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,1,:,:)));
            tempopts.name = sprintf('_%s_VarPct_qtile%s',testName,int2str(i));
            MainFindingsPlots(params, order, opts, tempopts, dataopts, panelLegend, statNames, YLabs, squeeze(tempFullPanel(:,2,:,:)));
            clear tempFullPanel;
        end
    end
    
    
    
    
    clear StatEsts_Base WealthStatEsts_Base HumanCapStatEsts_Base LearnStatEsts_Base StatEsts_Alt WealthStatEsts_Alt HumanCapStatEsts_Alt LearnStatEsts_Alt;
end