function MainPlots(params, order, opts, plotopts, statNames, YLabs, lifetime_earnings, lifetime_variance, statArray, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

[ColorSet2,~,~] = brewermap(24,'RdYlBu');
[ColorSet3,~,~] = brewermap(24,'BrBG');
[ColorSet4,~,~] = brewermap(24,'PRGn');
[ColorSet1,~,~] = brewermap(24,'RdYlBu');
[ColorSet5,~,~] = brewermap(12,'Paired');

FormatOpts = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,4,4]);


% AggShocks = [0;AggShocks];


%%Plots
% Time Series: Loop over statNamess above

LRIncHVY23 = squeeze(statArray(1,find(strcmp(statNames, 'HumanCap')),1)).*squeeze(statArray(1,find(strcmp(statNames, 'PieceRateShare')),:)).*(1 - squeeze(statArray(1,find(strcmp(statNames, 'PieceRateShare')),:))).*w0;

LRIncHVY23 = log(LRIncHVY23);

p1 = plot(squeeze(statArray(1,2,:)),squeeze(statArray(1,find(strcmp(statNames, 'LRIncHVY_3')),:)),'LineWidth',1.5,'color','b');
p2 = plot(squeeze(statArray(1,2,:)),LRIncHVY23,'LineWidth',1.5,'color','b');
hold on;
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
xlabel('Age','Interpreter','latex')
ylabel(YLabs{i},'Interpreter','latex')
hleg1 = legend(temp,panelLegend(startInd:end),'Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'LineWidth'   , 1         );        
figfile = fullfile(results_graphics_path,strcat(statNames{i},plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

end