function xmin = Main_Wrapper(params,opts,II_params,moments,weights,NumObs,NObsNames,init_earnings,init_assets,earnNorm,earnNormVar,lifetime_earnings,lifetime_variance,ResultsSeries)
%%Model_Wrapper m-file
%Author: Ben Griffy
%Date: Sept., 2017

    
% switch GPU if running on GPU other than #1
    if opts.gpu == 'y'
        if opts.gpunum ~= 1
            gpuDevice(opts.gpunum);
        end
    end


    % Create directories for all possible counterfactuals and output paths
    if ~isequal(exist(fullfile(pwd,opts.graphics_path),'dir'),7)
        mkdir(fullfile(pwd,opts.graphics_path));
    end
    if ~isequal(exist(fullfile(pwd,opts.output_path),'dir'),7)
        mkdir(fullfile(pwd,opts.output_path));
    end
    if opts.solve == 'y'
        if ~isequal(exist(fullfile(pwd,opts.output_path,'RepRate'),'dir'),7)
            mkdir(fullfile(pwd,opts.output_path,'RepRate'));
        end
        if ~isequal(exist(fullfile(pwd,opts.output_path,'UIDur'),'dir'),7)
            mkdir(fullfile(pwd,opts.output_path,'UIDur'));
        end                
        if ~isequal(exist(fullfile(pwd,opts.output_path,'UIDurDown'),'dir'),7)
            mkdir(fullfile(pwd,opts.output_path,'UIDurDown'));
        end
        if ~isequal(exist(fullfile(pwd,opts.output_path,'RepRateDown'),'dir'),7)
            mkdir(fullfile(pwd,opts.output_path,'RepRateDown'));
        end
        if ~isequal(exist(fullfile(pwd,opts.output_path,'EmpRisk'),'dir'),7)
            mkdir(fullfile(pwd,opts.output_path,'EmpRisk'));
        end
    end
    if ~isequal(exist(fullfile(pwd,opts.II_path),'dir'),7)
        mkdir(fullfile(pwd,opts.II_path));
    end
    if opts.II == 'n'
        if ~isequal(exist(fullfile(pwd,opts.results_path),'dir'),7)
            mkdir(fullfile(pwd,opts.results_path));
        end
    end
    % Calculated parameters
    params.w0 = exp(mean(init_earnings))./params.Norm;
    params.MaxUI = params.MaxUI./params.w0;
    params.bRet = params.bRet./params.w0;
    params.MaxUIUITest = params.MaxUIUITest./params.w0;
    params.bbarUITest = params.bbarUITest./params.w0;
    params.blDeltUITest = params.blDeltUITest./params.w0;
    A=[];                               
    B=[];

    rAnn = (1 + params.r)^(params.freq) - 1;

    LC99thPctileEarnProfile = earnNorm + 2.*sqrt(earnNormVar);
    LC1stPctileEarnProfile = earnNorm - 2.*sqrt(earnNormVar);
    params.uba = params.NumYears.*(rAnn.*max(exp(LC99thPctileEarnProfile)))./params.w0;
    params.ubh = max(exp(LC99thPctileEarnProfile))./params.w0;
    dU = @(c)((params.w0./params.freq).*c).^(-params.ssigma);
    nnuUB = dU(params.uba.*params.freq);
    delthLB = min(exp(LC1stPctileEarnProfile))./params.w0;
    delthUB = min(exp(LC99thPctileEarnProfile))./params.w0;
    blUB = (rAnn.*max(exp(LC1stPctileEarnProfile)))./params.w0;
    MeanMin = (exp(mean(earnNorm))./params.Norm)./params.w0;
    kkappaLB = 0.2*MeanMin;
    kkappaUB = 0.6*MeanMin;

 %        'bl', 'eeta', 'kkappa', 'MuEps', 'SigEps', 'MuA', 'MuH',  'MuL',  'SigA','SigH', 'SigL','SigAH','SigAL','SigHL','aalphah', 'llambe', 'delth', 'deltl','SigXi'
    LB = [0.01,   0.4,  kkappaLB, -0.03,    0.03,     0.2,  -0.6,    1.0,    0.75,  0.8,    0.4,   0.3,    0.35,   0.35,    0.35,      0.55,  delthLB,   0.01,  0.03];
    UB = [0.04,   1,    kkappaUB, -0.01,    0.07,     1.0,   0.1,    2.0,    1.5,   1.5,    1.1,   0.8,    0.7,    0.75,    0.75,       0.8,  delthUB,   0.15,  0.15];
    Aeq = [];
    Beq = [];
        
    
    clear nnuUB dU delthLB delthUB blUB LC99thPctileEarnProfile LC1stPctileEarnProfile;

    % Subset params to get the II parameters at the front
    % This is a stupid way to do this and I would program it differently now
    params_array = NaN(length(fieldnames(params)),1);
    order = [];

    for j = 1:length(II_params)
        params_array(j) = extractfield(params,II_params{1,j});
        order{j,1} = II_params{1,j};
        params = rmfield(params,II_params{1,j});
    end

    keys = fieldnames(params);

    for i = 1:length(keys)
        params_array(length(II_params)+i) = extractfield(params,keys{i,1});
        order(length(II_params)+ i) = keys(i);
    end
   

    xmin = [];

    if opts.II == 'y'
        if opts.solver == 'PS'
            options = optimoptions('patternsearch','Display','iter','PlotFcn',{@psplotbestf,@psplotmeshsize},'PollOrderAlgorithm','Random','InitialMeshSize',0.00125);
            obj_fun = @(est_params)II_Wrapper([est_params; params_array(length(II_params)+1:end)],order,length(II_params),opts,moments,weights,NumObs,NObsNames,init_earnings,init_assets,lifetime_earnings,lifetime_variance,ResultsSeries);
            [xmin,fval] = patternsearch(obj_fun,params_array(1:length(II_params)),A,B,Aeq,Beq,LB,UB,[],options);
        elseif strcat(opts.solver) == 'DR'
            options = struct('maxevals',10000000,'maxits',10000000,'showits',0,'tol',1e-6,'impcons',1);
            obj_fun = @(est_params)II_Wrapper([est_params; params_array(length(II_params)+1:end)],order,length(II_params),opts,moments,weights,NumObs,NObsNames,init_earnings,init_assets,lifetime_earnings,lifetime_variance,ResultsSeries);
            myprob  = struct('f',obj_fun);
            bounds = reshape(cat(2,LB,UB),length(II_params),2);
            [fval,xmin,hist] = Direct(myprob,bounds,options);
        elseif strcat(opts.solver) == 'SA'
            hybridopts = optimoptions('patternsearch','Display','iter','PlotFcn',@psplotbestf,'Cache','on','UseCompletePoll',true,'UseCompleteSearch',true,'InitialMeshSize',0.00125);
            options = optimoptions(@simulannealbnd,'HybridFcn',{@patternsearch,hybridopts},'PlotFcn',{@saplotbestf, @saplotf},'ObjectiveLimit',0.0);
            obj_fun = @(est_params)II_Wrapper([est_params; params_array(length(II_params)+1:end)],order,length(II_params),opts,moments,weights,NumObs,NObsNames,init_earnings,init_assets,lifetime_earnings,lifetime_variance,ResultsSeries);
            [xmin,fval] = simulannealbnd(obj_fun,params_array(1:length(II_params)),LB,UB,options);
        elseif strcat(opts.solver) == 'MH'
            obj_fun = @(est_params)II_Wrapper([est_params; params_array(length(II_params)+1:end)],order,length(II_params),opts,moments,weights,NumObs,NObsNames,init_earnings,init_assets,lifetime_earnings,lifetime_variance,ResultsSeries);
            [xmin,xminse] = MetHastings_Estim(obj_fun,params_array(1:length(II_params)),LB,UB,opts);
        end
    elseif opts.II == 'n'
        MainFindings(params_array,order,II_params,length(II_params),opts,moments,weights,NumObs,NObsNames,init_earnings,init_assets,lifetime_earnings,lifetime_variance,ResultsSeries);
        xmin = [];
    end
end
