function Model(params, order, opts)
%% Model m-file for Wealth Effects, Search and Inequality
% 

reset(gpuDevice)

feature accel on

if ~isequal(exist(fullfile(pwd,opts.output_path),'dir'),7)
    mkdir(fullfile(pwd,opts.output_path));
end


%% Set Parameters Values

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

%% Grids

[J0,Theta,R,Rub,Rubl,V,wprimee1,aprimee1,thate1,hhate1,wprimeu1b,bgrid,wgrid,hgrid,lgrid,wugrid,wwgrid,ttgrid,wmesh,hmesh,lmesh,xxigrid,Epsgrid,EpsPDF] = Grids(params, order, opts);

if opts.ret == 'y'
    fprintf('period %1.1f\n',T+1)
    ca = 2;
    agrid  = gpuArray(linspace(0,ub.a.^(1/ca),Na).^ca);
    aagrid  = gpuArray(linspace(0,ub.a,na*na));
    chatRet = bsxfun(@minus,(1 + r).*reshape(agrid,Na,1) + bRet,reshape(aagrid,1,na*na));
    UhatRet = U(chatRet);
    UhatRet(chatRet<=0) = -realmax./T;
    clear chatRet;
    VRet = zeros(Na,1);
    VRet1 = zeros(Na,1);
    aprime1ret = zeros(Na,1);
    abserr = 100;
    while abserr > errtol
        Valaux = RetObj(aagrid,agrid,UhatRet,VRet,params,order,opts);
        [VRet1,pol] = max(Valaux,[],2);
        aprime1ret = aagrid(pol);
        abserr = max(abs([VRet1-VRet]));
        VRet = VRet1;
        clear VRet1 Valaux pol;
    end
    Rubl = (exitProb.*Rubl + (1 - exitProb).*repmat(reshape(VRet,Na,1,1),1,Nh,Nl));
    Rub = (exitProb.*Rub + (1 - exitProb).*repmat(reshape(VRet,1,Na,1,1),Nb,1,Nh,Nl));
    R = (exitProb.*R + (1 - exitProb).*repmat(reshape(VRet,1,Na,1,1),Nw,1,Nh,Nl));
    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',T+1));
    save(matfile, 'aprime1ret');
    clear UhatRet VRet aprime1ret;
end

idl       = find(speye(Nl,Nl));

err = 0
%% Solve for the Value Functions
tic
for t = T:-1:0
    err = 0;
    fprintf('period %1.1f\n',t)
    [agrid, agridt, aagrid, Uhatb, Uhatbl, chatemp1, chatemp2] = UpdateGrids(t, params, order, bgrid, hgrid, ttgrid, opts);
    % Update consumption and savings Bellman Equations Vubl, Vub, V
    % Unemployed Workers Vu(a)
    Rbl       = permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1),interp1(hgrid.',permute(Rubl,[2,1,3]),max(min(bsxfun(@times,exp(Epsgrid),hgrid),ub.h),lb.h).','linear')),2)),[2,1,3]);
    Valaux    = UblObj(aagrid,agridt,Uhatbl,Rbl,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],4);
    aprimeu1bl  = aagrid(pol);
    Vubl      = Val;
    clear Val pol Valaux Uhatbl;
    Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1),interp1(hgrid.',permute(Rub,[3,1,2,4]),max(min(bsxfun(@times,exp(Epsgrid),hgrid),ub.h),lb.h).','linear')),2));
    Rb        = permute(Rb,[2,3,1,4]);
    Valaux    = UbObj(aagrid,agridt,Uhatb,Rb,Rbl,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],5);
    aprimeu1b   = aagrid(pol);
    Vub       = Val;
    clear Val pol Rbl Valaux Uhatb Rb;
    Rb = repmat(permute(Rub,[3,1,2,4]),1,1,1,1,Epsnodes,nt);
    Rw = repmat(permute(R,[3,1,2,4]),1,1,1,1,Epsnodes,nt);
    for il = 1:Nl
        Rb(:,:,:,il,:,:) = permute(interp1(hgrid.',squeeze(Rb(:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear'),[1,4,5,2,3]);
        Rw(:,:,:,il,:,:) = permute(interp1(hgrid.',squeeze(Rw(:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear'),[1,4,5,2,3]);
    end
    Rw        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,Epsnodes,1),Rw),5));
    Rw        = permute(Rw,[2,3,1,4,5]);
    Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,Epsnodes,1),Rb),5));
    Rb        = permute(Rb,[2,3,1,4,5]);
    if opts.gpu == 'y'
        for ih = 1:Nh
            for iw = 1:Nw
                Valaux       = WObj(aagrid,agridt,bgrid,wgrid(iw).*chatemp1(ih,:),chatemp2,squeeze(Rw(iw,:,ih,:,:)),squeeze(Rb(:,:,ih,:,:)),params,order,opts); % Value of being Employed
                Valaux       = reshape(Valaux,Na,Nl,na*nt);       
                [Val,pol]    = max(Valaux,[],3);
                [pola,polt]  = ind2sub([na nt],pol);
                aprimee1(iw,:,ih,:)       = aagrid(pola);
                thate1(iw,:,ih,:)       = ttgrid(polt);
                temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
                hhate1(iw,:,ih,:)       = temp(:,idl);
                V(iw,:,ih,:)            = Val;
                clear Val pol pola polt temp Valaux;
            end
        end
    else
        parfor ih = 1:Nh
            for iw = 1:Nw
                Valaux       = WObj(aagrid,agridt,bgrid,wgrid(iw).*chatemp1(ih,:),chatemp2,squeeze(Rw(iw,:,ih,:,:)),squeeze(Rb(:,:,ih,:,:)),params,order,opts); % Value of being Employed
                Valaux       = reshape(Valaux,Na,Nl,na*nt);       
                [Val,pol]    = max(Valaux,[],3);
                [pola,polt]  = ind2sub([na nt],pol);
                aprimee1(iw,:,ih,:)       = aagrid(pola);
                thate1(iw,:,ih,:)       = ttgrid(polt);
                temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
                hhate1(iw,:,ih,:)       = temp(:,idl);
                V(iw,:,ih,:)            = Val;
            end
        end
        clear Val pol pola polt temp Valaux;
    end
    clear Rb Rw aagrid chatemp1 chatemp2;
    set(0,'defaultFigureVisible','off');
    if opts.save_diagplots == 'y' %This makes the code much slower.
        f = figure('name','SavingsRules');
        ax1 = subplot(4,3,1,'Parent',f);
        ax2 = subplot(4,3,2,'Parent',f);
        ax3 = subplot(4,3,3,'parent',f);
        ax4 = subplot(4,3,4,'Parent',f);
        ax5 = subplot(4,3,5,'Parent',f);
        ax6 = subplot(4,3,6,'Parent',f);
        ax7 = subplot(4,3,7,'parent',f);
        ax8 = subplot(4,3,8,'Parent',f);
        ax9 = subplot(4,3,9,'Parent',f);
        ax10 = subplot(4,3,10,'Parent',f);
        ax11 = subplot(4,3,11,'parent',f);
        ax12 = subplot(4,3,12,'Parent',f);
        set(f,'PaperPosition',[0,0,20,18]);
        mesh(ax1,wgrid,agrid,aprimee1(:,:,2,1)');
        xlabel(ax1,'Wage')
        ylabel(ax1,'Assets')
        title(ax1,'Emp: Low HC, Low Learn')
        mesh(ax2,wgrid,agrid,aprimee1(:,:,Nh-1,Nl-1)');
        xlabel(ax2,'Wage')
        ylabel(ax2,'Assets')
        title(ax2,'Emp: High HC, High Learn')
        mesh(ax3,wgrid,agrid,aprimee1(:,:,Nh-1,1)');
        xlabel(ax3,'Wage')
        ylabel(ax3,'Assets')
        title(ax3,'Emp: High HC, Low Learn')
        mesh(ax4,wgrid,agrid,aprimee1(:,:,2,Nl-1)');
        xlabel(ax4,'Wage')
        ylabel(ax4,'Assets')
        title(ax4,'Emp: Low HC, High Learn')
        mesh(ax5,bgrid,agrid,squeeze(aprimeu1b(:,:,2,1))');
        xlabel(ax5,'Wage')
        ylabel(ax5,'Assets')
        title(ax5,'Unemp: Low HC, Low Learn')
        mesh(ax6,bgrid,agrid,squeeze(aprimeu1b(:,:,Nh-1,Nl-1))');
        xlabel(ax6,'Wage')
        ylabel(ax6,'Assets')
        title(ax6,'Unemp: High HC, High Learn')
        mesh(ax7,bgrid,agrid,squeeze(aprimeu1b(:,:,Nh-1,1))');
        xlabel(ax7,'Wage')
        ylabel(ax7,'Assets')
        title(ax7,'Unemp: High HC, Low Learn')
        mesh(ax8,bgrid,agrid,squeeze(aprimeu1b(:,:,2,Nl-1))');
        xlabel(ax8,'Wage')
        ylabel(ax8,'Assets')
        title(ax8,'Unemp: Low HC, High Learn')
        plot(ax9,agrid,squeeze(aprimeu1bl(:,2,1))');
        xlabel(ax9,'Assets')
        title(ax9,'Unemp: Low HC, Low Learn')
        plot(ax10,agrid,squeeze(aprimeu1bl(:,Nh-1,Nl-1))');
        xlabel(ax10,'Assets')
        title(ax10,'Unemp: High HC, High Learn')
        plot(ax11,agrid,squeeze(aprimeu1bl(:,Nh-1,1))');
        xlabel(ax11,'Assets')
        title(ax11,'Unemp: High HC, Low Learn')
        plot(ax12,agrid,squeeze(aprimeu1bl(:,2,Nl-1))');
        xlabel(ax12,'Assets')
        title(ax12,'Unemp: Low HC, High Learn')
        figfile = fullfile(pwd,'/graphics/',strcat('SavingRules_', int2str(t), '.png'));
        saveas(f,figfile);
        close;

        f = figure('name','InvestmentRules');
        ax1 = subplot(3,4,1,'Parent',f);
        ax2 = subplot(3,4,2,'Parent',f);
        ax3 = subplot(3,4,3,'parent',f);
        ax4 = subplot(3,4,4,'Parent',f);
        ax5 = subplot(3,4,5,'Parent',f);
        ax6 = subplot(3,4,6,'Parent',f);
        ax7 = subplot(3,4,7,'parent',f);
        ax8 = subplot(3,4,8,'Parent',f);
        ax9 = subplot(3,4,9,'Parent',f);
        ax10 = subplot(3,4,10,'Parent',f);
        ax11 = subplot(3,4,11,'parent',f);
        ax12 = subplot(3,4,12,'Parent',f);
        set(f,'PaperPosition',[0,0,18,20]);
        mesh(ax1,wgrid,agrid,thate1(:,:,2,1)');
        xlabel(ax1,'Wage')
        ylabel(ax1,'Assets')
        title(ax1,'Low HC, Low Learn')
        mesh(ax2,wgrid,agrid,thate1(:,:,floor(Nh/2),1)');
        xlabel(ax2,'Wage')
        ylabel(ax2, 'Assets') 
        title(ax2,'Med HC, Low Learn')
        mesh(ax3,wgrid,agrid,thate1(:,:,Nh-1,1)');
        xlabel(ax3,'Wage')
        ylabel(ax3,'Assets')
        title(ax3,'High HC, Low Learn')
        mesh(ax4,wgrid,agrid,thate1(:,:,2,3)');
        xlabel(ax4,'Wage')
        ylabel(ax4,'Assets')
        title(ax4,'Low HC, Low/Med Learn')
        mesh(ax5,wgrid,agrid,thate1(:,:,floor(Nh/2),3)');
        xlabel(ax5,'Wage')
        ylabel(ax5,'Assets')
        title(ax5,'Med HC, Low/Med Learn')
        mesh(ax6,wgrid,agrid,thate1(:,:,Nh-1,3)');
        xlabel(ax6,'Wage')
        ylabel(ax6,'Assets')
        title(ax6,'High HC, Low/Med Learn')
        mesh(ax7,wgrid,agrid,thate1(:,:,2,5)');
        xlabel(ax7,'Wage')
        ylabel(ax7,'Assets')
        title(ax7,'Low HC, Med/High Learn')
        mesh(ax8,wgrid,agrid,thate1(:,:,floor(Nh/2),5)');
        xlabel(ax8,'Wage')
        ylabel(ax8,'Assets')
        title(ax8,'Med HC, Med/High Learn')
        mesh(ax9,wgrid,agrid,thate1(:,:,Nh-1,5)');
        xlabel(ax9,'Wage')
        ylabel(ax9,'Assets')
        title(ax9,'High HC, Med/High Learn')
        mesh(ax10,wgrid,agrid,thate1(:,:,2,7)');
        xlabel(ax10,'Wage')
        ylabel(ax10, 'Assets')
        title(ax10,'Low HC, High Learn')
        mesh(ax11,wgrid,agrid,thate1(:,:,floor(Nh/2),7)');
        xlabel(ax11,'Wage')
        ylabel(ax11,'Assets')
        title(ax11,'Med HC, High Learn')
        mesh(ax12,wgrid,agrid,thate1(:,:,Nh-1,7)');
        xlabel(ax12,'Wage')
        ylabel(ax12,'Assets')
        title(ax12,'High HC, High Learn')
        figfile = fullfile(pwd,'/graphics/',strcat('LearningTime_', int2str(t), '.png'));
        saveas(f,figfile);
        close;
    end
    
    
    thetaaux  = interpn(wgrid.',agridt.',hgrid.',lgrid.',Theta,repmat(reshape(wprimee1,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,Epsnodes),reshape(hhate1,Nw,Na,Nh,Nl,1)),ub.h),lb.h),repmat(reshape(lmesh,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    thetaaux(thetaaux<0) = 0;
    thetaaux(isnan(thetaaux)) = 0;
    paux      = p(thetaaux);
    clear thetaaux;
    Jaux  = interpn(wgrid.',agridt.',hgrid.',lgrid.',J0,repmat(reshape(wmesh,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,Epsnodes),reshape(hhate1,Nw,Na,Nh,Nl,1)),ub.h),lb.h),repmat(reshape(lmesh,Nw,Na,Nh,Nl,1),1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    clear J0;
    J0 = bsxfun(@times,(1 - thate1),(1 - wmesh).*phi(hmesh,t)) + bbeta.*(1-ddelta).*squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,Epsnodes),(1-llambe.*paux).*Jaux),5));
    clear Jaux paux agridt;
    
    % Update Theta(v,a) 

    invq          = kkappa./(J0);
    Theta         = iq(J0);
    Theta(invq<0) = 0;
    Theta(invq>1) = 0;
    clear invq;
    
    % Update R(w,a) and Ru(w,a) - Returns to search

    % Unemployed Workers Ru(a)
    Ruaux     = RublObj(wugrid,wgrid,V,Vubl,Theta,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Ruaux,[],4);
    wprimeu1bl  = wugrid(pol);
    Rubl     = Val;
    clear Val pol Ruaux;
    if opts.gpu == 'y'
        for ib = 1:Nb
            Ruaux     = RubObj(wugrid,wgrid,V,squeeze(Vub(ib,:,:,:)),Theta,params,order,opts); % Value of Search and Optimal Search Policy
            [Val,pol] = max(Ruaux,[],4);
            wprimeu1b(ib,:,:,:)   = wugrid(pol);
            Rub(ib,:,:,:)       = Val;
            clear Val pol Ruaux;
        end
        for il=1:Nl
            for iw = 1:Nw
                Raux        = REObj(wwgrid(iw,:),wgrid,V(:,:,:,il),squeeze(V(iw,:,:,il)),Theta(:,:,:,il),params,order,opts); % Return of on the job search
                [Val,pol]   = max(Raux,[],3);
                wprimee1(iw,:,:,il)      = reshape(wwgrid(iw,pol(:)),Na,Nh);
                R(iw,:,:,il)           = Val;
                clear Val pol Ruaux;
            end
        end
    else
        parfor ib = 1:Nb
                Ruaux     = RubObj(wugrid,wgrid,V,squeeze(Vub(ib,:,:,:)),Theta,params,order,opts); % Value of Search and Optimal Search Policy
                [Val,pol] = max(Ruaux,[],4);
                wprimeu1b(ib,:,:,:)   = wugrid(pol);
                Rub(ib,:,:,:)       = Val;
        end
        clear Val pol Ruaux;
        parfor iw=1:Nw
            for il = 1:Nl
                Raux        = REObj(wwgrid(iw,:),wgrid,V(:,:,:,il),squeeze(V(iw,:,:,il)),Theta(:,:,:,il),params,order,opts); % Return of on the job search
                [Val,pol]   = max(Raux,[],3);
                wprimee1(iw,:,:,il)      = reshape(wwgrid(iw,pol(:)),Na,Nh);
                R(iw,:,:,il)           = Val;
            end
        end
        clear Val pol Ruaux;
    end
    
    if opts.concave_check == 'y'
        temp = 0;
        temp = sum(wprimeu1bl(2:end,:,:) - wprimeu1bl(1:end-1,:,:)<0,1);
        temp = sum(temp(:))
        if temp > 0
            err = 1
        end
    end
    

    if opts.save_diagplots == 'y' %This makes the code much slower.
        f = figure('name','SavingsRules');
        ax1 = subplot(4,4,1,'Parent',f);
        ax2 = subplot(4,4,2,'Parent',f);
        ax3 = subplot(4,4,3,'parent',f);
        ax4 = subplot(4,4,4,'Parent',f);
        ax5 = subplot(4,4,5,'Parent',f);
        ax6 = subplot(4,4,6,'Parent',f);
        ax7 = subplot(4,4,7,'parent',f);
        ax8 = subplot(4,4,8,'Parent',f);
        ax9 = subplot(4,4,9,'Parent',f);
        ax10 = subplot(4,4,10,'Parent',f);
        ax11 = subplot(4,4,11,'parent',f);
        ax12 = subplot(4,4,12,'Parent',f);
        ax13 = subplot(4,4,13,'Parent',f);
        ax14 = subplot(4,4,14,'Parent',f);
        ax15 = subplot(4,4,15,'parent',f);
        ax16 = subplot(4,4,16,'Parent',f);
        set(f,'PaperPosition',[0,0,24,24]);
        mesh(ax1,wgrid,agrid,wprimee1(:,:,2,1)');
        xlabel(ax1,'Wage')
        ylabel(ax1,'Assets')
        title(ax1,'Emp: Low HC, Low Learn')
        mesh(ax2,wgrid,agrid,wprimee1(:,:,Nh-1,Nl-1)');
        xlabel(ax2,'Wage')
        ylabel(ax2,'Assets')
        title(ax2,'Emp: High HC, High Learn')
        mesh(ax3,wgrid,agrid,wprimee1(:,:,Nh-1,1)');
        xlabel(ax3,'Wage')
        ylabel(ax3,'Assets')
        title(ax3,'Emp: High HC, Low Learn')
        mesh(ax4,wgrid,agrid,wprimee1(:,:,2,Nl-1)');
        xlabel(ax4,'Wage')
        ylabel(ax4,'Assets')
        title(ax4,'Emp: Low HC, High Learn')
        mesh(ax5,bgrid,agrid,squeeze(wprimeu1b(:,:,2,1))');
        xlabel(ax5,'Wage')
        ylabel(ax5,'Assets')
        title(ax5,'Unemp: Low HC, Low Learn')
        mesh(ax6,bgrid,agrid,squeeze(wprimeu1b(:,:,Nh-1,Nl-1))');
        xlabel(ax6,'Wage')
        ylabel(ax6,'Assets')
        title(ax6,'Unemp: High HC, High Learn')
        mesh(ax7,bgrid,agrid,squeeze(wprimeu1b(:,:,Nh-1,1))');
        xlabel(ax7,'Wage')
        ylabel(ax7,'Assets')
        title(ax7,'Unemp: High HC, Low Learn')
        mesh(ax8,bgrid,agrid,squeeze(wprimeu1b(:,:,2,Nl-1))');
        xlabel(ax8,'Wage')
        ylabel(ax8,'Assets')
        title(ax8,'Unemp: Low HC, High Learn')
        plot(ax9,agrid,squeeze(wprimeu1bl(:,2,1))');
        xlabel(ax9,'Assets')
        title(ax9,'Unemp: Low HC, Low Learn')
        plot(ax10,agrid,squeeze(wprimeu1bl(:,Nh-1,Nl-1))');
        xlabel(ax10,'Assets')
        title(ax10,'Unemp: High HC, High Learn')
        plot(ax11,agrid,squeeze(wprimeu1bl(:,Nh-1,1))');
        xlabel(ax11,'Assets')
        title(ax11,'Unemp: High HC, Low Learn')
        plot(ax12,agrid,squeeze(wprimeu1bl(:,2,Nl-1))');
        xlabel(ax12,'Assets')
        title(ax12,'Unemp: Low HC, High Learn')
        mesh(ax13,wgrid,agrid,squeeze(p(Theta(:,:,2,1)))');
        xlabel(ax13,'Wage')
        ylabel(ax13,'Assets')
        title(ax13,'Prob: Low HC, Low Learn')
        mesh(ax14,wgrid,agrid,squeeze(p(Theta(:,:,Nh-1,Nl-1)))');
        xlabel(ax14,'Wage')
        ylabel(ax14,'Assets')
        title(ax14,'Prob: High HC, High Learn')
        mesh(ax15,wgrid,agrid,squeeze(p(Theta(:,:,Nh-1,1)))');
        xlabel(ax15,'Wage')
        ylabel(ax15,'Assets')
        title(ax15,'Prob: High HC, Low Learn')
        mesh(ax16,wgrid,agrid,squeeze(p(Theta(:,:,2,Nl-1)))');
        xlabel(ax16,'Wage')
        ylabel(ax16,'Assets')
        title(ax16,'Prob: Low HC, High Learn')
        figfile = fullfile(pwd,'/graphics/',strcat('ApplicationRules_', int2str(t), '.png'));
        saveas(f,figfile);
        close;
    end
    

    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',t));
    save(matfile, 'wprimeu1b', 'wprimeu1bl', 'wprimee1', 'aprimeu1b', 'aprimeu1bl', 'aprimee1', 'agrid', 'wgrid', 'Theta', 'thate1', 'hhate1');
    clear agrid;
end
toc
end
