function ModelLBDEmpRisk(params, order, statNames, opts)
%% Model m-file for Wealth Effects, Search and Inequality
% 

reset(gpuDevice)

feature accel on

if ~isequal(exist(fullfile(pwd,opts.output_path),'dir'),7)
    mkdir(fullfile(pwd,opts.output_path));
end


%% Set Parameters Values

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

%% Grids

[J0,Theta,R,Rub,Rubl,V,wprimee1,aprimee1,thate1,hhate1,wprimeu1b,bgrid,wgrid,hgrid,lgrid,wugrid,wwgrid,ttgrid,dmesh,wmesh,hmesh,lmesh,xxigrid,Epsgrid,EpsPDF] = GridsEmpRisk(params, order, opts);

matfile = fullfile(pwd,'ProfilesCalc_Standard.mat');
load(matfile);

AveTau = nanmean(squeeze(modelProfilesFinal(1,find(strcmp(statNames, 'LearnTimeEmp')),:)));
if strcmpi(opts.test,'LBDDecompLearnDiffsEmpRisk')
    HHat = squeeze(max(min(interp1(ttgrid,permute(xxigrid,[3,1,2]),AveTau,'linear'),ub.h),lb.h));
else
    HumanCapProfile = squeeze(modelProfilesFinal(1,find(strcmp(statNames, 'LHumanCap')),:));
    DeltHC = (1 + nanmean(HumanCapProfile(2:end) - HumanCapProfile(1:end-1))).^(1/4)./exp(MuEps + (SigEps^2)./2);
    HHat = DeltHC.*hgrid;
end


if opts.ret == 'y'
    fprintf('period %1.1f\n',T+1)
    ca = 2;
    agrid  = gpuArray(linspace(0,ub.a.^(1/ca),Na).^ca);
    aagrid  = gpuArray(linspace(0,ub.a,na*na));
    chatRet = bsxfun(@minus,(1 + r).*reshape(agrid,Na,1) + bRet,reshape(aagrid,1,na*na));
    UhatRet = U(chatRet);
    UhatRet(chatRet<=0) = -realmax./T;
    clear chatRet;
    VRet = zeros(Na,1);
    VRet1 = zeros(Na,1);
    aprime1ret = zeros(Na,1);
    abserr = 100;
    while abserr > errtol
        Valaux = RetObj(aagrid,agrid,UhatRet,VRet,params,order,opts);
        [VRet1,pol] = max(Valaux,[],2);
        aprime1ret = aagrid(pol);
        abserr = max(abs([VRet1-VRet]));
        VRet = VRet1;
        clear VRet1 Valaux pol;
    end
    Rubl = (exitProb.*Rubl + (1 - exitProb).*repmat(reshape(VRet,1,Na,1,1),Nd,1,Nh,Nl));
    Rub = (exitProb.*Rub + (1 - exitProb).*repmat(reshape(VRet,1,1,Na,1,1),Nd,Nb,1,Nh,Nl));
    R = (exitProb.*R + (1 - exitProb).*repmat(reshape(VRet,1,1,Na,1,1),Nd,Nw,1,Nh,Nl));
    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',T+1));
    save(matfile, 'aprime1ret');
    clear UhatRet VRet aprime1ret;
end

idl       = find(speye(Nl,Nl));
idh       = find(speye(Nh,Nh));

err = 0
%% Solve for the Value Functions
tic
for t = T:-1:0
    err = 0;
    fprintf('period %1.1f\n',t)
    [agrid, agridt, aagrid, Uhatb, Uhatbl, Uhate, UIIncEmp] = UpdateGridsLBD(t, params, order, bgrid, hgrid, wgrid, AveTau, opts);
    % Update consumption and savings Bellman Equations Vubl, Vub, V
    % Unemployed Workers Vu(a)
    Rbl       = permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1),interp1(hgrid.',permute(Rubl,[3,1,2,4]),max(min(bsxfun(@times,exp(Epsgrid),hgrid),ub.h),lb.h).','linear')),2)),[3,2,1,4]);
    Valaux    = UblObjEmpRisk(aagrid,agridt,Uhatbl,Rbl,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],5);
    aprimeu1bl  = aagrid(pol);
    Vubl      = Val;
    clear Val pol Valaux Uhatbl;
    Rb        = permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',permute(Rub,[4,1,2,3,5]),max(min(bsxfun(@times,exp(Epsgrid),hgrid),ub.h),lb.h).','linear')),2)),[4,2,3,1,5]);
    Valaux    = UbObjEmpRisk(aagrid,agridt,Uhatb,Rb,Rbl,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],6);
    aprimeu1b   = aagrid(pol);
    Vub       = Val;
    clear Val pol Rbl Valaux Uhatb Rb;
    if strcmpi(opts.test,'LBDDecompLearnDiffsEmpRisk')
        Rb        = reshape(permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',permute(Rub,[4,1,2,3,5]),max(min(bsxfun(@times,exp(Epsgrid).',reshape(HHat,Nh,1,Nl)),ub.h),lb.h),'linear')),2)),[1,3,4,5,2,6]),Nh,Nd,Nb,Na,Nl*Nl);
        Rb        = Rb(:,:,:,:,idl);
        Rb        = permute(Rb,[2,3,4,1,5]);
        Rw        = reshape(permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',permute(R,[4,1,2,3,5]),max(min(bsxfun(@times,exp(Epsgrid).',reshape(HHat,Nh,1,Nl)),ub.h),lb.h),'linear')),2)),[1,3,4,5,2,6]),Nh,Nd,Nw,Na,Nl*Nl);
        Rw        = Rw(:,:,:,:,idl);
        Rw        = permute(Rw,[2,3,4,1,5]);
    else
        % Rb        = reshape(permute(interp1(hgrid.',permute(Rub,[3,1,2,4]),HHat),[1,3,4,2,5]),Nh,Nb,Na,Nl*Nl);
        % Rb        = Rb(:,:,:,idl);
        Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',permute(Rub,[4,1,2,3,5]),max(min(bsxfun(@times,exp(Epsgrid),HHat),ub.h),lb.h).','linear')),2));
        Rb        = permute(Rb,[2,3,4,1,5]);
        Rw        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',permute(R,[4,1,2,3,5]),max(min(bsxfun(@times,exp(Epsgrid),HHat),ub.h),lb.h).','linear')),2));
        Rw        = permute(Rw,[2,3,4,1,5]);

        % Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1),interp1(hgrid.',permute(Rub,[3,1,2,4]),max(min(bsxfun(@times,exp(Epsgrid),DeltHC.*hgrid),ub.h),lb.h).','linear')),2));
        % Rb        = permute(Rb,[2,3,1,4]);
        % Rw        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1),interpn(hgrid.',permute(R,[3,1,2,4]),max(min(bsxfun(@times,exp(Epsgrid),DeltHC.*hgrid),ub.h),lb.h).','linear')),2));
        % Rw        = permute(Rw,[2,3,1,4]);
        % for il = 1:Nl
        %     Rb(:,:,:,il) = permute(interp1(hgrid.',squeeze(Rb(:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',HHat(:,il,:)),ub.h),lb.h),'linear'),[1,4,5,2,3]);
        %     Rw(:,:,:,il) = permute(interp1(hgrid.',squeeze(Rw(:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',HHat(:,il,:)),ub.h),lb.h),'linear'),[1,4,5,2,3]);
        % end

    end
    Rb        = reshape(permute(interp1(bgrid,permute(Rb,[2,1,3,4,5]),UIIncEmp,'linear'),[1,3,4,6,2,5]),Nw,Nd,Na,Nl,Nh*Nh);
    Rb        = permute(Rb(:,:,:,:,idh),[2,1,3,5,4]);
    Valaux    = WObjLBDEmpRisk(aagrid,agridt,Uhate,Rw,Rb,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],6);
    aprimee1  = aagrid(pol);
    V         = Val;
    clear Val pol Rw Valaux Uhatb Rb;


    % Rb = repmat(permute(Rub,[4,1,2,3,5]),1,1,1,1,1,nt);
    % Rw = repmat(permute(R,[4,1,2,3,5]),1,1,1,1,1,nt);
    % for il = 1:Nl
    %     Rb(:,:,:,:,il,:,:) = permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',squeeze(Rb(:,:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear')),2)),[1,3,4,5,2]);
    %     Rw(:,:,:,:,il,:,:) = permute(squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1,1,1),interp1(hgrid.',squeeze(Rw(:,:,:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear')),2)),[1,3,4,5,2]);
    % end
    % % Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,Epsnodes,1),Rb),5));
    % Rb        = permute(Rb,[2,3,4,1,5,6]);
    % % Rw        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,Epsnodes,1),Rw),5));
    % Rw        = permute(Rw,[2,3,4,1,5,6]);
    % if opts.gpu == 'y'
    %     for id = 1:Nd
    %         for ih = 1:Nh
    %             for iw = 1:Nw
    %                 Valaux       = WObjEmpRisk(aagrid,agridt,bgrid,wgrid(iw).*chatemp1(ih,:),chatemp2,squeeze(Rw(id,iw,:,ih,:,:)),squeeze(Rb(id,:,:,ih,:,:)),ddelta(id),params,order,opts); % Value of being Employed
    %                 Valaux       = reshape(Valaux,Na,Nl,na*nt);       
    %                 [Val,pol]    = max(Valaux,[],3);
    %                 [pola,polt]  = ind2sub([na nt],pol);
    %                 aprimee1(id,iw,:,ih,:)       = aagrid(pola);
    %                 thate1(id,iw,:,ih,:)       = ttgrid(polt);
    %                 temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
    %                 hhate1(id,iw,:,ih,:)       = temp(:,idl);
    %                 V(id,iw,:,ih,:)            = Val;
    %                 clear Val pol pola polt temp Valaux;
    %             end
    %         end
    %     end
    % else
    %     parfor id = 1:Nd
    %         for ih = 1:Nh
    %             for iw = 1:Nw
    %                 Valaux       = WObjEmpRisk(aagrid,agridt,bgrid,wgrid(iw).*chatemp1(ih,:),chatemp2,squeeze(Rw(id,iw,:,ih,:,:)),squeeze(Rb(id,:,:,ih,:,:)),params,order,opts); % Value of being Employed
    %                 Valaux       = reshape(Valaux,Na,Nl,na*nt);       
    %                 [Val,pol]    = max(Valaux,[],3);
    %                 [pola,polt]  = ind2sub([na nt],pol);
    %                 aprimee1(id,iw,:,ih,:)       = aagrid(pola);
    %                 thate1(id,iw,:,ih,:)       = ttgrid(polt);
    %                 temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
    %                 hhate1(id,iw,:,ih,:)       = temp(:,idl);
    %                 V(id,iw,:,ih,:)            = Val;
    %             end
    %         end
    %     end
    %     clear Val pol pola polt temp Valaux;
    % end
    clear Rb Rw aagrid chatemp1 chatemp2;
    set(0,'defaultFigureVisible','off');
    if opts.save_diagplots == 'y' %This makes the code much slower.
        f = figure('name','SavingsRules');
        ax1 = subplot(4,3,1,'Parent',f);
        ax2 = subplot(4,3,2,'Parent',f);
        ax3 = subplot(4,3,3,'parent',f);
        ax4 = subplot(4,3,4,'Parent',f);
        ax5 = subplot(4,3,5,'Parent',f);
        ax6 = subplot(4,3,6,'Parent',f);
        ax7 = subplot(4,3,7,'parent',f);
        ax8 = subplot(4,3,8,'Parent',f);
        ax9 = subplot(4,3,9,'Parent',f);
        ax10 = subplot(4,3,10,'Parent',f);
        ax11 = subplot(4,3,11,'parent',f);
        ax12 = subplot(4,3,12,'Parent',f);
        set(f,'PaperPosition',[0,0,20,18]);
        for id = 1:3:Nd
            mesh(ax1,wgrid,agrid,squeeze(aprimee1(id,:,:,2,1))');
            xlabel(ax1,'Wage')
            ylabel(ax1,'Assets')
            title(ax1,'Emp: Low HC, Low Learn')
            mesh(ax2,wgrid,agrid,squeeze(aprimee1(id,:,:,Nh-1,Nl-1))');
            xlabel(ax2,'Wage')
            ylabel(ax2,'Assets')
            title(ax2,'Emp: High HC, High Learn')
            mesh(ax3,wgrid,agrid,squeeze(aprimee1(id,:,:,Nh-1,1))');
            xlabel(ax3,'Wage')
            ylabel(ax3,'Assets')
            title(ax3,'Emp: High HC, Low Learn')
            mesh(ax4,wgrid,agrid,squeeze(aprimee1(id,:,:,2,Nl-1))');
            xlabel(ax4,'Wage')
            ylabel(ax4,'Assets')
            title(ax4,'Emp: Low HC, High Learn')
            mesh(ax5,bgrid,agrid,squeeze(aprimeu1b(id,:,:,2,1))');
            xlabel(ax5,'Wage')
            ylabel(ax5,'Assets')
            title(ax5,'Unemp: Low HC, Low Learn')
            mesh(ax6,bgrid,agrid,squeeze(aprimeu1b(id,:,:,Nh-1,Nl-1))');
            xlabel(ax6,'Wage')
            ylabel(ax6,'Assets')
            title(ax6,'Unemp: High HC, High Learn')
            mesh(ax7,bgrid,agrid,squeeze(aprimeu1b(id,:,:,Nh-1,1))');
            xlabel(ax7,'Wage')
            ylabel(ax7,'Assets')
            title(ax7,'Unemp: High HC, Low Learn')
            mesh(ax8,bgrid,agrid,squeeze(aprimeu1b(id,:,:,2,Nl-1))');
            xlabel(ax8,'Wage')
            ylabel(ax8,'Assets')
            title(ax8,'Unemp: Low HC, High Learn')
            plot(ax9,agrid,squeeze(aprimeu1bl(id,:,2,1))');
            xlabel(ax9,'Assets')
            title(ax9,'Unemp: Low HC, Low Learn')
            plot(ax10,agrid,squeeze(aprimeu1bl(id,:,Nh-1,Nl-1))');
            xlabel(ax10,'Assets')
            title(ax10,'Unemp: High HC, High Learn')
            plot(ax11,agrid,squeeze(aprimeu1bl(id,:,Nh-1,1))');
            xlabel(ax11,'Assets')
            title(ax11,'Unemp: High HC, Low Learn')
            plot(ax12,agrid,squeeze(aprimeu1bl(id,:,2,Nl-1))');
            xlabel(ax12,'Assets')
            title(ax12,'Unemp: Low HC, High Learn')
            figfile = fullfile(pwd,'/graphics/LBDEmpRisk/',strcat('SavingRules_', int2str(t), '_', int2str(id), '.png'));
            saveas(f,figfile);
        end
        close;

        f = figure('name','InvestmentRules');
        ax1 = subplot(3,4,1,'Parent',f);
        ax2 = subplot(3,4,2,'Parent',f);
        ax3 = subplot(3,4,3,'parent',f);
        ax4 = subplot(3,4,4,'Parent',f);
        ax5 = subplot(3,4,5,'Parent',f);
        ax6 = subplot(3,4,6,'Parent',f);
        ax7 = subplot(3,4,7,'parent',f);
        ax8 = subplot(3,4,8,'Parent',f);
        ax9 = subplot(3,4,9,'Parent',f);
        ax10 = subplot(3,4,10,'Parent',f);
        ax11 = subplot(3,4,11,'parent',f);
        ax12 = subplot(3,4,12,'Parent',f);
        set(f,'PaperPosition',[0,0,18,20]);        
        for id = 1:3:Nd
            mesh(ax1,wgrid,agrid,squeeze(thate1(id,:,:,2,1))');
            xlabel(ax1,'Wage')
            ylabel(ax1,'Assets')
            title(ax1,'Low HC, Low Learn')
            mesh(ax2,wgrid,agrid,squeeze(thate1(id,:,:,floor(Nh/2),1))');
            xlabel(ax2,'Wage')
            ylabel(ax2, 'Assets') 
            title(ax2,'Med HC, Low Learn')
            mesh(ax3,wgrid,agrid,squeeze(thate1(id,:,:,Nh-1,1))');
            xlabel(ax3,'Wage')
            ylabel(ax3,'Assets')
            title(ax3,'High HC, Low Learn')
            mesh(ax4,wgrid,agrid,squeeze(thate1(id,:,:,2,3))');
            xlabel(ax4,'Wage')
            ylabel(ax4,'Assets')
            title(ax4,'Low HC, Low/Med Learn')
            mesh(ax5,wgrid,agrid,squeeze(thate1(id,:,:,floor(Nh/2),3))');
            xlabel(ax5,'Wage')
            ylabel(ax5,'Assets')
            title(ax5,'Med HC, Low/Med Learn')
            mesh(ax6,wgrid,agrid,squeeze(thate1(id,:,:,Nh-1,3))');
            xlabel(ax6,'Wage')
            ylabel(ax6,'Assets')
            title(ax6,'High HC, Low/Med Learn')
            mesh(ax7,wgrid,agrid,squeeze(thate1(id,:,:,2,5))');
            xlabel(ax7,'Wage')
            ylabel(ax7,'Assets')
            title(ax7,'Low HC, Med/High Learn')
            mesh(ax8,wgrid,agrid,squeeze(thate1(id,:,:,floor(Nh/2),5))');
            xlabel(ax8,'Wage')
            ylabel(ax8,'Assets')
            title(ax8,'Med HC, Med/High Learn')
            mesh(ax9,wgrid,agrid,squeeze(thate1(id,:,:,Nh-1,5))');
            xlabel(ax9,'Wage')
            ylabel(ax9,'Assets')
            title(ax9,'High HC, Med/High Learn')
            mesh(ax10,wgrid,agrid,squeeze(thate1(id,:,:,2,7))');
            xlabel(ax10,'Wage')
            ylabel(ax10, 'Assets')
            title(ax10,'Low HC, High Learn')
            mesh(ax11,wgrid,agrid,squeeze(thate1(id,:,:,floor(Nh/2),7))');
            xlabel(ax11,'Wage')
            ylabel(ax11,'Assets')
            title(ax11,'Med HC, High Learn')
            mesh(ax12,wgrid,agrid,squeeze(thate1(id,:,:,Nh-1,7))');
            xlabel(ax12,'Wage')
            ylabel(ax12,'Assets')
            title(ax12,'High HC, High Learn')
            figfile = fullfile(pwd,'/graphics/LBDEmpRisk/',strcat('LearningTime_', int2str(t), '_', int2str(id), '.png'));
            saveas(f,figfile);
        end
        close;
    end

    if strcmpi(opts.test,'LBDDecompLearnDiffsEmpRisk')
        thetaaux  = interpn(ddelta.',wgrid.',agridt.',hgrid.',lgrid.',Theta,repmat(reshape(dmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(wprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,1,Epsnodes),repmat(reshape(HHat,1,1,1,Nh,Nl,1),Nd,Nw,Na,1,1,1)),ub.h),lb.h),repmat(reshape(lmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    else
        thetaaux  = interpn(ddelta.',wgrid.',agridt.',hgrid.',lgrid.',Theta,repmat(reshape(dmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(wprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,1,Epsnodes),repmat(reshape(HHat,1,1,1,Nh,1,1),Nd,Nw,Na,1,Nl,1)),ub.h),lb.h),repmat(reshape(lmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    end
    thetaaux(thetaaux<0) = 0;
    thetaaux(isnan(thetaaux)) = 0;
    paux      = p(thetaaux);
    clear thetaaux;
    if strcmpi(opts.test,'LBDDecompLearnDiffsEmpRisk')
        Jaux  = interpn(ddelta.',wgrid.',agridt.',hgrid.',lgrid.',J0,repmat(reshape(dmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(wmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,1,Epsnodes),repmat(reshape(HHat,1,1,1,Nh,Nl,1),Nd,Nw,Na,1,1,1)),ub.h),lb.h),repmat(reshape(lmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    else
        Jaux  = interpn(ddelta.',wgrid.',agridt.',hgrid.',lgrid.',J0,repmat(reshape(dmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(wmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),repmat(reshape(aprimee1,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),max(min(bsxfun(@times,reshape(exp(Epsgrid),1,1,1,1,1,Epsnodes),repmat(reshape(HHat,1,1,1,Nh,1,1),Nd,Nw,Na,1,Nl,1)),ub.h),lb.h),repmat(reshape(lmesh,Nd,Nw,Na,Nh,Nl,1),1,1,1,1,1,Epsnodes),'linear'); % Interpolated tightness at (wprime,aprime)
    end
    clear J0;
    J0 = bsxfun(@times,(1 - AveTau),(1 - wmesh).*phi(hmesh,t)) + bbeta.*bsxfun(@times,reshape((1-ddelta),Nd,1,1,1,1),squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,1,1,Epsnodes),(1-llambe.*paux).*Jaux),6)));
    clear Jaux paux agridt;
    
    % Update Theta(v,a) 

    invq          = kkappa./(J0);
    Theta         = iq(J0);
    Theta(invq<0) = 0;
    Theta(invq>1) = 0;
    clear invq;
    
    % Update R(w,a) and Ru(w,a) - Returns to search

    % Unemployed Workers Ru(a)
    Ruaux     = RublObjEmpRisk(wugrid,wgrid,V,Vubl,Theta,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Ruaux,[],5);
    wprimeu1bl  = wugrid(pol);
    Rubl     = Val;
    clear Val pol Ruaux;
    if opts.gpu == 'y'
        for ib = 1:Nb
            Ruaux     = RubObjEmpRisk(wugrid,wgrid,V,squeeze(Vub(:,ib,:,:,:)),Theta,params,order,opts); % Value of Search and Optimal Search Policy
            [Val,pol] = max(Ruaux,[],5);
            wprimeu1b(:,ib,:,:,:)   = wugrid(pol);
            Rub(:,ib,:,:,:)       = Val;
            clear Val pol Ruaux;
        end
        for il=1:Nl
            for iw = 1:Nw
                Raux        = REObjEmpRisk(wwgrid(iw,:),wgrid,V(:,:,:,:,il),squeeze(V(:,iw,:,:,il)),Theta(:,:,:,:,il),params,order,opts); % Return of on the job search
                [Val,pol]   = max(Raux,[],4);
                wprimee1(:,iw,:,:,il)      = reshape(wwgrid(iw,pol(:)),Nd,Na,Nh);
                R(:,iw,:,:,il)           = Val;
                clear Val pol Ruaux;
            end
        end
    else
        parfor ib = 1:Nb
            Ruaux     = RubObjEmpRisk(wugrid,wgrid,V,squeeze(Vub(:,ib,:,:,:)),Theta,params,order,opts); % Value of Search and Optimal Search Policy
            [Val,pol] = max(Ruaux,[],5);
            wprimeu1b(:,ib,:,:,:)   = wugrid(pol);
            Rub(:,ib,:,:,:)       = Val;
            clear Val pol Ruaux;
        end
        clear Val pol Ruaux;
        parfor iw=1:Nw
            for il = 1:Nl
                Raux        = REObjEmpRisk(wwgrid(iw,:),wgrid,V(:,:,:,:,il),squeeze(V(:,iw,:,:,il)),Theta(:,:,:,:,il),params,order,opts); % Return of on the job search
                [Val,pol]   = max(Raux,[],4);
                wprimee1(:,iw,:,:,il)      = reshape(wwgrid(iw,pol(:)),Nd,Na,Nh);
                R(:,iw,:,:,il)           = Val;
                clear Val pol Ruaux;
            end
        end
        clear Val pol Ruaux;
    end
    
    if opts.concave_check == 'y'
        temp = 0;
        temp = sum(wprimeu1bl(2:end,:,:) - wprimeu1bl(1:end-1,:,:)<0,1);
        temp = sum(temp(:))
        if temp > 0
            err = 1
        end
    end
    

    if opts.save_diagplots == 'y' %This makes the code much slower.
        f = figure('name','SavingsRules');
        ax1 = subplot(4,4,1,'Parent',f);
        ax2 = subplot(4,4,2,'Parent',f);
        ax3 = subplot(4,4,3,'parent',f);
        ax4 = subplot(4,4,4,'Parent',f);
        ax5 = subplot(4,4,5,'Parent',f);
        ax6 = subplot(4,4,6,'Parent',f);
        ax7 = subplot(4,4,7,'parent',f);
        ax8 = subplot(4,4,8,'Parent',f);
        ax9 = subplot(4,4,9,'Parent',f);
        ax10 = subplot(4,4,10,'Parent',f);
        ax11 = subplot(4,4,11,'parent',f);
        ax12 = subplot(4,4,12,'Parent',f);
        ax13 = subplot(4,4,13,'Parent',f);
        ax14 = subplot(4,4,14,'Parent',f);
        ax15 = subplot(4,4,15,'parent',f);
        ax16 = subplot(4,4,16,'Parent',f);
        set(f,'PaperPosition',[0,0,24,24]);
        for id = 1:3:Nd
            mesh(ax1,wgrid,agrid,squeeze(wprimee1(id,:,:,2,1))');
            xlabel(ax1,'Wage')
            ylabel(ax1,'Assets')
            title(ax1,'Emp: Low HC, Low Learn')
            mesh(ax2,wgrid,agrid,squeeze(wprimee1(id,:,:,Nh-1,Nl-1))');
            xlabel(ax2,'Wage')
            ylabel(ax2,'Assets')
            title(ax2,'Emp: High HC, High Learn')
            mesh(ax3,wgrid,agrid,squeeze(wprimee1(id,:,:,Nh-1,1))');
            xlabel(ax3,'Wage')
            ylabel(ax3,'Assets')
            title(ax3,'Emp: High HC, Low Learn')
            mesh(ax4,wgrid,agrid,squeeze(wprimee1(id,:,:,2,Nl-1))');
            xlabel(ax4,'Wage')
            ylabel(ax4,'Assets')
            title(ax4,'Emp: Low HC, High Learn')
            mesh(ax5,bgrid,agrid,squeeze(wprimeu1b(id,:,:,2,1))');
            xlabel(ax5,'UI (Norm)')
            ylabel(ax5,'Assets')
            title(ax5,'Unemp: Low HC, Low Learn')
            mesh(ax6,bgrid,agrid,squeeze(wprimeu1b(id,:,:,Nh-1,Nl-1))');
            xlabel(ax6,'UI (Norm)')
            ylabel(ax6,'Assets')
            title(ax6,'Unemp: High HC, High Learn')
            mesh(ax7,bgrid,agrid,squeeze(wprimeu1b(id,:,:,Nh-1,1))');
            xlabel(ax7,'UI (Norm)')
            ylabel(ax7,'Assets')
            title(ax7,'Unemp: High HC, Low Learn')
            mesh(ax8,bgrid,agrid,squeeze(wprimeu1b(id,:,:,2,Nl-1))');
            xlabel(ax8,'UI (Norm)')
            ylabel(ax8,'Assets')
            title(ax8,'Unemp: Low HC, High Learn')
            plot(ax9,agrid,squeeze(wprimeu1bl(id,:,2,1))');
            xlabel(ax9,'Assets')
            title(ax9,'Unemp: Low HC, Low Learn')
            plot(ax10,agrid,squeeze(wprimeu1bl(id,:,Nh-1,Nl-1))');
            xlabel(ax10,'Assets')
            title(ax10,'Unemp: High HC, High Learn')
            plot(ax11,agrid,squeeze(wprimeu1bl(id,:,Nh-1,1))');
            xlabel(ax11,'Assets')
            title(ax11,'Unemp: High HC, Low Learn')
            plot(ax12,agrid,squeeze(wprimeu1bl(id,:,2,Nl-1))');
            xlabel(ax12,'Assets')
            title(ax12,'Unemp: Low HC, High Learn')
            mesh(ax13,wgrid,agrid,squeeze(p(Theta(id,:,:,2,1)))');
            xlabel(ax13,'Wage')
            ylabel(ax13,'Assets')
            title(ax13,'Prob: Low HC, Low Learn')
            mesh(ax14,wgrid,agrid,squeeze(p(Theta(id,:,:,Nh-1,Nl-1)))');
            xlabel(ax14,'Wage')
            ylabel(ax14,'Assets')
            title(ax14,'Prob: High HC, High Learn')
            mesh(ax15,wgrid,agrid,squeeze(p(Theta(id,:,:,Nh-1,1)))');
            xlabel(ax15,'Wage')
            ylabel(ax15,'Assets')
            title(ax15,'Prob: High HC, Low Learn')
            mesh(ax16,wgrid,agrid,squeeze(p(Theta(id,:,:,2,Nl-1)))');
            xlabel(ax16,'Wage')
            ylabel(ax16,'Assets')
            title(ax16,'Prob: Low HC, High Learn')
            figfile = fullfile(pwd,'/graphics/LBDEmpRisk/',strcat('ApplicationRules_', int2str(t), '_', int2str(id), '.png'));
            saveas(f,figfile);
        end
        close;
    end

    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',t));
    save(matfile, 'wprimeu1b', 'wprimeu1bl', 'wprimee1', 'aprimeu1b', 'aprimeu1bl', 'aprimee1', 'agrid', 'wgrid', 'Theta', 'thate1', 'hhate1');
    clear agrid;
end
toc
end
