function ModelNoSearch(params, order, opts)
%% Model m-file for Wealth Effects, Search and Inequality
% 

reset(gpuDevice)

feature accel on

if ~isequal(exist(fullfile(pwd,opts.output_path),'dir'),7)
    mkdir(fullfile(pwd,opts.output_path));
end


%% Set Parameters Values

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

%% Grids

[J0,Theta,R,Rub,V,aprimee1,thate1,hhate1,hgrid,lgrid,ttgrid,hmesh,lmesh,xxigrid,Epsgrid,EpsPDF] = GridsNoSearch(params, order, opts);

if opts.ret == 'y'
    fprintf('period %1.1f\n',T+1)
    ca = 2;
    agrid  = gpuArray(linspace(0,ub.a.^(1/ca),Na).^ca);
    aagrid  = gpuArray(linspace(0,ub.a,na*na));
    chatRet = bsxfun(@minus,(1 + r).*reshape(agrid,Na,1) + bRet,reshape(aagrid,1,na*na));
    UhatRet = U(chatRet);
    UhatRet(chatRet<=0) = -realmax./T;
    clear chatRet;
    VRet = zeros(Na,1);
    VRet1 = zeros(Na,1);
    aprime1ret = zeros(Na,1);
    abserr = 100;
    while abserr > errtol
        Valaux = RetObj(aagrid,agrid,UhatRet,VRet,params,order,opts);
        [VRet1,pol] = max(Valaux,[],2);
        aprime1ret = aagrid(pol);
        abserr = max(abs([VRet1-VRet]));
        VRet = VRet1;
        clear VRet1 Valaux pol;
    end
    Rub = (exitProb.*Rub + (1 - exitProb).*repmat(reshape(VRet,Na,1,1),1,Nh,Nl));
    R = (exitProb.*R + (1 - exitProb).*repmat(reshape(VRet,Na,1,1),1,Nh,Nl));
    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',T+1));
    save(matfile, 'aprime1ret');
    clear UhatRet VRet aprime1ret;
end

idl       = find(speye(Nl,Nl));

err = 0
%% Solve for the Value Functions
tic
for t = T:-1:0
    err = 0;
    fprintf('period %1.1f\n',t)
    [agrid, agridt, aagrid, Uhatb, chatemp1, chatemp2] = UpdateGridsNoSearch(t, params, order, hgrid, ttgrid, opts);
    % Update consumption and savings Bellman Equations Vubl, Vub, V
    % Unemployed Workers Vu(a)
    Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,Epsnodes,1,1),interp1(hgrid.',permute(Rub,[2,1,3]),max(min(bsxfun(@times,exp(Epsgrid),hgrid),ub.h),lb.h).','linear')),2));
    Rb        = permute(Rb,[2,1,3]);
    Valaux    = UbObjNoSearch(aagrid,agridt,Uhatb,R,Rb,params,order,opts); % Value of Search and Optimal Search Policy
    [Val,pol] = max(Valaux,[],4);
    aprimeu1b   = aagrid(pol);
    Vub       = Val;
    clear Val pol Rbl Valaux Uhatb Rb;
    Rb = repmat(permute(Rub,[2,1,3]),1,1,1,Epsnodes,nt);
    Rw = repmat(permute(R,[2,1,3]),1,1,1,Epsnodes,nt);
    for il = 1:Nl
        Rb(:,:,il,:,:) = permute(interp1(hgrid.',squeeze(Rb(:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear'),[1,4,2,3]);
        Rw(:,:,il,:,:) = permute(interp1(hgrid.',squeeze(Rw(:,:,il)),max(min(bsxfun(@times,exp(Epsgrid).',xxigrid(:,il,:)),ub.h),lb.h),'linear'),[1,4,2,3]);
    end
    Rw        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,Epsnodes,1),Rw),4));
    Rw        = permute(Rw,[2,1,3,4]);
    Rb        = squeeze(sum(bsxfun(@times,reshape(EpsPDF,1,1,1,Epsnodes,1),Rb),4));
    Rb        = permute(Rb,[2,1,3,4]);
    if opts.gpu == 'y'
        for ih = 1:Nh
            Valaux       = WObjNoSearch(aagrid,agridt,chatemp1(ih,:),chatemp2,squeeze(Rw(:,ih,:,:)),squeeze(Rb(:,ih,:,:)),params,order,opts); % Value of being Employed
            Valaux       = reshape(Valaux,Na,Nl,na*nt);
            [Val,pol]    = max(Valaux,[],3);
            [pola,polt]  = ind2sub([na nt],pol);
            aprimee1(:,ih,:)       = aagrid(pola);
            thate1(:,ih,:)       = ttgrid(polt);
            temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
            hhate1(:,ih,:)       = temp(:,idl);
            V(:,ih,:)            = Val;
            clear Val pol pola polt temp Valaux;
        end
    else
        parfor ih = 1:Nh
            Valaux       = WObjNoSearch(aagrid,agridt,chatemp1(ih,:),chatemp2,squeeze(Rw(:,ih,:,:)),squeeze(Rb(:,ih,:,:)),params,order,opts); % Value of being Employed
            Valaux       = reshape(Valaux,Na,Nl,na*nt);
            [Val,pol]    = max(Valaux,[],3);
            [pola,polt]  = ind2sub([na nt],pol);
            aprimee1(:,ih,:)       = aagrid(pola);
            thate1(:,ih,:)       = ttgrid(polt);
            temp                    = reshape(xxigrid(ih,:,polt.'),Nl*Nl,Na).';
            hhate1(:,ih,:)       = temp(:,idl);
            V(:,ih,:)            = Val;
            clear Val pol pola polt temp Valaux;
        end
        clear Val pol pola polt temp Valaux;
    end
    clear Rb Rw aagrid chatemp1 chatemp2;
    set(0,'defaultFigureVisible','off');
    if opts.save_diagplots == 'y' %This makes the code much slower.
        f = figure('name','SavingsRules');
        ax1 = subplot(4,3,1,'Parent',f);
        ax2 = subplot(4,3,2,'Parent',f);
        ax3 = subplot(4,3,3,'parent',f);
        ax4 = subplot(4,3,4,'Parent',f);
        ax5 = subplot(4,3,5,'Parent',f);
        ax6 = subplot(4,3,6,'Parent',f);
        ax7 = subplot(4,3,7,'parent',f);
        ax8 = subplot(4,3,8,'Parent',f);
        ax9 = subplot(4,3,9,'Parent',f);
        ax10 = subplot(4,3,10,'Parent',f);
        ax11 = subplot(4,3,11,'parent',f);
        ax12 = subplot(4,3,12,'Parent',f);
        set(f,'PaperPosition',[0,0,20,18]);
        mesh(ax1,wgrid,agrid,aprimee1(:,:,2,1)');
        xlabel(ax1,'Wage')
        ylabel(ax1,'Assets')
        title(ax1,'Emp: Low HC, Low Learn')
        mesh(ax2,wgrid,agrid,aprimee1(:,:,Nh-1,Nl-1)');
        xlabel(ax2,'Wage')
        ylabel(ax2,'Assets')
        title(ax2,'Emp: High HC, High Learn')
        mesh(ax3,wgrid,agrid,aprimee1(:,:,Nh-1,1)');
        xlabel(ax3,'Wage')
        ylabel(ax3,'Assets')
        title(ax3,'Emp: High HC, Low Learn')
        mesh(ax4,wgrid,agrid,aprimee1(:,:,2,Nl-1)');
        xlabel(ax4,'Wage')
        ylabel(ax4,'Assets')
        title(ax4,'Emp: Low HC, High Learn')
        mesh(ax5,bgrid,agrid,squeeze(aprimeu1b(:,:,2,1))');
        xlabel(ax5,'Wage')
        ylabel(ax5,'Assets')
        title(ax5,'Unemp: Low HC, Low Learn')
        mesh(ax6,bgrid,agrid,squeeze(aprimeu1b(:,:,Nh-1,Nl-1))');
        xlabel(ax6,'Wage')
        ylabel(ax6,'Assets')
        title(ax6,'Unemp: High HC, High Learn')
        mesh(ax7,bgrid,agrid,squeeze(aprimeu1b(:,:,Nh-1,1))');
        xlabel(ax7,'Wage')
        ylabel(ax7,'Assets')
        title(ax7,'Unemp: High HC, Low Learn')
        mesh(ax8,bgrid,agrid,squeeze(aprimeu1b(:,:,2,Nl-1))');
        xlabel(ax8,'Wage')
        ylabel(ax8,'Assets')
        title(ax8,'Unemp: Low HC, High Learn')
        plot(ax9,agrid,squeeze(aprimeu1bl(:,2,1))');
        xlabel(ax9,'Assets')
        title(ax9,'Unemp: Low HC, Low Learn')
        plot(ax10,agrid,squeeze(aprimeu1bl(:,Nh-1,Nl-1))');
        xlabel(ax10,'Assets')
        title(ax10,'Unemp: High HC, High Learn')
        plot(ax11,agrid,squeeze(aprimeu1bl(:,Nh-1,1))');
        xlabel(ax11,'Assets')
        title(ax11,'Unemp: High HC, Low Learn')
        plot(ax12,agrid,squeeze(aprimeu1bl(:,2,Nl-1))');
        xlabel(ax12,'Assets')
        title(ax12,'Unemp: Low HC, High Learn')
        figfile = fullfile(pwd,'/graphics/',strcat('SavingRules_', int2str(t), '.png'));
        saveas(f,figfile);
        close;

        f = figure('name','InvestmentRules');
        ax1 = subplot(3,4,1,'Parent',f);
        ax2 = subplot(3,4,2,'Parent',f);
        ax3 = subplot(3,4,3,'parent',f);
        ax4 = subplot(3,4,4,'Parent',f);
        ax5 = subplot(3,4,5,'Parent',f);
        ax6 = subplot(3,4,6,'Parent',f);
        ax7 = subplot(3,4,7,'parent',f);
        ax8 = subplot(3,4,8,'Parent',f);
        ax9 = subplot(3,4,9,'Parent',f);
        ax10 = subplot(3,4,10,'Parent',f);
        ax11 = subplot(3,4,11,'parent',f);
        ax12 = subplot(3,4,12,'Parent',f);
        set(f,'PaperPosition',[0,0,18,20]);
        mesh(ax1,wgrid,agrid,thate1(:,:,2,1)');
        xlabel(ax1,'Wage')
        ylabel(ax1,'Assets')
        title(ax1,'Low HC, Low Learn')
        mesh(ax2,wgrid,agrid,thate1(:,:,floor(Nh/2),1)');
        xlabel(ax2,'Wage')
        ylabel(ax2, 'Assets') 
        title(ax2,'Med HC, Low Learn')
        mesh(ax3,wgrid,agrid,thate1(:,:,Nh-1,1)');
        xlabel(ax3,'Wage')
        ylabel(ax3,'Assets')
        title(ax3,'High HC, Low Learn')
        mesh(ax4,wgrid,agrid,thate1(:,:,2,3)');
        xlabel(ax4,'Wage')
        ylabel(ax4,'Assets')
        title(ax4,'Low HC, Low/Med Learn')
        mesh(ax5,wgrid,agrid,thate1(:,:,floor(Nh/2),3)');
        xlabel(ax5,'Wage')
        ylabel(ax5,'Assets')
        title(ax5,'Med HC, Low/Med Learn')
        mesh(ax6,wgrid,agrid,thate1(:,:,Nh-1,3)');
        xlabel(ax6,'Wage')
        ylabel(ax6,'Assets')
        title(ax6,'High HC, Low/Med Learn')
        mesh(ax7,wgrid,agrid,thate1(:,:,2,5)');
        xlabel(ax7,'Wage')
        ylabel(ax7,'Assets')
        title(ax7,'Low HC, Med/High Learn')
        mesh(ax8,wgrid,agrid,thate1(:,:,floor(Nh/2),5)');
        xlabel(ax8,'Wage')
        ylabel(ax8,'Assets')
        title(ax8,'Med HC, Med/High Learn')
        mesh(ax9,wgrid,agrid,thate1(:,:,Nh-1,5)');
        xlabel(ax9,'Wage')
        ylabel(ax9,'Assets')
        title(ax9,'High HC, Med/High Learn')
        mesh(ax10,wgrid,agrid,thate1(:,:,2,7)');
        xlabel(ax10,'Wage')
        ylabel(ax10, 'Assets')
        title(ax10,'Low HC, High Learn')
        mesh(ax11,wgrid,agrid,thate1(:,:,floor(Nh/2),7)');
        xlabel(ax11,'Wage')
        ylabel(ax11,'Assets')
        title(ax11,'Med HC, High Learn')
        mesh(ax12,wgrid,agrid,thate1(:,:,Nh-1,7)');
        xlabel(ax12,'Wage')
        ylabel(ax12,'Assets')
        title(ax12,'High HC, High Learn')
        figfile = fullfile(pwd,'/graphics/',strcat('LearningTime_', int2str(t), '.png'));
        saveas(f,figfile);
        close;
    end
    
    R = V;
    Rub = Vub;

    matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',t));
    save(matfile, 'aprimeu1b', 'aprimee1', 'agrid', 'thate1', 'hhate1');
    clear agrid;
end
toc
end
