function NonTargetedAveragePlots(params, order, opts, testopts, statNames, YLabs, statArrayNames, statArray)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,testopts.dir);
    model_results_table_path = fullfile(results_table_path,testopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

% StatArray: 1: TimeVar, 2: LRInc, 3: RInc, 4: RIncEmp, 5: HumanCap, 6: HumanCapEmp, 7: HumanCapUnemp, 8: HumanCapUnempwUI, 9: HumanCapUnempwoUI, 10: RLiqWealth, 11: RLiqWealthEmp, 12: RLiqWealthUnemp, 13: RLiqWealthUnempwUI, 14: RLiqWealthUnempwoUI, 15: Emp, 16: Unemp, 17: UnempwUI, 18: Ten, 19: TenEmp, 20: Cons, 21: ConsEmp, 22: ConsUnemp, 23: ConsUnempwUI, 24: ConsUnempwoUI, 25: PieceRate, 26: AppStrat, 27: AppStratEmp, 28: AppStratUnemp, 29: AppStratUnempwUI, 30: AppStratUnempwoUI, 31: EmpProb, 32: EmpProbEmp, 33: EmpProbUnemp, 34: EmpProbUnempwUI, 35: EmpProbUnempwoUI, 36: SubTightness, 37: SubTightnessEmp, 38: SubTightnessUnemp, 39: SubTightnessUnempwUI, 40: SubTightnessUnempwoUI, 41: LearnTime, 42: LearnTimeEmp, 43: UnempDur



%%Statistics
% Time Series: Income
if size(statArray,3)>1
    for i = 1:size(statArray,2)
        TableArray = squeeze(statArray(:,i,:)).';
        TableArrayNames = strcat(repmat(strtrim(statNames{i}),TScar./freq,1),'_',strtrim(cellstr(int2str((1:TScar./freq).'))));
        fid = fopen(strcat(results_table_path,statNames{i},'Averages',testopts.('name'),'.csv'), 'w');
        for j = 1:length(statArrayNames)
            fprintf(fid,'%s,',statArrayNames{j});
        end
        fprintf(fid, '\n');
        fclose(fid);
        fid = fopen(strcat(results_table_path,statNames{i},'Averages',testopts.('name'),'.csv'), 'a+');
        if fid>0
            for k=1:size(TableArray,1)
                fprintf(fid,'%s,',TableArrayNames{k});
                for j=1:size(TableArray,2)
                    fprintf(fid,'%f,',TableArray(k,j));
                end
                fprintf(fid,'\n');
            end
            fclose(fid);
        end
    end
else
    for i = 1:size(statArray,1)
        TableArray = squeeze(statArray(i,:)).';
        TableArrayNames = strcat(repmat(strtrim(statNames{i}),TScar./freq,1),'_',strtrim(cellstr(int2str((1:TScar./freq).'))));
        fid = fopen(strcat(results_table_path,statNames{i},'Averages',testopts.('name'),'.csv'), 'w');
        for j = 1:length(statArrayNames)
            fprintf(fid,'%s,',statArrayNames{j});
        end
        fprintf(fid, '\n');
        fclose(fid);
        fid = fopen(strcat(results_table_path,statNames{i},'Averages',testopts.('name'),'.csv'), 'a+');
        if fid>0
            for k=1:size(TableArray,1)
                fprintf(fid,'%s,',TableArrayNames{k});
                for j=1:size(TableArray,2)
                    fprintf(fid,'%f,',TableArray(k,j));
                end
                fprintf(fid,'\n');
            end
            fclose(fid);
        end
    end
end    


end