function NonTargetedCompPlots(params, order, opts, plotopts, statNames, YLabs, DataAve, DataSE, statArray, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

[ColorSet2,~,~] = brewermap(24,'RdYlBu');
[ColorSet3,~,~] = brewermap(24,'BrBG');
[ColorSet4,~,~] = brewermap(24,'PRGn');
[ColorSet1,~,~] = brewermap(24,'RdYlBu');
[ColorSet5,~,~] = brewermap(12,'Paired');

FormatOpts = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,4,4]);


% AggShocks = [0;AggShocks];


%%Plots
% Time Series: Loop over statNamess above

Q1DataColor = ColorSet1(2,:);
Q1ModelColor = ColorSet1(22,:);
Q2Q5DataColor = ColorSet1(9,:);
Q2Q5ModelColor = ColorSet4(2,:);

DataQ1_ci = zeros(7,2);
DataQ1_ci(:,1) = (DataAve(1:7,1)-2.*DataSE(1:7,1));
DataQ1_ci(:,2) = (DataAve(1:7,1)+2.*DataSE(1:7,1));

DataQ2Q5_ci = zeros(7,2);
DataQ2Q5_ci(:,1) = (DataAve(1:7,2)-2.*DataSE(1:7,2));
DataQ2Q5_ci(:,2) = (DataAve(1:7,2)+2.*DataSE(1:7,2));

DataQ2Q5Sum_ci = zeros(7,2);
DataQ2Q5Sum_ci(:,1) = (DataAve(1:7,3)-2.*DataSE(1:7,3));
DataQ2Q5Sum_ci(:,2) = (DataAve(1:7,3)+2.*DataSE(1:7,3));


if strcmpi(opts.plotTest,'UnempScarring')
    ylimB1 = -0.4;
    ylimB2 = 0.05;
else
    ylimB1 = min(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)));
    ylimB2 = max(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)));
end

p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ1Comp2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

p1 = plot(squeeze(1:7),DataAve(1:7,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ1CompFull2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;

fill([squeeze(1:5) fliplr(squeeze(1:5))], [DataQ1_ci(1:5,1).' fliplr(DataQ1_ci(1:5,2).')], Q1DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:5),DataQ1_ci(1:5,1).','color',Q1DataColor);
plot(squeeze(1:5),DataQ1_ci(1:5,2).','color',Q1DataColor);
alpha(0.25);
p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ1Comp2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;


fill([squeeze(1:5) fliplr(squeeze(1:5))], [DataQ1_ci(1:5,1).' fliplr(DataQ1_ci(1:5,2).')], Q1DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:5),DataQ1_ci(1:5,1).','color',Q1DataColor);
plot(squeeze(1:5),DataQ1_ci(1:5,2).','color',Q1DataColor);
alpha(0.25);
p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
% hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
% set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ1DataCI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;


fill([squeeze(1:7) fliplr(squeeze(1:7))], [DataQ1_ci(1:7,1).' fliplr(DataQ1_ci(1:7,2).')], Q1DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:7),DataQ1_ci(1:7,1).','color',Q1DataColor);
plot(squeeze(1:7),DataQ1_ci(1:7,2).','color',Q1DataColor);
alpha(0.25);
p1 = plot(squeeze(1:7),DataAve(1:7,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ1CompFull2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

p1 = plot(squeeze(1:5),DataAve(1:5,2).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5Comp2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

p1 = plot(squeeze(1:7),DataAve(1:7,2).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:10),squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompFull2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


fill([squeeze(1:5) fliplr(squeeze(1:5))], [DataQ2Q5_ci(1:5,1).' fliplr(DataQ2Q5_ci(1:5,2).')], Q2Q5DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:5),DataQ2Q5_ci(1:5,1).','color',Q2Q5DataColor);
plot(squeeze(1:5),DataQ2Q5_ci(1:5,2).','color',Q2Q5DataColor);
alpha(0.25);
p1 = plot(squeeze(1:5),DataAve(1:5,2).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:5),squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5Comp2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;



fill([squeeze(1:7) fliplr(squeeze(1:7))], [DataQ2Q5_ci(1:7,1).' fliplr(DataQ2Q5_ci(1:7,2).')], Q2Q5DataColor, 'linestyle', 'none')
hold on;
plot(squeeze(1:7),DataQ2Q5_ci(1:7,1).','color',Q2Q5DataColor);
plot(squeeze(1:7),DataQ2Q5_ci(1:7,2).','color',Q2Q5DataColor);
alpha(0.25);
p1 = plot(squeeze(1:7),DataAve(1:7,2).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:10),squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompFull2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

p1 = plot(squeeze(1:5),DataAve(1:5,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)+statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompSum2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


p1 = plot(squeeze(1:7),DataAve(1:7,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)+statArray(2,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompSumFull2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


fill([squeeze(1:5) fliplr(squeeze(1:5))], [(DataQ2Q5Sum_ci(1:5,1).') fliplr(DataQ2Q5Sum_ci(1:5,2).')], Q2Q5DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:5),(DataQ2Q5Sum_ci(1:5,1).'),'color',Q2Q5DataColor);
plot(squeeze(1:5),(DataQ2Q5Sum_ci(1:5,2).'),'color',Q2Q5DataColor);
alpha(0.25);
p1 = plot(squeeze(1:5),DataAve(1:5,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)+statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompSum2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


fill([squeeze(1:7) fliplr(squeeze(1:7))], [(DataQ2Q5Sum_ci(1:7,1).') fliplr(DataQ2Q5Sum_ci(1:7,2).')], Q2Q5DataColor, 'linestyle', 'none');
hold on;
plot(squeeze(1:7),(DataQ2Q5Sum_ci(1:7,1).'),'color',Q2Q5DataColor);
plot(squeeze(1:7),(DataQ2Q5Sum_ci(1:7,2).'),'color',Q2Q5DataColor);
alpha(0.25);
p1 = plot(squeeze(1:7),DataAve(1:7,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
p2 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)+statArray(2,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','--','Marker','^');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data','Model','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncQ2Q5CompSumFull2CI',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;



p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),DataAve(1:5,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','--','Marker','p');
p3 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle',':','Marker','^');
p4 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)+statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','-.','Marker','s');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p3,p2,p4],'Data Q1','Model Q1','Data > Q1','Model > Q1','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncAllCompSum2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;



p1 = plot(squeeze(1:7),DataAve(1:7,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:7),DataAve(1:7,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','--','Marker','p');
p3 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle',':','Marker','^');
p4 = plot(squeeze(1:10),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:11)+statArray(2,find(strcmp(statNames, 'LRInc')),2:11)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','-.','Marker','s');
set(gca,'XTick',1:2:10)
set(gca,'XTickLabel',1:2:10)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p3,p2,p4],'Data Q1','Model Q1','Data > Q1','Model > Q1','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncAllCompSumFull2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;


p1 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q1ModelColor,'LineWidth',1.5,'LineStyle',':','Marker','^');
hold on;
p2 = plot(squeeze(1:5),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),2:6)+statArray(2,find(strcmp(statNames, 'LRInc')),2:6)),'color',Q2Q5ModelColor,'LineWidth',1.5,'LineStyle','-.','Marker','s');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Model Q1','Model > Q1','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncModelAllCompSum2',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),DataAve(1:5,2).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','--','Marker','p');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimA1 ylimA2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data Q1','Data > Q1','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDataAllComp',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;


p1 = plot(squeeze(1:5),DataAve(1:5,1).','color',Q1DataColor,'LineWidth',1.5,'LineStyle','-','Marker','o');
hold on;
p2 = plot(squeeze(1:5),DataAve(1:5,3).','color',Q2Q5DataColor,'LineWidth',1.5,'LineStyle','--','Marker','p');
set(gca,'XTick',1:5)
set(gca,'XTickLabel',1:5)
yLims = get(gca,'ylim');
if strcmpi(opts.plotTest,'UnempScarring')
ylim([ylimB1 ylimB2]);
else
ylim([min(yLims) max(yLims)])
end
axes = get(gca, 'position');
xlabel('Years','Interpreter','latex')
ylabel('Diff. log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Data Q1','Data > Q1','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDataAllCompSum',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;




end
