function NonTargetedModelComp_Wrapper(params, order, opts, panelNames, statNames, YLabs, ResultsSeries, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


if opts.calcUnempScarring == 'y'
    opts.plotTest = 'UnempScarring';

    matfile = fullfile(pwd,sprintf('UnempScarCompCalc_%s.mat',panelNames{1}));
    load(matfile);
    NonTargetedBasePlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.UnempScarPooledAve, ResultsSeries.UnempScarPooledSE, squeeze(modelUnempScarFinal), dataopts);
    matfile = fullfile(pwd,sprintf('UnempScarCompCalc_%s.mat',panelNames{1}));
    load(matfile);
    modelUnempScarCompFinal1 = modelUnempScarCompFinal;
    matfile = fullfile(pwd,sprintf('UnempScarCompCalc_%s.mat',panelNames{2}));
    load(matfile);
    modelUnempScarCompFinal2 = modelUnempScarCompFinal;
    tempopts.dir = sprintf('/UnempScar%s_comp/',dataopts.name);
    tempopts.name = sprintf('_%s',dataopts.name);
    coefNames = {'J2U','J2U:Wealth_Presentqtile2_1'};
    dataopts.norm = 'n';
    dataopts.allQtiles = 'n';
    NonTargetedModelCompPlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.UnempScarAve, ResultsSeries.UnempScarSE, squeeze(modelUnempScarCompFinal1), squeeze(modelUnempScarCompFinal2), dataopts);

end

if opts.calcEmpRisk == 'y'
    opts.plotTest = 'EmpRisk';
        matfile = fullfile(pwd,sprintf('EmpRiskCompEmpCalc_%s.mat',panelNames{1}));
        load(matfile);
        modelEmpRiskCompEmpFinal1 = modelEmpRiskCompEmpFinal;
        matfile = fullfile(pwd,sprintf('EmpRiskCompEmpCalc_%s.mat',panelNames{2}));
        load(matfile);
        modelEmpRiskCompEmpFinal2 = modelEmpRiskCompEmpFinal;
        tempopts.dir = sprintf('/EmpRisk%s_compEmp/',dataopts.name);
        tempopts.name = sprintf('_%s',dataopts.name);
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile2_1'};
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedModelCompPlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.EmpRiskAve, ResultsSeries.EmpRiskSE, squeeze(modelEmpRiskCompEmpFinal1), squeeze(modelEmpRiskCompEmpFinal2), dataopts);


end

end
