function NonTargeted_Wrapper(params, order, opts, panelNames, statNames, YLabs, ResultsSeries, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


if opts.calcUnempScarring == 'y'
    opts.plotTest = 'UnempScarring';
        matfile = fullfile(pwd,sprintf('UnempScarCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/UnempScar%s/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'J2U'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelUnempScarFinal));
        matfile = fullfile(pwd,sprintf('UnempScarCompCalc_%s.mat',panelNames{1}));
        load(matfile);
        NonTargetedBasePlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.UnempScarPooledAve, ResultsSeries.UnempScarPooledSE, squeeze(modelUnempScarFinal), dataopts);
        matfile = fullfile(pwd,sprintf('UnempScarCompCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/UnempScar%s_comp/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'J2U','J2U:Wealth_Presentqtile2_1'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelUnempScarCompFinal));
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedCompPlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.UnempScarAve, ResultsSeries.UnempScarSE, squeeze(modelUnempScarCompFinal), dataopts);
        NonTargetedHeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, squeeze(modelUnempScarCompFinal), dataopts);
        load(matfile);
        matfile = fullfile(pwd,sprintf('UnempScarWealthCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/UnempScar%s_wealth/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'J2U','J2U:Wealth_Presentqtile_2','J2U:Wealth_Presentqtile_3','J2U:Wealth_Presentqtile_4','J2U:Wealth_Presentqtile_5'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelUnempScarWealthFinal));
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedHeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, squeeze(modelUnempScarWealthFinal), dataopts);
        if opts.humancapQtilesScarring == 'y'
            matfile = fullfile(pwd,sprintf('UnempScarHumanCapCalc_%s.mat',panelNames{1}));
            load(matfile);
            tempopts.dir = sprintf('/UnempScar%s_humancap/',panelNames{1});
            tempopts.name = sprintf('_%s',panelNames{1});
            coefNames = {'J2U','J2U:Learn_Presentqtile_2','J2U:Learn_Presentqtile_3','J2U:Learn_Presentqtile_4','J2U:Learn_Presentqtile_5'};
            NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelUnempScarHumanCapFinal));
        end
        if opts.learnQtilesScarring == 'y'
            matfile = fullfile(pwd,sprintf('UnempScarLearnCalc_%s.mat',panelNames{1}));
            load(matfile);
            tempopts.dir = sprintf('/UnempScar%s_learn/',panelNames{1});
            tempopts.name = sprintf('_%s',panelNames{1});
            coefNames = {'J2U','J2U:HumanCap_Presentqtile_2','J2U:HumanCap_Presentqtile_3','J2U:HumanCap_Presentqtile_4','J2U:HumanCap_Presentqtile_5'};
            NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelUnempScarLearnFinal));
        end
    clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;
end

if opts.calcEmpRisk == 'y'
    opts.plotTest = 'EmpRisk';
        matfile = fullfile(pwd,sprintf('EmpRiskCompEmpCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/EmpRisk%s_compEmp/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile2_1'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelEmpRiskCompEmpFinal));
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedCompPlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.EmpRiskAve, ResultsSeries.EmpRiskSE, squeeze(modelEmpRiskCompEmpFinal), dataopts);
        NonTargetedHeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, squeeze(modelEmpRiskCompEmpFinal), dataopts);
        matfile = fullfile(pwd,sprintf('EmpRiskCompUnempCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/EmpRisk%s_compUnemp/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile2_1'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelEmpRiskCompUnempFinal));
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedCompPlots(params, order, opts, tempopts, statNames, YLabs, ResultsSeries.EmpRiskAve, ResultsSeries.EmpRiskSE, squeeze(modelEmpRiskCompUnempFinal), dataopts);
        NonTargetedHeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, squeeze(modelEmpRiskCompUnempFinal), dataopts);
        matfile = fullfile(pwd,sprintf('EmpRiskWealthCalc_%s.mat',panelNames{1}));
        load(matfile);
        tempopts.dir = sprintf('/EmpRisk%s_wealth/',panelNames{1});
        tempopts.name = sprintf('_%s',panelNames{1});
        coefNames = {'EmpRisk','EmpRisk:Wealth_Presentqtile_2','EmpRisk:Wealth_Presentqtile_3','EmpRisk:Wealth_Presentqtile_4','EmpRisk:Wealth_Presentqtile_5'};
        NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelEmpRiskWealthFinal));
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        NonTargetedHeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, squeeze(modelEmpRiskWealthFinal), dataopts);
        if opts.humancapQtilesScarring == 'y'
            matfile = fullfile(pwd,sprintf('EmpRiskHumanCapCalc_%s.mat',panelNames{1}));
            load(matfile);
            tempopts.dir = sprintf('/EmpRisk%s_humancap/',panelNames{1});
            tempopts.name = sprintf('_%s',panelNames{1});
            coefNames = {'EmpRisk','EmpRisk:HumanCap_Presentqtile_2','EmpRisk:HumanCap_Presentqtile_3','EmpRisk:HumanCap_Presentqtile_4','EmpRisk:HumanCap_Presentqtile_5'};
            NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelEmpRiskHumanCapFinal));
        end
        if opts.learnQtilesScarring == 'y'
            matfile = fullfile(pwd,sprintf('EmpRiskLearnCalc_%s.mat',panelNames{1}));
            load(matfile);
            tempopts.dir = sprintf('/EmpRisk%s_learn/',panelNames{1});
            tempopts.name = sprintf('_%s',panelNames{1});
            coefNames = {'EmpRisk','EmpRisk:Learn_Presentqtile_2','EmpRisk:Learn_Presentqtile_3','EmpRisk:Learn_Presentqtile_4','EmpRisk:Learn_Presentqtile_5'};
            NonTargetedAverageStats(params, order, opts, tempopts, statNames, YLabs, coefNames, squeeze(modelEmpRiskLearnFinal));
        end
    clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;
end

end
