function [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts)

%% Define Parameters for the Model with state (w,a) and contractible assets
% r,delta,eta,gamma,lambda_e,lambda_u,delta_h,fix_h,var_h,alpha_h,b,bl,kappa,sigma,Ns,Nw,Na,Nh,nw,na,nx,T
% beta = 1/(1 + r)
    
%% Parameters Values

freq = params(find(strcmp(order, 'freq')));
r      = params(find(strcmp(order, 'r')));    % exogenous real interest rate
ddelta = params(find(strcmp(order, 'ddelta')));      % exogenous separation rate
eeta   = params(find(strcmp(order, 'eeta')));
ggamma  = params(find(strcmp(order, 'ggamma')));      % probability of losing unemployment benefits
% $$$ y = params(find(strcmp(order, 'y')));
bl = params(find(strcmp(order, 'bl')));
gg = params(find(strcmp(order, 'gg')));
b = params(find(strcmp(order, 'b')));
MaxUI = params(find(strcmp(order, 'MaxUI')));
MaxUIUITest = params(find(strcmp(order, 'MaxUIUITest')));
bUITest = params(find(strcmp(order, 'bUITest')));
blDeltUITest = params(find(strcmp(order, 'blDeltUITest')));
blUITest = bl + blDeltUITest;
bbarUITest = params(find(strcmp(order, 'bbarUITest')));
bbar = params(find(strcmp(order, 'bbar')));
ggammaUITest  = params(find(strcmp(order, 'ggammaUITest')));      % probability of losing unemployment benefits
bRet = params(find(strcmp(order, 'bRet')));
kkappa = params(find(strcmp(order, 'kkappa')));
ssigma = params(find(strcmp(order, 'ssigma')));
aalphah = params(find(strcmp(order, 'aalphah')));
nnu = params(find(strcmp(order, 'nnu')));
NumYears = params(find(strcmp(order, 'NumYears')));
NumYearsYoung = params(find(strcmp(order, 'NumYearsYoung')));
NumYearsOld = params(find(strcmp(order, 'NumYearsOld')));
NumYearsScar = params(find(strcmp(order, 'NumYearsScar')));
T = NumYears.*freq;
TYoung = NumYearsYoung.*freq;
TOld = NumYearsOld.*freq;
TScar = NumYearsScar.*freq;
llambu = params(find(strcmp(order, 'llambu')));
llambe = params(find(strcmp(order, 'llambe')));
eepsilon = params(find(strcmp(order, 'eepsilon')));
delt.h = params(find(strcmp(order, 'ddelth')));
delt.l = params(find(strcmp(order, 'ddeltl')));
lb.a = params(find(strcmp(order, 'lba')));
ub.a = params(find(strcmp(order, 'uba'))).*freq;
%lb.w = params(find(strcmp(order, 'lbw')));
ub.w = params(find(strcmp(order, 'ubw')));
lb.h = (params(find(strcmp(order, 'lbh')))+delt.h);
ub.h = params(find(strcmp(order, 'ubh')));
lb.l = params(find(strcmp(order, 'lbl')))+delt.l;
ub.l = params(find(strcmp(order, 'ubl')))+delt.l;
lb.t = params(find(strcmp(order, 'lbt')));
ub.t = params(find(strcmp(order, 'ubt')));
lb.d = params(find(strcmp(order, 'lbd')));
ub.d = params(find(strcmp(order, 'ubd')));
Nd = params(find(strcmp(order, 'dsize')));
Nw = params(find(strcmp(order, 'wsize')));
Na = params(find(strcmp(order, 'asize')));
Nh = params(find(strcmp(order, 'hsize')));
Nl = params(find(strcmp(order, 'lsize')));
Nb = params(find(strcmp(order, 'UIsize')));
na = params(find(strcmp(order, 'aasize')));
nw = params(find(strcmp(order, 'wwsize'))); 
nt = params(find(strcmp(order, 'ttsize')));
MuA = params(find(strcmp(order, 'MuA')));
MuH = params(find(strcmp(order, 'MuH')));
MuL = params(find(strcmp(order, 'MuL')));
SigA = params(find(strcmp(order, 'SigA')));
SigH = params(find(strcmp(order, 'SigH')));
SigL = params(find(strcmp(order, 'SigL')));
SigAL = params(find(strcmp(order, 'SigAL')));
SigAH = params(find(strcmp(order, 'SigAH')));
SigHL = params(find(strcmp(order, 'SigHL')));
SigXi = params(find(strcmp(order, 'SigXi')));
MPIncreaseSA = params(find(strcmp(order, 'MPIncreaseSA')));
MPDecreaseSA = params(find(strcmp(order, 'MPDecreaseSA')));
MPIncreaseSH = params(find(strcmp(order, 'MPIncreaseSH')));
MPDecreaseSH = params(find(strcmp(order, 'MPDecreaseSH')));
MPIncreaseSL = params(find(strcmp(order, 'MPIncreaseSL')));
MPDecreaseSL = params(find(strcmp(order, 'MPDecreaseSL')));
ubi = params(find(strcmp(order, 'ubi')));
EITCSlopeA = params(find(strcmp(order, 'EITCSlopeA')));
EITCSlopeB = params(find(strcmp(order, 'EITCSlopeB')));
minEITC = params(find(strcmp(order, 'minEITC')));
maxEITC = params(find(strcmp(order, 'maxEITC')));
flatEITCA = params(find(strcmp(order, 'flatEITCA')));
flatEITCB = params(find(strcmp(order, 'flatEITCB')));
EITCCap = params(find(strcmp(order, 'EITCCap')));
PHat = params(find(strcmp(order, 'PHat')));
w0 = params(find(strcmp(order, 'w0')));
N = params(find(strcmp(order, 'N')));
NScar = params(find(strcmp(order, 'NScar')));
S = params(find(strcmp(order, 'S')));
exitProb = params(find(strcmp(order, 'exitProb')));
errtol = params(find(strcmp(order, 'errtol')));
Epsnodes = params(find(strcmp(order, 'Epsnodes')));
MuEps = params(find(strcmp(order, 'MuEps')));
SigEps = params(find(strcmp(order, 'SigEps'))); 
StdEps = params(find(strcmp(order, 'StdEps')));

if strcmpi(opts.test,'EmpRisk') | strcmpi(opts.test,'EmpRiskComp') | strcmpi(opts.test,'EmpRiskWealth') | strcmpi(opts.test,'EmpRiskHumanCap') | strcmpi(opts.test,'EmpRiskLearn') | strcmpi(opts.test,'LBDDecompEmpRisk') | strcmpi(opts.test,'LBDDecompLearnDiffsEmpRisk')
    ddelta = linspace(lb.d,ub.d,Nd);
end


%% Frequency adjustment
%----------------------%
bbeta  = 1./(1 + r);
ubi = ubi./w0;
minEITC = minEITC./w0;
maxEITC = maxEITC./w0;
flatEITCA = flatEITCA./w0;
flatEITCB = flatEITCB./w0;
EITCCap = EITCCap./w0;
nnu = nnu./freq;
w0 = w0./freq;

lb.w = max(params(find(strcmp(order, 'lbw'))),(bl+eepsilon)./(lb.h*b));
lb.b = bl+eepsilon;
ub.b = min(ub.w*ub.h*b,MaxUI);


%% Model Functions
%------------------%

U = @(c)((w0.*c).^(1-ssigma)-1)/(1-ssigma);                          % period utility of consumption
xxi = @(h,ab,t)(h + w0.^(aalphah-1).*ab.*((h.*(t)).^aalphah));
phi = @(h,t)(1 + gg).^(t).*h;
    
if strcmpi(opts.test,'UBI')
    IncFun = @(w)w + ubi;
elseif strcmpi(opts.test,'UBIBernie')
    IncFun = @(w)w + 1.5.*ubi;
elseif strcmpi(opts.test,'UBIBiden')
    IncFun = @(w)w + 0.5.*ubi;    
elseif strcmpi(opts.test,'EITC')
    IncFun = @(w)w + w.*EITCSlopeA.*(w >= minEITC & w < flatEITCA) + EITCCap.*(w>= flatEITCA & w < maxEITC) - (w - flatEITCB).*EITCSlopeB.*(w >= flatEITCB & w < maxEITC);
elseif strcmpi(opts.test,'EITCFirstDollar')
    IncFun = @(w)w + EITCCap.*(w>= minEITC & w < maxEITC) - (w - flatEITCB).*EITCSlopeB.*(w >= flatEITCB & w < maxEITC);
elseif strcmpi(opts.test,'EITCHighCap')
    IncFun = @(w)w + w.*2.*EITCSlopeA.*(w >= minEITC & w < flatEITCA) + 2.*EITCCap.*(w>= flatEITCA & w < maxEITC) - (w - flatEITCB).*2.*EITCSlopeB.*(w >= flatEITCB & w < maxEITC);
else
    IncFun = @(w)w + bbar;
end

p = @(theta)min((1+(theta).^(-eeta)).^(-1/eeta),1); % Generalized Telephone Line Matching
q = @(theta)p(theta)./theta;
iq = @(x)(((max(x,kkappa)./kkappa).^(eeta)) - (1.^(eeta))).^(1/eeta); % inverse of q to calculate tightness (x is expected firms value)


end