function PlotDecisionRules(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts, seedval)
%% SMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

[J0,Theta,R,Rub,Rubl,V,wprimee1,aprimee1,thate1,hhate1,wprimeu1b,bgrid,wgrid,hgrid,lgrid,wugrid,wwgrid,ttgrid,wmesh,hmesh,lmesh,xxigrid,Epsgrid,EpsPDF] = Grids(params, order, opts);

alb = geosum(r,bl,T);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,'/DecisionRules/');
    model_results_table_path = fullfile(results_table_path,'/DecisionRules/');

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;


%% Run single simulation to get life-cycle averages
[EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles] = Simulation(params, order, opts, seedval);
EE = gather(EE);
UU = gather(UU);
WW = gather(WW);
AA = gather(AA);
BB = gather(BB);
CC = gather(CC);
UB = gather(UB);
MU = gather(MU);
HH = gather(HH);
TT = gather(TT);
UT = gather(UT);
UE= gather(UE);
EU= gather(EU);            
E2E= gather(E2E);
ET = gather(ET);
LL = gather(LL);
ZZ = gather(ZZ);
WPrime = gather(WPrime);
ThetaPrime = gather(ThetaPrime);
TreatedInd = gather(TreatedInd);
PInitHat = gather(PInitHat);



% dataopts.dataset = 'SIPP';
% dataopts.datasubset = [];
% [SIPPSpellsPanel, err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, [], UB, MU, HH, TT, [], UT, [], [], [], [], [], dataopts);

% RLiqWealth_Qtiles = quantile(SIPPSpellsPanel.Wealth,5);

[ColorsMap1,~,~] = brewermap(24,'RdYlBu');
[ColorsMap2,~,~] = brewermap(24,'PRGn');
[ColorsMap3,~,~] = brewermap(24,'BrBG');

OptsSet1 = struct('Color',ColorsMap1(3,:),'CI_yn','n','CI',0.05,'LS','-','LW',1.5);
OptsSet2 = struct('Color',ColorsMap2(3,:),'CI_yn','n','CI',0.05,'LS','--','LW',1.5);
OptsSet3 = struct('Color',ColorsMap1(22,:),'CI_yn','n','CI',0.05,'LS','-','LW',1.5);
OptsSet4 = struct('Color',ColorsMap2(19,:),'CI_yn','n','CI',0.05,'LS','--','LW',1.5);
OptsSet5 = struct('Color',ColorsMap3(3,:),'CI_yn','n','CI',0.05,'LS','-','LW',1.5);
OptsSet6 = struct('Color',ColorsMap3(8,:),'CI_yn','n','CI',0.05,'LS','--','LW',1.5);

%% Load and Plot Decision Rules Evaluated at Different States    

[~,~,~,~,~,~,~,~,~,~,~,bgrid,wgrid,hgrid,lgrid,wugrid,wwgrid,ttgrid,wmesh,hmesh,lmesh,~,~,~] = Grids(params, order, opts);
[~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,wmesh,hmesh,lmesh,hmeshu,lmeshu,bmeshb,hmeshb,lmeshb] = SimGrids(params,order,opts,seedval);



% Age 24 Decision Rules
[agrid24, agridt24, aagrid24, ~, ~, ~, ~] = UpdateGrids(5, params, order, bgrid, hgrid, ttgrid, opts);
[amesh24,ameshu24,ameshb24] = UpdateSimGrids(5, params, order, opts);


matfile = fullfile(pwd,opts.output_path, 'Result5.mat');
load(matfile);
wprimeu1bAge24 = wprimeu1b;
wprimeu1blAge24 = wprimeu1bl;
wprimee1Age24 = wprimee1;
aprimeu1bAge24 = aprimeu1b;
aprimeu1blAge24 = aprimeu1bl;
aprimee1Age24 = aprimee1;
ThetaAge24 = Theta;
thate1Age24 = thate1;
hhate1Age24 = hhate1;


% Age 29 Decision Rules
[amesh29,ameshu29,ameshb29] = UpdateSimGrids(25, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result25.mat');
load(matfile);
wprimeu1bAge29 = wprimeu1b;
wprimeu1blAge29 = wprimeu1bl;
wprimee1Age29 = wprimee1;
aprimeu1bAge29 = aprimeu1b;
aprimeu1blAge29 = aprimeu1bl;
aprimee1Age29 = aprimee1;
ThetaAge29 = Theta;
thate1Age29 = thate1;
hhate1Age29 = hhate1;

% Age 34 Decision Rules
[amesh34,ameshu34,ameshb34] = UpdateSimGrids(45, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result45.mat');
load(matfile);
wprimeu1bAge34 = wprimeu1b;
wprimeu1blAge34 = wprimeu1bl;
wprimee1Age34 = wprimee1;
aprimeu1bAge34 = aprimeu1b;
aprimeu1blAge34 = aprimeu1bl;
aprimee1Age34 = aprimee1;
ThetaAge34 = Theta;
thate1Age34 = thate1;
hhate1Age34 = hhate1;

% Age 39 Decision Rules
[amesh39,ameshu39,ameshb39] = UpdateSimGrids(65, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result65.mat');
load(matfile);
wprimeu1bAge39 = wprimeu1b;
wprimeu1blAge39 = wprimeu1bl;
wprimee1Age39 = wprimee1;
aprimeu1bAge39 = aprimeu1b;
aprimeu1blAge39 = aprimeu1bl;
aprimee1Age39 = aprimee1;
ThetaAge39 = Theta;
thate1Age39 = thate1;
hhate1Age39 = hhate1;

% Age 44 Decision Rules
[amesh44,ameshu44,ameshb44] = UpdateSimGrids(85, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result85.mat');
load(matfile);
wprimeu1bAge44 = wprimeu1b;
wprimeu1blAge44 = wprimeu1bl;
wprimee1Age44 = wprimee1;
aprimeu1bAge44 = aprimeu1b;
aprimeu1blAge44 = aprimeu1bl;
aprimee1Age44 = aprimee1;
ThetaAge44 = Theta;
thate1Age44 = thate1;
hhate1Age44 = hhate1;

% Age 49 Decision Rules
[amesh49,ameshu49,ameshb49] = UpdateSimGrids(105, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result105.mat');
load(matfile);
wprimeu1bAge49 = wprimeu1b;
wprimeu1blAge49 = wprimeu1bl;
wprimee1Age49 = wprimee1;
aprimeu1bAge49 = aprimeu1b;
aprimeu1blAge49 = aprimeu1bl;
aprimee1Age49 = aprimee1;
ThetaAge49 = Theta;
thate1Age49 = thate1;
hhate1Age49 = hhate1;

% Age 54 Decision Rules
[amesh54,ameshu54,ameshb54] = UpdateSimGrids(125, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result125.mat');
load(matfile);
wprimeu1bAge54 = wprimeu1b;
wprimeu1blAge54 = wprimeu1bl;
wprimee1Age54 = wprimee1;
aprimeu1bAge54 = aprimeu1b;
aprimeu1blAge54 = aprimeu1bl;
aprimee1Age54 = aprimee1;
ThetaAge54 = Theta;
thate1Age54 = thate1;
hhate1Age54 = hhate1;

% Age 59 Decision Rules
[amesh59,ameshu59,ameshb59] = UpdateSimGrids(145, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result145.mat');
load(matfile);
wprimeu1bAge59 = wprimeu1b;
wprimeu1blAge59 = wprimeu1bl;
wprimee1Age59 = wprimee1;
aprimeu1bAge59 = aprimeu1b;
aprimeu1blAge59 = aprimeu1bl;
aprimee1Age59 = aprimee1;
ThetaAge59 = Theta;
thate1Age59 = thate1;
hhate1Age59 = hhate1;

% Age 64 Decision Rules
[amesh64,ameshu64,ameshb64] = UpdateSimGrids(165, params, order, opts);
matfile = fullfile(pwd,opts.output_path, 'Result165.mat');
load(matfile);
wprimeu1bAge64 = wprimeu1b;
wprimeu1blAge64 = wprimeu1bl;
wprimee1Age64 = wprimee1;
aprimeu1bAge64 = aprimeu1b;
aprimeu1blAge64 = aprimeu1bl;
aprimee1Age64 = aprimee1;
ThetaAge64 = Theta;
thate1Age64 = thate1;
hhate1Age64 = hhate1;



%%Application Rules
%By Employment:
% separate plots for changes in each of the heterogeneities

wprimeublAge24Hat = interpn(agrid24.',hgrid.',lgrid.',wprimeu1blAge24,agrid24,nanmean(HH(:,5),1),nanmean(LL,1));
wprimeeAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

f01=figure('name','wprimeu1bYoungDeltaWage');
hold on;
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
% p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
alpha(0.25)
xlabel('Wealth, a')
ylabel('Application Strategy, \mu\prime')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9),yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',wprimeu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',wprimeu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
hleg1 = legend([p1,p2],'Unemployed App. Strat.','Employed App. Strat.');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('wprimeAge24EmpUnempbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','wprimeu1bYoungDeltaWage');
hold on;
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
% p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(wprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS);
alpha(0.25)
xlabel('Wealth, a')
ylabel('Application Strategy, \mu\prime')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.05,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.2,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',wprimeu1blAge24,w0.*quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',wprimeu1blAge24,w0.*quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Unemp. App. Strat.');
% set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('wprimeAge24UnempbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


wprimeeAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
wprimeeAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';


f01=figure('name','wprimeu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).',squeeze(wprimeeAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))),'y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).',squeeze(wprimeeAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))),'y',ColorsMap1(22,:),1.5,'--','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Application Strategy, \mu\prime')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))-0.05],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
br = drawbrace([w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
text(br.XData(101).*0.7,br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
hleg1 = legend([p2,p1],'Emp. \mu(Q5)','Emp. \mu(Q1)');
set(hleg1,'Location','southeast');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('wprimeAge24EmpbyPieceRateWealthQtiles_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


wprimeublAge24HatQ1 = interpn(agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(AA(:,5)<quantile(AA(:,5),0.2),1),nanmean(HH(:,5),1),nanmean(LL,1)).';
wprimeublAge24HatQ5 = interpn(agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(AA(:,5)>quantile(AA(:,5),0.8),1),nanmean(HH(:,5),1),nanmean(LL,1)).';

wprimeeAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,wprimeublAge24HatQ1,agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
wprimeeAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,wprimeublAge24HatQ5,agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';


f01=figure('name','wprimeu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).',squeeze(wprimeeAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))),'y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).',squeeze(wprimeeAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))),'y',ColorsMap1(22,:),1.5,'--','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Application Strategy, \mu\prime')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))-0.05],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
br = drawbrace([w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
text(br.XData(101).*0.7,br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',wprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
hleg1 = legend([p2,p1],'Emp. \mu(Q5)','Emp. \mu(Q1)');
set(hleg1,'Location','southeast');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('wprimeAge24EmpbyFirstPieceRateWealthQtiles_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


%%Savings Rules
%By Employment:
% separate plots for changes in each of the heterogeneities

aprimeublAge24Hat = interpn(agrid24.',hgrid.',lgrid.',aprimeu1blAge24,agrid24,nanmean(HH(:,5),1),nanmean(LL,1));
aprimeeAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

f01=figure('name','aprimeu1bYoungDeltaWage');
hold on;
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
% p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
alpha(0.25)
xlabel('Wealth')
ylabel('Application Strategy')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9),yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',aprimeu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',aprimeu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
hleg1 = legend([p1,p2],'Unemp. Savings','Emp. Savings');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('aprimeAge24EmpUnempbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','aprimeu1bYoungDeltaWage');
hold on;
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
% p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','color',OptsSet1.Color,'LineWidth',1.5,'LineStyle',OptsSet1.LS);
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeublAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS);
alpha(0.25)
xlabel('Wealth')
ylabel('Application Strategy')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.05,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.2,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',aprimeu1blAge24,w0.*quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',aprimeu1blAge24,w0.*quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Unemp. App. Strat.');
% set(hleg1,'Location','best');
% myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('aprimeAge24UnempbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

aprimeeAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
aprimeeAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

f01=figure('name','aprimeu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'s');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeeAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y','b',1.5,OptsSet1.LS,'o');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Application Strategy, \mu\prime')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))-0.05],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
br = drawbrace([w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
text(br.XData(101).*0.7,br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
hleg1 = legend([p2,p1],'Emp. \mu(Q5)','Emp. \mu(Q1)');
set(hleg1,'Location','southeast');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('aprimeAge24EmpbyPieceRateWealthQtiles_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;



%% Human Capital Investment

thateAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,[]);
alpha(0.25)
xlabel('Wealth, a')
ylabel('Learning Time, \tau')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1).*0.95,yl(1)+0.15,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.625,yl(1)+0.15,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Unemployed App. Strat.','Employed App. Strat.');
% set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('thatAge24EmpUnempbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

thateAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
thateAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',ColorsMap1(22,:),1.5,'--','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Learning Time, \tau')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1).*2.8,yl(1)+0.2,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))-0.05],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
% br = drawbrace([w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101).*0.7,br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
hleg1 = legend([p2,p1],'Emp. \mu(Q5)','Emp. \mu(Q1)');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('thatAge24EmpbyPieceRateWealthQtiles_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


%% Portfolio Allocation

thateAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
aprimeAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

% IncLvls = nanmean(MU(:,5),1).*(1 - squeeze(thateAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)))).*nanmean(HH(:,5),1);

IncLvls = nanmean(MU(:,5),1).*nanmean(HH(:,5),1);
LearnTimeIncLvls = nanmean(MU(:,5),1).*squeeze(thateAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(:,5),1);
LearnTimeShare = LearnTimeIncLvls./(IncLvls + (1 + r).*nanmean(AA(:,5),1));
SavingsShare = (aprimeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvls + (1 + r).*nanmean(AA(:,5),1));

f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),LearnTimeShare.','y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),SavingsShare.','y',ColorsMap1(22,:),1.5,'--','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Fraction of Budget')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1).*0.95,yl(1)+0.05,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.625,yl(1)+0.05,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Unemployed App. Strat.','Employed App. Strat.');
hleg1 = legend([p2,p1],'Save Alloc.','Learn Alloc.');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('PortfolioAge24EmpbyWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

thateAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
aprimeAge24HatQ1 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
thateAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
aprimeAge24HatQ5 = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';


IncLvlsQ1 = nanmean(MU(:,5),1).*nanmean(HH(:,5),1);
LearnTimeIncLvlsQ1 = nanmean(MU(:,5),1).*squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(:,5),1);
LearnTimeShareQ1 = LearnTimeIncLvlsQ1./(IncLvlsQ1 + (1 + r).*nanmean(AA(:,5),1));
SavingsShareQ1 = (aprimeAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvlsQ1 + (1 + r).*nanmean(AA(:,5),1));


% IncLvlsQ1 = nanmean(MU(EE(:,5)==1,5),1).*(1 - squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)))).*nanmean(HH(EE(:,5)==1,5),1);
% LearnTimeIncLvlsQ1 = nanmean(MU(EE(:,5)==1,5),1).*squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(EE(:,5)==1,5),1);
% LearnTimeShareQ1 = LearnTimeIncLvlsQ1./(IncLvlsQ1 + (1 + r).*nanmean(AA(EE(:,5)==1,5),1));
% SavingsShare = (aprimeAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvls + (1 + r).*nanmean(AA(:,5),1));

IncLvlsQ5 = nanmean(MU(:,5),1).*nanmean(HH(:,5),1);
LearnTimeIncLvlsQ5 = nanmean(MU(:,5),1).*squeeze(thateAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(:,5),1);
LearnTimeShareQ5 = LearnTimeIncLvlsQ5./(IncLvlsQ5 + (1 + r).*nanmean(AA(:,5),1));
SavingsShareQ5 = (aprimeAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvlsQ5 + (1 + r).*nanmean(AA(:,5),1));


f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),LearnTimeShareQ1.','y',OptsSet1.Color,1.5,OptsSet1.LS,'o');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),SavingsShareQ1.','y','b',1.5,'--','o');
p3 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),LearnTimeShareQ5.','y','g',1.5,OptsSet1.LS,'s');
p4 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),SavingsShareQ5.','y','k',1.5,'--','s');
% p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'s');
% p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y','b',1.5,OptsSet1.LS,'o');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Learning Time, \tau')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1).*2.8,yl(1)+0.2,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.3,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))-0.05],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
% br = drawbrace([w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],[w0.*quantile(AA(:,5),0.9) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101).*0.7,br.YData(101),sprintf('Diff. of \n%0.2f',(interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1)) - interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))+0.05)));
hleg1 = legend([p1,p2,p3,p4],'Learn \mu(Q5)','Save \mu(Q5)','Learn \mu(Q1)','Save \mu(Q1)');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('PortfolioAge24EmpbyPieceRateWealthQtiles_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;



%% Employment Risk

thateAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
aprimeAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

opts.test = 'EmpRisk';

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


% Age 24 Decision Rules
% [~,~,~,~,~,~,~,~,~,~,~,bgrid,wgrid,hgrid,lgrid,wugrid,wwgrid,ttgrid,dmesh,wmesh,hmesh,lmesh,~,~,~] = GridsEmpRisk(params, order, opts);
% [~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,~,wmesh,hmesh,lmesh,hmeshu,lmeshu,bmeshb,hmeshb,lmeshb] = SimGridsEmpRisk(params,order,opts,seedval);


[agrid24, agridt24, aagrid24, ~, ~, ~, ~] = UpdateGrids(5, params, order, bgrid, hgrid, ttgrid, opts);
[amesh24,ameshu24,ameshb24] = UpdateSimGrids(5, params, order, opts);


matfile = fullfile(pwd,'/output/EmpRisk/', 'Result5.mat');
load(matfile);
wprimeu1bAge24SepRates = wprimeu1b;
wprimeu1blAge24SepRates = wprimeu1bl;
wprimee1Age24SepRates = wprimee1;
aprimeu1bAge24SepRates = aprimeu1b;
aprimeu1blAge24SepRates = aprimeu1bl;
aprimee1Age24SepRates = aprimee1;
ThetaAge24SepRates = Theta;
thate1Age24SepRates = thate1;
hhate1Age24SepRates = hhate1;

thateAge24HatLowSep = squeeze(interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24SepRates,ddelta(1),nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)));
thateAge24HatMedSep = squeeze(interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24SepRates,ddelta(5),nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)));
thateAge24HatHighSep = squeeze(interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24SepRates,ddelta(end),nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)));

aprimeAge24HatLowSep = squeeze(interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24SepRates,ddelta(1),nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)));
aprimeAge24HatHighSep = squeeze(interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24SepRates,ddelta(end),nanmean(MU(EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)));


f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatMedSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatLowSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet2.Color,1.5,'--','o');
p3 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatHighSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet3.Color,1.5,':','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Learning Time, \tau')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.175,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.1,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
hleg1 = legend([p2,p1,p3],'\delta=0.01','Baseline','\delta = 0.1');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('thatAge24EmpbyWealthSepRates_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatMedSep(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'^');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatLowSep(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet2.Color,1.5,'--','o');
p3 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatHighSep(agrid24<quantile(AA(:,5),0.5)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet3.Color,1.5,':','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Learning Time, \tau')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
% line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1),yl(1)+0.85,sprintf('1st\nQuintile'));
% text(w0.*quantile(AA(:,5),0.9).*0.65,yl(1)+0.1,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
hleg1 = legend([p2,p1,p3],'\delta=0.01','Baseline','\delta = 0.05');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('thatAge24EmpbyWealthSepRatesQ1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;




f01=figure('name','aprimu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS,'s');
p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeAge24HatLowSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet2.Color,1.5,'--','x');
p3 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(aprimeAge24HatHighSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet3.Color,1.5,':','o');
alpha(0.25)
xlabel('Wealth, a','Interpreter','latex')
ylabel('Savings, a\prime','Interpreter','latex')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([quantile(AA(:,5),0.1) quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([quantile(AA(:,5),0.9) quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
[figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(quantile(AA(:,5),0.1),yl(1)+0.175,sprintf('1st\nQuintile'));
text(quantile(AA(:,5),0.9).*0.65,yl(1)+0.1,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
hleg1 = legend([p2,p1,p3],'\delta=0.01','Baseline','\delta = 0.1');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('aprimeAge24EmpbyWealthSepRates_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

%% Portfolio Allocation

% thateAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
% aprimeAge24Hat = interpn(wgrid.',agrid24.',hgrid.',lgrid.',aprimee1Age24,nanmean(MU(:,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

% IncLvls = nanmean(MU(:,5),1).*(1 - squeeze(thateAge24Hat(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)))).*nanmean(HH(:,5),1);

IncLvlsLowSep = nanmean(MU(:,5),1).*nanmean(HH(:,5),1);
LearnTimeIncLvlsLowSep = nanmean(MU(:,5),1).*squeeze(thateAge24HatLowSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(:,5),1);
LearnTimeShareLowSep = LearnTimeIncLvlsLowSep./(IncLvlsLowSep + (1 + r).*nanmean(AA(:,5),1));
SavingsShareLowSep = (aprimeAge24HatLowSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvlsLowSep + (1 + r).*nanmean(AA(:,5),1));

IncLvlsHighSep = nanmean(MU(:,5),1).*nanmean(HH(:,5),1);
LearnTimeIncLvlsHighSep = nanmean(MU(:,5),1).*squeeze(thateAge24HatHighSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).*nanmean(HH(:,5),1);
LearnTimeShareHighSep = LearnTimeIncLvlsHighSep./(IncLvlsHighSep + (1 + r).*nanmean(AA(:,5),1));
SavingsShareHighSep = (aprimeAge24HatHighSep(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))-agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)).')./(IncLvlsHighSep + (1 + r).*nanmean(AA(:,5),1));


f01=figure('name','thatu1bYoungDeltaWage');
hold on;
p1 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),LearnTimeShareLowSep.','y',OptsSet1.Color,1.5,OptsSet1.LS,'o');
p2 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),SavingsShareLowSep.','y',ColorsMap1(8,:),1.5,OptsSet1.LS,'^');
p3 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),LearnTimeShareHighSep.','y',ColorsMap1(22,:),1.5,'--','v');
p4 = plotsmooth(w0.*agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),SavingsShareHighSep.','y',ColorsMap3(20,:),1.5,':','p');
alpha(0.25)
xlabel('Wealth, a')
ylabel('Fraction of Budget')
xl = get(gca, 'xlim');
yl = get(gca, 'ylim');
axes = get(gca, 'position');
line([w0.*quantile(AA(:,5),0.1) w0.*quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
line([w0.*quantile(AA(:,5),0.9) w0.*quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
[figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
text(w0.*quantile(AA(:,5),0.1).*0.95,yl(1)+0.15,sprintf('1st\nQuintile'));
text(w0.*quantile(AA(:,5),0.9).*0.625,yl(1)+0.27,sprintf('5th\nQuintile'));
%annotation('doublearrow',gather([figx1 figx2]), ...
%    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(agrid24.',hgrid.',lgrid.',thatu1blAge24,quantile(AA(:,5),0.9),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Unemployed App. Strat.','Employed App. Strat.');
hleg1 = legend([p4,p2,p1,p3],'Save Alloc. \delta=0.05','Save Alloc. \delta=0.01','Learn Alloc. \delta=0.01','Learn Alloc. \delta=0.05');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('PortfolioAge24EmpbyWealthSepRates_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


% thateAge24HatQ1 = interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';
% thateAge24HatQ5 = interpn(ddelta.',wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8)&EE(:,5)==1,5),1),agrid24,nanmean(HH(:,5),1),nanmean(LL,1)).';

% f01=figure('name','thatu1bYoungDeltaWage');
% hold on;
% p1 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ1(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS);
% p2 = plotsmooth(agrid24(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01)),squeeze(thateAge24HatQ5(agrid24<quantile(AA(:,5),0.95)&agrid24>quantile(AA(:,5),0.01))).','y',OptsSet1.Color,1.5,OptsSet1.LS);
% alpha(0.25)
% xlabel('Wealth')
% ylabel('Application Strategy')
% xl = get(gca, 'xlim');
% yl = get(gca, 'ylim');
% axes = get(gca, 'position');
% line([quantile(AA(:,5),0.1) quantile(AA(:,5),0.1)], yl, 'LineStyle','--','Color','k');
% line([quantile(AA(:,5),0.9) quantile(AA(:,5),0.9)], yl, 'LineStyle','--','Color','k');
% % line([RLiqWealth_Qtiles(1,1) RLiqWealth_Qtiles(1,1)], yl, 'LineStyle','--','Color','k');
% [figx1, figy1] = normalize_coordinate(p1.XData(3), p1.YData(3), axes, xl, yl, 0, 0);
% [figx2, figy2] = normalize_coordinate(p2.XData(3), p2.YData(3), axes, xl, yl, 0, 0);
% text(quantile(AA(:,5),0.1),yl(1)+0.1,sprintf('1st\nQuintile'));
% text(quantile(AA(:,5),0.9),yl(1)+0.3,sprintf('5th\nQuintile'));
% %annotation('doublearrow',gather([figx1 figx2]), ...
% %    gather([figy1 figy2]));
% br = drawbrace([quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)<quantile(AA(:,5),0.2),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],[quantile(AA(:,5),0.1) interpn(wgrid.',agrid24.',hgrid.',lgrid.',thate1Age24,nanmean(MU(AA(:,5)>quantile(AA(:,5),0.8),5),1),quantile(AA(:,5),0.1),nanmean(HH(:,5),1),nanmean(LL,1))],10,'Color','k');
% text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(p2.YData(3) - p1.YData(3))));
% hleg1 = legend([p1,p2],'Emp. Q1','Emp. Q5');
% set(hleg1,'Location','best');
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);

% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('thatAge24EmpbyPieceRateWealthQtiles',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% hold off;

end