function [f, p] = PlotFun(X,Y,opts,Color,fig)

if fig == 'y'
    f = figure('name','Figure');
else
    f = [];
end

if isfield(opts, 'LW')
    if isempty(opts.LW)
        opts.LW = 1.5;
    end
else
    opts.LW = 1.5;
end

if isfield(opts, 'MS')
    if isempty(opts.MS)
        opts.MS = [];
    end
else
    opts.MS = [];
end

if isfield(opts, 'MI')
    if isempty(opts.MI)
        opts.MI = 1:5:length(Y);
    else
        opts.MI = 1:opts.MI:length(Y);
    end
else
    opts.MI = [];
end

if ~isempty(opts.LS)
    if ~isempty(Color)
        p = plot(reshape(X,[],1),reshape(Y,[],1),'color',Color,'LineWidth',opts.LW,'LineStyle',opts.LS,'Marker',opts.MS,'MarkerIndices',opts.MI);
    else
        p = plot(reshape(X,[],1),reshape(Y,[],1),'LineWidth',opts.LW,'LineStyle',opts.LS,'Marker',opts.MS,'MarkerIndices',opts.MI);
    end
else
    if ~isempty(Color)
        p = plot(reshape(X,[],1),reshape(Y,[],1),'color',Color,'LineWidth',opts.LW,'Marker',opts.MS,'MarkerIndices',opts.MI);
    else
        p = plot(reshape(X,[],1),reshape(Y,[],1),'LineWidth',opts.LW,'Marker',opts.MS,'MarkerIndices',opts.MI);
    end    
end
set(gcf, 'PaperPosition', opts.PaperPosition);
    
set(gca, ...
    'GridLineStyle'         , opts.GridLineStyle     , ...
    'Box'         , opts.Box     , ...
    'TickDir'     , opts.TickDir     , ...
    'TickLength'  , opts.TickLength , ...
    'XMinorTick'  , opts.XMinorTick      , ...
    'YMinorTick'  , opts.YMinorTick      , ...
    'XGrid'       , opts.XGrid      , ...
    'YGrid'       , opts.YGrid      , ...
    'XColor'      , opts.XColor, ...
    'YColor'      , opts.YColor, ...
    'FontSize'    , opts.FontSize, ...
    'LineWidth'   , opts.LineWidth);

end