function Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles, dataopts)
%% SMM m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
 na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
 SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts);
    model_results_table_path = fullfile(results_table_path,plotopts);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

[Panel,err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);


% [Panel,err] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, [], dataopts);

AAscaled = (AA(:,1) - min(AA(:,1)))./(max(AA(:,1)) - min(AA(:,1)));
HHscaled = (HH(:,1) - min(HH(:,1)))./(max(HH(:,1)) - min(HH(:,1)));
LLscaled = (LL - min(LL))./(max(LL) - min(LL));
sz       = 4.*ones(N,1);

DataAge = 25:54;
DataQuarters = (TYoung/freq + 1):T;
Age = 23:64;
Quarters = 1:T;


[QtileColors1,~,~] = brewermap(24,'RdYlBu');
[QtileColors2,~,~] = brewermap(24,'BrBG');
[QtileColors3,~,~] = brewermap(24,'PRGn');
[EmpColors,~,~] = brewermap(24,'RdYlBu');
[CompareColors,~,~] = brewermap(12,'Paired');

ModelCompOpts = struct('Color',CompareColors(2,:),'CI_yn','n','CI',0.05,'LS',[],'scatter',[]);
DataCompOpts = struct('Color',CompareColors(6,:),'CI_yn','n','CI',0.05,'LS','--','scatter',[]);

EmpOpts = struct('Color',EmpColors(3,:),'CI_yn','n','CI',0.05,'LS',[]);
UnempOpts = struct('Color',EmpColors(8,:),'CI_yn','n','CI',0.05,'LS','--');
UnempNoUIOpts = struct('Color',EmpColors(22,:),'CI_yn','n','CI',0.05,'LS','-.');

Q1EmpOpts = struct('Color',QtileColors1(3,:),'CI_yn','n','CI',0.05,'LS',[]);
Q1UnempUIOpts = struct('Color',QtileColors1(7,:),'CI_yn','n','CI',0.05,'LS','--');
Q1UnempNoUIOpts = struct('Color',QtileColors1(22,:),'CI_yn','n','CI',0.05,'LS','-.');
Q3EmpOpts = struct('Color',QtileColors2(3,:),'CI_yn','n','CI',0.05,'LS',[]);
Q3UnempUIOpts = struct('Color',QtileColors2(7,:),'CI_yn','n','CI',0.05,'LS','--');
Q3UnempNoUIOpts = struct('Color',QtileColors2(2,:),'CI_yn','n','CI',0.05,'LS','-.');
Q5EmpOpts = struct('Color',QtileColors3(3,:),'CI_yn','n','CI',0.05,'LS',[]);
Q5UnempUIOpts = struct('Color',QtileColors3(8,:),'CI_yn','n','CI',0.05,'LS','--');
Q5UnempNoUIOpts = struct('Color',QtileColors3(19,:),'CI_yn','n','CI',0.05,'LS','-.');

%%Full Sample Plots
%Life-Cycle Profiles:
% LRInc, LRInc_3, LRIncHVY_3 - Compared with PSID/NLSY
if opts.II == 'n'
f01=figure('name','LRInc_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25,:),Panel.Age(Panel.Age>=25,:),'mean',ModelCompOpts);
p2 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
alpha(0.25)
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_compare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

ModelCompOpts.scatter = 'y';
f01=figure('name','LRInc_ScatterCompare');
hold on;
p1 = scatter(Panel.Age(Panel.Age>=25&Panel.Age<=54),Panel.LRInc(Panel.Age>=25&Panel.Age<=54),25,'MarkerEdgeColor',ModelCompOpts.Color);
p2 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'mean',EmpOpts);
p3 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
alpha(0.25)
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'Model (Scatter)','Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_scatter_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

ModelCompOpts.scatter = 'n';

f01=figure('name','LRInc_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc_3(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'mean',ModelCompOpts);
p2 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_3_compare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'mean',ModelCompOpts);
p2 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

if opts.II == 'n'
    
ModelCompOpts.scatter = 'y';
f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = scatter(Panel.Age(Panel.Age>=25&Panel.Age<=54),Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54),25,'MarkerEdgeColor',ModelCompOpts.Color);
p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'mean',EmpOpts);
p3 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'Model (Scatter)','Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_scatter_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

ModelCompOpts.scatter = 'n';
f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54),Panel.Age(Panel.Age>=25&Panel.Age<=54),'mean',ModelCompOpts);
p2 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compareFullPlot1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

Age23HC = grpstats(Panel(Panel.Age==23,:),'IndID','mean','DataVars',{'HumanCap'});
temp = [Age23HC.IndID Age23HC.mean_HumanCap];
temp = array2table(temp,'VariableNames',{'IndID','Age23HC'});

Panel = join(Panel,temp,'Keys','IndID');

Panel.AdjustedRInc = w0.*Panel.PieceRateShare.*(1 - Panel.LearnTime).*Panel.Age23HC;

Panel.AdjustedRIncHVY = Panel.AdjustedRInc;

Panel.AdjustedRIncHVY(Panel.Age<=30&(Panel.AdjustedRInc<4750|Panel.HrsWrked<=260)) = NaN;
Panel.AdjustedRIncHVY(Panel.Age>30&(Panel.AdjustedRInc<9500|Panel.HrsWrked<=520)) = NaN;

%RIncHVY_3 = reshape(movmean(reshape(Panel.AdjustedRIncHVY,T/freq,N),[1 1],'includenan'),[],1);
Panel.AdjustedRIncHVY_3 = Panel.AdjustedRIncHVY;

Panel.LRIncAdjustedHVY_3 = log(Panel.AdjustedRIncHVY_3);

Age23HC = nanmean(Panel.HumanCap(Panel.Age==23&Panel.EmpInd==1));

f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54),Panel.Age(Panel.Age>=25&Panel.Age<=54),'mean',ModelCompOpts);
p2 = GrpStatsPlotFun(log(Panel.PieceRate(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28).*Age23HC),Panel.Age(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28),'mean',Q1EmpOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Model + Age 23 HC');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compareFullPlot2_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54),Panel.Age(Panel.Age>=25&Panel.Age<=54),'mean',ModelCompOpts);
p2 = GrpStatsPlotFun(Panel.LRIncAdjustedHVY_3(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28),Panel.Age(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28),'mean',Q1EmpOpts);
Q1EmpOpts.LS = '--';
p3 = GrpStatsPlotFun(Panel.LRIncAdjustedHVY_3(Panel.EmpInd==1&Panel.Age>=28&Panel.Age<=54),Panel.Age(Panel.EmpInd==1&Panel.Age>=28&Panel.Age<=54),'mean',Q1EmpOpts);
diff = p3.YData(12) - p1.YData(15);
xlabel('Age')
ylabel('Log Annual Earnings')
br = drawbrace([p1.XData(15) p1.YData(15)],[p3.XData(12) p3.YData(12)],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(diff)),'HorizontalAlignment','left');
hleg1 = legend([p1,p2],'Model','Model + Age 23 HC');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compareFullPlot3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','LRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54),Panel.Age(Panel.Age>=25&Panel.Age<=54),'mean',ModelCompOpts);
p2 = GrpStatsPlotFun(log(Panel.PieceRate(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28).*Age23HC.*(1 - Panel.LearnTime(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28))),Panel.Age(Panel.EmpInd==1&Panel.Age>=25&Panel.Age<=28),'mean',Q1EmpOpts);
Q1EmpOpts.LS = '--';
p3 = GrpStatsPlotFun(log(Panel.PieceRate(Panel.EmpInd==1&Panel.Age>=28&Panel.Age<=54).*Age23HC.*(1 - Panel.LearnTime(Panel.EmpInd==1&Panel.Age>=28&Panel.Age<=54))),Panel.Age(Panel.EmpInd==1&Panel.Age>=28&Panel.Age<=54),'mean',Q1EmpOpts);
diff = p3.YData(12) - p1.YData(15);
xlabel('Age')
ylabel('Log Annual Earnings')
br = drawbrace([p1.XData(15) p1.YData(15)],[p3.XData(12) p3.YData(12)],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Difference of %0.2f',(diff)),'HorizontalAlignment','left');
hleg1 = legend([p1,p2],'Model','Model + Age 23 HC');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compareFullPlot3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

Q1EmpOpts.LS = [];

LRInc_ci = zeros(30,2);
LRInc_ci(:,1) = (lifetime_earnings-2.*sqrt(lifetime_variance));
LRInc_ci(:,2) = (lifetime_earnings+2.*sqrt(lifetime_variance));

f01=figure('name','LRIncHVY_3wVar_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'mean',ModelCompOpts);
p2 = plot(DataAge,lifetime_earnings,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
fill([DataAge fliplr(DataAge)], [LRInc_ci(:,1).' fliplr(LRInc_ci(:,2).')], DataCompOpts.Color, 'linestyle', 'none');
plot(DataAge,(lifetime_earnings+2.*sqrt(lifetime_variance)),'color',DataCompOpts.Color);
plot(DataAge,(lifetime_earnings-2.*sqrt(lifetime_variance)),'color',DataCompOpts.Color);
alpha(0.25);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3wVar_compare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

f01=figure('name','LRIncHVY_3Var_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Age<=54,:),Panel.Age(Panel.Age>=25&Panel.Age<=54,:),'var',ModelCompOpts);
p2 = plot(DataAge,lifetime_variance,'color',DataCompOpts.Color,'LineStyle',DataCompOpts.LS);
xlabel('Age')
ylabel('Var(log Annual Earnings)')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3Var_compare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

ModelCompOpts.CI_yn = 'y';

if opts.II == 'n'

f01=figure('name','LRInc_compare');
p = GrpStatsPlotFun(Panel.LRInc,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','LRInc_3_compare');
p = GrpStatsPlotFun(Panel.LRInc_3,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','LRIncHVY_3_compare');
p = GrpStatsPlotFun(Panel.LRIncHVY_3,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','LRIncHVY_3Var_compare');
p = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
xlabel('Age')
ylabel('Var(log earnings)')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3Var_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

% HC, HCEmp, HCUnemp
Panel.LnHumanCap = log(Panel.HumanCap);

f01=figure('name','HumanCap');
p = GrpStatsPlotFun(Panel.LnHumanCap,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Human Capital')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('HumanCap_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

if opts.II == 'n'

f01=figure('name','HumanCap');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCap,Panel.Age,'mean',EmpOpts);
p2 = scatter(Panel.Age,Panel.HumanCap,25,'MarkerEdgeColor',ModelCompOpts.Color);
xlabel('Age')
ylabel('Human Capital')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('HumanCap_scatter_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;

end

if opts.II == 'n'

    f01=figure('name','HumanCapEmp');
    p = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Human Capital')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('HumanCapEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','HumanCapUnemp');
    p = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Human Capital')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('HumanCapUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;


    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;
    hold off;


end

f01=figure('name','HumanCapdbyEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.Unemp<=Panel.UI_yn),Panel.Age(Panel.UnempInd==1&Panel.Unemp<=Panel.UI_yn),'mean',UnempOpts);
p3 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.Unemp>Panel.UI_yn),Panel.Age(Panel.UnempInd==1&Panel.Unemp>Panel.UI_yn),'mean',UnempNoUIOpts);
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('HumanCapbyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

ModelCompOpts.CI_yn = 'n';

% Productivity, Productivity Shares
% Productivity Lost to Unemployment, Productivity Lost to HC Accum

if opts.II == 'n'

f01=figure('name','Prod');
p = GrpStatsPlotFun(Panel.Prod,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Average Productivity')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('Prod_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

if opts.II == 'n'

    f01=figure('name','ProdEmp');
    p = GrpStatsPlotFun(Panel.Prod(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Average Productivity')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProdEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ProdUnemp');
    p = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Average Productivity')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProdUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

end

if opts.II == 'n'

f01=figure('name','ProdbyEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.Prod(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.Prod(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
xlabel('Age')
ylabel('Average Productivity')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ProdbyEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    Panel.FirmPieceRate = (1 - Panel.PieceRateShare).*Panel.Prod;

    f01=figure('name','ProductivityShares');
    hold on;
    p1 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',ModelCompOpts);
    p2 = GrpStatsPlotFun(Panel.FirmPieceRate(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',DataCompOpts);
    xlabel('Age')
    ylabel('Average Productivity')
    hleg1 = legend([p1,p2],'Worker Share','Firm Share');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProductivityShares_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Net Wealth, Net Wealth of the Employed, Net Wealth of Unemployed

ModelCompOpts.CI_yn = 'y';

f01=figure('name','RLiqWealth');
p = GrpStatsPlotFun(Panel.RLiqWealth,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Net Wealth')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('RLiqWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

if opts.II == 'n'

    f01=figure('name','RLiqWealthEmp');
    p = GrpStatsPlotFun(Panel.RLiqWealth(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Net Wealth')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('RLiqWealthEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','RLiqWealthUnemp');
    p = GrpStatsPlotFun(Panel.RLiqWealth(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Net Wealth')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('RLiqWealthUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

end

f01=figure('name','ProdbyEmpStat');
hold on;
p1 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
xlabel('Age')
ylabel('Net Wealth')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ProdbyEmpStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% Employment Rate, Unemployment Rate, Percent Covered by UI

f01=figure('name','EmpRate');
p = GrpStatsPlotFun(Panel.EmpInd,Panel.Age,'mean',EmpOpts);
xlabel('Age')
ylabel('Rate')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('EmpRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','UnempRate');
p = GrpStatsPlotFun(Panel.UnempInd,Panel.Age,'mean',UnempOpts);
xlabel('Age')
ylabel('Rate')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('UnempRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','UI_yn');
p = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1)./4,Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
xlabel('Age')
ylabel('Percent with UI')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('UI_yn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% Average weekly UI, replacement rate

if opts.II == 'n'    
    
% Panel.wbaAvg = (Panel.UIAmt./Panel.UnempDur)./13;
% Panel.lastwage = Panel.RInc;
% Panel.lastwage(Panel.UnempInd==1) = NaN;
% lastwage = reshape(Panel.lastwage,T/freq,N);
% lastwage = fillmissing(lastwage,'previous');
% Panel.lastwage = reshape(lastwage.',[],1);
% Panel.RepRate = (Panel.wbaAvg.*52)./Panel.lastwage;
% 
% f01=figure('name','wbaAvg');
% p = GrpStatsPlotFun(Panel.wbaAvg(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
% xlabel('Age')
% ylabel('Weekly Average')
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);
% 
% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('wbaAvg_',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% hold off;
% 
% f01=figure('name','ProdbyEmp');
% p = GrpStatsPlotFun(Panel.RepRate(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
% xlabel('Age')
% ylabel('Ratio')
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);
% 
% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('ProdbyEmp_',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% hold off;

% Average Tenure among Employed and Overall

f01=figure('name','TenAll');
hold on;
p1 = GrpStatsPlotFun(Panel.Tenure(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.Tenure,Panel.Age,'mean',ModelCompOpts);
xlabel('Age')
ylabel('Quarters')
hleg1 = legend([p1,p2],'Tenure Among Employed','Overall Tenure');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('TenAll_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','TenEmp');
    p = GrpStatsPlotFun(Panel.Tenure(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Quarters')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('RLiqWealthEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

end

% Average Experience Overall
% Average Unemployment Duration

if opts.II == 'n'

    f01=figure('name','UnempDur');
    p = GrpStatsPlotFun(52.*Panel.UnempDur(Panel.UnempDur>0),Panel.Age(Panel.UnempDur>0),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Average Unemployment Duration')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('UnempDur_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

ModelCompOpts.CI_yn = 'n';

if opts.II == 'n'
% Productivity Shocks

    f01=figure('name','ProdShocks');
    p = GrpStatsPlotFun(Panel.ZZProdShocks,Panel.Age,'mean',ModelCompOpts);
    xlabel('Age')
    ylabel('Productivity Lost')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProdShocks_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ProdShocksEmp');
    p = GrpStatsPlotFun(Panel.ZZProdShocks(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Productivity Lost')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProdShocksEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ProdShocksUnemp');
    p = GrpStatsPlotFun(Panel.ZZProdShocks(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Productivity Lost')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ProdShocksUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

% Consumption

    ModelCompOpts.CI_yn = 'y';
    
    f01=figure('name','Cons');
    p = GrpStatsPlotFun(Panel.Cons,Panel.Age,'mean',ModelCompOpts);
    xlabel('Age')
    ylabel('Consumption')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Cons_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    
    f01=figure('name','ConsbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.Cons,Panel.Age,'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.RLiqWealth,Panel.Age,'mean',UnempOpts);
    xlabel('Age')
    ylabel('Amount')
    hleg1 = legend([p1,p2],'Consumption','Net Wealth');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ConsWealthProfiles_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ConsEmp');
    p = GrpStatsPlotFun(Panel.Cons(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Consumption')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ConsEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ConsUnemp');
    p = GrpStatsPlotFun(Panel.Cons(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Consumption')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ConsUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ConsbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.Cons(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.Cons(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Consumption')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ConsbyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

% Marginal Propensity to Consume by Employment Status

    ModelCompOpts.CI_yn = 'n';
    
    f01=figure('name','MPC');
    p = GrpStatsPlotFun(Panel.MPC,Panel.Age,'mean',ModelCompOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPC_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCEmp');
    p = GrpStatsPlotFun(Panel.MPC(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCUnemp');
    p = GrpStatsPlotFun(Panel.MPC(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.MPC(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.MPC(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCbyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

% Marginal Utility of Consumption by Employment Status

    Panel.MargUtil = Panel.Cons.^(-ssigma);

    f01=figure('name','MargUtil');
    p = GrpStatsPlotFun(Panel.MargUtil,Panel.Age,'mean',EmpOpts);
    xlabel('Age')
    ylabel('Marginal Utility')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MargUtil_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MargUtilEmp');
    p = GrpStatsPlotFun(Panel.MargUtil(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Marginal Utility')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MargUtilEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MargUtilUnemp');
    p = GrpStatsPlotFun(Panel.MargUtil(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Utility')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MargUtilUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MargUtilbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.MargUtil(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.MargUtil(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Utility')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MargUtilbyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

% Marginal Propensity to Consume out of Budget by Employment Status

    f01=figure('name','MPCB');
    p = GrpStatsPlotFun(Panel.MPCB,Panel.Age,'mean',EmpOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume from Budget')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCB_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCBEmp');
    p = GrpStatsPlotFun(Panel.MPCB(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume from Budget')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCBEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCBUnemp');
    p = GrpStatsPlotFun(Panel.MPCB(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume from Budget')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCBUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','MPCBbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.MPCB(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.MPCB(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Marginal Propensity to Consume from Budget')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MPCBbyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;
end

% Skewness: Mean/Median of Earnings, HC, Wealth, Productivity

ModelCompOpts.CI_yn = 'n';

[AveInc] = grpstats(Panel.LRIncHVY_3(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),{'mean'});
[MedInc] = grpstats(Panel.LRIncHVY_3(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),{@median});
[AgeSeries] = grpstats(Panel.Age(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),{'mean'});


f01=figure('name','LRIncHVY_3_Skewness');
p = plot(AgeSeries,AveInc./MedInc,'color',ModelCompOpts.Color);
hold on;
xlabel('Age')
ylabel('Annual Earnings Skewness')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_Skewness_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

if opts.II == 'n'

    f01=figure('name','HumanCap_Skewness');
    p = GrpStatsPlotFun(Panel.HumanCap,Panel.Age,@skewness,ModelCompOpts);
    xlabel('Age')
    ylabel('Human Capital Skewness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('HumanCap_Skewness_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','RLiqWealth_Skewness');
    p = GrpStatsPlotFun(Panel.RLiqWealth,Panel.Age,@skewness,ModelCompOpts);
    xlabel('Age')
    ylabel('Human Capital Skewness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('RLiqWealth_Skewness_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','Prod_Skewness');
    p = GrpStatsPlotFun(Panel.Prod,Panel.Age,@skewness,ModelCompOpts);
    xlabel('Age')
    ylabel('Productivity Skewness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Prod_Skewness_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
end

% Gini Coefficient of Earnings, HC, Wealth, Productivity



%%Life-Cycle Wage Growth Decomposition Profiles and Decision Rules:


Panel.LnMU = log(Panel.PieceRateShare.*w0);
Panel.LnHumanCap = log(Panel.HumanCap);
Panel.LnProdTime = log(1 - Panel.LearnTime);
Panel.LnLearnTime = log(Panel.LearnTime);
DecompProfile = grpstats(Panel(Panel.EmpInd==1,:),{'Age'},{'mean'},'DataVars',{'LnMU','LnHumanCap','LRInc'});
DecompVarProfile = grpstats(Panel(Panel.EmpInd==1&Panel.HVYInd==1,:),{'Age'},{'nancov'},'DataVars',{'LnMU','LnHumanCap','LnProdTime','LRInc'});
DecompVarProfileNoLearn = grpstats(Panel(Panel.EmpInd==1&Panel.HVYInd==1,:),{'Age'},{'var'},'DataVars',{'LnMU','LnHumanCap','LRWage'});
MUProfile = DecompProfile.mean_LnMU.*DecompProfile.mean_LnHumanCap(1);
HCProfile = DecompProfile.mean_LnMU(1).*DecompProfile.mean_LnHumanCap;
GrowthSourceProfile = MUProfile - HCProfile;
MUVarProfile = DecompVarProfile.nancov_LnMU;
HCVarProfile = DecompVarProfile.nancov_LnHumanCap;
TimeVarProfile = DecompVarProfile.nancov_LnProdTime;
LRIncVarProfile = DecompVarProfile.nancov_LRInc;

CovMUHC = [];
CovMUTime = [];
CovHCTime = [];

for i = 23:64
    tempMUHC = nancov(Panel.LnMU(Panel.EmpInd==1&Panel.Age==i),Panel.LnHumanCap(Panel.EmpInd==1&Panel.Age==i));
    CovMUHC = cat(2,CovMUHC,tempMUHC(1,2));
    tempMUTime = nancov(Panel.LnMU(Panel.EmpInd==1&Panel.Age==i),Panel.LnLearnTime(Panel.EmpInd==1&Panel.Age==i));
    CovMUTime = cat(2,CovMUTime,tempMUTime(1,2));
    tempHCTime = nancov(Panel.LnHumanCap(Panel.EmpInd==1&Panel.Age==i),Panel.LnLearnTime(Panel.EmpInd==1&Panel.Age==i));
    CovHCTime = cat(2,CovHCTime,tempHCTime(1,2));
end


MUProfile = DecompProfile.mean_LnMU.*DecompProfile.mean_LnHumanCap(1);
HCProfile = DecompProfile.mean_LnMU(1).*DecompProfile.mean_LnHumanCap;
GrowthSourceProfile = MUProfile - HCProfile;
MUVarProfileNoLearn = DecompVarProfileNoLearn.var_LnMU;
HCVarProfileNoLearn = DecompVarProfileNoLearn.var_LnHumanCap;
LRIncVarProfileNoLearn = DecompVarProfileNoLearn.var_LRWage;
CovMUHCNoLearn = 2*(LRIncVarProfileNoLearn - MUVarProfileNoLearn - HCVarProfileNoLearn);


if opts.II == 'n'

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = plot(23:64,MUProfile,'color','blue','LineStyle','--');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Piece Rate Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDecomp1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = plot(23:64,HCProfile,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDecomp2_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = plot(23:64,MUProfile,'color','blue','LineStyle','--');
p3 = plot(23:64,HCProfile,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'Profile','Piece Rate Growth','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDecomp3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfileNoLearn,'color','blue','LineStyle','--');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Piece Rate Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp1NoLearn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,HCVarProfileNoLearn,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp2NoLearn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfileNoLearn,'color','blue','LineStyle','--');
p3 = plot(23:64,HCVarProfileNoLearn,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'Profile','Piece Rate Growth','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp3NoLearn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfileNoLearn,'color','blue','LineStyle','--');
p3 = plot(23:64,HCVarProfileNoLearn,'color','red','LineStyle','-.');
p4 = plot(23:64,CovMUHCNoLearn,'color','black','LineStyle',':');
xlabel('Age')
ylabel('Var(log earnings)')
hleg1 = legend([p1,p2,p3,p4],'Profile','Piece Rate','Human Capital','Covariance');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp4NoLearn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1&Panel.Age>=25,:),Panel.Age(Panel.EmpInd==1&Panel.Age>=25,:),'var',EmpOpts);
p2 = plot(25:64,MUVarProfileNoLearn(3:end),'color','blue','LineStyle','--');
p3 = plot(25:64,HCVarProfileNoLearn(3:end),'color','red','LineStyle','-.');
p4 = plot(25:64,CovMUHCNoLearn(3:end),'color','black','LineStyle',':');
xlabel('Age')
ylabel('Var(log earnings)')
hleg1 = legend([p1,p2,p3,p4],'Profile','Piece Rate','Human Capital','Covariance');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecompPaperNoLearn_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfile,'color','blue','LineStyle','--');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Piece Rate Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,HCVarProfile,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2],'Profile','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp2_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfile,'color','blue','LineStyle','--');
p3 = plot(23:64,HCVarProfile,'color','red','LineStyle','-.');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'Profile','Piece Rate Growth','Human Capital Growth');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'var',EmpOpts);
p2 = plot(23:64,MUVarProfile,'color','blue','LineStyle','--');
p3 = plot(23:64,HCVarProfile,'color','red','LineStyle','-.');
p4 = plot(23:64,CovMUHC,'color','black','LineStyle',':');
xlabel('Age')
ylabel('Var(log earnings)')
hleg1 = legend([p1,p2,p3,p4],'Profile','Piece Rate','Human Capital','Covariance');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecomp4_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.EmpInd==1&Panel.Age>=25,:),Panel.Age(Panel.EmpInd==1&Panel.Age>=25,:),'var',EmpOpts);
p2 = plot(25:64,MUVarProfile(3:end),'color','blue','LineStyle','--');
p3 = plot(25:64,HCVarProfile(3:end),'color','red','LineStyle','-.');
p4 = plot(25:64,CovMUHC(3:end),'color','black','LineStyle',':');
xlabel('Age')
ylabel('Var(log earnings)')
hleg1 = legend([p1,p2,p3,p4],'Profile','Piece Rate','Human Capital','Covariance');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncVarDecompPaper_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% MU, MU_3, MUHVY_3

f01=figure('name','MU');
p = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
xlabel('Age')
ylabel('Piece Rate')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('MU_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

if opts.II == 'n'

f01=figure('name','MU');
hold on;
p1 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p2 = scatter(Panel.Age(Panel.EmpInd==1),Panel.PieceRateShare(Panel.EmpInd==1),25,'MarkerEdgeColor',ModelCompOpts.Color);
xlabel('Age')
ylabel('Piece Rate')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('MU_scatter_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;

end

if opts.II == 'n'

    f01=figure('name','MW');
    p = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Scaled Piece Rate')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('MW_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

end

% Application Strategy Aggregated, Application Strategy by Employment State and UI Status

f01=figure('name','ApplicationStrategy');
p = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
xlabel('Age')
ylabel('Application Strategy')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ApplicationStrategy_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

if opts.II == 'n'

    f01=figure('name','ApplicationStrategyEmp');
    p = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ApplicationStrategyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyUnemp');
    p = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ApplicationStrategyUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyUnemp');
    p = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ApplicationStrategyUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2],'UI','No UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ApplicationStrategybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('ApplicationStrategybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ApplicationStrategybyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% Employment Probabilities Aggregated, Employment Probabilities by Employment State and UI Status

if opts.II == 'n'

f01=figure('name','EmploymentProbability');
p = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
xlabel('Age')
ylabel('Job Finding Rate')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('EmploymentProbability_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

if opts.II == 'n'

    f01=figure('name','EmploymentProbabilityEmp');
    p = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilityEmp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','EmploymentProbabilityUnemp');
    p = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilityUnemp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','EmploymentProbabilityUnemp');
    p = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilityUnemp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','EmploymentProbabilitybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2],'UI','No UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilitybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;
    hold off;

    f01=figure('name','EmploymentProbabilitybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilitybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;
    hold off;
end


f01=figure('name','EmploymentProbabilitybyEmpUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('EmploymentProbabilitybyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% Submarket Tightness Aggregated, Submarket Tightness by Employment State and UI Status

if opts.II == 'n'

f01=figure('name','SubmarketTightness');
p = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
xlabel('Age')
ylabel('Submarket Tightness')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('SubmarketTightness_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

if opts.II == 'n'

    f01=figure('name','SubmarketTightnessEmp');
    p = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Submarket Tightness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessEmp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','SubmarketTightnessUnemp');
    p = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Submarket Tightness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessUnemp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','SubmarketTightnessUnemp');
    p = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Submarket Tightness')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessUnemp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','SubmarketTightnessbyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
    p2 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
    xlabel('Age')
    ylabel('Submarket Tightness')
    hleg1 = legend([p1,p2],'UI','No UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessbyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;
    hold off;

    f01=figure('name','SubmarketTightnessbyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
    p2 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1),Panel.Age(Panel.UnempInd==1),'mean',UnempOpts);
    xlabel('Age')
    ylabel('Submarket Tightness')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessbyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;
    hold off;
end


f01=figure('name','SubmarketTightnessbyEmpUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),Panel.Age(Panel.EmpInd==1&Panel.ApplicationStrategy>Panel.PieceRateShare),'mean',EmpOpts);
p2 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),'mean',UnempOpts);
p3 = GrpStatsPlotFun(Panel.SubmarketTightness(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),'mean',UnempNoUIOpts);
ylabel('Submarket Tightness')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('SubmarketTightnessbyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

% TW, TW_3, TWHVY_3 - Conditioning on Employment

f01=figure('name','LearnTimeEmpEmp');
p = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
xlabel('Age')
ylabel('Fraction of Time Learning')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LearnTimeEmpEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','LearnTimeEmpEmp');
hold on;
p = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
p = scatter(Panel.Age(Panel.EmpInd==1),Panel.LearnTimeEmp(Panel.EmpInd==1),25,'MarkerEdgeColor',ModelCompOpts.Color);
xlabel('Age')
ylabel('Fraction of Time Learning')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LearnTimeEmpEmp_scatter_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;
close;

if opts.II == 'n'
    
    ModelCompOpts.CI_yn = 'y';

    f01=figure('name','LearnTimeEmp');
    p = GrpStatsPlotFun(Panel.LearnTimeEmp,Panel.Age,'mean',ModelCompOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnTimeEmp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;


    f01=figure('name','LearnTimeProd');
    p = GrpStatsPlotFun(Panel.LearnTimeProd,Panel.Age,'mean',ModelCompOpts);
    xlabel('Age')
    ylabel('Productivity Lost from Learning')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnTimeProd_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

    f01=figure('name','LearnTimeProdEmp');
    p = GrpStatsPlotFun(Panel.LearnTimeProd(Panel.EmpInd==1),Panel.Age(Panel.EmpInd==1),'mean',EmpOpts);
    xlabel('Age')
    ylabel('Productivity Lost from Learning')
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnTimeProdEmp_',plotopts));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    close;

end

% Growth Rates of MU, MU_3, MUHVY_3
% Growth Rates of TW, TW_3, TWHVY_3
% Growth Rates of HH - Employed and Unemployed
% Shocks to HH for Employed and Unemployed
% Growth Rates of AA for Employed and Unemployed

%Histograms:
% Marginal Distributions of Wealth, Human Capital, Learning Ability

f01=figure('name','RLiqWealthDist');
hold on;
p1 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.RLiqWealth<200000),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(init_assets,100,'Normalization','probability','FaceColor',DataCompOpts.Color,'EdgeColor',DataCompOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Wealth')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('RLiqWealthDistCompare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','RLiqWealthDist');
hold on;
p1 = histogram(Panel.LRInc(Panel.Age<=24),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(init_earnings,100,'Normalization','probability','FaceColor',DataCompOpts.Color,'EdgeColor',DataCompOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Log Earnings')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Model','Data');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRIncDistCompare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','RLiqWealthDist');
p = histogram(Panel.RLiqWealth(Panel.Age==23),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color);
xlabel('Wealth')
ylabel('Distribution')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('RLiqWealthDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','HumanCapDist');
p = histogram(Panel.HumanCap(Panel.Age==23),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color);
xlabel('Human Capital')
ylabel('Distribution')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('HumanCapDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','LearnAbDist');
p = histogram(Panel.LearnAb(Panel.Age==23),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color);
xlabel('Learning Ability')
ylabel('Distribution')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LearnAbDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

% Initial Conditions Scatter Plots

% if opts.II == 'n'
% 
% f01=figure('name','earnings_profiles');
% scatter(AAscaled,HHscaled,sz,'filled','MarkerFaceColor',ModelCompOpts.Color);
% xlabel('Initial Net Wealth Pctile')
% ylabel('Initial Human Capital Pctile')
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);
% 
% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('AAHH_initcondcorr_',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% 
% f01=figure('name','earnings_profiles');
% scatter(AAscaled,LLscaled,sz,'filled','MarkerFaceColor',ModelCompOpts.Color);
% xlabel('Initial Net Wealth Pctile')
% ylabel('Initial Learning Pctile')
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);
% 
% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('AALL_initcondcorr_',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% 
% f01=figure('name','earnings_profiles');
% scatter(HHscaled,LLscaled,sz,'filled','MarkerFaceColor',ModelCompOpts.Color);
% xlabel('Initial Human Capital Pctile')
% ylabel('Initial Learning Pctile')
% myfiguresize=[0,0,4,4];
% set(gcf, 'PaperPosition', myfiguresize);
% 
% set(gca, ...
%   'GridLineStyle'         , '--'     , ...
%   'Box'         , 'off'     , ...
%   'TickDir'     , 'out'     , ...
%   'TickLength'  , [.02 .02] , ...
%   'XMinorTick'  , 'on'      , ...
%   'YMinorTick'  , 'on'      , ...
%   'XGrid'       , 'on'      , ...
%   'YGrid'       , 'on'      , ...
%   'XColor'      , [.3 .3 .3], ...
%   'YColor'      , [.3 .3 .3], ...
%   'LineWidth'   , 1         );
% figfile = fullfile(results_graphics_path,strcat('HHLL_initcondcorr_',plotopts));
% saveas(gcf,figfile,'png');
% if opts.II == 'n'
%     saveas(gcf,figfile,'epsc');
% end
% close;
% 
% end

% Initial Decision Rules Aggregated and by Employment Status

if opts.II == 'n'

f01=figure('name','ApplicationStrategyDist');
p = histogram(Panel.ApplicationStrategy(Panel.Age<=24),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color);
xlabel('Application Strategy')
ylabel('Distribution')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ApplicationStrategyDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','ApplicationStrategybyEmpStat');
hold on
p1 = histogram(Panel.ApplicationStrategy(Panel.EmpInd==1),100,'Normalization','probability','FaceColor',EmpOpts.Color,'EdgeColor',EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.UnempInd==1),100,'Normalization','probability','FaceColor',UnempOpts.Color,'EdgeColor',UnempOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ApplicationStrategybyEmpStatDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on
p1 = histogram(Panel.ApplicationStrategy(Panel.EmpInd==1),100,'Normalization','probability','FaceColor',EmpOpts.Color,'EdgeColor',EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',UnempOpts.Color,'EdgeColor',UnempOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',UnempNoUIOpts.Color,'EdgeColor',UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('ApplicationStrategybyEmpUIStatDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','LearnTimeEmpDist');
p = histogram(Panel.LearnTimeEmp(Panel.Age<=24),100,'Normalization','probability','FaceColor',ModelCompOpts.Color,'EdgeColor',ModelCompOpts.Color);
xlabel('Fraction of Time Learning')
ylabel('Distribution')
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LearnTimeEmpDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

% Decision Rules by Employment Status and UI status


%%Plots by Initial Conditions
%Life-Cycle Profiles:
% Repeat the above Stratifying by 10th, 50th, 90th in Wealth, Human Capital, and Learning Ability
% LRInc, LRInc_3, LRIncHVY_3 - Compared with PSID/NLSY

if opts.II == 'n'

f01=figure('name','WealthLLRInc_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLRInc_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','WealthLLRIncHVY_3_compare');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLRIncHVY_3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

slope_wealth_moments = tabconv(fullfile(opts.project_path,opts.input_path,'SlopesRLiqWealthOLogitUncondPSID.csv'),'n');

DataYoung = DataAge;
DataYoung(DataYoung<=40) = 1;
DataYoung(DataYoung>40) = 0;
DataOld = ones(size(DataYoung));
DataOld = DataOld - DataYoung;

WealthEarningsRegression10 = repmat(slope_wealth_moments(end),1,30) + (slope_wealth_moments(1) + slope_wealth_moments(15).*DataOld).*DataAge + slope_wealth_moments(10).*DataOld;

WealthEarningsRegression50 = repmat(slope_wealth_moments(end),1,30) + (slope_wealth_moments(1) + slope_wealth_moments(7) + slope_wealth_moments(17).*DataOld).*DataAge + slope_wealth_moments(3) + slope_wealth_moments(12).*DataOld;
WealthEarningsRegression90 = repmat(slope_wealth_moments(end),1,30) + (slope_wealth_moments(1) + slope_wealth_moments(9) + slope_wealth_moments(19).*DataOld).*DataAge + slope_wealth_moments(5) + slope_wealth_moments(14).*DataOld;

f01=figure('name','WealthLRIncHVY_3_compareSlopes');
hold on;
p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==1,:),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==3,:),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.RLiqWealth_qtile==5,:),'mean',Q5EmpOpts);
p4 = plot(DataAge(DataYoung==1),WealthEarningsRegression10(DataYoung==1),'color',Q1EmpOpts.Color,'LineStyle','--');
p5 = plot(DataAge(DataOld==1),WealthEarningsRegression10(DataOld==1),'color',Q1EmpOpts.Color,'LineStyle','--');
p6 = plot(DataAge(DataYoung==1),WealthEarningsRegression50(DataYoung==1),'color',Q3EmpOpts.Color,'LineStyle','--');
p7 = plot(DataAge(DataOld==1),WealthEarningsRegression50(DataOld==1),'color',Q3EmpOpts.Color,'LineStyle','--');
p8 = plot(DataAge(DataYoung==1),WealthEarningsRegression90(DataYoung==1),'color',Q5EmpOpts.Color,'LineStyle','--');
p9 = plot(DataAge(DataOld==1),WealthEarningsRegression90(DataOld==1),'color',Q5EmpOpts.Color,'LineStyle','--');
xlabel('Age')
ylabel('Log Annual Earnings')
hleg1 = legend([p1,p4,p2,p6,p3,p8],'1st','10th (Age-Reg Ests.)','3rd','50th (Age-Reg Ests.)','5th','90th (Age-Reg Ests.)');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthMomentsLRIncHVY_3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'
    f01=figure('name','LearnLLRInc_compare');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.Learn_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==1,:),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.Learn_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==3,:),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.Learn_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==5,:),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnLRInc_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','LearnLLRIncHVY_3_compare');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==1,:),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==3,:),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==5,:),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnLRIncHVY_3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;
    
slope_ability_moments = tabconv(fullfile(opts.project_path,opts.input_path,'SlopesAFQTUncondNLSY.csv'),'n');

DataYoung = DataAge;
DataYoung(DataYoung<=40) = 1;
DataYoung(DataYoung>40) = 0;
DataOld = ones(size(DataYoung));
DataOld = DataOld - DataYoung;

AbilityEarningsRegression10 = repmat(slope_ability_moments(end),1,30) + (slope_ability_moments(1) + slope_ability_moments(15).*DataOld).*DataAge + slope_ability_moments(10).*DataOld;

AbilityEarningsRegression50 = repmat(slope_ability_moments(end),1,30) + (slope_ability_moments(1) + slope_ability_moments(7) + slope_ability_moments(17).*DataOld).*DataAge + slope_ability_moments(3) + slope_ability_moments(12).*DataOld;
AbilityEarningsRegression90 = repmat(slope_ability_moments(end),1,30) + (slope_ability_moments(1) + slope_ability_moments(9) + slope_ability_moments(19).*DataOld).*DataAge + slope_ability_moments(5) + slope_ability_moments(14).*DataOld;
    
    f01=figure('name','LearnLLRIncHVY_3_compareSlopes');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==1,:),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==3,:),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.Learn_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.Learn_qtile==5,:),'mean',Q5EmpOpts);
    p4 = plot(DataAge(DataYoung==1),AbilityEarningsRegression10(DataYoung==1),'color',Q1EmpOpts.Color,'LineStyle','--');
    p5 = plot(DataAge(DataOld==1),AbilityEarningsRegression10(DataOld==1),'color',Q1EmpOpts.Color,'LineStyle','--');
    p6 = plot(DataAge(DataYoung==1),AbilityEarningsRegression50(DataYoung==1),'color',Q3EmpOpts.Color,'LineStyle','--');
    p7 = plot(DataAge(DataOld==1),AbilityEarningsRegression50(DataOld==1),'color',Q3EmpOpts.Color,'LineStyle','--');
    p8 = plot(DataAge(DataYoung==1),AbilityEarningsRegression90(DataYoung==1),'color',Q5EmpOpts.Color,'LineStyle','--');
    p9 = plot(DataAge(DataOld==1),AbilityEarningsRegression90(DataOld==1),'color',Q5EmpOpts.Color,'LineStyle','--');
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p4,p2,p6,p3,p8],'1st','10th (Data Age-Regs)','3rd','50th (Data Age-Regs)','5th','90th (Data Age-Regs)');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnMomentsLRIncHVY_3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;    

    f01=figure('name','AFQTLLRInc_compare');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.AFQT_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==1,:),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.AFQT_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==3,:),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LRInc(Panel.Age>=25&Panel.AFQT_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==5,:),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTLRInc_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','AFQTLLRIncHVY_3_compare');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.AFQT_qtile==1,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==1,:),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.AFQT_qtile==3,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==3,:),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LRIncHVY_3(Panel.Age>=25&Panel.AFQT_qtile==5,:),Panel.Age(Panel.Age>=25&Panel.AFQT_qtile==5,:),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTLRIncHVY_3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;
end

% Budget Allocation

Panel.Budget = Panel.RInc + (1 + r).*Panel.RLiqWealth + Panel.UIAmt;
Panel.Savings = Panel.Budget - Panel.Cons;
Panel.PotentialBudget = Panel.RInc + Panel.LearnTimeProd + (1 + r).*Panel.RLiqWealth + Panel.UIAmt;
Panel.HumanCapAllocation = Panel.LearnTimeProd./Panel.Budget;
Panel.SavingsAllocation = Panel.Savings./Panel.Budget;
Panel.SavingsGrowth = (Panel.Savings./Panel.RLiqWealth - 1)*100;
Panel.SavingsRate = (Panel.Savings./Panel.RInc)*100;
Panel.HumanCapSavingsRate = (Panel.LearnTimeProd./Panel.RInc)*100;

if opts.II == 'n'

f01=figure('name','HumanCapAllocation');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCapAllocation(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCapAllocation(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.HumanCapAllocation(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital Portfolio Allocation')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthHumanCapAllocation_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','SavingsAllocation');
hold on;
p1 = GrpStatsPlotFun(Panel.SavingsAllocation(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.SavingsAllocation(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.SavingsAllocation(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Savings Portfolio Allocation')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealthAllocation_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','SavingsGrowth');
hold on;
p1 = GrpStatsPlotFun(Panel.SavingsGrowth(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.SavingsGrowth(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.SavingsGrowth(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Savings Portfolio Growth')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealthGrowth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','SavingsRate');
hold on;
p1 = GrpStatsPlotFun(Panel.SavingsRate(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.SavingsRate(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.SavingsRate(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Savings Portfolio Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealthRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','HumanCapSavingsRate');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCapSavingsRate(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCapSavingsRate(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.HumanCapSavingsRate(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital Portfolio Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealthHumanCapRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


end


% HC, HCEmp, HCUnemp

if opts.II == 'n'

f01=figure('name','HumanCap');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.HumanCap(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthHumanCap_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'
    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Wealth1HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Wealth3HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Wealth5HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

if opts.II == 'n'

f01=figure('name','HumanCap');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.HumanCap(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('AFQTHumanCap_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQT1HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQT3HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQT5HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

if opts.II == 'n'

f01=figure('name','HumanCap');
hold on;
p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.HumanCap(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LearnHumanCap_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

if opts.II == 'n'

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Learn1HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Learn3HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapdbyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.HumanCap(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    p2 = GrpStatsPlotFun(Panel.HumanCap(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('Learn5HumanCapbyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Net Wealth, Net Wealth of the Employed, Net Wealth of Unemployed

if opts.II == 'n'

f01=figure('name','RLiqWealth');
hold on;
p1 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Net Wealth')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealth_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Net Wealth')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTRLiqWealth_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.RLiqWealth(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Net Wealth')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnRLiqWealth_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;
end

% Employment Rate, Unemployment Rate, Percent Covered by UI

if opts.II == 'n'

f01=figure('name','RLiqWealth');
hold on;
p1 = GrpStatsPlotFun(Panel.EmpInd(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmpInd(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.EmpInd(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Employment Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmpRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmpInd(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmpInd(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmpInd(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Employment Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmpRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmpInd(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmpInd(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmpInd(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Employment Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmpRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

if opts.II == 'n'

f01=figure('name','RLiqWealth');
hold on;
p1 = GrpStatsPlotFun(Panel.UnempInd(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.UnempInd(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.UnempInd(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Unemployment Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthUnempRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.UnempInd(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.UnempInd(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.UnempInd(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Unemployment Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTUnempRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.UnempInd(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.UnempInd(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.UnempInd(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Unemployment Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnUnempRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

if opts.II == 'n'

f01=figure('name','RLiqWealth');
hold on;
p1 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Human Capital')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthUICovRate_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTUICovRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','RLiqWealth');
    hold on;
    p1 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.UI_yn(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Human Capital')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnUICovRate_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Average weekly UI, replacement rate
% Average Tenure among Employed and Overall
% Average Experience Overall
% Average Unemployment Duration
% Productivity, Productivity Shares
% Productivity Lost to Unemployment, Productivity Lost to HC Accum
% Productivity Shocks
% Consumption, MPC, Marginal Utility
% Skewness: Mean/Median of Earnings, HC, Wealth, Productivity
% Gini Coefficient of Earnings, HC, Wealth, Productivity

%Life-Cycle Wage Growth Decomposition Profiles:
% Repeat the above Stratifying by 10th, 50th, 90th in Wealth, Human Capital, and Learning Ability
% MU, MU_3, MUHVY_3

if opts.II == 'n'

f01=figure('name','PieceRateShareEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthPieceRateShareEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','PieceRateShareEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTPieceRateShareEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','PieceRateShareEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.PieceRateShare(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnPieceRateShareEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

if opts.II == 'n'

f01=figure('name','PieceRateEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthPieceRateEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','PieceRateEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTPieceRateEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','PieceRateEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.PieceRate(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnPieceRateEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end


% Application Strategy Aggregated, Application Strategy by Employment State and UI Status

if opts.II == 'n'

f01=figure('name','ApplicationStrategy');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategy_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','ApplicationStrategyEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategyEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','ApplicationStrategyUnemp');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategyUnemp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','ApplicationStrategybyUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempNoUIOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempNoUIOpts);
p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempNoUIOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','ApplicationStrategybyEmpStat');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
xlabel('Age')
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempNoUIOpts);
p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempNoUIOpts);
p7 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
p8 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
p9 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempNoUIOpts);
ylabel('Application Strategy')
hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','ApplicationStrategy');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategy_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategyUnemp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategyUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','ApplicationStrategybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempNoUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempNoUIOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempNoUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempNoUIOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempNoUIOpts);
    p7 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    p8 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    p9 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempNoUIOpts);
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategy');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategy_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategyEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategyUnemp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategyUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','ApplicationStrategybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempNoUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempNoUIOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempNoUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempNoUIOpts);
    p4 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p5 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempNoUIOpts);
    p7 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.EmpInd==1&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    p8 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    p9 = GrpStatsPlotFun(Panel.ApplicationStrategy(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempNoUIOpts);
    ylabel('Application Strategy')
    hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Employment Probabilities Aggregated, Employment Probabilities by Employment State and UI Status

if opts.II == 'n'

f01=figure('name','EmploymentProbability');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.RLiqWealth_qtile==1),Panel.Age(Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.RLiqWealth_qtile==3),Panel.Age(Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.RLiqWealth_qtile==5),Panel.Age(Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbability_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','EmploymentProbabilityEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbabilityEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','EmploymentProbabilityUnemp');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
xlabel('Age')
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbabilityUnemp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','EmploymentProbabilitybyUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempNoUIOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempNoUIOpts);
p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempNoUIOpts);
xlabel('Age')
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbabilitybyUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','EmploymentProbabilitybyEmpStat');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
xlabel('Age')
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbabilitybyEmpStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;


f01=figure('name','EmploymentProbabilitybyEmpUIStat');
hold on;
p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempUIOpts);
p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==1),'mean',Q1UnempNoUIOpts);
p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempUIOpts);
p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==3),'mean',Q3UnempNoUIOpts);
p7 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
p8 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempUIOpts);
p9 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5), ...
                Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.RLiqWealth_qtile==5),'mean',Q5UnempNoUIOpts);
ylabel('Job Finding Rate')
hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthEmploymentProbabilitybyEmpUIStat_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','EmploymentProbability');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.AFQT_qtile==1),Panel.Age(Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.AFQT_qtile==3),Panel.Age(Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.AFQT_qtile==5),Panel.Age(Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbability_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','EmploymentProbabilityEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbabilityEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','EmploymentProbabilityUnemp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbabilityUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','EmploymentProbabilitybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempNoUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempNoUIOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempNoUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbabilitybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','EmploymentProbabilitybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbabilitybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','EmploymentProbabilitybyEmpUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==1),'mean',Q1UnempNoUIOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==3),'mean',Q3UnempNoUIOpts);
    p7 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    p8 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempUIOpts);
    p9 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.AFQT_qtile==5),'mean',Q5UnempNoUIOpts);
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTEmploymentProbabilitybyEmpUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','EmploymentProbability');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.Learn_qtile==1),Panel.Age(Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.Learn_qtile==3),Panel.Age(Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.Learn_qtile==5),Panel.Age(Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbability_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','EmploymentProbabilityEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbabilityEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','EmploymentProbabilityUnemp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbabilityUnemp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','EmploymentProbabilitybyUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempNoUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempNoUIOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempNoUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'UI 10th','No UI 10th','UI 50th','No UI 50th','UI 90th','No UI 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbabilitybyUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','EmploymentProbabilitybyEmpStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.UnempInd==1&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    xlabel('Age')
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6],'E 10th','U 10th','E 50th','U 50th','E 90th','U 90th');
    set(hleg1,'Location','bestoutside');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbabilitybyEmpStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;


    f01=figure('name','EmploymentProbabilitybyEmpUIStat');
    hold on;
    p1 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempUIOpts);
    p3 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==1),'mean',Q1UnempNoUIOpts);
    p4 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p5 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempUIOpts);
    p6 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==3),'mean',Q3UnempNoUIOpts);
    p7 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.EmpInd==1&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    p8 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempUIOpts);
    p9 = GrpStatsPlotFun(Panel.EmploymentProbability(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5), ...
                    Panel.Age(Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)&Panel.Learn_qtile==5),'mean',Q5UnempNoUIOpts);
    ylabel('Job Finding Rate')
    hleg1 = legend([p1,p2,p3,p4,p5,p6,p7,p8,p9],'E 10th','UI 10th','no UI 10th','E 50th','UI 50th','no UI 50th','E 90th','UI 90th','no UI 90th');
    set(hleg1,'Location','bestoutside');
    myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnEmploymentProbabilitybyEmpUIStat_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% TW, TW_3, TWHVY_3 - Conditioning on Employment

if opts.II == 'n'

f01=figure('name','LearnTimeEmpEmp');
hold on;
p1 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==1),'mean',Q1EmpOpts);
p2 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==3),'mean',Q3EmpOpts);
p3 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.RLiqWealth_qtile==5),'mean',Q5EmpOpts);
xlabel('Age')
ylabel('Fraction of Time Learning')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,6,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLearnTimeEmpEmp_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'

    f01=figure('name','LearnTimeEmpEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.AFQT_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.AFQT_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.AFQT_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.AFQT_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTLearnTimeEmpEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','LearnTimeEmpEmp');
    hold on;
    p1 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.Learn_qtile==1),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==1),'mean',Q1EmpOpts);
    p2 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.Learn_qtile==3),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==3),'mean',Q3EmpOpts);
    p3 = GrpStatsPlotFun(Panel.LearnTimeEmp(Panel.EmpInd==1&Panel.Learn_qtile==5),Panel.Age(Panel.EmpInd==1&Panel.Learn_qtile==5),'mean',Q5EmpOpts);
    xlabel('Age')
    ylabel('Fraction of Time Learning')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,6,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnLearnTimeEmpEmp_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Growth Rates of MU, MU_3, MUHVY_3
% Growth Rates of TW, TW_3, TWHVY_3
% Growth Rates of HH - Employed and Unemployed
% Shocks to HH for Employed and Unemployed
% Growth Rates of AA for Employed and Unemployed

%Histograms:
% Marginal Distributions of Initial Conditions by the percentile of the other two

if opts.II == 'n'

f01=figure('name','LRIncDist');
hold on;
p1 = histogram(Panel.LRInc(Panel.Age==23&Panel.RLiqWealth_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.LRInc(Panel.Age<=24&Panel.RLiqWealth_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.LRInc(Panel.Age<=24&Panel.RLiqWealth_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Log Earnings')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLRIncDistCompare_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','RLiqWealthDist');
hold on;
p1 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.RLiqWealth_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.RLiqWealth_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.RLiqWealth_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Wealth')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthRLiqWealthDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','HumanCapDist');
hold on;
p1 = histogram(Panel.HumanCap(Panel.Age==23&Panel.RLiqWealth_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.HumanCap(Panel.Age==23&Panel.RLiqWealth_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.HumanCap(Panel.Age==23&Panel.RLiqWealth_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Human Capital')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthHumanCapDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','LearnAbDist');
hold on;
p1 = histogram(Panel.LearnAb(Panel.Age==23&Panel.RLiqWealth_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.LearnAb(Panel.Age==23&Panel.RLiqWealth_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.LearnAb(Panel.Age==23&Panel.RLiqWealth_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Learning Ability')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLearnAbDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

end

if opts.II == 'n'
    
    f01=figure('name','RLiqWealthDist');
    hold on;
    p1 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.AFQT_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.AFQT_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.AFQT_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Wealth')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTRLiqWealthDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapDist');
    hold on;
    p1 = histogram(Panel.HumanCap(Panel.Age==23&Panel.AFQT_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.HumanCap(Panel.Age==23&Panel.AFQT_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.HumanCap(Panel.Age==23&Panel.AFQT_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Human Capital')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTHumanCapDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','LearnAbDist');
    hold on;
    p1 = histogram(Panel.LearnAb(Panel.Age==23&Panel.AFQT_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.LearnAb(Panel.Age==23&Panel.AFQT_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.LearnAb(Panel.Age==23&Panel.AFQT_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Learning Ability')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTLearnAbDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','RLiqWealthDist');
    hold on;
    p1 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.Learn_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.Learn_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.RLiqWealth(Panel.Age==23&Panel.Learn_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Wealth')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnRLiqWealthDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','HumanCapDist');
    hold on;
    p1 = histogram(Panel.HumanCap(Panel.Age==23&Panel.Learn_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.HumanCap(Panel.Age==23&Panel.Learn_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.HumanCap(Panel.Age==23&Panel.Learn_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Human Capital')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnHumanCapDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','LearnAbDist');
    hold on;
    p1 = histogram(Panel.LearnAb(Panel.Age==23&Panel.Learn_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.LearnAb(Panel.Age==23&Panel.Learn_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.LearnAb(Panel.Age==23&Panel.Learn_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Learning Ability')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnLearnAbDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

end

% Initial Decision Rules Aggregated and by Initial Condition Percentile

if opts.II == 'n'

f01=figure('name','ApplicationStrategyDist');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.RLiqWealth_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.RLiqWealth_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.RLiqWealth_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategyDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off;

f01=figure('name','ApplicationStrategyDist');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategyDistbyEmpDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

f01=figure('name','ApplicationStrategyDist');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategyDistbyUnempDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpStatQ1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==1&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempNoUIOpts.Color,'EdgeColor',Q5UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpUIStatQ1_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpStatQ3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==3&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempNoUIOpts.Color,'EdgeColor',Q3UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpUIStatQ3_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off


f01=figure('name','ApplicationStrategybyEmpStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2],'Emp','Unemp');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpStatQ5_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','ApplicationStrategybyEmpUIStat');
hold on;
p1 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.ApplicationStrategy(Panel.RLiqWealth_qtile==5&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempNoUIOpts.Color,'EdgeColor',Q5UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Application Strategy')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthApplicationStrategybyEmpUIStatQ5_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;
hold off

f01=figure('name','LearnTimeEmpDist');
hold on;
p1 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.RLiqWealth_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p2 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.RLiqWealth_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
p3 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.RLiqWealth_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
xlabel('Fraction of Time Learning')
ylabel('Distribution')
hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
set(hleg1,'Location','best');
myfiguresize=[0,0,4,4];
set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('WealthLearnTimeEmpDist_',plotopts));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
close;

end

if opts.II == 'n'
    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.AFQT_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.AFQT_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.AFQT_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategyDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategyDistbyEmpDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategyDistbyUnempDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpStatQ1_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==1&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q1UnempNoUIOpts.Color,'EdgeColor',Q1UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpUIStatQ1_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpStatQ3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==3&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempNoUIOpts.Color,'EdgeColor',Q3UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpUIStatQ3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off


    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpStatQ5_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.AFQT_qtile==5&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempNoUIOpts.Color,'EdgeColor',Q5UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTApplicationStrategybyEmpUIStatQ5_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','LearnTimeEmpDist');
    hold on;
    p1 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.AFQT_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.AFQT_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.AFQT_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Fraction of Time Learning')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('AFQTLearnTimeEmpDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.Learn_qtile==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.Learn_qtile==3),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Age<=24&Panel.Learn_qtile==5),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategyDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off;

    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategyDistbyEmpDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

    f01=figure('name','ApplicationStrategyDist');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategyDistbyUnempDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpStatQ1_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q1UnempUIOpts.Color,'EdgeColor',Q1UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==1&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q1UnempNoUIOpts.Color,'EdgeColor',Q1UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpUIStatQ1_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpStatQ3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempUIOpts.Color,'EdgeColor',Q3UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==3&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q3UnempNoUIOpts.Color,'EdgeColor',Q3UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpUIStatQ3_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off


    f01=figure('name','ApplicationStrategybyEmpStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.UnempInd==1),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2],'Emp','Unemp');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpStatQ5_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','ApplicationStrategybyEmpUIStat');
    hold on;
    p1 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.UnempInd==1&(Panel.Unemp<=Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempUIOpts.Color,'EdgeColor',Q5UnempUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.ApplicationStrategy(Panel.Learn_qtile==5&Panel.UnempInd==1&(Panel.Unemp>Panel.UI_yn)),100,'Normalization','probability','FaceColor',Q5UnempNoUIOpts.Color,'EdgeColor',Q5UnempNoUIOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Application Strategy')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'Emp','Unemp UI','Unemp no UI');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnApplicationStrategybyEmpUIStatQ5_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;
    hold off

    f01=figure('name','LearnTimeEmpDist');
    hold on;
    p1 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.Learn_qtile==1&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q1EmpOpts.Color,'EdgeColor',Q1EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p2 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.Learn_qtile==3&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q3EmpOpts.Color,'EdgeColor',Q3EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    p3 = histogram(Panel.LearnTimeEmp(Panel.Age<=24&Panel.Learn_qtile==5&Panel.EmpInd==1),100,'Normalization','probability','FaceColor',Q5EmpOpts.Color,'EdgeColor',Q5EmpOpts.Color,'FaceAlpha',0.6,'EdgeAlpha',0.6);
    xlabel('Fraction of Time Learning')
    ylabel('Distribution')
    hleg1 = legend([p1,p2,p3],'1st','3rd','5th');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);

set(gca, ...
  'GridLineStyle'         , '--'     , ...
  'Box'         , 'off'     , ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'XGrid'       , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LearnLearnTimeEmpDist_',plotopts));
    saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
    close;

end
    
% Decision Rules by Employment Status

end

% LocalWords:  SavingsAllocation
