function ProfileAverages_Wrapper(params, order, opts, panelNames, statNames, YLabs, aveNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    for i = 1:length(panelNames)
        matfile = fullfile(pwd,sprintf('AveragesCalc_%s.mat',panelNames{i}));
        load(matfile);
        tempopts.dir = sprintf('/%s/',panelNames{i});
        tempopts.name = sprintf('_%s',panelNames{i});
        % AverageStats(params, order, opts, tempopts, statNames, YLabs, aveNames, lifetime_earnings, lifetime_variance, squeeze(modelAveragesFinal));
        if opts.wealthQtiles == 'y'
            matfile = fullfile(pwd,sprintf('AveragesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_wealth/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});
            HeterogeneityAverageStats(params, order, opts, tempopts, statNames, YLabs, aveNames, squeeze(modelAveragesWealthFinal));
        end
        if opts.learnQtiles == 'y'
            matfile = fullfile(pwd,sprintf('AveragesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_learn/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});
            HeterogeneityAverageStats(params, order, opts, tempopts, statNames, YLabs, aveNames, squeeze(modelAveragesLearnFinal));
        end
        if opts.humancapQtiles == 'y'
            matfile = fullfile(pwd,sprintf('AveragesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_humancap/',panelNames{i});
            tempopts.name = sprintf('_%s',panelNames{i});
            HeterogeneityAverageStats(params, order, opts, tempopts, statNames, YLabs, aveNames, squeeze(modelAveragesHumanCapFinal));
        end
    end
    clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;

end