function ProfilePlots(params, order, opts, plotopts, statNames, YLabs, lifetime_profile, statArray, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

[ColorSet2,~,~] = brewermap(24,'RdYlBu');
[ColorSet3,~,~] = brewermap(24,'BrBG');
[ColorSet4,~,~] = brewermap(24,'PRGn');
[ColorSet1,~,~] = brewermap(24,'RdYlBu');
[ColorSet5,~,~] = brewermap(12,'Paired');

[CompareColors,~,~] = brewermap(12,'Paired');

ModelCompOpts = struct('Color',CompareColors(2,:),'CI_yn','n','CI',0.05,'LS',[],'scatter',[]);
DataCompOpts = struct('Color',CompareColors(6,:),'CI_yn','n','CI',0.05,'LS','--','scatter',[]);

FormatOpts = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'PaperPosition', [0,0,4,4]);


% AggShocks = [0;AggShocks];


%%Plots
% Time Series: Loop over statNamess above

if dataopts.norm == 'y'
    for i = 2:length(statNames)
        p1 = plot(squeeze(statArray(2,:)),squeeze(statArray(i,:))./repmat(squeeze(statArray(i,1)),1,T./freq),'LineWidth',1.5,'color','b');
        hold on;
        yLims = get(gca,'ylim');
        ylim([min(yLims) max(yLims)]);
        xlabel('Age','Interpreter','latex')
        ylabel(YLabs{i},'Interpreter','latex')
        set(gca, ...
            'GridLineStyle'         , '--'     , ...
            'Box'         , 'off'     , ...
            'TickDir'     , 'out'     , ...
            'TickLength'  , [.02 .02] , ...
            'XMinorTick'  , 'on'      , ...
            'YMinorTick'  , 'on'      , ...
            'XGrid'       , 'on'      , ...
            'YGrid'       , 'on'      , ...
            'XColor'      , [.3 .3 .3], ...
            'YColor'      , [.3 .3 .3], ...
            'FontSize'    , 14        , ...
            'LineWidth'   , 1         );
        figfile = fullfile(results_graphics_path,strcat(statNames{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
    end
    p1 = plot(squeeze(statArray(2,TYoung./freq+1:end-TOld./freq)),squeeze(statArray(find(strcmp(statNames, 'LRIncHVY_3')),TYoung./freq+1:end-TOld./freq))./repmat(squeeze(statArray(find(strcmp(statNames, 'LRIncHVY_3')),1)),1,(T-TOld./freq-TYoung./freq-1)./freq),'color','b','LineWidth',1.5,'Marker','o');
    hold on;
    p2 = plot(squeeze(statArray(2,TYoung./freq+1:end-TOld./freq)),lifetime_profile./repmat(squeeze(lifetime_profile(1)),1,T./freq),'color',DataCompOpts.Color,'LineWidth',1.5,'LineStyle','-.','Marker','^');
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2],'Model','Data');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);
    set(gca, ...
        'GridLineStyle'         , '--'     , ...
        'Box'         , 'off'     , ...
        'TickDir'     , 'out'     , ...
        'TickLength'  , [.02 .02] , ...
        'XMinorTick'  , 'on'      , ...
        'YMinorTick'  , 'on'      , ...
        'XGrid'       , 'on'      , ...
        'YGrid'       , 'on'      , ...
        'XColor'      , [.3 .3 .3], ...
        'YColor'      , [.3 .3 .3], ...
        'FontSize'    , 14        , ...
        'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compare',plotopts.name));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    hold off;

else
    for i = 2:length(statNames)
        p1 = plot(squeeze(statArray(2,:)),squeeze(statArray(i,:)),'LineWidth',1.5,'color','b');
        hold on;
        yLims = get(gca,'ylim');
        ylim([min(yLims) max(yLims)]);
        xlabel('Age','Interpreter','latex')
        ylabel(YLabs{i},'Interpreter','latex')
        set(gca, ...
            'GridLineStyle'         , '--'     , ...
            'Box'         , 'off'     , ...
            'TickDir'     , 'out'     , ...
            'TickLength'  , [.02 .02] , ...
            'XMinorTick'  , 'on'      , ...
            'YMinorTick'  , 'on'      , ...
            'XGrid'       , 'on'      , ...
            'YGrid'       , 'on'      , ...
            'XColor'      , [.3 .3 .3], ...
            'YColor'      , [.3 .3 .3], ...
            'FontSize'    , 14        , ...
            'LineWidth'   , 1         );
        figfile = fullfile(results_graphics_path,strcat(statNames{i},plotopts.name));
        saveas(gcf,figfile,'png');
        if opts.II == 'n'
            saveas(gcf,figfile,'epsc');
        end
        hold off;
    end
    p1 = plot(squeeze(statArray(2,TYoung./freq+1:end-TOld./freq)),squeeze(statArray(find(strcmp(statNames, 'LRIncHVY_3')),TYoung./freq+1:end-TOld./freq)),'color','b','LineWidth',1.5,'Marker','o');
    hold on;
    p2 = plot(squeeze(statArray(2,TYoung./freq+1:end-TOld./freq)),lifetime_profile,'color',DataCompOpts.Color,'LineWidth',1.5,'LineStyle','-.','Marker','^');
    xlabel('Age')
    ylabel('Log Annual Earnings')
    hleg1 = legend([p1,p2],'Model','Data');
    set(hleg1,'Location','best');
    myfiguresize=[0,0,4,4];
    set(gcf, 'PaperPosition', myfiguresize);
    set(gca, ...
        'GridLineStyle'         , '--'     , ...
        'Box'         , 'off'     , ...
        'TickDir'     , 'out'     , ...
        'TickLength'  , [.02 .02] , ...
        'XMinorTick'  , 'on'      , ...
        'YMinorTick'  , 'on'      , ...
        'XGrid'       , 'on'      , ...
        'YGrid'       , 'on'      , ...
        'XColor'      , [.3 .3 .3], ...
        'YColor'      , [.3 .3 .3], ...
        'FontSize'    , 14        , ...
        'LineWidth'   , 1         );
    figfile = fullfile(results_graphics_path,strcat('LRIncHVY_3_compare',plotopts.name));
    saveas(gcf,figfile,'png');
    if opts.II == 'n'
        saveas(gcf,figfile,'epsc');
    end
    hold off;


end

end
