function ProfilePlots_Wrapper(params, order, opts, panelNames, statNames, YLabs, init_earnings, init_assets, lifetime_earnings, lifetime_variance, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    for i = 1:length(panelNames)
        matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{i}));
        load(matfile);
        tempopts.dir = sprintf('/%s/',panelNames{i});
        tempopts.name = sprintf('_Ave_%s',panelNames{i});
        dataopts.norm = 'n';
        ProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, squeeze(modelProfilesFinal(1,:,:)), dataopts);
        tempopts.name = sprintf('_Var_%s',panelNames{i});
        dataopts.norm = 'n';
        dataopts.allQtiles = 'n';
        ProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_variance, squeeze(modelProfilesFinal(2,:,:)), dataopts);
        if opts.wealthQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_wealth/',panelNames{i});
            tempopts.name = sprintf('_Ave_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesWealthFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_Var_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesWealthFinal(2,:,:,:)), dataopts);
        end
        if opts.learnQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_learn/',panelNames{i});
            tempopts.name = sprintf('_Ave_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesLearnFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_Var_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesLearnFinal(2,:,:,:)), dataopts);
        end
        if opts.humancapQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_humancap/',panelNames{i});
            tempopts.name = sprintf('_Ave_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesHumanCapFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_Var_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesHumanCapFinal(2,:,:,:)), dataopts);
        end
        matfile = fullfile(pwd,sprintf('ProfilesCalc_%s.mat',panelNames{i}));
        load(matfile);
        dataopts.norm = 'y';
        tempopts.dir = sprintf('/%s/',panelNames{i});
        tempopts.name = sprintf('_AveNorm_%s',panelNames{i});
        ProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, squeeze(modelProfilesFinal(1,:,:)), dataopts);
        tempopts.name = sprintf('_VarNorm_%s',panelNames{i});
        ProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_variance, squeeze(modelProfilesFinal(2,:,:)), dataopts);
        if opts.wealthQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesWealthCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_wealth/',panelNames{i});
            tempopts.name = sprintf('_AveNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, squeeze(modelProfilesWealthFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_VarNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesWealthFinal(2,:,:,:)), dataopts);
        end
        if opts.learnQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesLearnCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_learn/',panelNames{i});
            tempopts.name = sprintf('_AveNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesLearnFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_VarNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesLearnFinal(2,:,:,:)), dataopts);
        end
        if opts.humancapQtiles == 'y'
            matfile = fullfile(pwd,sprintf('ProfilesHumanCapCalc_%s.mat',panelNames{i}));
            load(matfile);
            tempopts.dir = sprintf('/%s_humancap/',panelNames{i});
            tempopts.name = sprintf('_AveNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesHumanCapFinal(1,:,:,:)), dataopts);
            tempopts.name = sprintf('_VarNorm_%s',panelNames{i});
            HeterogeneityProfilePlots(params, order, opts, tempopts, statNames, YLabs, lifetime_earnings, lifetime_variance, squeeze(modelProfilesHumanCapFinal(2,:,:,:)), dataopts);
        end
    end
    clear StatEsts WealthStatEsts LearnStatEsts HumanCapStatEsts;

end
