function Results(params, order, II_params, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance)
%% Results m-file for Borrowing Constraints, Search, and Life-Cycle Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


    if isequal(exist(fullfile(pwd,opts.graphics_path,'Results/'),'dir'),7);
        results_graphics_path = fullfile(pwd,opts.graphics_path,'Results/');
    else
        results_graphics_path = fullfile(pwd,opts.graphics_path,'Results/');
        mkdir(fullfile(pwd,opts.graphics_path,'Results/'));
    end

    seedval = 9;
%matfile = fullfile(pwd,output_path,sprintf('Result%d.mat',1));
%load(matfile);
    if opts.solve == 'y'
        Model(params, order, opts);
    end
    set(0,'defaultFigureVisible','off');
    opts.simfile = 'Simulation_Standard.mat';
    opts.savesim = 'n';
    if opts.simulate == 'y'
        opts.test = 'n';
        [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd] = Simulation(params,order,opts, seedval);
        EE = gather(EE);
        UU = gather(UU);
        WW = gather(WW);
        AA = gather(AA);
        BB = gather(BB);
        CC = gather(CC);
        UB = gather(UB);
        MU = gather(MU);
        HH = gather(HH);
        TT = gather(TT);
        UT = gather(UT);
        E2E= gather(E2E);
        ET = gather(ET);
        LL = gather(LL);
        ZZ = gather(ZZ);
        WPrime = gather(WPrime);
        ThetaPrime = gather(ThetaPrime);

        EE = EE(:,2:end);
        UU = UU(:,2:end);
        WW = WW(:,2:end);
        AA = AA(:,1:end-1);
        BB = BB(:,2:end);
        CC = CC(:,1:end-1);
        UB = UB(:,2:end);
        MU = MU(:,1:end-1);
        HH = HH(:,1:end-1);
        TT = TT(:,2:end);
        UT = UT(:,2:end);
        E2E= E2E(:,2:end);
        ET = ET(:,2:end);
        ZZ = ZZ(:,2:end);
        WPrime = WPrime(:,2:end);
        ThetaPrime = ThetaPrime(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EE', 'UU', 'WW', 'AA', 'CC', 'BB', 'UB', 'MU', 'HH', 'TT', 'LL', 'UT', 'E2E', 'ET', 'ZZ', 'WPrime', 'ThetaPrime');
        clear EE UU WW AA BB CC UB MU HH TT UT E2E ET LL;
    end

    opts.simfile = 'Simulation_Aup.mat';
    if opts.subsim == 'y'
        opts.test = 'Aup';
        [EEAup, UUAup, WWAup, AAAup, CCAup, BBAup, UBAup, MUAup, HHAup, TTAup, LLAup, UTAup, E2EAup, ETAup, ZZAup, WPrimeAup, ThetaPrimeAup] = Simulation(params,order,opts,seedval);
        EEAup = gather(EEAup);
        UUAup = gather(UUAup);
        WWAup = gather(WWAup);
        AAAup = gather(AAAup);
        BBAup = gather(BBAup);
        CCAup = gather(CCAup);
        UBAup = gather(UBAup);
        MUAup = gather(MUAup);
        HHAup = gather(HHAup);
        TTAup = gather(TTAup);
        UTAup = gather(UTAup);
        E2EAup = gather(E2EAup);
        ETAup = gather(ETAup);
        LLAup = gather(LLAup);
        ZZAup = gather(ZZAup);
        WPrimeAup = gather(WPrimeAup);
        ThetaPrimeAup = gather(ThetaPrimeAup);

        EEAup = EEAup(:,2:end);
        UUAup = UUAup(:,2:end);
        WWAup = WWAup(:,2:end);
        AAAup = AAAup(:,1:end-1);
        BBAup = BBAup(:,2:end);
        CCAup = CCAup(:,1:end-1);
        UBAup = UBAup(:,2:end);
        MUAup = MUAup(:,1:end-1);
        HHAup = HHAup(:,1:end-1);
        TTAup = TTAup(:,2:end);
        UTAup = UTAup(:,2:end);
        E2EAup = E2EAup(:,2:end);
        ETAup = ETAup(:,2:end);
        ZZAup = ZZAup(:,2:end);
        WPrimeAup = WPrimeAup(:,2:end);
        ThetaPrimeAup = ThetaPrimeAup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAup', 'UUAup', 'WWAup', 'AAAup', 'CCAup', 'BBAup', 'UBAup', 'MUAup', 'HHAup', 'TTAup', 'LLAup', 'UTAup', 'E2EAup', 'ETAup', 'ZZAup', 'WPrimeAup', 'ThetaPrimeAup');
        clear EEAup UUAup WWAup AAAup CCAup BBAup UBAup MUAup HHAup TTAup LLAup UTAup E2EAup ETAup ZZAup WPrimeAup ThetaPrimeAup;
    end

    opts.simfile = 'Simulation_Adown.mat';
    if opts.subsim == 'y'
        opts.test = 'Adown';
        [EEAdown, UUAdown, WWAdown, AAAdown, CCAdown, BBAdown, UBAdown, MUAdown, HHAdown, TTAdown, LLAdown, UTAdown, E2EAdown, ETAdown, ZZAdown, WPrimeAdown, ThetaPrimeAdown] = Simulation(params,order,opts,seedval);
        EEAdown = gather(EEAdown);
        UUAdown = gather(UUAdown);
        WWAdown = gather(WWAdown);
        AAAdown = gather(AAAdown);
        BBAdown = gather(BBAdown);
        CCAdown = gather(CCAdown);
        UBAdown = gather(UBAdown);
        MUAdown = gather(MUAdown);
        HHAdown = gather(HHAdown);
        TTAdown = gather(TTAdown);
        UTAdown = gather(UTAdown);
        E2EAdown = gather(E2EAdown);
        ETAdown = gather(ETAdown);
        LLAdown = gather(LLAdown);
        ZZAdown = gather(ZZAdown);
        WPrimeAdown = gather(WPrimeAdown);
        ThetaPrimeAdown = gather(ThetaPrimeAdown);

        EEAdown = EEAdown(:,2:end);
        UUAdown = UUAdown(:,2:end);
        WWAdown = WWAdown(:,2:end);
        AAAdown = AAAdown(:,1:end-1);
        BBAdown = BBAdown(:,2:end);
        CCAdown = CCAdown(:,1:end-1);
        UBAdown = UBAdown(:,2:end);
        MUAdown = MUAdown(:,1:end-1);
        HHAdown = HHAdown(:,1:end-1);
        TTAdown = TTAdown(:,2:end);
        UTAdown = UTAdown(:,2:end);
        E2EAdown = E2EAdown(:,2:end);
        ETAdown = ETAdown(:,2:end);
        ZZAdown = ZZAdown(:,2:end);
        WPrimeAdown = WPrimeAdown(:,2:end);
        ThetaPrimeAdown = ThetaPrimeAdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdown', 'UUAdown', 'WWAdown', 'AAAdown', 'CCAdown', 'BBAdown', 'UBAdown', 'MUAdown', 'HHAdown', 'TTAdown', 'LLAdown', 'UTAdown', 'E2EAdown', 'ETAdown', 'ZZAdown', 'WPrimeAdown', 'ThetaPrimeAdown');
        clear EEAdown UUAdown WWAdown AAAdown CCAdown BBAdown UBAdown MUAdown HHAdown TTAdown LLAdown UTAdown E2EAdown ETAdown ZZAdown WPrimeAdown ThetaPrimeAdown;
    end

        opts.simfile = 'Simulation_Aup2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Aup2StD';
        [EEAup2StD, UUAup2StD, WWAup2StD, AAAup2StD, CCAup2StD, BBAup2StD, UBAup2StD, MUAup2StD, HHAup2StD, TTAup2StD, LLAup2StD, UTAup2StD, E2EAup2StD, ETAup2StD, ZZAup2StD, WPrimeAup2StD, ThetaPrimeAup2StD] = Simulation(params,order,opts,seedval);
        EEAup2StD = gather(EEAup2StD);
        UUAup2StD = gather(UUAup2StD);
        WWAup2StD = gather(WWAup2StD);
        AAAup2StD = gather(AAAup2StD);
        BBAup2StD = gather(BBAup2StD);
        CCAup2StD = gather(CCAup2StD);
        UBAup2StD = gather(UBAup2StD);
        MUAup2StD = gather(MUAup2StD);
        HHAup2StD = gather(HHAup2StD);
        TTAup2StD = gather(TTAup2StD);
        UTAup2StD = gather(UTAup2StD);
        E2EAup2StD = gather(E2EAup2StD);
        ETAup2StD = gather(ETAup2StD);
        LLAup2StD = gather(LLAup2StD);
        ZZAup2StD = gather(ZZAup2StD);
        WPrimeAup2StD = gather(WPrimeAup2StD);
        ThetaPrimeAup2StD = gather(ThetaPrimeAup2StD);

        EEAup2StD = EEAup2StD(:,2:end);
        UUAup2StD = UUAup2StD(:,2:end);
        WWAup2StD = WWAup2StD(:,2:end);
        AAAup2StD = AAAup2StD(:,1:end-1);
        BBAup2StD = BBAup2StD(:,2:end);
        CCAup2StD = CCAup2StD(:,1:end-1);
        UBAup2StD = UBAup2StD(:,2:end);
        MUAup2StD = MUAup2StD(:,1:end-1);
        HHAup2StD = HHAup2StD(:,1:end-1);
        TTAup2StD = TTAup2StD(:,2:end);
        UTAup2StD = UTAup2StD(:,2:end);
        E2EAup2StD = E2EAup2StD(:,2:end);
        ETAup2StD = ETAup2StD(:,2:end);
        ZZAup2StD = ZZAup2StD(:,2:end);
        WPrimeAup2StD = WPrimeAup2StD(:,2:end);
        ThetaPrimeAup2StD = ThetaPrimeAup2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAup2StD', 'UUAup2StD', 'WWAup2StD', 'AAAup2StD', 'CCAup2StD', 'BBAup2StD', 'UBAup2StD', 'MUAup2StD', 'HHAup2StD', 'TTAup2StD', 'LLAup2StD', 'UTAup2StD', 'E2EAup2StD', 'ETAup2StD', 'ZZAup2StD', 'WPrimeAup2StD', 'ThetaPrimeAup2StD');
        clear EEAup2StD UUAup2StD WWAup2StD AAAup2StD CCAup2StD BBAup2StD UBAup2StD MUAup2StD HHAup2StD TTAup2StD LLAup2StD UTAup2StD E2EAup2StD ETAup2StD ZZAup2StD WPrimeAup2StD ThetaPrimeAup2StD;
    end

    opts.simfile = 'Simulation_Adown2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Adown2StD';
        [EEAdown2StD, UUAdown2StD, WWAdown2StD, AAAdown2StD, CCAdown2StD, BBAdown2StD, UBAdown2StD, MUAdown2StD, HHAdown2StD, TTAdown2StD, LLAdown2StD, UTAdown2StD, E2EAdown2StD, ETAdown2StD, ZZAdown2StD, WPrimeAdown2StD, ThetaPrimeAdown2StD] = Simulation(params,order,opts,seedval);
        EEAdown2StD = gather(EEAdown2StD);
        UUAdown2StD = gather(UUAdown2StD);
        WWAdown2StD = gather(WWAdown2StD);
        AAAdown2StD = gather(AAAdown2StD);
        BBAdown2StD = gather(BBAdown2StD);
        CCAdown2StD = gather(CCAdown2StD);
        UBAdown2StD = gather(UBAdown2StD);
        MUAdown2StD = gather(MUAdown2StD);
        HHAdown2StD = gather(HHAdown2StD);
        TTAdown2StD = gather(TTAdown2StD);
        UTAdown2StD = gather(UTAdown2StD);
        E2EAdown2StD = gather(E2EAdown2StD);
        ETAdown2StD = gather(ETAdown2StD);
        LLAdown2StD = gather(LLAdown2StD);
        ZZAdown2StD = gather(ZZAdown2StD);
        WPrimeAdown2StD = gather(WPrimeAdown2StD);
        ThetaPrimeAdown2StD = gather(ThetaPrimeAdown2StD);

        EEAdown2StD = EEAdown2StD(:,2:end);
        UUAdown2StD = UUAdown2StD(:,2:end);
        WWAdown2StD = WWAdown2StD(:,2:end);
        AAAdown2StD = AAAdown2StD(:,1:end-1);
        BBAdown2StD = BBAdown2StD(:,2:end);
        CCAdown2StD = CCAdown2StD(:,1:end-1);
        UBAdown2StD = UBAdown2StD(:,2:end);
        MUAdown2StD = MUAdown2StD(:,1:end-1);
        HHAdown2StD = HHAdown2StD(:,1:end-1);
        TTAdown2StD = TTAdown2StD(:,2:end);
        UTAdown2StD = UTAdown2StD(:,2:end);
        E2EAdown2StD = E2EAdown2StD(:,2:end);
        ETAdown2StD = ETAdown2StD(:,2:end);
        ZZAdown2StD = ZZAdown2StD(:,2:end);
        WPrimeAdown2StD = WPrimeAdown2StD(:,2:end);
        ThetaPrimeAdown2StD = ThetaPrimeAdown2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdown2StD', 'UUAdown2StD', 'WWAdown2StD', 'AAAdown2StD', 'CCAdown2StD', 'BBAdown2StD', 'UBAdown2StD', 'MUAdown2StD', 'HHAdown2StD', 'TTAdown2StD', 'LLAdown2StD', 'UTAdown2StD', 'E2EAdown2StD', 'ETAdown2StD', 'ZZAdown2StD', 'WPrimeAdown2StD', 'ThetaPrimeAdown2StD');
        clear EEAdown2StD UUAdown2StD WWAdown2StD AAAdown2StD CCAdown2StD BBAdown2StD UBAdown2StD MUAdown2StD HHAdown2StD TTAdown2StD LLAdown2StD UTAdown2StD E2EAdown2StD ETAdown2StD ZZAdown2StD WPrimeAdown2StD ThetaPrimeAdown2StD;
    end

    
    opts.simfile = 'Simulation_Hup.mat';
    if opts.subsim == 'y'
        opts.test = 'Hup';
        [EEHup, UUHup, WWHup, AAHup, CCHup, BBHup, UBHup, MUHup, HHHup, TTHup, LLHup, UTHup, E2EHup, ETHup, ZZHup, WPrimeHup, ThetaPrimeHup] = Simulation(params,order,opts,seedval);
        EEHup = gather(EEHup);
        UUHup = gather(UUHup);
        WWHup = gather(WWHup);
        AAHup = gather(AAHup);
        BBHup = gather(BBHup);
        CCHup = gather(CCHup);
        UBHup = gather(UBHup);
        MUHup = gather(MUHup);
        HHHup = gather(HHHup);
        TTHup = gather(TTHup);
        UTHup = gather(UTHup);
        E2EHup = gather(E2EHup);
        ETHup = gather(ETHup);
        LLHup = gather(LLHup);
        ZZHup = gather(ZZHup);
        WPrimeHup = gather(WPrimeHup);
        ThetaPrimeHup = gather(ThetaPrimeHup);

        EEHup = EEHup(:,2:end);
        UUHup = UUHup(:,2:end);
        WWHup = WWHup(:,2:end);
        AAHup = AAHup(:,1:end-1);
        BBHup = BBHup(:,2:end);
        CCHup = CCHup(:,1:end-1);
        UBHup = UBHup(:,2:end);
        MUHup = MUHup(:,1:end-1);
        HHHup = HHHup(:,1:end-1);
        TTHup = TTHup(:,2:end);
        UTHup = UTHup(:,2:end);
        E2EHup = E2EHup(:,2:end);
        ETHup = ETHup(:,2:end);
        ZZHup = ZZHup(:,2:end);
        WPrimeHup = WPrimeHup(:,2:end);
        ThetaPrimeHup = ThetaPrimeHup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHup', 'UUHup', 'WWHup', 'AAHup', 'CCHup', 'BBHup', 'UBHup', 'MUHup', 'HHHup', 'TTHup', 'LLHup', 'UTHup', 'E2EHup', 'ETHup', 'ZZHup', 'WPrimeHup', 'ThetaPrimeHup');
        clear EEHup UUHup WWHup AAHup CCHup BBHup UBHup MUHup HHHup TTHup LLHup UTHup E2EHup ETHup ZZHup WPrimeHup ThetaPrimeHup;
    end

    opts.simfile = 'Simulation_Hdown.mat';
    if opts.subsim == 'y'
        opts.test = 'Hdown';
        [EEHdown, UUHdown, WWHdown, AAHdown, CCHdown, BBHdown, UBHdown, MUHdown, HHHdown, TTHdown, LLHdown, UTHdown, E2EHdown, ETHdown, ZZHdown, WPrimeHdown, ThetaPrimeHdown] = Simulation(params,order,opts,seedval);
        EEHdown = gather(EEHdown);
        UUHdown = gather(UUHdown);
        WWHdown = gather(WWHdown);
        AAHdown = gather(AAHdown);
        BBHdown = gather(BBHdown);
        CCHdown = gather(CCHdown);
        UBHdown = gather(UBHdown);
        MUHdown = gather(MUHdown);
        HHHdown = gather(HHHdown);
        TTHdown = gather(TTHdown);
        UTHdown = gather(UTHdown);
        E2EHdown = gather(E2EHdown);
        ETHdown = gather(ETHdown);
        LLHdown = gather(LLHdown);
        ZZHdown = gather(ZZHdown);
        WPrimeHdown = gather(WPrimeHdown);
        ThetaPrimeHdown = gather(ThetaPrimeHdown);

        EEHdown = EEHdown(:,2:end);
        UUHdown = UUHdown(:,2:end);
        WWHdown = WWHdown(:,2:end);
        AAHdown = AAHdown(:,1:end-1);
        BBHdown = BBHdown(:,2:end);
        CCHdown = CCHdown(:,1:end-1);
        UBHdown = UBHdown(:,2:end);
        MUHdown = MUHdown(:,1:end-1);
        HHHdown = HHHdown(:,1:end-1);
        TTHdown = TTHdown(:,2:end);
        UTHdown = UTHdown(:,2:end);
        E2EHdown = E2EHdown(:,2:end);
        ETHdown = ETHdown(:,2:end);
        ZZHdown = ZZHdown(:,2:end);
        WPrimeHdown = WPrimeHdown(:,2:end);
        ThetaPrimeHdown = ThetaPrimeHdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHdown', 'UUHdown', 'WWHdown', 'AAHdown', 'CCHdown', 'BBHdown', 'UBHdown', 'MUHdown', 'HHHdown', 'TTHdown', 'LLHdown', 'UTHdown', 'E2EHdown', 'ETHdown', 'ZZHdown', 'WPrimeHdown', 'ThetaPrimeHdown');
        clear EEHdown UUHdown WWHdown AAHdown CCHdown BBHdown UBHdown MUHdown HHHdown TTHdown LLHdown UTHdown E2EHdown ETHdown ZZHdown WPrimeHdown ThetaPrimeHdown;
    end

    
    
    opts.simfile = 'Simulation_Hup2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Hup2StD';
        [EEHup2StD, UUHup2StD, WWHup2StD, AAHup2StD, CCHup2StD, BBHup2StD, UBHup2StD, MUHup2StD, HHHup2StD, TTHup2StD, LLHup2StD, UTHup2StD, E2EHup2StD, ETHup2StD, ZZHup2StD, WPrimeHup2StD, ThetaPrimeHup2StD] = Simulation(params,order,opts,seedval);
        EEHup2StD = gather(EEHup2StD);
        UUHup2StD = gather(UUHup2StD);
        WWHup2StD = gather(WWHup2StD);
        AAHup2StD = gather(AAHup2StD);
        BBHup2StD = gather(BBHup2StD);
        CCHup2StD = gather(CCHup2StD);
        UBHup2StD = gather(UBHup2StD);
        MUHup2StD = gather(MUHup2StD);
        HHHup2StD = gather(HHHup2StD);
        TTHup2StD = gather(TTHup2StD);
        UTHup2StD = gather(UTHup2StD);
        E2EHup2StD = gather(E2EHup2StD);
        ETHup2StD = gather(ETHup2StD);
        LLHup2StD = gather(LLHup2StD);
        ZZHup2StD = gather(ZZHup2StD);
        WPrimeHup2StD = gather(WPrimeHup2StD);
        ThetaPrimeHup2StD = gather(ThetaPrimeHup2StD);

        EEHup2StD = EEHup2StD(:,2:end);
        UUHup2StD = UUHup2StD(:,2:end);
        WWHup2StD = WWHup2StD(:,2:end);
        AAHup2StD = AAHup2StD(:,1:end-1);
        BBHup2StD = BBHup2StD(:,2:end);
        CCHup2StD = CCHup2StD(:,1:end-1);
        UBHup2StD = UBHup2StD(:,2:end);
        MUHup2StD = MUHup2StD(:,1:end-1);
        HHHup2StD = HHHup2StD(:,1:end-1);
        TTHup2StD = TTHup2StD(:,2:end);
        UTHup2StD = UTHup2StD(:,2:end);
        E2EHup2StD = E2EHup2StD(:,2:end);
        ETHup2StD = ETHup2StD(:,2:end);
        ZZHup2StD = ZZHup2StD(:,2:end);
        WPrimeHup2StD = WPrimeHup2StD(:,2:end);
        ThetaPrimeHup2StD = ThetaPrimeHup2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHup2StD', 'UUHup2StD', 'WWHup2StD', 'AAHup2StD', 'CCHup2StD', 'BBHup2StD', 'UBHup2StD', 'MUHup2StD', 'HHHup2StD', 'TTHup2StD', 'LLHup2StD', 'UTHup2StD', 'E2EHup2StD', 'ETHup2StD', 'ZZHup2StD', 'WPrimeHup2StD', 'ThetaPrimeHup2StD');
        clear EEHup2StD UUHup2StD WWHup2StD AAHup2StD CCHup2StD BBHup2StD UBHup2StD MUHup2StD HHHup2StD TTHup2StD LLHup2StD UTHup2StD E2EHup2StD ETHup2StD ZZHup2StD WPrimeHup2StD ThetaPrimeHup2StD;
    end

    opts.simfile = 'Simulation_Hdown2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Hdown2StD';
        [EEHdown2StD, UUHdown2StD, WWHdown2StD, AAHdown2StD, CCHdown2StD, BBHdown2StD, UBHdown2StD, MUHdown2StD, HHHdown2StD, TTHdown2StD, LLHdown2StD, UTHdown2StD, E2EHdown2StD, ETHdown2StD, ZZHdown2StD, WPrimeHdown2StD, ThetaPrimeHdown2StD] = Simulation(params,order,opts,seedval);
        EEHdown2StD = gather(EEHdown2StD);
        UUHdown2StD = gather(UUHdown2StD);
        WWHdown2StD = gather(WWHdown2StD);
        AAHdown2StD = gather(AAHdown2StD);
        BBHdown2StD = gather(BBHdown2StD);
        CCHdown2StD = gather(CCHdown2StD);
        UBHdown2StD = gather(UBHdown2StD);
        MUHdown2StD = gather(MUHdown2StD);
        HHHdown2StD = gather(HHHdown2StD);
        TTHdown2StD = gather(TTHdown2StD);
        UTHdown2StD = gather(UTHdown2StD);
        E2EHdown2StD = gather(E2EHdown2StD);
        ETHdown2StD = gather(ETHdown2StD);
        LLHdown2StD = gather(LLHdown2StD);
        ZZHdown2StD = gather(ZZHdown2StD);
        WPrimeHdown2StD = gather(WPrimeHdown2StD);
        ThetaPrimeHdown2StD = gather(ThetaPrimeHdown2StD);

        EEHdown2StD = EEHdown2StD(:,2:end);
        UUHdown2StD = UUHdown2StD(:,2:end);
        WWHdown2StD = WWHdown2StD(:,2:end);
        AAHdown2StD = AAHdown2StD(:,1:end-1);
        BBHdown2StD = BBHdown2StD(:,2:end);
        CCHdown2StD = CCHdown2StD(:,1:end-1);
        UBHdown2StD = UBHdown2StD(:,2:end);
        MUHdown2StD = MUHdown2StD(:,1:end-1);
        HHHdown2StD = HHHdown2StD(:,1:end-1);
        TTHdown2StD = TTHdown2StD(:,2:end);
        UTHdown2StD = UTHdown2StD(:,2:end);
        E2EHdown2StD = E2EHdown2StD(:,2:end);
        ETHdown2StD = ETHdown2StD(:,2:end);
        ZZHdown2StD = ZZHdown2StD(:,2:end);
        WPrimeHdown2StD = WPrimeHdown2StD(:,2:end);
        ThetaPrimeHdown2StD = ThetaPrimeHdown2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHdown2StD', 'UUHdown2StD', 'WWHdown2StD', 'AAHdown2StD', 'CCHdown2StD', 'BBHdown2StD', 'UBHdown2StD', 'MUHdown2StD', 'HHHdown2StD', 'TTHdown2StD', 'LLHdown2StD', 'UTHdown2StD', 'E2EHdown2StD', 'ETHdown2StD', 'ZZHdown2StD', 'WPrimeHdown2StD', 'ThetaPrimeHdown2StD');
        clear EEHdown2StD UUHdown2StD WWHdown2StD AAHdown2StD CCHdown2StD BBHdown2StD UBHdown2StD MUHdown2StD HHHdown2StD TTHdown2StD LLHdown2StD UTHdown2StD E2EHdown2StD ETHdown2StD ZZHdown2StD WPrimeHdown2StD ThetaPrimeHdown2StD;
    end

    
    opts.simfile = 'Simulation_Lup.mat';
    if opts.subsim == 'y'
        opts.test = 'Lup';
        [EELup, UULup, WWLup, AALup, CCLup, BBLup, UBLup, MULup, HHLup, TTLup, LLLup, UTLup, E2ELup, ETLup, ZZLup, WPrimeLup, ThetaPrimeLup] = Simulation(params,order,opts,seedval);
        EELup = gather(EELup);
        UULup = gather(UULup);
        WWLup = gather(WWLup);
        AALup = gather(AALup);
        BBLup = gather(BBLup);
        CCLup = gather(CCLup);
        UBLup = gather(UBLup);
        MULup = gather(MULup);
        HHLup = gather(HHLup);
        TTLup = gather(TTLup);
        UTLup = gather(UTLup);
        E2ELup = gather(E2ELup);
        ETLup = gather(ETLup);
        LLLup = gather(LLLup);
        ZZLup = gather(ZZLup);
        WPrimeLup = gather(WPrimeLup);
        ThetaPrimeLup = gather(ThetaPrimeLup);

        EELup = EELup(:,2:end);
        UULup = UULup(:,2:end);
        WWLup = WWLup(:,2:end);
        AALup = AALup(:,1:end-1);
        BBLup = BBLup(:,2:end);
        CCLup = CCLup(:,1:end-1);
        UBLup = UBLup(:,2:end);
        MULup = MULup(:,1:end-1);
        HHLup = HHLup(:,1:end-1);
        TTLup = TTLup(:,2:end);
        UTLup = UTLup(:,2:end);
        E2ELup = E2ELup(:,2:end);
        ETLup = ETLup(:,2:end);
        ZZLup = ZZLup(:,2:end);
        WPrimeLup = WPrimeLup(:,2:end);
        ThetaPrimeLup = ThetaPrimeLup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELup', 'UULup', 'WWLup', 'AALup', 'CCLup', 'BBLup', 'UBLup', 'MULup', 'HHLup', 'TTLup', 'LLLup', 'UTLup', 'E2ELup', 'ETLup', 'ZZLup', 'WPrimeLup', 'ThetaPrimeLup');
        clear EELup UULup WWLup AALup CCLup BBLup UBLup MULup HHLup TTLup LLLup UTLup E2ELup ETLup ZZLup WPrimeLup ThetaPrimeLup;
    end

    opts.simfile = 'Simulation_Ldown.mat';
    if opts.subsim == 'y'
        opts.test = 'Ldown';
        [EELdown, UULdown, WWLdown, AALdown, CCLdown, BBLdown, UBLdown, MULdown, HHLdown, TTLdown, LLLdown, UTLdown, E2ELdown, ETLdown, ZZLdown, WPrimeLdown, ThetaPrimeLdown] = Simulation(params,order,opts,seedval);
        EELdown = gather(EELdown);
        UULdown = gather(UULdown);
        WWLdown = gather(WWLdown);
        AALdown = gather(AALdown);
        BBLdown = gather(BBLdown);
        CCLdown = gather(CCLdown);
        UBLdown = gather(UBLdown);
        MULdown = gather(MULdown);
        HHLdown = gather(HHLdown);
        TTLdown = gather(TTLdown);
        UTLdown = gather(UTLdown);
        E2ELdown = gather(E2ELdown);
        ETLdown = gather(ETLdown);
        LLLdown = gather(LLLdown);
        ZZLdown = gather(ZZLdown);
        WPrimeLdown = gather(WPrimeLdown);
        ThetaPrimeLdown = gather(ThetaPrimeLdown);

        EELdown = EELdown(:,2:end);
        UULdown = UULdown(:,2:end);
        WWLdown = WWLdown(:,2:end);
        AALdown = AALdown(:,1:end-1);
        BBLdown = BBLdown(:,2:end);
        CCLdown = CCLdown(:,1:end-1);
        UBLdown = UBLdown(:,2:end);
        MULdown = MULdown(:,1:end-1);
        HHLdown = HHLdown(:,1:end-1);
        TTLdown = TTLdown(:,2:end);
        UTLdown = UTLdown(:,2:end);
        E2ELdown = E2ELdown(:,2:end);
        ETLdown = ETLdown(:,2:end);
        ZZLdown = ZZLdown(:,2:end);
        WPrimeLdown = WPrimeLdown(:,2:end);
        ThetaPrimeLdown = ThetaPrimeLdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELdown', 'UULdown', 'WWLdown', 'AALdown', 'CCLdown', 'BBLdown', 'UBLdown', 'MULdown', 'HHLdown', 'TTLdown', 'LLLdown', 'UTLdown', 'E2ELdown', 'ETLdown', 'ZZLdown', 'WPrimeLdown', 'ThetaPrimeLdown');
        clear EELdown UULdown WWLdown AALdown CCLdown BBLdown UBLdown MULdown HHLdown TTLdown LLLdown UTLdown E2ELdown ETLdown ZZLdown WPrimeLdown ThetaPrimeLdown;
    end

    
    opts.simfile = 'Simulation_Lup2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Lup2StD';
        [EELup2StD, UULup2StD, WWLup2StD, AALup2StD, CCLup2StD, BBLup2StD, UBLup2StD, MULup2StD, HHLup2StD, TTLup2StD, LLLup2StD, UTLup2StD, E2ELup2StD, ETLup2StD, ZZLup2StD, WPrimeLup2StD, ThetaPrimeLup2StD] = Simulation(params,order,opts,seedval);
        EELup2StD = gather(EELup2StD);
        UULup2StD = gather(UULup2StD);
        WWLup2StD = gather(WWLup2StD);
        AALup2StD = gather(AALup2StD);
        BBLup2StD = gather(BBLup2StD);
        CCLup2StD = gather(CCLup2StD);
        UBLup2StD = gather(UBLup2StD);
        MULup2StD = gather(MULup2StD);
        HHLup2StD = gather(HHLup2StD);
        TTLup2StD = gather(TTLup2StD);
        UTLup2StD = gather(UTLup2StD);
        E2ELup2StD = gather(E2ELup2StD);
        ETLup2StD = gather(ETLup2StD);
        LLLup2StD = gather(LLLup2StD);
        ZZLup2StD = gather(ZZLup2StD);
        WPrimeLup2StD = gather(WPrimeLup2StD);
        ThetaPrimeLup2StD = gather(ThetaPrimeLup2StD);

        EELup2StD = EELup2StD(:,2:end);
        UULup2StD = UULup2StD(:,2:end);
        WWLup2StD = WWLup2StD(:,2:end);
        AALup2StD = AALup2StD(:,1:end-1);
        BBLup2StD = BBLup2StD(:,2:end);
        CCLup2StD = CCLup2StD(:,1:end-1);
        UBLup2StD = UBLup2StD(:,2:end);
        MULup2StD = MULup2StD(:,1:end-1);
        HHLup2StD = HHLup2StD(:,1:end-1);
        TTLup2StD = TTLup2StD(:,2:end);
        UTLup2StD = UTLup2StD(:,2:end);
        E2ELup2StD = E2ELup2StD(:,2:end);
        ETLup2StD = ETLup2StD(:,2:end);
        ZZLup2StD = ZZLup2StD(:,2:end);
        WPrimeLup2StD = WPrimeLup2StD(:,2:end);
        ThetaPrimeLup2StD = ThetaPrimeLup2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELup2StD', 'UULup2StD', 'WWLup2StD', 'AALup2StD', 'CCLup2StD', 'BBLup2StD', 'UBLup2StD', 'MULup2StD', 'HHLup2StD', 'TTLup2StD', 'LLLup2StD', 'UTLup2StD', 'E2ELup2StD', 'ETLup2StD', 'ZZLup2StD', 'WPrimeLup2StD', 'ThetaPrimeLup2StD');
        clear EELup2StD UULup2StD WWLup2StD AALup2StD CCLup2StD BBLup2StD UBLup2StD MULup2StD HHLup2StD TTLup2StD LLLup2StD UTLup2StD E2ELup2StD ETLup2StD ZZLup2StD WPrimeLup2StD ThetaPrimeLup2StD;
    end

    opts.simfile = 'Simulation_Ldown2StD.mat';
    if opts.subsim == 'y'
        opts.test = 'Ldown2StD';
        [EELdown2StD, UULdown2StD, WWLdown2StD, AALdown2StD, CCLdown2StD, BBLdown2StD, UBLdown2StD, MULdown2StD, HHLdown2StD, TTLdown2StD, LLLdown2StD, UTLdown2StD, E2ELdown2StD, ETLdown2StD, ZZLdown2StD, WPrimeLdown2StD, ThetaPrimeLdown2StD] = Simulation(params,order,opts,seedval);
        EELdown2StD = gather(EELdown2StD);
        UULdown2StD = gather(UULdown2StD);
        WWLdown2StD = gather(WWLdown2StD);
        AALdown2StD = gather(AALdown2StD);
        BBLdown2StD = gather(BBLdown2StD);
        CCLdown2StD = gather(CCLdown2StD);
        UBLdown2StD = gather(UBLdown2StD);
        MULdown2StD = gather(MULdown2StD);
        HHLdown2StD = gather(HHLdown2StD);
        TTLdown2StD = gather(TTLdown2StD);
        UTLdown2StD = gather(UTLdown2StD);
        E2ELdown2StD = gather(E2ELdown2StD);
        ETLdown2StD = gather(ETLdown2StD);
        LLLdown2StD = gather(LLLdown2StD);
        ZZLdown2StD = gather(ZZLdown2StD);
        WPrimeLdown2StD = gather(WPrimeLdown2StD);
        ThetaPrimeLdown2StD = gather(ThetaPrimeLdown2StD);

        EELdown2StD = EELdown2StD(:,2:end);
        UULdown2StD = UULdown2StD(:,2:end);
        WWLdown2StD = WWLdown2StD(:,2:end);
        AALdown2StD = AALdown2StD(:,1:end-1);
        BBLdown2StD = BBLdown2StD(:,2:end);
        CCLdown2StD = CCLdown2StD(:,1:end-1);
        UBLdown2StD = UBLdown2StD(:,2:end);
        MULdown2StD = MULdown2StD(:,1:end-1);
        HHLdown2StD = HHLdown2StD(:,1:end-1);
        TTLdown2StD = TTLdown2StD(:,2:end);
        UTLdown2StD = UTLdown2StD(:,2:end);
        E2ELdown2StD = E2ELdown2StD(:,2:end);
        ETLdown2StD = ETLdown2StD(:,2:end);
        ZZLdown2StD = ZZLdown2StD(:,2:end);
        WPrimeLdown2StD = WPrimeLdown2StD(:,2:end);
        ThetaPrimeLdown2StD = ThetaPrimeLdown2StD(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELdown2StD', 'UULdown2StD', 'WWLdown2StD', 'AALdown2StD', 'CCLdown2StD', 'BBLdown2StD', 'UBLdown2StD', 'MULdown2StD', 'HHLdown2StD', 'TTLdown2StD', 'LLLdown2StD', 'UTLdown2StD', 'E2ELdown2StD', 'ETLdown2StD', 'ZZLdown2StD', 'WPrimeLdown2StD', 'ThetaPrimeLdown2StD');
        clear EELdown2StD UULdown2StD WWLdown2StD AALdown2StD CCLdown2StD BBLdown2StD UBLdown2StD MULdown2StD HHLdown2StD TTLdown2StD LLLdown2StD UTLdown2StD E2ELdown2StD ETLdown2StD ZZLdown2StD WPrimeLdown2StD ThetaPrimeLdown2StD;
    end

    
    opts.simfile = 'Simulation_ACons.mat';
    if opts.subsim == 'y'
        opts.test = 'ACons';
        [EEACons, UUACons, WWACons, AAACons, CCACons, BBACons, UBACons, MUACons, HHACons, TTACons, LLACons, UTACons, E2EACons, ETACons, ZZACons, WPrimeACons, ThetaPrimeACons] = Simulation(params,order,opts,seedval);
        EEACons = gather(EEACons);
        UUACons = gather(UUACons);
        WWACons = gather(WWACons);
        AAACons = gather(AAACons);
        BBACons = gather(BBACons);
        CCACons = gather(CCACons);
        UBACons = gather(UBACons);
        MUACons = gather(MUACons);
        HHACons = gather(HHACons);
        TTACons = gather(TTACons);
        UTACons = gather(UTACons);
        E2EACons = gather(E2EACons);
        ETACons = gather(ETACons);
        LLACons = gather(LLACons);
        ZZACons = gather(ZZACons);
        WPrimeACons = gather(WPrimeACons);
        ThetaPrimeACons = gather(ThetaPrimeACons);

        EEACons = EEACons(:,2:end);
        UUACons = UUACons(:,2:end);
        WWACons = WWACons(:,2:end);
        AAACons = AAACons(:,1:end-1);
        BBACons = BBACons(:,2:end);
        CCACons = CCACons(:,1:end-1);
        UBACons = UBACons(:,2:end);
        MUACons = MUACons(:,1:end-1);
        HHACons = HHACons(:,1:end-1);
        TTACons = TTACons(:,2:end);
        UTACons = UTACons(:,2:end);
        E2EACons = E2EACons(:,2:end);
        ETACons = ETACons(:,2:end);
        ZZACons = ZZACons(:,2:end);
        WPrimeACons = WPrimeACons(:,2:end);
        ThetaPrimeACons = ThetaPrimeACons(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEACons', 'UUACons', 'WWACons', 'AAACons', 'CCACons', 'BBACons', 'UBACons', 'MUACons', 'HHACons', 'TTACons', 'LLACons', 'UTACons', 'E2EACons', 'ETACons', 'ZZACons', 'WPrimeACons', 'ThetaPrimeACons');
        clear EEACons UUACons WWACons AAACons CCACons BBACons UBACons MUACons HHACons TTACons LLACons UTACons E2EACons ETACons ZZACons WPrimeACons ThetaPrimeACons;
    end

        
    opts.simfile = 'Simulation_HCons.mat';
    if opts.subsim == 'y'
        opts.test = 'HCons';
        [EEHCons, UUHCons, WWHCons, AAHCons, CCHCons, BBHCons, UBHCons, MUHCons, HHHCons, TTHCons, LLHCons, UTHCons, E2EHCons, ETHCons, ZZHCons, WPrimeHCons, ThetaPrimeHCons] = Simulation(params,order,opts,seedval);
        EEHCons = gather(EEHCons);
        UUHCons = gather(UUHCons);
        WWHCons = gather(WWHCons);
        AAHCons = gather(AAHCons);
        BBHCons = gather(BBHCons);
        CCHCons = gather(CCHCons);
        UBHCons = gather(UBHCons);
        MUHCons = gather(MUHCons);
        HHHCons = gather(HHHCons);
        TTHCons = gather(TTHCons);
        UTHCons = gather(UTHCons);
        E2EHCons = gather(E2EHCons);
        ETHCons = gather(ETHCons);
        LLHCons = gather(LLHCons);
        ZZHCons = gather(ZZHCons);
        WPrimeHCons = gather(WPrimeHCons);
        ThetaPrimeHCons = gather(ThetaPrimeHCons);

        EEHCons = EEHCons(:,2:end);
        UUHCons = UUHCons(:,2:end);
        WWHCons = WWHCons(:,2:end);
        AAHCons = AAHCons(:,1:end-1);
        BBHCons = BBHCons(:,2:end);
        CCHCons = CCHCons(:,1:end-1);
        UBHCons = UBHCons(:,2:end);
        MUHCons = MUHCons(:,1:end-1);
        HHHCons = HHHCons(:,1:end-1);
        TTHCons = TTHCons(:,2:end);
        UTHCons = UTHCons(:,2:end);
        E2EHCons = E2EHCons(:,2:end);
        ETHCons = ETHCons(:,2:end);
        ZZHCons = ZZHCons(:,2:end);
        WPrimeHCons = WPrimeHCons(:,2:end);
        ThetaPrimeHCons = ThetaPrimeHCons(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHCons', 'UUHCons', 'WWHCons', 'AAHCons', 'CCHCons', 'BBHCons', 'UBHCons', 'MUHCons', 'HHHCons', 'TTHCons', 'LLHCons', 'UTHCons', 'E2EHCons', 'ETHCons', 'ZZHCons', 'WPrimeHCons', 'ThetaPrimeHCons');
        clear EEHCons UUHCons WWHCons AAHCons CCHCons BBHCons UBHCons MUHCons HHHCons TTHCons LLHCons UTHCons E2EHCons ETHCons ZZHCons WPrimeHCons ThetaPrimeHCons;
    end

    
    opts.simfile = 'Simulation_LCons.mat';
    if opts.subsim == 'y'
        opts.test = 'LCons';
        [EELCons, UULCons, WWLCons, AALCons, CCLCons, BBLCons, UBLCons, MULCons, HHLCons, TTLCons, LLLCons, UTLCons, E2ELCons, ETLCons, ZZLCons, WPrimeLCons, ThetaPrimeLCons] = Simulation(params,order,opts,seedval);
        EELCons = gather(EELCons);
        UULCons = gather(UULCons);
        WWLCons = gather(WWLCons);
        AALCons = gather(AALCons);
        BBLCons = gather(BBLCons);
        CCLCons = gather(CCLCons);
        UBLCons = gather(UBLCons);
        MULCons = gather(MULCons);
        HHLCons = gather(HHLCons);
        TTLCons = gather(TTLCons);
        UTLCons = gather(UTLCons);
        E2ELCons = gather(E2ELCons);
        ETLCons = gather(ETLCons);
        LLLCons = gather(LLLCons);
        ZZLCons = gather(ZZLCons);
        WPrimeLCons = gather(WPrimeLCons);
        ThetaPrimeLCons = gather(ThetaPrimeLCons);

        EELCons = EELCons(:,2:end);
        UULCons = UULCons(:,2:end);
        WWLCons = WWLCons(:,2:end);
        AALCons = AALCons(:,1:end-1);
        BBLCons = BBLCons(:,2:end);
        CCLCons = CCLCons(:,1:end-1);
        UBLCons = UBLCons(:,2:end);
        MULCons = MULCons(:,1:end-1);
        HHLCons = HHLCons(:,1:end-1);
        TTLCons = TTLCons(:,2:end);
        UTLCons = UTLCons(:,2:end);
        E2ELCons = E2ELCons(:,2:end);
        ETLCons = ETLCons(:,2:end);
        ZZLCons = ZZLCons(:,2:end);
        WPrimeLCons = WPrimeLCons(:,2:end);
        ThetaPrimeLCons = ThetaPrimeLCons(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELCons', 'UULCons', 'WWLCons', 'AALCons', 'CCLCons', 'BBLCons', 'UBLCons', 'MULCons', 'HHLCons', 'TTLCons', 'LLLCons', 'UTLCons', 'E2ELCons', 'ETLCons', 'ZZLCons', 'WPrimeLCons', 'ThetaPrimeLCons');
        clear EELCons UULCons WWLCons AALCons CCLCons BBLCons UBLCons MULCons HHLCons TTLCons LLLCons UTLCons E2ELCons ETLCons ZZLCons WPrimeLCons ThetaPrimeLCons;
    end    
    
    opts.simfile = 'Simulation_Q1.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1';
        [EEQ1, UUQ1, WWQ1, AAQ1, CCQ1, BBQ1, UBQ1, MUQ1, HHQ1, TTQ1, LLQ1, UTQ1, E2EQ1, ETQ1, ZZQ1, WPrimeQ1, ThetaPrimeQ1] = Simulation(params,order,opts,seedval);
        EEQ1 = gather(EEQ1);
        UUQ1 = gather(UUQ1);
        WWQ1 = gather(WWQ1);
        AAQ1 = gather(AAQ1);
        BBQ1 = gather(BBQ1);
        CCQ1 = gather(CCQ1);
        UBQ1 = gather(UBQ1);
        MUQ1 = gather(MUQ1);
        HHQ1 = gather(HHQ1);
        TTQ1 = gather(TTQ1);
        UTQ1 = gather(UTQ1);
        E2EQ1 = gather(E2EQ1);
        ETQ1 = gather(ETQ1);
        LLQ1 = gather(LLQ1);
        ZZQ1 = gather(ZZQ1);
        WPrimeQ1 = gather(WPrimeQ1);
        ThetaPrimeQ1 = gather(ThetaPrimeQ1);

        EEQ1 = EEQ1(:,2:end);
        UUQ1 = UUQ1(:,2:end);
        WWQ1 = WWQ1(:,2:end);
        AAQ1 = AAQ1(:,1:end-1);
        BBQ1 = BBQ1(:,2:end);
        CCQ1 = CCQ1(:,1:end-1);
        UBQ1 = UBQ1(:,2:end);
        MUQ1 = MUQ1(:,1:end-1);
        HHQ1 = HHQ1(:,1:end-1);
        TTQ1 = TTQ1(:,2:end);
        UTQ1 = UTQ1(:,2:end);
        E2EQ1 = E2EQ1(:,2:end);
        ETQ1 = ETQ1(:,2:end);
        ZZQ1 = ZZQ1(:,2:end);
        WPrimeQ1 = WPrimeQ1(:,2:end);
        ThetaPrimeQ1 = ThetaPrimeQ1(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1', 'UUQ1', 'WWQ1', 'AAQ1', 'CCQ1', 'BBQ1', 'UBQ1', 'MUQ1', 'HHQ1', 'TTQ1', 'LLQ1', 'UTQ1', 'E2EQ1', 'ETQ1', 'ZZQ1', 'WPrimeQ1', 'ThetaPrimeQ1');
        clear EEQ1 UUQ1 WWQ1 AAQ1 CCQ1 BBQ1 UBQ1 MUQ1 HHQ1 TTQ1 LLQ1 UTQ1 E2EQ1 ETQ1 ZZQ1 WPrimeQ1 ThetaPrimeQ1;
    end
    
    opts.simfile = 'Simulation_Q1A.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1A';
        [EEQ1A, UUQ1A, WWQ1A, AAQ1A, CCQ1A, BBQ1A, UBQ1A, MUQ1A, HHQ1A, TTQ1A, LLQ1A, UTQ1A, E2EQ1A, ETQ1A, ZZQ1A, WPrimeQ1A, ThetaPrimeQ1A] = Simulation(params,order,opts,seedval);
        EEQ1A = gather(EEQ1A);
        UUQ1A = gather(UUQ1A);
        WWQ1A = gather(WWQ1A);
        AAQ1A = gather(AAQ1A);
        BBQ1A = gather(BBQ1A);
        CCQ1A = gather(CCQ1A);
        UBQ1A = gather(UBQ1A);
        MUQ1A = gather(MUQ1A);
        HHQ1A = gather(HHQ1A);
        TTQ1A = gather(TTQ1A);
        UTQ1A = gather(UTQ1A);
        E2EQ1A = gather(E2EQ1A);
        ETQ1A = gather(ETQ1A);
        LLQ1A = gather(LLQ1A);
        ZZQ1A = gather(ZZQ1A);
        WPrimeQ1A = gather(WPrimeQ1A);
        ThetaPrimeQ1A = gather(ThetaPrimeQ1A);

        EEQ1A = EEQ1A(:,2:end);
        UUQ1A = UUQ1A(:,2:end);
        WWQ1A = WWQ1A(:,2:end);
        AAQ1A = AAQ1A(:,1:end-1);
        BBQ1A = BBQ1A(:,2:end);
        CCQ1A = CCQ1A(:,1:end-1);
        UBQ1A = UBQ1A(:,2:end);
        MUQ1A = MUQ1A(:,1:end-1);
        HHQ1A = HHQ1A(:,1:end-1);
        TTQ1A = TTQ1A(:,2:end);
        UTQ1A = UTQ1A(:,2:end);
        E2EQ1A = E2EQ1A(:,2:end);
        ETQ1A = ETQ1A(:,2:end);
        ZZQ1A = ZZQ1A(:,2:end);
        WPrimeQ1A = WPrimeQ1A(:,2:end);
        ThetaPrimeQ1A = ThetaPrimeQ1A(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1A', 'UUQ1A', 'WWQ1A', 'AAQ1A', 'CCQ1A', 'BBQ1A', 'UBQ1A', 'MUQ1A', 'HHQ1A', 'TTQ1A', 'LLQ1A', 'UTQ1A', 'E2EQ1A', 'ETQ1A', 'ZZQ1A', 'WPrimeQ1A', 'ThetaPrimeQ1A');
        clear EEQ1A UUQ1A WWQ1A AAQ1A CCQ1A BBQ1A UBQ1A MUQ1A HHQ1A TTQ1A LLQ1A UTQ1A E2EQ1A ETQ1A ZZQ1A WPrimeQ1A ThetaPrimeQ1A;
    end
    
    opts.simfile = 'Simulation_Q1H.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1H';
        [EEQ1H, UUQ1H, WWQ1H, AAQ1H, CCQ1H, BBQ1H, UBQ1H, MUQ1H, HHQ1H, TTQ1H, LLQ1H, UTQ1H, E2EQ1H, ETQ1H, ZZQ1H, WPrimeQ1H, ThetaPrimeQ1H] = Simulation(params,order,opts,seedval);
        EEQ1H = gather(EEQ1H);
        UUQ1H = gather(UUQ1H);
        WWQ1H = gather(WWQ1H);
        AAQ1H = gather(AAQ1H);
        BBQ1H = gather(BBQ1H);
        CCQ1H = gather(CCQ1H);
        UBQ1H = gather(UBQ1H);
        MUQ1H = gather(MUQ1H);
        HHQ1H = gather(HHQ1H);
        TTQ1H = gather(TTQ1H);
        UTQ1H = gather(UTQ1H);
        E2EQ1H = gather(E2EQ1H);
        ETQ1H = gather(ETQ1H);
        LLQ1H = gather(LLQ1H);
        ZZQ1H = gather(ZZQ1H);
        WPrimeQ1H = gather(WPrimeQ1H);
        ThetaPrimeQ1H = gather(ThetaPrimeQ1H);

        EEQ1H = EEQ1H(:,2:end);
        UUQ1H = UUQ1H(:,2:end);
        WWQ1H = WWQ1H(:,2:end);
        AAQ1H = AAQ1H(:,1:end-1);
        BBQ1H = BBQ1H(:,2:end);
        CCQ1H = CCQ1H(:,1:end-1);
        UBQ1H = UBQ1H(:,2:end);
        MUQ1H = MUQ1H(:,1:end-1);
        HHQ1H = HHQ1H(:,1:end-1);
        TTQ1H = TTQ1H(:,2:end);
        UTQ1H = UTQ1H(:,2:end);
        E2EQ1H = E2EQ1H(:,2:end);
        ETQ1H = ETQ1H(:,2:end);
        ZZQ1H = ZZQ1H(:,2:end);
        WPrimeQ1H = WPrimeQ1H(:,2:end);
        ThetaPrimeQ1H = ThetaPrimeQ1H(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1H', 'UUQ1H', 'WWQ1H', 'AAQ1H', 'CCQ1H', 'BBQ1H', 'UBQ1H', 'MUQ1H', 'HHQ1H', 'TTQ1H', 'LLQ1H', 'UTQ1H', 'E2EQ1H', 'ETQ1H', 'ZZQ1H', 'WPrimeQ1H', 'ThetaPrimeQ1H');
        clear EEQ1H UUQ1H WWQ1H AAQ1H CCQ1H BBQ1H UBQ1H MUQ1H HHQ1H TTQ1H LLQ1H UTQ1H E2EQ1H ETQ1H ZZQ1H WPrimeQ1H ThetaPrimeQ1H;
    end
    
    opts.simfile = 'Simulation_Q1L.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1L';
        [EEQ1L, UUQ1L, WWQ1L, AAQ1L, CCQ1L, BBQ1L, UBQ1L, MUQ1L, HHQ1L, TTQ1L, LLQ1L, UTQ1L, E2EQ1L, ETQ1L, ZZQ1L, WPrimeQ1L, ThetaPrimeQ1L] = Simulation(params,order,opts,seedval);
        EEQ1L = gather(EEQ1L);
        UUQ1L = gather(UUQ1L);
        WWQ1L = gather(WWQ1L);
        AAQ1L = gather(AAQ1L);
        BBQ1L = gather(BBQ1L);
        CCQ1L = gather(CCQ1L);
        UBQ1L = gather(UBQ1L);
        MUQ1L = gather(MUQ1L);
        HHQ1L = gather(HHQ1L);
        TTQ1L = gather(TTQ1L);
        UTQ1L = gather(UTQ1L);
        E2EQ1L = gather(E2EQ1L);
        ETQ1L = gather(ETQ1L);
        LLQ1L = gather(LLQ1L);
        ZZQ1L = gather(ZZQ1L);
        WPrimeQ1L = gather(WPrimeQ1L);
        ThetaPrimeQ1L = gather(ThetaPrimeQ1L);

        EEQ1L = EEQ1L(:,2:end);
        UUQ1L = UUQ1L(:,2:end);
        WWQ1L = WWQ1L(:,2:end);
        AAQ1L = AAQ1L(:,1:end-1);
        BBQ1L = BBQ1L(:,2:end);
        CCQ1L = CCQ1L(:,1:end-1);
        UBQ1L = UBQ1L(:,2:end);
        MUQ1L = MUQ1L(:,1:end-1);
        HHQ1L = HHQ1L(:,1:end-1);
        TTQ1L = TTQ1L(:,2:end);
        UTQ1L = UTQ1L(:,2:end);
        E2EQ1L = E2EQ1L(:,2:end);
        ETQ1L = ETQ1L(:,2:end);
        ZZQ1L = ZZQ1L(:,2:end);
        WPrimeQ1L = WPrimeQ1L(:,2:end);
        ThetaPrimeQ1L = ThetaPrimeQ1L(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1L', 'UUQ1L', 'WWQ1L', 'AAQ1L', 'CCQ1L', 'BBQ1L', 'UBQ1L', 'MUQ1L', 'HHQ1L', 'TTQ1L', 'LLQ1L', 'UTQ1L', 'E2EQ1L', 'ETQ1L', 'ZZQ1L', 'WPrimeQ1L', 'ThetaPrimeQ1L');
        clear EEQ1L UUQ1L WWQ1L AAQ1L CCQ1L BBQ1L UBQ1L MUQ1L HHQ1L TTQ1L LLQ1L UTQ1L E2EQ1L ETQ1L ZZQ1L WPrimeQ1L ThetaPrimeQ1L;
    end
    
    opts.simfile = 'Simulation_Q1DA.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1DA';
        [EEQ1DA, UUQ1DA, WWQ1DA, AAQ1DA, CCQ1DA, BBQ1DA, UBQ1DA, MUQ1DA, HHQ1DA, TTQ1DA, LLQ1DA, UTQ1DA, E2EQ1DA, ETQ1DA, ZZQ1DA, WPrimeQ1DA, ThetaPrimeQ1DA] = Simulation(params,order,opts,seedval);
        EEQ1DA = gather(EEQ1DA);
        UUQ1DA = gather(UUQ1DA);
        WWQ1DA = gather(WWQ1DA);
        AAQ1DA = gather(AAQ1DA);
        BBQ1DA = gather(BBQ1DA);
        CCQ1DA = gather(CCQ1DA);
        UBQ1DA = gather(UBQ1DA);
        MUQ1DA = gather(MUQ1DA);
        HHQ1DA = gather(HHQ1DA);
        TTQ1DA = gather(TTQ1DA);
        UTQ1DA = gather(UTQ1DA);
        E2EQ1DA = gather(E2EQ1DA);
        ETQ1DA = gather(ETQ1DA);
        LLQ1DA = gather(LLQ1DA);
        ZZQ1DA = gather(ZZQ1DA);
        WPrimeQ1DA = gather(WPrimeQ1DA);
        ThetaPrimeQ1DA = gather(ThetaPrimeQ1DA);

        EEQ1DA = EEQ1DA(:,2:end);
        UUQ1DA = UUQ1DA(:,2:end);
        WWQ1DA = WWQ1DA(:,2:end);
        AAQ1DA = AAQ1DA(:,1:end-1);
        BBQ1DA = BBQ1DA(:,2:end);
        CCQ1DA = CCQ1DA(:,1:end-1);
        UBQ1DA = UBQ1DA(:,2:end);
        MUQ1DA = MUQ1DA(:,1:end-1);
        HHQ1DA = HHQ1DA(:,1:end-1);
        TTQ1DA = TTQ1DA(:,2:end);
        UTQ1DA = UTQ1DA(:,2:end);
        E2EQ1DA = E2EQ1DA(:,2:end);
        ETQ1DA = ETQ1DA(:,2:end);
        ZZQ1DA = ZZQ1DA(:,2:end);
        WPrimeQ1DA = WPrimeQ1DA(:,2:end);
        ThetaPrimeQ1DA = ThetaPrimeQ1DA(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1DA', 'UUQ1DA', 'WWQ1DA', 'AAQ1DA', 'CCQ1DA', 'BBQ1DA', 'UBQ1DA', 'MUQ1DA', 'HHQ1DA', 'TTQ1DA', 'LLQ1DA', 'UTQ1DA', 'E2EQ1DA', 'ETQ1DA', 'ZZQ1DA', 'WPrimeQ1DA', 'ThetaPrimeQ1DA');
        clear EEQ1DA UUQ1DA WWQ1DA AAQ1DA CCQ1DA BBQ1DA UBQ1DA MUQ1DA HHQ1DA TTQ1DA LLQ1DA UTQ1DA E2EQ1DA ETQ1DA ZZQ1DA WPrimeQ1DA ThetaPrimeQ1DA;
    end
    
    opts.simfile = 'Simulation_Q1DH.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1DH';
        [EEQ1DH, UUQ1DH, WWQ1DH, AAQ1DH, CCQ1DH, BBQ1DH, UBQ1DH, MUQ1DH, HHQ1DH, TTQ1DH, LLQ1DH, UTQ1DH, E2EQ1DH, ETQ1DH, ZZQ1DH, WPrimeQ1DH, ThetaPrimeQ1DH] = Simulation(params,order,opts,seedval);
        EEQ1DH = gather(EEQ1DH);
        UUQ1DH = gather(UUQ1DH);
        WWQ1DH = gather(WWQ1DH);
        AAQ1DH = gather(AAQ1DH);
        BBQ1DH = gather(BBQ1DH);
        CCQ1DH = gather(CCQ1DH);
        UBQ1DH = gather(UBQ1DH);
        MUQ1DH = gather(MUQ1DH);
        HHQ1DH = gather(HHQ1DH);
        TTQ1DH = gather(TTQ1DH);
        UTQ1DH = gather(UTQ1DH);
        E2EQ1DH = gather(E2EQ1DH);
        ETQ1DH = gather(ETQ1DH);
        LLQ1DH = gather(LLQ1DH);
        ZZQ1DH = gather(ZZQ1DH);
        WPrimeQ1DH = gather(WPrimeQ1DH);
        ThetaPrimeQ1DH = gather(ThetaPrimeQ1DH);

        EEQ1DH = EEQ1DH(:,2:end);
        UUQ1DH = UUQ1DH(:,2:end);
        WWQ1DH = WWQ1DH(:,2:end);
        AAQ1DH = AAQ1DH(:,1:end-1);
        BBQ1DH = BBQ1DH(:,2:end);
        CCQ1DH = CCQ1DH(:,1:end-1);
        UBQ1DH = UBQ1DH(:,2:end);
        MUQ1DH = MUQ1DH(:,1:end-1);
        HHQ1DH = HHQ1DH(:,1:end-1);
        TTQ1DH = TTQ1DH(:,2:end);
        UTQ1DH = UTQ1DH(:,2:end);
        E2EQ1DH = E2EQ1DH(:,2:end);
        ETQ1DH = ETQ1DH(:,2:end);
        ZZQ1DH = ZZQ1DH(:,2:end);
        WPrimeQ1DH = WPrimeQ1DH(:,2:end);
        ThetaPrimeQ1DH = ThetaPrimeQ1DH(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1DH', 'UUQ1DH', 'WWQ1DH', 'AAQ1DH', 'CCQ1DH', 'BBQ1DH', 'UBQ1DH', 'MUQ1DH', 'HHQ1DH', 'TTQ1DH', 'LLQ1DH', 'UTQ1DH', 'E2EQ1DH', 'ETQ1DH', 'ZZQ1DH', 'WPrimeQ1DH', 'ThetaPrimeQ1DH');
        clear EEQ1DH UUQ1DH WWQ1DH AAQ1DH CCQ1DH BBQ1DH UBQ1DH MUQ1DH HHQ1DH TTQ1DH LLQ1DH UTQ1DH E2EQ1DH ETQ1DH ZZQ1DH WPrimeQ1DH ThetaPrimeQ1DH;
    end
    
    opts.simfile = 'Simulation_Q1DL.mat';
    if opts.subsim == 'y'
        opts.test = 'Q1DL';
        [EEQ1DL, UUQ1DL, WWQ1DL, AAQ1DL, CCQ1DL, BBQ1DL, UBQ1DL, MUQ1DL, HHQ1DL, TTQ1DL, LLQ1DL, UTQ1DL, E2EQ1DL, ETQ1DL, ZZQ1DL, WPrimeQ1DL, ThetaPrimeQ1DL] = Simulation(params,order,opts,seedval);
        EEQ1DL = gather(EEQ1DL);
        UUQ1DL = gather(UUQ1DL);
        WWQ1DL = gather(WWQ1DL);
        AAQ1DL = gather(AAQ1DL);
        BBQ1DL = gather(BBQ1DL);
        CCQ1DL = gather(CCQ1DL);
        UBQ1DL = gather(UBQ1DL);
        MUQ1DL = gather(MUQ1DL);
        HHQ1DL = gather(HHQ1DL);
        TTQ1DL = gather(TTQ1DL);
        UTQ1DL = gather(UTQ1DL);
        E2EQ1DL = gather(E2EQ1DL);
        ETQ1DL = gather(ETQ1DL);
        LLQ1DL = gather(LLQ1DL);
        ZZQ1DL = gather(ZZQ1DL);
        WPrimeQ1DL = gather(WPrimeQ1DL);
        ThetaPrimeQ1DL = gather(ThetaPrimeQ1DL);

        EEQ1DL = EEQ1DL(:,2:end);
        UUQ1DL = UUQ1DL(:,2:end);
        WWQ1DL = WWQ1DL(:,2:end);
        AAQ1DL = AAQ1DL(:,1:end-1);
        BBQ1DL = BBQ1DL(:,2:end);
        CCQ1DL = CCQ1DL(:,1:end-1);
        UBQ1DL = UBQ1DL(:,2:end);
        MUQ1DL = MUQ1DL(:,1:end-1);
        HHQ1DL = HHQ1DL(:,1:end-1);
        TTQ1DL = TTQ1DL(:,2:end);
        UTQ1DL = UTQ1DL(:,2:end);
        E2EQ1DL = E2EQ1DL(:,2:end);
        ETQ1DL = ETQ1DL(:,2:end);
        ZZQ1DL = ZZQ1DL(:,2:end);
        WPrimeQ1DL = WPrimeQ1DL(:,2:end);
        ThetaPrimeQ1DL = ThetaPrimeQ1DL(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEQ1DL', 'UUQ1DL', 'WWQ1DL', 'AAQ1DL', 'CCQ1DL', 'BBQ1DL', 'UBQ1DL', 'MUQ1DL', 'HHQ1DL', 'TTQ1DL', 'LLQ1DL', 'UTQ1DL', 'E2EQ1DL', 'ETQ1DL', 'ZZQ1DL', 'WPrimeQ1DL', 'ThetaPrimeQ1DL');
        clear EEQ1DL UUQ1DL WWQ1DL AAQ1DL CCQ1DL BBQ1DL UBQ1DL MUQ1DL HHQ1DL TTQ1DL LLQ1DL UTQ1DL E2EQ1DL ETQ1DL ZZQ1DL WPrimeQ1DL ThetaPrimeQ1DL;
    end
    
    opts.simfile = 'Simulation_Med.mat';
    if opts.subsim == 'y'
        opts.test = 'Med';
        [EEMed, UUMed, WWMed, AAMed, CCMed, BBMed, UBMed, MUMed, HHMed, TTMed, LLMed, UTMed, E2EMed, ETMed, ZZMed, WPrimeMed, ThetaPrimeMed] = Simulation(params,order,opts,seedval);
        EEMed = gather(EEMed);
        UUMed = gather(UUMed);
        WWMed = gather(WWMed);
        AAMed = gather(AAMed);
        BBMed = gather(BBMed);
        CCMed = gather(CCMed);
        UBMed = gather(UBMed);
        MUMed = gather(MUMed);
        HHMed = gather(HHMed);
        TTMed = gather(TTMed);
        UTMed = gather(UTMed);
        E2EMed = gather(E2EMed);
        ETMed = gather(ETMed);
        LLMed = gather(LLMed);
        ZZMed = gather(ZZMed);
        WPrimeMed = gather(WPrimeMed);
        ThetaPrimeMed = gather(ThetaPrimeMed);

        EEMed = EEMed(:,2:end);
        UUMed = UUMed(:,2:end);
        WWMed = WWMed(:,2:end);
        AAMed = AAMed(:,1:end-1);
        BBMed = BBMed(:,2:end);
        CCMed = CCMed(:,1:end-1);
        UBMed = UBMed(:,2:end);
        MUMed = MUMed(:,1:end-1);
        HHMed = HHMed(:,1:end-1);
        TTMed = TTMed(:,2:end);
        UTMed = UTMed(:,2:end);
        E2EMed = E2EMed(:,2:end);
        ETMed = ETMed(:,2:end);
        ZZMed = ZZMed(:,2:end);
        WPrimeMed = WPrimeMed(:,2:end);
        ThetaPrimeMed = ThetaPrimeMed(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEMed', 'UUMed', 'WWMed', 'AAMed', 'CCMed', 'BBMed', 'UBMed', 'MUMed', 'HHMed', 'TTMed', 'LLMed', 'UTMed', 'E2EMed', 'ETMed', 'ZZMed', 'WPrimeMed', 'ThetaPrimeMed');
        clear EEMed UUMed WWMed AAMed CCMed BBMed UBMed MUMed HHMed TTMed LLMed UTMed E2EMed ETMed ZZMed WPrimeMed ThetaPrimeMed;
    end
    
    
    opts.simfile = 'Simulation_A1050.mat';
    if opts.subsim == 'y'
        opts.test = 'A1050';
        [EEA1050, UUA1050, WWA1050, AAA1050, CCA1050, BBA1050, UBA1050, MUA1050, HHA1050, TTA1050, LLA1050, UTA1050, E2EA1050, ETA1050, ZZA1050, WPrimeA1050, ThetaPrimeA1050] = Simulation(params,order,opts,seedval);
        EEA1050 = gather(EEA1050);
        UUA1050 = gather(UUA1050);
        WWA1050 = gather(WWA1050);
        AAA1050 = gather(AAA1050);
        BBA1050 = gather(BBA1050);
        CCA1050 = gather(CCA1050);
        UBA1050 = gather(UBA1050);
        MUA1050 = gather(MUA1050);
        HHA1050 = gather(HHA1050);
        TTA1050 = gather(TTA1050);
        UTA1050 = gather(UTA1050);
        E2EA1050 = gather(E2EA1050);
        ETA1050 = gather(ETA1050);
        LLA1050 = gather(LLA1050);
        ZZA1050 = gather(ZZA1050);
        WPrimeA1050 = gather(WPrimeA1050);
        ThetaPrimeA1050 = gather(ThetaPrimeA1050);

        EEA1050 = EEA1050(:,2:end);
        UUA1050 = UUA1050(:,2:end);
        WWA1050 = WWA1050(:,2:end);
        AAA1050 = AAA1050(:,1:end-1);
        BBA1050 = BBA1050(:,2:end);
        CCA1050 = CCA1050(:,1:end-1);
        UBA1050 = UBA1050(:,2:end);
        MUA1050 = MUA1050(:,1:end-1);
        HHA1050 = HHA1050(:,1:end-1);
        TTA1050 = TTA1050(:,2:end);
        UTA1050 = UTA1050(:,2:end);
        E2EA1050 = E2EA1050(:,2:end);
        ETA1050 = ETA1050(:,2:end);
        ZZA1050 = ZZA1050(:,2:end);
        WPrimeA1050 = WPrimeA1050(:,2:end);
        ThetaPrimeA1050 = ThetaPrimeA1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEA1050', 'UUA1050', 'WWA1050', 'AAA1050', 'CCA1050', 'BBA1050', 'UBA1050', 'MUA1050', 'HHA1050', 'TTA1050', 'LLA1050', 'UTA1050', 'E2EA1050', 'ETA1050', 'ZZA1050', 'WPrimeA1050', 'ThetaPrimeA1050');
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
    end

    opts.simfile = 'Simulation_H1050.mat';
    if opts.subsim == 'y'
        opts.test = 'H1050';
        [EEH1050, UUH1050, WWH1050, AAH1050, CCH1050, BBH1050, UBH1050, MUH1050, HHH1050, TTH1050, LLH1050, UTH1050, E2EH1050, ETH1050, ZZH1050, WPrimeH1050, ThetaPrimeH1050] = Simulation(params,order,opts,seedval);
        EEH1050 = gather(EEH1050);
        UUH1050 = gather(UUH1050);
        WWH1050 = gather(WWH1050);
        AAH1050 = gather(AAH1050);
        BBH1050 = gather(BBH1050);
        CCH1050 = gather(CCH1050);
        UBH1050 = gather(UBH1050);
        MUH1050 = gather(MUH1050);
        HHH1050 = gather(HHH1050);
        TTH1050 = gather(TTH1050);
        UTH1050 = gather(UTH1050);
        E2EH1050 = gather(E2EH1050);
        ETH1050 = gather(ETH1050);
        LLH1050 = gather(LLH1050);
        ZZH1050 = gather(ZZH1050);
        WPrimeH1050 = gather(WPrimeH1050);
        ThetaPrimeH1050 = gather(ThetaPrimeH1050);

        EEH1050 = EEH1050(:,2:end);
        UUH1050 = UUH1050(:,2:end);
        WWH1050 = WWH1050(:,2:end);
        AAH1050 = AAH1050(:,1:end-1);
        BBH1050 = BBH1050(:,2:end);
        CCH1050 = CCH1050(:,1:end-1);
        UBH1050 = UBH1050(:,2:end);
        MUH1050 = MUH1050(:,1:end-1);
        HHH1050 = HHH1050(:,1:end-1);
        TTH1050 = TTH1050(:,2:end);
        UTH1050 = UTH1050(:,2:end);
        E2EH1050 = E2EH1050(:,2:end);
        ETH1050 = ETH1050(:,2:end);
        ZZH1050 = ZZH1050(:,2:end);
        WPrimeH1050 = WPrimeH1050(:,2:end);
        ThetaPrimeH1050 = ThetaPrimeH1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEH1050', 'UUH1050', 'WWH1050', 'AAH1050', 'CCH1050', 'BBH1050', 'UBH1050', 'MUH1050', 'HHH1050', 'TTH1050', 'LLH1050', 'UTH1050', 'E2EH1050', 'ETH1050', 'ZZH1050', 'WPrimeH1050', 'ThetaPrimeH1050');
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
    end

    opts.simfile = 'Simulation_L1050.mat';
    if opts.subsim == 'y'
        opts.test = 'L1050';
        [EEL1050, UUL1050, WWL1050, AAL1050, CCL1050, BBL1050, UBL1050, MUL1050, HHL1050, TTL1050, LLL1050, UTL1050, E2EL1050, ETL1050, ZZL1050, WPrimeL1050, ThetaPrimeL1050] = Simulation(params,order,opts,seedval);
        EEL1050 = gather(EEL1050);
        UUL1050 = gather(UUL1050);
        WWL1050 = gather(WWL1050);
        AAL1050 = gather(AAL1050);
        BBL1050 = gather(BBL1050);
        CCL1050 = gather(CCL1050);
        UBL1050 = gather(UBL1050);
        MUL1050 = gather(MUL1050);
        HHL1050 = gather(HHL1050);
        TTL1050 = gather(TTL1050);
        UTL1050 = gather(UTL1050);
        E2EL1050 = gather(E2EL1050);
        ETL1050 = gather(ETL1050);
        LLL1050 = gather(LLL1050);
        ZZL1050 = gather(ZZL1050);
        WPrimeL1050 = gather(WPrimeL1050);
        ThetaPrimeL1050 = gather(ThetaPrimeL1050);

        EEL1050 = EEL1050(:,2:end);
        UUL1050 = UUL1050(:,2:end);
        WWL1050 = WWL1050(:,2:end);
        AAL1050 = AAL1050(:,1:end-1);
        BBL1050 = BBL1050(:,2:end);
        CCL1050 = CCL1050(:,1:end-1);
        UBL1050 = UBL1050(:,2:end);
        MUL1050 = MUL1050(:,1:end-1);
        HHL1050 = HHL1050(:,1:end-1);
        TTL1050 = TTL1050(:,2:end);
        UTL1050 = UTL1050(:,2:end);
        E2EL1050 = E2EL1050(:,2:end);
        ETL1050 = ETL1050(:,2:end);
        ZZL1050 = ZZL1050(:,2:end);
        WPrimeL1050 = WPrimeL1050(:,2:end);
        ThetaPrimeL1050 = ThetaPrimeL1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEL1050', 'UUL1050', 'WWL1050', 'AAL1050', 'CCL1050', 'BBL1050', 'UBL1050', 'MUL1050', 'HHL1050', 'TTL1050', 'LLL1050', 'UTL1050', 'E2EL1050', 'ETL1050', 'ZZL1050', 'WPrimeL1050', 'ThetaPrimeL1050');
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
    end
    
    opts.simfile = 'Simulation_AD1050.mat';
    if opts.subsim == 'y'
        opts.test = 'AD1050';
        [EEAD1050, UUAD1050, WWAD1050, AAAD1050, CCAD1050, BBAD1050, UBAD1050, MUAD1050, HHAD1050, TTAD1050, LLAD1050, UTAD1050, E2EAD1050, ETAD1050, ZZAD1050, WPrimeAD1050, ThetaPrimeAD1050] = Simulation(params,order,opts,seedval);
        EEAD1050 = gather(EEAD1050);
        UUAD1050 = gather(UUAD1050);
        WWAD1050 = gather(WWAD1050);
        AAAD1050 = gather(AAAD1050);
        BBAD1050 = gather(BBAD1050);
        CCAD1050 = gather(CCAD1050);
        UBAD1050 = gather(UBAD1050);
        MUAD1050 = gather(MUAD1050);
        HHAD1050 = gather(HHAD1050);
        TTAD1050 = gather(TTAD1050);
        UTAD1050 = gather(UTAD1050);
        E2EAD1050 = gather(E2EAD1050);
        ETAD1050 = gather(ETAD1050);
        LLAD1050 = gather(LLAD1050);
        ZZAD1050 = gather(ZZAD1050);
        WPrimeAD1050 = gather(WPrimeAD1050);
        ThetaPrimeAD1050 = gather(ThetaPrimeAD1050);

        EEAD1050 = EEAD1050(:,2:end);
        UUAD1050 = UUAD1050(:,2:end);
        WWAD1050 = WWAD1050(:,2:end);
        AAAD1050 = AAAD1050(:,1:end-1);
        BBAD1050 = BBAD1050(:,2:end);
        CCAD1050 = CCAD1050(:,1:end-1);
        UBAD1050 = UBAD1050(:,2:end);
        MUAD1050 = MUAD1050(:,1:end-1);
        HHAD1050 = HHAD1050(:,1:end-1);
        TTAD1050 = TTAD1050(:,2:end);
        UTAD1050 = UTAD1050(:,2:end);
        E2EAD1050 = E2EAD1050(:,2:end);
        ETAD1050 = ETAD1050(:,2:end);
        ZZAD1050 = ZZAD1050(:,2:end);
        WPrimeAD1050 = WPrimeAD1050(:,2:end);
        ThetaPrimeAD1050 = ThetaPrimeAD1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAD1050', 'UUAD1050', 'WWAD1050', 'AAAD1050', 'CCAD1050', 'BBAD1050', 'UBAD1050', 'MUAD1050', 'HHAD1050', 'TTAD1050', 'LLAD1050', 'UTAD1050', 'E2EAD1050', 'ETAD1050', 'ZZAD1050', 'WPrimeAD1050', 'ThetaPrimeAD1050');
        clear EEAD1050 UUAD1050 WWAD1050 AAAD1050 CCAD1050 BBAD1050 UBAD1050 MUAD1050 HHAD1050 TTAD1050 LLAD1050 UTAD1050 E2EAD1050 ETAD1050 ZZAD1050 WPrimeAD1050 ThetaPrimeAD1050;
    end

    opts.simfile = 'Simulation_HD1050.mat';
    if opts.subsim == 'y'
        opts.test = 'HD1050';
        [EEHD1050, UUHD1050, WWHD1050, AAHD1050, CCHD1050, BBHD1050, UBHD1050, MUHD1050, HHHD1050, TTHD1050, LLHD1050, UTHD1050, E2EHD1050, ETHD1050, ZZHD1050, WPrimeHD1050, ThetaPrimeHD1050] = Simulation(params,order,opts,seedval);
        EEHD1050 = gather(EEHD1050);
        UUHD1050 = gather(UUHD1050);
        WWHD1050 = gather(WWHD1050);
        AAHD1050 = gather(AAHD1050);
        BBHD1050 = gather(BBHD1050);
        CCHD1050 = gather(CCHD1050);
        UBHD1050 = gather(UBHD1050);
        MUHD1050 = gather(MUHD1050);
        HHHD1050 = gather(HHHD1050);
        TTHD1050 = gather(TTHD1050);
        UTHD1050 = gather(UTHD1050);
        E2EHD1050 = gather(E2EHD1050);
        ETHD1050 = gather(ETHD1050);
        LLHD1050 = gather(LLHD1050);
        ZZHD1050 = gather(ZZHD1050);
        WPrimeHD1050 = gather(WPrimeHD1050);
        ThetaPrimeHD1050 = gather(ThetaPrimeHD1050);

        EEHD1050 = EEHD1050(:,2:end);
        UUHD1050 = UUHD1050(:,2:end);
        WWHD1050 = WWHD1050(:,2:end);
        AAHD1050 = AAHD1050(:,1:end-1);
        BBHD1050 = BBHD1050(:,2:end);
        CCHD1050 = CCHD1050(:,1:end-1);
        UBHD1050 = UBHD1050(:,2:end);
        MUHD1050 = MUHD1050(:,1:end-1);
        HHHD1050 = HHHD1050(:,1:end-1);
        TTHD1050 = TTHD1050(:,2:end);
        UTHD1050 = UTHD1050(:,2:end);
        E2EHD1050 = E2EHD1050(:,2:end);
        ETHD1050 = ETHD1050(:,2:end);
        ZZHD1050 = ZZHD1050(:,2:end);
        WPrimeHD1050 = WPrimeHD1050(:,2:end);
        ThetaPrimeHD1050 = ThetaPrimeHD1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHD1050', 'UUHD1050', 'WWHD1050', 'AAHD1050', 'CCHD1050', 'BBHD1050', 'UBHD1050', 'MUHD1050', 'HHHD1050', 'TTHD1050', 'LLHD1050', 'UTHD1050', 'E2EHD1050', 'ETHD1050', 'ZZHD1050', 'WPrimeHD1050', 'ThetaPrimeHD1050');
        clear EEHD1050 UUHD1050 WWHD1050 AAHD1050 CCHD1050 BBHD1050 UBHD1050 MUHD1050 HHHD1050 TTHD1050 LLHD1050 UTHD1050 E2EHD1050 ETHD1050 ZZHD1050 WPrimeHD1050 ThetaPrimeHD1050;
    end

    opts.simfile = 'Simulation_LD1050.mat';
    if opts.subsim == 'y'
        opts.test = 'LD1050';
        [EELD1050, UULD1050, WWLD1050, AALD1050, CCLD1050, BBLD1050, UBLD1050, MULD1050, HHLD1050, TTLD1050, LLLD1050, UTLD1050, E2ELD1050, ETLD1050, ZZLD1050, WPrimeLD1050, ThetaPrimeLD1050] = Simulation(params,order,opts,seedval);
        EELD1050 = gather(EELD1050);
        UULD1050 = gather(UULD1050);
        WWLD1050 = gather(WWLD1050);
        AALD1050 = gather(AALD1050);
        BBLD1050 = gather(BBLD1050);
        CCLD1050 = gather(CCLD1050);
        UBLD1050 = gather(UBLD1050);
        MULD1050 = gather(MULD1050);
        HHLD1050 = gather(HHLD1050);
        TTLD1050 = gather(TTLD1050);
        UTLD1050 = gather(UTLD1050);
        E2ELD1050 = gather(E2ELD1050);
        ETLD1050 = gather(ETLD1050);
        LLLD1050 = gather(LLLD1050);
        ZZLD1050 = gather(ZZLD1050);
        WPrimeLD1050 = gather(WPrimeLD1050);
        ThetaPrimeLD1050 = gather(ThetaPrimeLD1050);

        EELD1050 = EELD1050(:,2:end);
        UULD1050 = UULD1050(:,2:end);
        WWLD1050 = WWLD1050(:,2:end);
        AALD1050 = AALD1050(:,1:end-1);
        BBLD1050 = BBLD1050(:,2:end);
        CCLD1050 = CCLD1050(:,1:end-1);
        UBLD1050 = UBLD1050(:,2:end);
        MULD1050 = MULD1050(:,1:end-1);
        HHLD1050 = HHLD1050(:,1:end-1);
        TTLD1050 = TTLD1050(:,2:end);
        UTLD1050 = UTLD1050(:,2:end);
        E2ELD1050 = E2ELD1050(:,2:end);
        ETLD1050 = ETLD1050(:,2:end);
        ZZLD1050 = ZZLD1050(:,2:end);
        WPrimeLD1050 = WPrimeLD1050(:,2:end);
        ThetaPrimeLD1050 = ThetaPrimeLD1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELD1050', 'UULD1050', 'WWLD1050', 'AALD1050', 'CCLD1050', 'BBLD1050', 'UBLD1050', 'MULD1050', 'HHLD1050', 'TTLD1050', 'LLLD1050', 'UTLD1050', 'E2ELD1050', 'ETLD1050', 'ZZLD1050', 'WPrimeLD1050', 'ThetaPrimeLD1050');
        clear EELD1050 UULD1050 WWLD1050 AALD1050 CCLD1050 BBLD1050 UBLD1050 MULD1050 HHLD1050 TTLD1050 LLLD1050 UTLD1050 E2ELD1050 ETLD1050 ZZLD1050 WPrimeLD1050 ThetaPrimeLD1050;
    end
    
    opts.simfile = 'Simulation_AQ1050.mat';
    if opts.subsim == 'y'
        opts.test = 'AQ1050';
        [EEAQ1050, UUAQ1050, WWAQ1050, AAAQ1050, CCAQ1050, BBAQ1050, UBAQ1050, MUAQ1050, HHAQ1050, TTAQ1050, LLAQ1050, UTAQ1050, E2EAQ1050, ETAQ1050, ZZAQ1050, WPrimeAQ1050, ThetaPrimeAQ1050] = Simulation(params,order,opts,seedval);
        EEAQ1050 = gather(EEAQ1050);
        UUAQ1050 = gather(UUAQ1050);
        WWAQ1050 = gather(WWAQ1050);
        AAAQ1050 = gather(AAAQ1050);
        BBAQ1050 = gather(BBAQ1050);
        CCAQ1050 = gather(CCAQ1050);
        UBAQ1050 = gather(UBAQ1050);
        MUAQ1050 = gather(MUAQ1050);
        HHAQ1050 = gather(HHAQ1050);
        TTAQ1050 = gather(TTAQ1050);
        UTAQ1050 = gather(UTAQ1050);
        E2EAQ1050 = gather(E2EAQ1050);
        ETAQ1050 = gather(ETAQ1050);
        LLAQ1050 = gather(LLAQ1050);
        ZZAQ1050 = gather(ZZAQ1050);
        WPrimeAQ1050 = gather(WPrimeAQ1050);
        ThetaPrimeAQ1050 = gather(ThetaPrimeAQ1050);

        EEAQ1050 = EEAQ1050(:,2:end);
        UUAQ1050 = UUAQ1050(:,2:end);
        WWAQ1050 = WWAQ1050(:,2:end);
        AAAQ1050 = AAAQ1050(:,1:end-1);
        BBAQ1050 = BBAQ1050(:,2:end);
        CCAQ1050 = CCAQ1050(:,1:end-1);
        UBAQ1050 = UBAQ1050(:,2:end);
        MUAQ1050 = MUAQ1050(:,1:end-1);
        HHAQ1050 = HHAQ1050(:,1:end-1);
        TTAQ1050 = TTAQ1050(:,2:end);
        UTAQ1050 = UTAQ1050(:,2:end);
        E2EAQ1050 = E2EAQ1050(:,2:end);
        ETAQ1050 = ETAQ1050(:,2:end);
        ZZAQ1050 = ZZAQ1050(:,2:end);
        WPrimeAQ1050 = WPrimeAQ1050(:,2:end);
        ThetaPrimeAQ1050 = ThetaPrimeAQ1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAQ1050', 'UUAQ1050', 'WWAQ1050', 'AAAQ1050', 'CCAQ1050', 'BBAQ1050', 'UBAQ1050', 'MUAQ1050', 'HHAQ1050', 'TTAQ1050', 'LLAQ1050', 'UTAQ1050', 'E2EAQ1050', 'ETAQ1050', 'ZZAQ1050', 'WPrimeAQ1050', 'ThetaPrimeAQ1050');
        clear EEAQ1050 UUAQ1050 WWAQ1050 AAAQ1050 CCAQ1050 BBAQ1050 UBAQ1050 MUAQ1050 HHAQ1050 TTAQ1050 LLAQ1050 UTAQ1050 E2EAQ1050 ETAQ1050 ZZAQ1050 WPrimeAQ1050 ThetaPrimeAQ1050;
    end

    opts.simfile = 'Simulation_HQ1050.mat';
    if opts.subsim == 'y'
        opts.test = 'HQ1050';
        [EEHQ1050, UUHQ1050, WWHQ1050, AAHQ1050, CCHQ1050, BBHQ1050, UBHQ1050, MUHQ1050, HHHQ1050, TTHQ1050, LLHQ1050, UTHQ1050, E2EHQ1050, ETHQ1050, ZZHQ1050, WPrimeHQ1050, ThetaPrimeHQ1050] = Simulation(params,order,opts,seedval);
        EEHQ1050 = gather(EEHQ1050);
        UUHQ1050 = gather(UUHQ1050);
        WWHQ1050 = gather(WWHQ1050);
        AAHQ1050 = gather(AAHQ1050);
        BBHQ1050 = gather(BBHQ1050);
        CCHQ1050 = gather(CCHQ1050);
        UBHQ1050 = gather(UBHQ1050);
        MUHQ1050 = gather(MUHQ1050);
        HHHQ1050 = gather(HHHQ1050);
        TTHQ1050 = gather(TTHQ1050);
        UTHQ1050 = gather(UTHQ1050);
        E2EHQ1050 = gather(E2EHQ1050);
        ETHQ1050 = gather(ETHQ1050);
        LLHQ1050 = gather(LLHQ1050);
        ZZHQ1050 = gather(ZZHQ1050);
        WPrimeHQ1050 = gather(WPrimeHQ1050);
        ThetaPrimeHQ1050 = gather(ThetaPrimeHQ1050);

        EEHQ1050 = EEHQ1050(:,2:end);
        UUHQ1050 = UUHQ1050(:,2:end);
        WWHQ1050 = WWHQ1050(:,2:end);
        AAHQ1050 = AAHQ1050(:,1:end-1);
        BBHQ1050 = BBHQ1050(:,2:end);
        CCHQ1050 = CCHQ1050(:,1:end-1);
        UBHQ1050 = UBHQ1050(:,2:end);
        MUHQ1050 = MUHQ1050(:,1:end-1);
        HHHQ1050 = HHHQ1050(:,1:end-1);
        TTHQ1050 = TTHQ1050(:,2:end);
        UTHQ1050 = UTHQ1050(:,2:end);
        E2EHQ1050 = E2EHQ1050(:,2:end);
        ETHQ1050 = ETHQ1050(:,2:end);
        ZZHQ1050 = ZZHQ1050(:,2:end);
        WPrimeHQ1050 = WPrimeHQ1050(:,2:end);
        ThetaPrimeHQ1050 = ThetaPrimeHQ1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHQ1050', 'UUHQ1050', 'WWHQ1050', 'AAHQ1050', 'CCHQ1050', 'BBHQ1050', 'UBHQ1050', 'MUHQ1050', 'HHHQ1050', 'TTHQ1050', 'LLHQ1050', 'UTHQ1050', 'E2EHQ1050', 'ETHQ1050', 'ZZHQ1050', 'WPrimeHQ1050', 'ThetaPrimeHQ1050');
        clear EEHQ1050 UUHQ1050 WWHQ1050 AAHQ1050 CCHQ1050 BBHQ1050 UBHQ1050 MUHQ1050 HHHQ1050 TTHQ1050 LLHQ1050 UTHQ1050 E2EHQ1050 ETHQ1050 ZZHQ1050 WPrimeHQ1050 ThetaPrimeHQ1050;
    end

    opts.simfile = 'Simulation_LQ1050.mat';
    if opts.subsim == 'y'
        opts.test = 'LQ1050';
        [EELQ1050, UULQ1050, WWLQ1050, AALQ1050, CCLQ1050, BBLQ1050, UBLQ1050, MULQ1050, HHLQ1050, TTLQ1050, LLLQ1050, UTLQ1050, E2ELQ1050, ETLQ1050, ZZLQ1050, WPrimeLQ1050, ThetaPrimeLQ1050] = Simulation(params,order,opts,seedval);
        EELQ1050 = gather(EELQ1050);
        UULQ1050 = gather(UULQ1050);
        WWLQ1050 = gather(WWLQ1050);
        AALQ1050 = gather(AALQ1050);
        BBLQ1050 = gather(BBLQ1050);
        CCLQ1050 = gather(CCLQ1050);
        UBLQ1050 = gather(UBLQ1050);
        MULQ1050 = gather(MULQ1050);
        HHLQ1050 = gather(HHLQ1050);
        TTLQ1050 = gather(TTLQ1050);
        UTLQ1050 = gather(UTLQ1050);
        E2ELQ1050 = gather(E2ELQ1050);
        ETLQ1050 = gather(ETLQ1050);
        LLLQ1050 = gather(LLLQ1050);
        ZZLQ1050 = gather(ZZLQ1050);
        WPrimeLQ1050 = gather(WPrimeLQ1050);
        ThetaPrimeLQ1050 = gather(ThetaPrimeLQ1050);

        EELQ1050 = EELQ1050(:,2:end);
        UULQ1050 = UULQ1050(:,2:end);
        WWLQ1050 = WWLQ1050(:,2:end);
        AALQ1050 = AALQ1050(:,1:end-1);
        BBLQ1050 = BBLQ1050(:,2:end);
        CCLQ1050 = CCLQ1050(:,1:end-1);
        UBLQ1050 = UBLQ1050(:,2:end);
        MULQ1050 = MULQ1050(:,1:end-1);
        HHLQ1050 = HHLQ1050(:,1:end-1);
        TTLQ1050 = TTLQ1050(:,2:end);
        UTLQ1050 = UTLQ1050(:,2:end);
        E2ELQ1050 = E2ELQ1050(:,2:end);
        ETLQ1050 = ETLQ1050(:,2:end);
        ZZLQ1050 = ZZLQ1050(:,2:end);
        WPrimeLQ1050 = WPrimeLQ1050(:,2:end);
        ThetaPrimeLQ1050 = ThetaPrimeLQ1050(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EELQ1050', 'UULQ1050', 'WWLQ1050', 'AALQ1050', 'CCLQ1050', 'BBLQ1050', 'UBLQ1050', 'MULQ1050', 'HHLQ1050', 'TTLQ1050', 'LLLQ1050', 'UTLQ1050', 'E2ELQ1050', 'ETLQ1050', 'ZZLQ1050', 'WPrimeLQ1050', 'ThetaPrimeLQ1050');
        clear EELQ1050 UULQ1050 WWLQ1050 AALQ1050 CCLQ1050 BBLQ1050 UBLQ1050 MULQ1050 HHLQ1050 TTLQ1050 LLLQ1050 UTLQ1050 E2ELQ1050 ETLQ1050 ZZLQ1050 WPrimeLQ1050 ThetaPrimeLQ1050;
    end
    
    opts.simfile = 'Simulation_AupHup.mat';
    if opts.subsim == 'y'
        opts.test = 'AupHup';
        [EEAupHup, UUAupHup, WWAupHup, AAAupHup, CCAupHup, BBAupHup, UBAupHup, MUAupHup, HHAupHup, TTAupHup, LLAupHup, UTAupHup, E2EAupHup, ETAupHup, ZZAupHup, WPrimeAupHup, ThetaPrimeAupHup] = Simulation(params,order,opts,seedval);
        EEAupHup = gather(EEAupHup);
        UUAupHup = gather(UUAupHup);
        WWAupHup = gather(WWAupHup);
        AAAupHup = gather(AAAupHup);
        BBAupHup = gather(BBAupHup);
        CCAupHup = gather(CCAupHup);
        UBAupHup = gather(UBAupHup);
        MUAupHup = gather(MUAupHup);
        HHAupHup = gather(HHAupHup);
        TTAupHup = gather(TTAupHup);
        UTAupHup = gather(UTAupHup);
        E2EAupHup = gather(E2EAupHup);
        ETAupHup = gather(ETAupHup);
        LLAupHup = gather(LLAupHup);
        ZZAupHup = gather(ZZAupHup);
        WPrimeAupHup = gather(WPrimeAupHup);
        ThetaPrimeAupHup = gather(ThetaPrimeAupHup);

        EEAupHup = EEAupHup(:,2:end);
        UUAupHup = UUAupHup(:,2:end);
        WWAupHup = WWAupHup(:,2:end);
        AAAupHup = AAAupHup(:,1:end-1);
        BBAupHup = BBAupHup(:,2:end);
        CCAupHup = CCAupHup(:,1:end-1);
        UBAupHup = UBAupHup(:,2:end);
        MUAupHup = MUAupHup(:,1:end-1);
        HHAupHup = HHAupHup(:,1:end-1);
        TTAupHup = TTAupHup(:,2:end);
        UTAupHup = UTAupHup(:,2:end);
        E2EAupHup = E2EAupHup(:,2:end);
        ETAupHup = ETAupHup(:,2:end);
        ZZAupHup = ZZAupHup(:,2:end);
        WPrimeAupHup = WPrimeAupHup(:,2:end);
        ThetaPrimeAupHup = ThetaPrimeAupHup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAupHup', 'UUAupHup', 'WWAupHup', 'AAAupHup', 'CCAupHup', 'BBAupHup', 'UBAupHup', 'MUAupHup', 'HHAupHup', 'TTAupHup', 'LLAupHup', 'UTAupHup', 'E2EAupHup', 'ETAupHup', 'ZZAupHup', 'WPrimeAupHup', 'ThetaPrimeAupHup');
        clear EEAupHup UUAupHup WWAupHup AAAupHup CCAupHup BBAupHup UBAupHup MUAupHup HHAupHup TTAupHup LLAupHup UTAupHup E2EAupHup ETAupHup ZZAupHup WPrimeAupHup ThetaPrimeAupHup;
    end
    
    opts.simfile = 'Simulation_AupHdown.mat';
    if opts.subsim == 'y'
        opts.test = 'AupHdown';
        [EEAupHdown, UUAupHdown, WWAupHdown, AAAupHdown, CCAupHdown, BBAupHdown, UBAupHdown, MUAupHdown, HHAupHdown, TTAupHdown, LLAupHdown, UTAupHdown, E2EAupHdown, ETAupHdown, ZZAupHdown, WPrimeAupHdown, ThetaPrimeAupHdown] = Simulation(params,order,opts,seedval);
        EEAupHdown = gather(EEAupHdown);
        UUAupHdown = gather(UUAupHdown);
        WWAupHdown = gather(WWAupHdown);
        AAAupHdown = gather(AAAupHdown);
        BBAupHdown = gather(BBAupHdown);
        CCAupHdown = gather(CCAupHdown);
        UBAupHdown = gather(UBAupHdown);
        MUAupHdown = gather(MUAupHdown);
        HHAupHdown = gather(HHAupHdown);
        TTAupHdown = gather(TTAupHdown);
        UTAupHdown = gather(UTAupHdown);
        E2EAupHdown = gather(E2EAupHdown);
        ETAupHdown = gather(ETAupHdown);
        LLAupHdown = gather(LLAupHdown);
        ZZAupHdown = gather(ZZAupHdown);
        WPrimeAupHdown = gather(WPrimeAupHdown);
        ThetaPrimeAupHdown = gather(ThetaPrimeAupHdown);

        EEAupHdown = EEAupHdown(:,2:end);
        UUAupHdown = UUAupHdown(:,2:end);
        WWAupHdown = WWAupHdown(:,2:end);
        AAAupHdown = AAAupHdown(:,1:end-1);
        BBAupHdown = BBAupHdown(:,2:end);
        CCAupHdown = CCAupHdown(:,1:end-1);
        UBAupHdown = UBAupHdown(:,2:end);
        MUAupHdown = MUAupHdown(:,1:end-1);
        HHAupHdown = HHAupHdown(:,1:end-1);
        TTAupHdown = TTAupHdown(:,2:end);
        UTAupHdown = UTAupHdown(:,2:end);
        E2EAupHdown = E2EAupHdown(:,2:end);
        ETAupHdown = ETAupHdown(:,2:end);
        ZZAupHdown = ZZAupHdown(:,2:end);
        WPrimeAupHdown = WPrimeAupHdown(:,2:end);
        ThetaPrimeAupHdown = ThetaPrimeAupHdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAupHdown', 'UUAupHdown', 'WWAupHdown', 'AAAupHdown', 'CCAupHdown', 'BBAupHdown', 'UBAupHdown', 'MUAupHdown', 'HHAupHdown', 'TTAupHdown', 'LLAupHdown', 'UTAupHdown', 'E2EAupHdown', 'ETAupHdown', 'ZZAupHdown', 'WPrimeAupHdown', 'ThetaPrimeAupHdown');
        clear EEAupHdown UUAupHdown WWAupHdown AAAupHdown CCAupHdown BBAupHdown UBAupHdown MUAupHdown HHAupHdown TTAupHdown LLAupHdown UTAupHdown E2EAupHdown ETAupHdown ZZAupHdown WPrimeAupHdown ThetaPrimeAupHdown;
    end
    
    opts.simfile = 'Simulation_AupLup.mat';
    if opts.subsim == 'y'
        opts.test = 'AupLup';
        [EEAupLup, UUAupLup, WWAupLup, AAAupLup, CCAupLup, BBAupLup, UBAupLup, MUAupLup, HHAupLup, TTAupLup, LLAupLup, UTAupLup, E2EAupLup, ETAupLup, ZZAupLup, WPrimeAupLup, ThetaPrimeAupLup] = Simulation(params,order,opts,seedval);
        EEAupLup = gather(EEAupLup);
        UUAupLup = gather(UUAupLup);
        WWAupLup = gather(WWAupLup);
        AAAupLup = gather(AAAupLup);
        BBAupLup = gather(BBAupLup);
        CCAupLup = gather(CCAupLup);
        UBAupLup = gather(UBAupLup);
        MUAupLup = gather(MUAupLup);
        HHAupLup = gather(HHAupLup);
        TTAupLup = gather(TTAupLup);
        UTAupLup = gather(UTAupLup);
        E2EAupLup = gather(E2EAupLup);
        ETAupLup = gather(ETAupLup);
        LLAupLup = gather(LLAupLup);
        ZZAupLup = gather(ZZAupLup);
        WPrimeAupLup = gather(WPrimeAupLup);
        ThetaPrimeAupLup = gather(ThetaPrimeAupLup);

        EEAupLup = EEAupLup(:,2:end);
        UUAupLup = UUAupLup(:,2:end);
        WWAupLup = WWAupLup(:,2:end);
        AAAupLup = AAAupLup(:,1:end-1);
        BBAupLup = BBAupLup(:,2:end);
        CCAupLup = CCAupLup(:,1:end-1);
        UBAupLup = UBAupLup(:,2:end);
        MUAupLup = MUAupLup(:,1:end-1);
        HHAupLup = HHAupLup(:,1:end-1);
        TTAupLup = TTAupLup(:,2:end);
        UTAupLup = UTAupLup(:,2:end);
        E2EAupLup = E2EAupLup(:,2:end);
        ETAupLup = ETAupLup(:,2:end);
        ZZAupLup = ZZAupLup(:,2:end);
        WPrimeAupLup = WPrimeAupLup(:,2:end);
        ThetaPrimeAupLup = ThetaPrimeAupLup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAupLup', 'UUAupLup', 'WWAupLup', 'AAAupLup', 'CCAupLup', 'BBAupLup', 'UBAupLup', 'MUAupLup', 'HHAupLup', 'TTAupLup', 'LLAupLup', 'UTAupLup', 'E2EAupLup', 'ETAupLup', 'ZZAupLup', 'WPrimeAupLup', 'ThetaPrimeAupLup');
        clear EEAupLup UUAupLup WWAupLup AAAupLup CCAupLup BBAupLup UBAupLup MUAupLup HHAupLup TTAupLup LLAupLup UTAupLup E2EAupLup ETAupLup ZZAupLup WPrimeAupLup ThetaPrimeAupLup;
    end
    
    opts.simfile = 'Simulation_AupLdown.mat';
    if opts.subsim == 'y'
        opts.test = 'AupLdown';
        [EEAupLdown, UUAupLdown, WWAupLdown, AAAupLdown, CCAupLdown, BBAupLdown, UBAupLdown, MUAupLdown, HHAupLdown, TTAupLdown, LLAupLdown, UTAupLdown, E2EAupLdown, ETAupLdown, ZZAupLdown, WPrimeAupLdown, ThetaPrimeAupLdown] = Simulation(params,order,opts,seedval);
        EEAupLdown = gather(EEAupLdown);
        UUAupLdown = gather(UUAupLdown);
        WWAupLdown = gather(WWAupLdown);
        AAAupLdown = gather(AAAupLdown);
        BBAupLdown = gather(BBAupLdown);
        CCAupLdown = gather(CCAupLdown);
        UBAupLdown = gather(UBAupLdown);
        MUAupLdown = gather(MUAupLdown);
        HHAupLdown = gather(HHAupLdown);
        TTAupLdown = gather(TTAupLdown);
        UTAupLdown = gather(UTAupLdown);
        E2EAupLdown = gather(E2EAupLdown);
        ETAupLdown = gather(ETAupLdown);
        LLAupLdown = gather(LLAupLdown);
        ZZAupLdown = gather(ZZAupLdown);
        WPrimeAupLdown = gather(WPrimeAupLdown);
        ThetaPrimeAupLdown = gather(ThetaPrimeAupLdown);

        EEAupLdown = EEAupLdown(:,2:end);
        UUAupLdown = UUAupLdown(:,2:end);
        WWAupLdown = WWAupLdown(:,2:end);
        AAAupLdown = AAAupLdown(:,1:end-1);
        BBAupLdown = BBAupLdown(:,2:end);
        CCAupLdown = CCAupLdown(:,1:end-1);
        UBAupLdown = UBAupLdown(:,2:end);
        MUAupLdown = MUAupLdown(:,1:end-1);
        HHAupLdown = HHAupLdown(:,1:end-1);
        TTAupLdown = TTAupLdown(:,2:end);
        UTAupLdown = UTAupLdown(:,2:end);
        E2EAupLdown = E2EAupLdown(:,2:end);
        ETAupLdown = ETAupLdown(:,2:end);
        ZZAupLdown = ZZAupLdown(:,2:end);
        WPrimeAupLdown = WPrimeAupLdown(:,2:end);
        ThetaPrimeAupLdown = ThetaPrimeAupLdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAupLdown', 'UUAupLdown', 'WWAupLdown', 'AAAupLdown', 'CCAupLdown', 'BBAupLdown', 'UBAupLdown', 'MUAupLdown', 'HHAupLdown', 'TTAupLdown', 'LLAupLdown', 'UTAupLdown', 'E2EAupLdown', 'ETAupLdown', 'ZZAupLdown', 'WPrimeAupLdown', 'ThetaPrimeAupLdown');
        clear EEAupLdown UUAupLdown WWAupLdown AAAupLdown CCAupLdown BBAupLdown UBAupLdown MUAupLdown HHAupLdown TTAupLdown LLAupLdown UTAupLdown E2EAupLdown ETAupLdown ZZAupLdown WPrimeAupLdown ThetaPrimeAupLdown;
    end

    opts.simfile = 'Simulation_AdownHup.mat';
    if opts.subsim == 'y'
        opts.test = 'AdownHup';
        [EEAdownHup, UUAdownHup, WWAdownHup, AAAdownHup, CCAdownHup, BBAdownHup, UBAdownHup, MUAdownHup, HHAdownHup, TTAdownHup, LLAdownHup, UTAdownHup, E2EAdownHup, ETAdownHup, ZZAdownHup, WPrimeAdownHup, ThetaPrimeAdownHup] = Simulation(params,order,opts,seedval);
        EEAdownHup = gather(EEAdownHup);
        UUAdownHup = gather(UUAdownHup);
        WWAdownHup = gather(WWAdownHup);
        AAAdownHup = gather(AAAdownHup);
        BBAdownHup = gather(BBAdownHup);
        CCAdownHup = gather(CCAdownHup);
        UBAdownHup = gather(UBAdownHup);
        MUAdownHup = gather(MUAdownHup);
        HHAdownHup = gather(HHAdownHup);
        TTAdownHup = gather(TTAdownHup);
        UTAdownHup = gather(UTAdownHup);
        E2EAdownHup = gather(E2EAdownHup);
        ETAdownHup = gather(ETAdownHup);
        LLAdownHup = gather(LLAdownHup);
        ZZAdownHup = gather(ZZAdownHup);
        WPrimeAdownHup = gather(WPrimeAdownHup);
        ThetaPrimeAdownHup = gather(ThetaPrimeAdownHup);

        EEAdownHup = EEAdownHup(:,2:end);
        UUAdownHup = UUAdownHup(:,2:end);
        WWAdownHup = WWAdownHup(:,2:end);
        AAAdownHup = AAAdownHup(:,1:end-1);
        BBAdownHup = BBAdownHup(:,2:end);
        CCAdownHup = CCAdownHup(:,1:end-1);
        UBAdownHup = UBAdownHup(:,2:end);
        MUAdownHup = MUAdownHup(:,1:end-1);
        HHAdownHup = HHAdownHup(:,1:end-1);
        TTAdownHup = TTAdownHup(:,2:end);
        UTAdownHup = UTAdownHup(:,2:end);
        E2EAdownHup = E2EAdownHup(:,2:end);
        ETAdownHup = ETAdownHup(:,2:end);
        ZZAdownHup = ZZAdownHup(:,2:end);
        WPrimeAdownHup = WPrimeAdownHup(:,2:end);
        ThetaPrimeAdownHup = ThetaPrimeAdownHup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdownHup', 'UUAdownHup', 'WWAdownHup', 'AAAdownHup', 'CCAdownHup', 'BBAdownHup', 'UBAdownHup', 'MUAdownHup', 'HHAdownHup', 'TTAdownHup', 'LLAdownHup', 'UTAdownHup', 'E2EAdownHup', 'ETAdownHup', 'ZZAdownHup', 'WPrimeAdownHup', 'ThetaPrimeAdownHup');
        clear EEAdownHup UUAdownHup WWAdownHup AAAdownHup CCAdownHup BBAdownHup UBAdownHup MUAdownHup HHAdownHup TTAdownHup LLAdownHup UTAdownHup E2EAdownHup ETAdownHup ZZAdownHup WPrimeAdownHup ThetaPrimeAdownHup;
    end
    
    opts.simfile = 'Simulation_AdownHdown.mat';
    if opts.subsim == 'y'
        opts.test = 'AdownHdown';
        [EEAdownHdown, UUAdownHdown, WWAdownHdown, AAAdownHdown, CCAdownHdown, BBAdownHdown, UBAdownHdown, MUAdownHdown, HHAdownHdown, TTAdownHdown, LLAdownHdown, UTAdownHdown, E2EAdownHdown, ETAdownHdown, ZZAdownHdown, WPrimeAdownHdown, ThetaPrimeAdownHdown] = Simulation(params,order,opts,seedval);
        EEAdownHdown = gather(EEAdownHdown);
        UUAdownHdown = gather(UUAdownHdown);
        WWAdownHdown = gather(WWAdownHdown);
        AAAdownHdown = gather(AAAdownHdown);
        BBAdownHdown = gather(BBAdownHdown);
        CCAdownHdown = gather(CCAdownHdown);
        UBAdownHdown = gather(UBAdownHdown);
        MUAdownHdown = gather(MUAdownHdown);
        HHAdownHdown = gather(HHAdownHdown);
        TTAdownHdown = gather(TTAdownHdown);
        UTAdownHdown = gather(UTAdownHdown);
        E2EAdownHdown = gather(E2EAdownHdown);
        ETAdownHdown = gather(ETAdownHdown);
        LLAdownHdown = gather(LLAdownHdown);
        ZZAdownHdown = gather(ZZAdownHdown);
        WPrimeAdownHdown = gather(WPrimeAdownHdown);
        ThetaPrimeAdownHdown = gather(ThetaPrimeAdownHdown);

        EEAdownHdown = EEAdownHdown(:,2:end);
        UUAdownHdown = UUAdownHdown(:,2:end);
        WWAdownHdown = WWAdownHdown(:,2:end);
        AAAdownHdown = AAAdownHdown(:,1:end-1);
        BBAdownHdown = BBAdownHdown(:,2:end);
        CCAdownHdown = CCAdownHdown(:,1:end-1);
        UBAdownHdown = UBAdownHdown(:,2:end);
        MUAdownHdown = MUAdownHdown(:,1:end-1);
        HHAdownHdown = HHAdownHdown(:,1:end-1);
        TTAdownHdown = TTAdownHdown(:,2:end);
        UTAdownHdown = UTAdownHdown(:,2:end);
        E2EAdownHdown = E2EAdownHdown(:,2:end);
        ETAdownHdown = ETAdownHdown(:,2:end);
        ZZAdownHdown = ZZAdownHdown(:,2:end);
        WPrimeAdownHdown = WPrimeAdownHdown(:,2:end);
        ThetaPrimeAdownHdown = ThetaPrimeAdownHdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdownHdown', 'UUAdownHdown', 'WWAdownHdown', 'AAAdownHdown', 'CCAdownHdown', 'BBAdownHdown', 'UBAdownHdown', 'MUAdownHdown', 'HHAdownHdown', 'TTAdownHdown', 'LLAdownHdown', 'UTAdownHdown', 'E2EAdownHdown', 'ETAdownHdown', 'ZZAdownHdown', 'WPrimeAdownHdown', 'ThetaPrimeAdownHdown');
        clear EEAdownHdown UUAdownHdown WWAdownHdown AAAdownHdown CCAdownHdown BBAdownHdown UBAdownHdown MUAdownHdown HHAdownHdown TTAdownHdown LLAdownHdown UTAdownHdown E2EAdownHdown ETAdownHdown ZZAdownHdown WPrimeAdownHdown ThetaPrimeAdownHdown;
    end
    
    opts.simfile = 'Simulation_AdownLup.mat';
    if opts.subsim == 'y'
        opts.test = 'AdownLup';
        [EEAdownLup, UUAdownLup, WWAdownLup, AAAdownLup, CCAdownLup, BBAdownLup, UBAdownLup, MUAdownLup, HHAdownLup, TTAdownLup, LLAdownLup, UTAdownLup, E2EAdownLup, ETAdownLup, ZZAdownLup, WPrimeAdownLup, ThetaPrimeAdownLup] = Simulation(params,order,opts,seedval);
        EEAdownLup = gather(EEAdownLup);
        UUAdownLup = gather(UUAdownLup);
        WWAdownLup = gather(WWAdownLup);
        AAAdownLup = gather(AAAdownLup);
        BBAdownLup = gather(BBAdownLup);
        CCAdownLup = gather(CCAdownLup);
        UBAdownLup = gather(UBAdownLup);
        MUAdownLup = gather(MUAdownLup);
        HHAdownLup = gather(HHAdownLup);
        TTAdownLup = gather(TTAdownLup);
        UTAdownLup = gather(UTAdownLup);
        E2EAdownLup = gather(E2EAdownLup);
        ETAdownLup = gather(ETAdownLup);
        LLAdownLup = gather(LLAdownLup);
        ZZAdownLup = gather(ZZAdownLup);
        WPrimeAdownLup = gather(WPrimeAdownLup);
        ThetaPrimeAdownLup = gather(ThetaPrimeAdownLup);

        EEAdownLup = EEAdownLup(:,2:end);
        UUAdownLup = UUAdownLup(:,2:end);
        WWAdownLup = WWAdownLup(:,2:end);
        AAAdownLup = AAAdownLup(:,1:end-1);
        BBAdownLup = BBAdownLup(:,2:end);
        CCAdownLup = CCAdownLup(:,1:end-1);
        UBAdownLup = UBAdownLup(:,2:end);
        MUAdownLup = MUAdownLup(:,1:end-1);
        HHAdownLup = HHAdownLup(:,1:end-1);
        TTAdownLup = TTAdownLup(:,2:end);
        UTAdownLup = UTAdownLup(:,2:end);
        E2EAdownLup = E2EAdownLup(:,2:end);
        ETAdownLup = ETAdownLup(:,2:end);
        ZZAdownLup = ZZAdownLup(:,2:end);
        WPrimeAdownLup = WPrimeAdownLup(:,2:end);
        ThetaPrimeAdownLup = ThetaPrimeAdownLup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdownLup', 'UUAdownLup', 'WWAdownLup', 'AAAdownLup', 'CCAdownLup', 'BBAdownLup', 'UBAdownLup', 'MUAdownLup', 'HHAdownLup', 'TTAdownLup', 'LLAdownLup', 'UTAdownLup', 'E2EAdownLup', 'ETAdownLup', 'ZZAdownLup', 'WPrimeAdownLup', 'ThetaPrimeAdownLup');
        clear EEAdownLup UUAdownLup WWAdownLup AAAdownLup CCAdownLup BBAdownLup UBAdownLup MUAdownLup HHAdownLup TTAdownLup LLAdownLup UTAdownLup E2EAdownLup ETAdownLup ZZAdownLup WPrimeAdownLup ThetaPrimeAdownLup;
    end
    
    opts.simfile = 'Simulation_AdownLdown.mat';
    if opts.subsim == 'y'
        opts.test = 'AdownLdown';
        [EEAdownLdown, UUAdownLdown, WWAdownLdown, AAAdownLdown, CCAdownLdown, BBAdownLdown, UBAdownLdown, MUAdownLdown, HHAdownLdown, TTAdownLdown, LLAdownLdown, UTAdownLdown, E2EAdownLdown, ETAdownLdown, ZZAdownLdown, WPrimeAdownLdown, ThetaPrimeAdownLdown] = Simulation(params,order,opts,seedval);
        EEAdownLdown = gather(EEAdownLdown);
        UUAdownLdown = gather(UUAdownLdown);
        WWAdownLdown = gather(WWAdownLdown);
        AAAdownLdown = gather(AAAdownLdown);
        BBAdownLdown = gather(BBAdownLdown);
        CCAdownLdown = gather(CCAdownLdown);
        UBAdownLdown = gather(UBAdownLdown);
        MUAdownLdown = gather(MUAdownLdown);
        HHAdownLdown = gather(HHAdownLdown);
        TTAdownLdown = gather(TTAdownLdown);
        UTAdownLdown = gather(UTAdownLdown);
        E2EAdownLdown = gather(E2EAdownLdown);
        ETAdownLdown = gather(ETAdownLdown);
        LLAdownLdown = gather(LLAdownLdown);
        ZZAdownLdown = gather(ZZAdownLdown);
        WPrimeAdownLdown = gather(WPrimeAdownLdown);
        ThetaPrimeAdownLdown = gather(ThetaPrimeAdownLdown);

        EEAdownLdown = EEAdownLdown(:,2:end);
        UUAdownLdown = UUAdownLdown(:,2:end);
        WWAdownLdown = WWAdownLdown(:,2:end);
        AAAdownLdown = AAAdownLdown(:,1:end-1);
        BBAdownLdown = BBAdownLdown(:,2:end);
        CCAdownLdown = CCAdownLdown(:,1:end-1);
        UBAdownLdown = UBAdownLdown(:,2:end);
        MUAdownLdown = MUAdownLdown(:,1:end-1);
        HHAdownLdown = HHAdownLdown(:,1:end-1);
        TTAdownLdown = TTAdownLdown(:,2:end);
        UTAdownLdown = UTAdownLdown(:,2:end);
        E2EAdownLdown = E2EAdownLdown(:,2:end);
        ETAdownLdown = ETAdownLdown(:,2:end);
        ZZAdownLdown = ZZAdownLdown(:,2:end);
        WPrimeAdownLdown = WPrimeAdownLdown(:,2:end);
        ThetaPrimeAdownLdown = ThetaPrimeAdownLdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEAdownLdown', 'UUAdownLdown', 'WWAdownLdown', 'AAAdownLdown', 'CCAdownLdown', 'BBAdownLdown', 'UBAdownLdown', 'MUAdownLdown', 'HHAdownLdown', 'TTAdownLdown', 'LLAdownLdown', 'UTAdownLdown', 'E2EAdownLdown', 'ETAdownLdown', 'ZZAdownLdown', 'WPrimeAdownLdown', 'ThetaPrimeAdownLdown');
        clear EEAdownLdown UUAdownLdown WWAdownLdown AAAdownLdown CCAdownLdown BBAdownLdown UBAdownLdown MUAdownLdown HHAdownLdown TTAdownLdown LLAdownLdown UTAdownLdown E2EAdownLdown ETAdownLdown ZZAdownLdown WPrimeAdownLdown ThetaPrimeAdownLdown;
    end
    
    opts.simfile = 'Simulation_HupLup.mat';
    if opts.subsim == 'y'
        opts.test = 'HupLup';
        [EEHupLup, UUHupLup, WWHupLup, AAHupLup, CCHupLup, BBHupLup, UBHupLup, MUHupLup, HHHupLup, TTHupLup, LLHupLup, UTHupLup, E2EHupLup, ETHupLup, ZZHupLup, WPrimeHupLup, ThetaPrimeHupLup] = Simulation(params,order,opts,seedval);
        EEHupLup = gather(EEHupLup);
        UUHupLup = gather(UUHupLup);
        WWHupLup = gather(WWHupLup);
        AAHupLup = gather(AAHupLup);
        BBHupLup = gather(BBHupLup);
        CCHupLup = gather(CCHupLup);
        UBHupLup = gather(UBHupLup);
        MUHupLup = gather(MUHupLup);
        HHHupLup = gather(HHHupLup);
        TTHupLup = gather(TTHupLup);
        UTHupLup = gather(UTHupLup);
        E2EHupLup = gather(E2EHupLup);
        ETHupLup = gather(ETHupLup);
        LLHupLup = gather(LLHupLup);
        ZZHupLup = gather(ZZHupLup);
        WPrimeHupLup = gather(WPrimeHupLup);
        ThetaPrimeHupLup = gather(ThetaPrimeHupLup);

        EEHupLup = EEHupLup(:,2:end);
        UUHupLup = UUHupLup(:,2:end);
        WWHupLup = WWHupLup(:,2:end);
        AAHupLup = AAHupLup(:,1:end-1);
        BBHupLup = BBHupLup(:,2:end);
        CCHupLup = CCHupLup(:,1:end-1);
        UBHupLup = UBHupLup(:,2:end);
        MUHupLup = MUHupLup(:,1:end-1);
        HHHupLup = HHHupLup(:,1:end-1);
        TTHupLup = TTHupLup(:,2:end);
        UTHupLup = UTHupLup(:,2:end);
        E2EHupLup = E2EHupLup(:,2:end);
        ETHupLup = ETHupLup(:,2:end);
        ZZHupLup = ZZHupLup(:,2:end);
        WPrimeHupLup = WPrimeHupLup(:,2:end);
        ThetaPrimeHupLup = ThetaPrimeHupLup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHupLup', 'UUHupLup', 'WWHupLup', 'AAHupLup', 'CCHupLup', 'BBHupLup', 'UBHupLup', 'MUHupLup', 'HHHupLup', 'TTHupLup', 'LLHupLup', 'UTHupLup', 'E2EHupLup', 'ETHupLup', 'ZZHupLup', 'WPrimeHupLup', 'ThetaPrimeHupLup');
        clear EEHupLup UUHupLup WWHupLup AAHupLup CCHupLup BBHupLup UBHupLup MUHupLup HHHupLup TTHupLup LLHupLup UTHupLup E2EHupLup ETHupLup ZZHupLup WPrimeHupLup ThetaPrimeHupLup;
    end
    
    opts.simfile = 'Simulation_HupLdown.mat';
    if opts.subsim == 'y'
        opts.test = 'HupLdown';
        [EEHupLdown, UUHupLdown, WWHupLdown, AAHupLdown, CCHupLdown, BBHupLdown, UBHupLdown, MUHupLdown, HHHupLdown, TTHupLdown, LLHupLdown, UTHupLdown, E2EHupLdown, ETHupLdown, ZZHupLdown, WPrimeHupLdown, ThetaPrimeHupLdown] = Simulation(params,order,opts,seedval);
        EEHupLdown = gather(EEHupLdown);
        UUHupLdown = gather(UUHupLdown);
        WWHupLdown = gather(WWHupLdown);
        AAHupLdown = gather(AAHupLdown);
        BBHupLdown = gather(BBHupLdown);
        CCHupLdown = gather(CCHupLdown);
        UBHupLdown = gather(UBHupLdown);
        MUHupLdown = gather(MUHupLdown);
        HHHupLdown = gather(HHHupLdown);
        TTHupLdown = gather(TTHupLdown);
        UTHupLdown = gather(UTHupLdown);
        E2EHupLdown = gather(E2EHupLdown);
        ETHupLdown = gather(ETHupLdown);
        LLHupLdown = gather(LLHupLdown);
        ZZHupLdown = gather(ZZHupLdown);
        WPrimeHupLdown = gather(WPrimeHupLdown);
        ThetaPrimeHupLdown = gather(ThetaPrimeHupLdown);

        EEHupLdown = EEHupLdown(:,2:end);
        UUHupLdown = UUHupLdown(:,2:end);
        WWHupLdown = WWHupLdown(:,2:end);
        AAHupLdown = AAHupLdown(:,1:end-1);
        BBHupLdown = BBHupLdown(:,2:end);
        CCHupLdown = CCHupLdown(:,1:end-1);
        UBHupLdown = UBHupLdown(:,2:end);
        MUHupLdown = MUHupLdown(:,1:end-1);
        HHHupLdown = HHHupLdown(:,1:end-1);
        TTHupLdown = TTHupLdown(:,2:end);
        UTHupLdown = UTHupLdown(:,2:end);
        E2EHupLdown = E2EHupLdown(:,2:end);
        ETHupLdown = ETHupLdown(:,2:end);
        ZZHupLdown = ZZHupLdown(:,2:end);
        WPrimeHupLdown = WPrimeHupLdown(:,2:end);
        ThetaPrimeHupLdown = ThetaPrimeHupLdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHupLdown', 'UUHupLdown', 'WWHupLdown', 'AAHupLdown', 'CCHupLdown', 'BBHupLdown', 'UBHupLdown', 'MUHupLdown', 'HHHupLdown', 'TTHupLdown', 'LLHupLdown', 'UTHupLdown', 'E2EHupLdown', 'ETHupLdown', 'ZZHupLdown', 'WPrimeHupLdown', 'ThetaPrimeHupLdown');
        clear EEHupLdown UUHupLdown WWHupLdown AAHupLdown CCHupLdown BBHupLdown UBHupLdown MUHupLdown HHHupLdown TTHupLdown LLHupLdown UTHupLdown E2EHupLdown ETHupLdown ZZHupLdown WPrimeHupLdown ThetaPrimeHupLdown;
    end
    
    opts.simfile = 'Simulation_HdownLup.mat';
    if opts.subsim == 'y'
        opts.test = 'HdownLup';
        [EEHdownLup, UUHdownLup, WWHdownLup, AAHdownLup, CCHdownLup, BBHdownLup, UBHdownLup, MUHdownLup, HHHdownLup, TTHdownLup, LLHdownLup, UTHdownLup, E2EHdownLup, ETHdownLup, ZZHdownLup, WPrimeHdownLup, ThetaPrimeHdownLup] = Simulation(params,order,opts,seedval);
        EEHdownLup = gather(EEHdownLup);
        UUHdownLup = gather(UUHdownLup);
        WWHdownLup = gather(WWHdownLup);
        AAHdownLup = gather(AAHdownLup);
        BBHdownLup = gather(BBHdownLup);
        CCHdownLup = gather(CCHdownLup);
        UBHdownLup = gather(UBHdownLup);
        MUHdownLup = gather(MUHdownLup);
        HHHdownLup = gather(HHHdownLup);
        TTHdownLup = gather(TTHdownLup);
        UTHdownLup = gather(UTHdownLup);
        E2EHdownLup = gather(E2EHdownLup);
        ETHdownLup = gather(ETHdownLup);
        LLHdownLup = gather(LLHdownLup);
        ZZHdownLup = gather(ZZHdownLup);
        WPrimeHdownLup = gather(WPrimeHdownLup);
        ThetaPrimeHdownLup = gather(ThetaPrimeHdownLup);

        EEHdownLup = EEHdownLup(:,2:end);
        UUHdownLup = UUHdownLup(:,2:end);
        WWHdownLup = WWHdownLup(:,2:end);
        AAHdownLup = AAHdownLup(:,1:end-1);
        BBHdownLup = BBHdownLup(:,2:end);
        CCHdownLup = CCHdownLup(:,1:end-1);
        UBHdownLup = UBHdownLup(:,2:end);
        MUHdownLup = MUHdownLup(:,1:end-1);
        HHHdownLup = HHHdownLup(:,1:end-1);
        TTHdownLup = TTHdownLup(:,2:end);
        UTHdownLup = UTHdownLup(:,2:end);
        E2EHdownLup = E2EHdownLup(:,2:end);
        ETHdownLup = ETHdownLup(:,2:end);
        ZZHdownLup = ZZHdownLup(:,2:end);
        WPrimeHdownLup = WPrimeHdownLup(:,2:end);
        ThetaPrimeHdownLup = ThetaPrimeHdownLup(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHdownLup', 'UUHdownLup', 'WWHdownLup', 'AAHdownLup', 'CCHdownLup', 'BBHdownLup', 'UBHdownLup', 'MUHdownLup', 'HHHdownLup', 'TTHdownLup', 'LLHdownLup', 'UTHdownLup', 'E2EHdownLup', 'ETHdownLup', 'ZZHdownLup', 'WPrimeHdownLup', 'ThetaPrimeHdownLup');
        clear EEHdownLup UUHdownLup WWHdownLup AAHdownLup CCHdownLup BBHdownLup UBHdownLup MUHdownLup HHHdownLup TTHdownLup LLHdownLup UTHdownLup E2EHdownLup ETHdownLup ZZHdownLup WPrimeHdownLup ThetaPrimeHdownLup;
    end
    
    opts.simfile = 'Simulation_HdownLdown.mat';
    if opts.subsim == 'y'
        opts.test = 'HdownLdown';
        [EEHdownLdown, UUHdownLdown, WWHdownLdown, AAHdownLdown, CCHdownLdown, BBHdownLdown, UBHdownLdown, MUHdownLdown, HHHdownLdown, TTHdownLdown, LLHdownLdown, UTHdownLdown, E2EHdownLdown, ETHdownLdown, ZZHdownLdown, WPrimeHdownLdown, ThetaPrimeHdownLdown] = Simulation(params,order,opts,seedval);
        EEHdownLdown = gather(EEHdownLdown);
        UUHdownLdown = gather(UUHdownLdown);
        WWHdownLdown = gather(WWHdownLdown);
        AAHdownLdown = gather(AAHdownLdown);
        BBHdownLdown = gather(BBHdownLdown);
        CCHdownLdown = gather(CCHdownLdown);
        UBHdownLdown = gather(UBHdownLdown);
        MUHdownLdown = gather(MUHdownLdown);
        HHHdownLdown = gather(HHHdownLdown);
        TTHdownLdown = gather(TTHdownLdown);
        UTHdownLdown = gather(UTHdownLdown);
        E2EHdownLdown = gather(E2EHdownLdown);
        ETHdownLdown = gather(ETHdownLdown);
        LLHdownLdown = gather(LLHdownLdown);
        ZZHdownLdown = gather(ZZHdownLdown);
        WPrimeHdownLdown = gather(WPrimeHdownLdown);
        ThetaPrimeHdownLdown = gather(ThetaPrimeHdownLdown);

        EEHdownLdown = EEHdownLdown(:,2:end);
        UUHdownLdown = UUHdownLdown(:,2:end);
        WWHdownLdown = WWHdownLdown(:,2:end);
        AAHdownLdown = AAHdownLdown(:,1:end-1);
        BBHdownLdown = BBHdownLdown(:,2:end);
        CCHdownLdown = CCHdownLdown(:,1:end-1);
        UBHdownLdown = UBHdownLdown(:,2:end);
        MUHdownLdown = MUHdownLdown(:,1:end-1);
        HHHdownLdown = HHHdownLdown(:,1:end-1);
        TTHdownLdown = TTHdownLdown(:,2:end);
        UTHdownLdown = UTHdownLdown(:,2:end);
        E2EHdownLdown = E2EHdownLdown(:,2:end);
        ETHdownLdown = ETHdownLdown(:,2:end);
        ZZHdownLdown = ZZHdownLdown(:,2:end);
        WPrimeHdownLdown = WPrimeHdownLdown(:,2:end);
        ThetaPrimeHdownLdown = ThetaPrimeHdownLdown(:,2:end);
        matfile = fullfile(pwd,opts.simfile);
        save(matfile, 'EEHdownLdown', 'UUHdownLdown', 'WWHdownLdown', 'AAHdownLdown', 'CCHdownLdown', 'BBHdownLdown', 'UBHdownLdown', 'MUHdownLdown', 'HHHdownLdown', 'TTHdownLdown', 'LLHdownLdown', 'UTHdownLdown', 'E2EHdownLdown', 'ETHdownLdown', 'ZZHdownLdown', 'WPrimeHdownLdown', 'ThetaPrimeHdownLdown');
        clear EEHdownLdown UUHdownLdown WWHdownLdown AAHdownLdown CCHdownLdown BBHdownLdown UBHdownLdown MUHdownLdown HHHdownLdown TTHdownLdown LLHdownLdown UTHdownLdown E2EHdownLdown ETHdownLdown ZZHdownLdown WPrimeHdownLdown ThetaPrimeHdownLdown;
    end

    if opts.PlotDecisionRules == 'y'
        opts.simfile = 'Simulation_Standard.mat';
        matfile = fullfile(pwd,opts.simfile);
        load(matfile);

        plotopts = '_standard';
        dataopts.dataset = 'FullLifeCycle';
        tic
        PlotDecisionRules(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, dataopts);
        toc
    end

    if opts.Plots == 'y'
        opts.simfile = 'Simulation_Standard.mat';
        matfile = fullfile(pwd,opts.simfile);
        load(matfile);

        plotopts = '_standard';
        dataopts.dataset = 'FullLifeCycle';
        tic
        Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, dataopts);
        toc
        clear EE UU WW AA BB CC UB MU HH TT UT E2E ET LL EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

        if opts.Subplots == 'y'
            opts.simfile = 'Simulation_Aup.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Aup';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEAup, UUAup, WWAup, AAAup, BBAup, CCAup, UBAup, MUAup, HHAup, TTAup, UTAup, E2EAup, ETAup, LLAup, ZZAup, WPrimeAup, ThetaPrimeAup);

            clear EEAup UUAup WWAup AAAup CCAup BBAup UBAup MUAup HHAup TTAup UTAup E2EAup ETAup LLAup EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_Adown.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Adown';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEAdown, UUAdown, WWAdown, AAAdown, BBAdown, CCAdown, UBAdown, MUAdown, HHAdown, TTAdown, UTAdown, E2EAdown, ETAdown, LLAdown, ZZAdown, WPrimeAdown, ThetaPrimeAdown);

            clear EEAdown UUAdown WWAdown AAAdown CCAdown BBAdown UBAdown MUAdown HHAdown TTAdown UTAdown E2EAdown ETAdown LLAdown EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_Hup.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Hup';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEHup, UUHup, WWHup, AAHup, BBHup, CCHup, UBHup, MUHup, HHHup, TTHup, UTHup, E2EHup, ETHup, LLHup, ZZHup, WPrimeHup, ThetaPrimeHup);

            clear EEHup UUHup WWHup AAHup CCHup BBHup UBHup MUHup HHHup TTHup UTHup E2EHup ETHup LLHup EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_Hdown.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Hdown';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEHdown, UUHdown, WWHdown, AAHdown, BBHdown, CCHdown, UBHdown, MUHdown, HHHdown, TTHdown, UTHdown, E2EHdown, ETHdown, LLHdown, ZZHdown, WPrimeHdown, ThetaPrimeHdown);

            clear EEHdown UUHdown WWHdown AAHdown CCHdown BBHdown UBHdown MUHdown HHHdown TTHdown UTHdown E2EHdown ETHdown LLHdown EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_Lup.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Lup';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EELup, UULup, WWLup, AALup, BBLup, CCLup, UBLup, MULup, HHLup, TTLup, UTLup, E2ELup, ETLup, LLLup, ZZLup, WPrimeLup, ThetaPrimeLup);

            clear EELup UULup WWLup AALup CCLup BBLup UBLup MULup HHLup TTLup UTLup E2ELup ETLup LLLup EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_Ldown.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_Ldown';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EELdown, UULdown, WWLdown, AALdown, BBLdown, CCLdown, UBLdown, MULdown, HHLdown, TTLdown, UTLdown, E2ELdown, ETLdown, LLLdown, ZZLdown, WPrimeLdown, ThetaPrimeLdown);

            clear EELdown UULdown WWLdown AALdown CCLdown BBLdown UBLdown MULdown HHLdown TTLdown UTLdown E2ELdown ETLdown LLLdown EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_A1050.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_A1050';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEA1050, UUA1050, WWA1050, AAA1050, BBA1050, CCA1050, UBA1050, MUA1050, HHA1050, TTA1050, UTA1050, E2EA1050, ETA1050, LLA1050, ZZA1050, WPrimeA1050, ThetaPrimeA1050);

            clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 UTA1050 E2EA1050 ETA1050 LLA1050 EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_H1050.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_H1050';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEH1050, UUH1050, WWH1050, AAH1050, BBH1050, CCH1050, UBH1050, MUH1050, HHH1050, TTH1050, UTH1050, E2EH1050, ETH1050, LLH1050, ZZH1050, WPrimeH1050, ThetaPrimeH1050);

            clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 UTH1050 E2EH1050 ETH1050 LLH1050 EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

            opts.simfile = 'Simulation_L1050.mat';
            matfile = fullfile(pwd,opts.simfile);
            load(matfile);

            plotopts = '_L1050';
            Plots(params, order, opts, plotopts, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance, EEL1050, UUL1050, WWL1050, AAL1050, BBL1050, CCL1050, UBL1050, MUL1050, HHL1050, TTL1050, UTL1050, E2EL1050, ETL1050, LLL1050, ZZL1050, WPrimeL1050, ThetaPrimeL1050);

            clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 UTL1050 E2EL1050 ETL1050 LLL1050 EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;
        end

    end

    if opts.CalcFinalMoments == 'y'
        opts.test = 'n';
        [~, ~] = CalcPlotMomentsFinal(params, order, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, lifetime_earnings, lifetime_variance);

        clear EE UU WW AA BB CC UB MU HH TT UT E2E ET LL EW EWt EWtAn UBt TW TWt TWtAn AAtAn HHtAn EWtAn_scaled lnEWtAn_scaled AAtAn_scaled AA1Ind AA3Ind AA5Ind HHt_1 HHt_3 HHt_5 HHtAn_1 HHtAn_3 HHtAn_5 LL_1 LL_3 LL_5 LLtAn_1 LLtAn_3 LLtAn_5 EW_1 EW_3 EW_5 EWtAn_1 EWtAn_3 EWtAn_5 EWHH_1 EWHH_3 EWHH_5 lnEWHHtAnscaled_1 lnEWHHtAnscaled_3 lnEWHHtAnscaled_5 EWtAn_31 EWtAn_51 EWtAn_53 TWt_Dist TWtEW_Dist TWt_Dist1 TWt_Dist3 TWt_Dist5 TWtEW_Dist1 TWtEW_Dist3 TWtEW_Dist5 EW_Var covmat_model var_model Age Time;

        SaveFinalParams(params,order);
    end

    if opts.CompareInitConds == 'y'
        initcondcompmats = struct('Baseline','Simulation_Standard.mat','Aup','Simulation_Aup.mat','Aup2StD','Simulation_Aup2StD.mat','Adown', ...
                                  'Simulation_Adown.mat','Adown2StD','Simulation_Adown2StD.mat','Hup','Simulation_Hup.mat','Hup2StD','Simulation_Hup2StD.mat','Hdown', ...
                                  'Simulation_Hdown.mat','Hdown2StD','Simulation_Hdown2StD.mat','Lup','Simulation_Lup.mat','Lup2StD','Simulation_Lup2StD.mat','Ldown', ...
                                  'Simulation_Ldown.mat','Ldown2StD','Simulation_Ldown2StD.mat','ACons','Simulation_ACons.mat','HCons','Simulation_HCons.mat','LCons', ...
                                  'Simulation_LCons.mat','AupHup','Simulation_AupHup.mat','AupHdown','Simulation_AupHdown.mat','AdownHup','Simulation_AdownHup.mat', ...
                                  'AdownHdown','Simulation_AdownHdown.mat','AupLup','Simulation_AupLup.mat','AupLdown','Simulation_AupLdown.mat','AdownLup','Simulation_AdownLup.mat', ...
                                  'AdownLdown','Simulation_AdownLdown.mat','HupLup','Simulation_HupLup.mat','HupLdown','Simulation_HupLdown.mat','HdownLup','Simulation_HdownLup.mat', ...
                                  'HdownLdown','Simulation_HdownLdown.mat');

        %HVYComparison(params, order, opts, hvymats);
        
        
        
        matfile = fullfile(pwd,initcondcompmats.Baseline);
        load(matfile);
         
        matfile = fullfile(pwd,initcondcompmats.Aup);
        load(matfile);
        testopts = struct('name','Aup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAup, AAAup, HHAup, LLAup, EEAup, WWAup, MUAup, TTAup, WPrimeAup);
        clear EEAup UUAup WWAup AAAup CCAup BBAup UBAup MUAup HHAup TTAup LLAup UTAup E2EAup ETAup ZZAup WPrimeAup ThetaPrimeAup;
        matfile = fullfile(pwd,initcondcompmats.Adown);
        load(matfile);
        testopts = struct('name','Adown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdown, AAAdown, HHAdown, LLAdown, EEAdown, WWAdown, MUAdown, TTAdown, WPrimeAdown);
        clear EEAdown UUAdown WWAdown AAAdown CCAdown BBAdown UBAdown MUAdown HHAdown TTAdown LLAdown UTAdown E2EAdown ETAdown ZZAdown WPrimeAdown ThetaPrimeAdown;
        matfile = fullfile(pwd,initcondcompmats.Aup2StD);
        load(matfile);
        testopts = struct('name','Aup2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAup2StD, AAAup2StD, HHAup2StD, LLAup2StD, EEAup2StD, WWAup2StD, MUAup2StD, TTAup2StD, WPrimeAup2StD);
        clear EEAup2StD UUAup2StD WWAup2StD AAAup2StD CCAup2StD BBAup2StD UBAup2StD MUAup2StD HHAup2StD TTAup2StD LLAup2StD UTAup2StD E2EAup2StD ETAup2StD ZZAup2StD WPrimeAup2StD ThetaPrimeAup2StD;
        matfile = fullfile(pwd,initcondcompmats.Adown2StD);
        load(matfile);
        testopts = struct('name','Adown2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdown2StD, AAAdown2StD, HHAdown2StD, LLAdown2StD, EEAdown2StD, WWAdown2StD, MUAdown2StD, TTAdown2StD, WPrimeAdown2StD);
        clear EEAdown2StD UUAdown2StD WWAdown2StD AAAdown2StD CCAdown2StD BBAdown2StD UBAdown2StD MUAdown2StD HHAdown2StD TTAdown2StD LLAdown2StD UTAdown2StD E2EAdown2StD ETAdown2StD ZZAdown2StD WPrimeAdown2StD ThetaPrimeAdown2StD;
        
        matfile = fullfile(pwd,initcondcompmats.Hup);
        load(matfile);
        testopts = struct('name','Hup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHup, AAHup, HHHup, LLHup, EEHup, WWHup, MUHup, TTHup, WPrimeHup);
        clear EEHup UUHup WWHup AAHup CCHup BBHup UBHup MUHup HHHup TTHup LLHup UTHup E2EHup ETHup ZZHup WPrimeHup ThetaPrimeHup;
        matfile = fullfile(pwd,initcondcompmats.Hdown);
        load(matfile);
        testopts = struct('name','Hdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHdown, AAHdown, HHHdown, LLHdown, EEHdown, WWHdown, MUHdown, TTHdown, WPrimeHdown);
        clear EEHdown UUHdown WWHdown AAHdown CCHdown BBHdown UBHdown MUHdown HHHdown TTHdown LLHdown UTHdown E2EHdown ETHdown ZZHdown WPrimeHdown ThetaPrimeHdown;
        matfile = fullfile(pwd,initcondcompmats.Hup2StD);
        load(matfile);
        testopts = struct('name','Hup2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHup2StD, AAHup2StD, HHHup2StD, LLHup2StD, EEHup2StD, WWHup2StD, MUHup2StD, TTHup2StD, WPrimeHup2StD);
        clear EEHup2StD UUHup2StD WWHup2StD AAHup2StD CCHup2StD BBHup2StD UBHup2StD MUHup2StD HHHup2StD TTHup2StD LLHup2StD UTHup2StD E2EHup2StD ETHup2StD ZZHup2StD WPrimeHup2StD ThetaPrimeHup2StD;
        matfile = fullfile(pwd,initcondcompmats.Hdown2StD);
        load(matfile);
        testopts = struct('name','Hdown2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHdown2StD, AAHdown2StD, HHHdown2StD, LLHdown2StD, EEHdown2StD, WWHdown2StD, MUHdown2StD, TTHdown2StD, WPrimeHdown2StD);
        clear EEHdown2StD UUHdown2StD WWHdown2StD AAHdown2StD CCHdown2StD BBHdown2StD UBHdown2StD MUHdown2StD HHHdown2StD TTHdown2StD LLHdown2StD UTHdown2StD E2EHdown2StD ETHdown2StD ZZHdown2StD WPrimeHdown2StD ThetaPrimeHdown2StD;
        
        
        matfile = fullfile(pwd,initcondcompmats.Lup);
        load(matfile);
        testopts = struct('name','Lup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCLup, AALup, HHLup, LLLup, EELup, WWLup, MULup, TTLup, WPrimeLup);
        clear EELup UULup WWLup AALup CCLup BBLup UBLup MULup HHLup TTLup LLLup UTLup E2ELup ETLup ZZLup WPrimeLup ThetaPrimeLup;
        matfile = fullfile(pwd,initcondcompmats.Ldown);
        load(matfile);
        testopts = struct('name','Ldown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCLdown, AALdown, HHLdown, LLLdown, EELdown, WWLdown, MULdown, TTLdown, WPrimeLdown);
        clear EELdown UULdown WWLdown AALdown CCLdown BBLdown UBLdown MULdown HHLdown TTLdown LLLdown UTLdown E2ELdown ETLdown ZZLdown WPrimeLdown ThetaPrimeLdown;
        matfile = fullfile(pwd,initcondcompmats.Lup2StD);
        load(matfile);
        testopts = struct('name','Lup2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCLup2StD, AALup2StD, HHLup2StD, LLLup2StD, EELup2StD, WWLup2StD, MULup2StD, TTLup2StD, WPrimeLup2StD);
        clear EELup2StD UULup2StD WWLup2StD AALup2StD CCLup2StD BBLup2StD UBLup2StD MULup2StD HHLup2StD TTLup2StD LLLup2StD UTLup2StD E2ELup2StD ETLup2StD ZZLup2StD WPrimeLup2StD ThetaPrimeLup2StD;
        matfile = fullfile(pwd,initcondcompmats.Ldown2StD);
        load(matfile);
        testopts = struct('name','Ldown2StD');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCLdown2StD, AALdown2StD, HHLdown2StD, LLLdown2StD, EELdown2StD, WWLdown2StD, MULdown2StD, TTLdown2StD, WPrimeLdown2StD);
        clear EELdown2StD UULdown2StD WWLdown2StD AALdown2StD CCLdown2StD BBLdown2StD UBLdown2StD MULdown2StD HHLdown2StD TTLdown2StD LLLdown2StD UTLdown2StD E2ELdown2StD ETLdown2StD ZZLdown2StD WPrimeLdown2StD ThetaPrimeLdown2StD;
        
        matfile = fullfile(pwd,initcondcompmats.AupHup);
        load(matfile);
        testopts = struct('name','AupHup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAupHup, AAAupHup, HHAupHup, LLAupHup, EEAupHup, WWAupHup, MUAupHup, TTAupHup, WPrimeAupHup);
        clear EEAupHup UUAupHup WWAupHup AAAupHup CCAupHup BBAupHup UBAupHup MUAupHup HHAupHup TTAupHup LLAupHup UTAupHup E2EAupHup ETAupHup ZZAupHup WPrimeAupHup ThetaPrimeAupHup;
        matfile = fullfile(pwd,initcondcompmats.AupHdown);
        load(matfile);
        testopts = struct('name','AupHdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAupHdown, AAAupHdown, HHAupHdown, LLAupHdown, EEAupHdown, WWAupHdown, MUAupHdown, TTAupHdown, WPrimeAupHdown);
        clear EEAupHdown UUAupHdown WWAupHdown AAAupHdown CCAupHdown BBAupHdown UBAupHdown MUAupHdown HHAupHdown TTAupHdown LLAupHdown UTAupHdown E2EAupHdown ETAupHdown ZZAupHdown WPrimeAupHdown ThetaPrimeAupHdown;
        matfile = fullfile(pwd,initcondcompmats.AdownHup);
        load(matfile);
        testopts = struct('name','AdownHup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdownHup, AAAdownHup, HHAdownHup, LLAdownHup, EEAdownHup, WWAdownHup, MUAdownHup, TTAdownHup, WPrimeAdownHup);
        clear EEAdownHup UUAdownHup WWAdownHup AAAdownHup CCAdownHup BBAdownHup UBAdownHup MUAdownHup HHAdownHup TTAdownHup LLAdownHup UTAdownHup E2EAdownHup ETAdownHup ZZAdownHup WPrimeAdownHup ThetaPrimeAdownHup;
        matfile = fullfile(pwd,initcondcompmats.AdownHdown);
        load(matfile);
        testopts = struct('name','AdownHdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdownHdown, AAAdownHdown, HHAdownHdown, LLAdownHdown, EEAdownHdown, WWAdownHdown, MUAdownHdown, TTAdownHdown, WPrimeAdownHdown);
        clear EEAdownHdown UUAdownHdown WWAdownHdown AAAdownHdown CCAdownHdown BBAdownHdown UBAdownHdown MUAdownHdown HHAdownHdown TTAdownHdown LLAdownHdown UTAdownHdown E2EAdownHdown ETAdownHdown ZZAdownHdown WPrimeAdownHdown ThetaPrimeAdownHdown;
        
        matfile = fullfile(pwd,initcondcompmats.AupLup);
        load(matfile);
        testopts = struct('name','AupLup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAupLup, AAAupLup, HHAupLup, LLAupLup, EEAupLup, WWAupLup, MUAupLup, TTAupLup, WPrimeAupLup);
        clear EEAupLup UUAupLup WWAupLup AAAupLup CCAupLup BBAupLup UBAupLup MUAupLup HHAupLup TTAupLup LLAupLup UTAupLup E2EAupLup ETAupLup ZZAupLup WPrimeAupLup ThetaPrimeAupLup;
        matfile = fullfile(pwd,initcondcompmats.AupLdown);
        load(matfile);
        testopts = struct('name','AupLdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAupLdown, AAAupLdown, HHAupLdown, LLAupLdown, EEAupLdown, WWAupLdown, MUAupLdown, TTAupLdown, WPrimeAupLdown);
        clear EEAupLdown UUAupLdown WWAupLdown AAAupLdown CCAupLdown BBAupLdown UBAupLdown MUAupLdown HHAupLdown TTAupLdown LLAupLdown UTAupLdown E2EAupLdown ETAupLdown ZZAupLdown WPrimeAupLdown ThetaPrimeAupLdown;
        matfile = fullfile(pwd,initcondcompmats.AdownLup);
        load(matfile);
        testopts = struct('name','AdownLup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdownLup, AAAdownLup, HHAdownLup, LLAdownLup, EEAdownLup, WWAdownLup, MUAdownLup, TTAdownLup, WPrimeAdownLup);
        clear EEAdownLup UUAdownLup WWAdownLup AAAdownLup CCAdownLup BBAdownLup UBAdownLup MUAdownLup HHAdownLup TTAdownLup LLAdownLup UTAdownLup E2EAdownLup ETAdownLup ZZAdownLup WPrimeAdownLup ThetaPrimeAdownLup;
        matfile = fullfile(pwd,initcondcompmats.AdownLdown);
        load(matfile);
        testopts = struct('name','AdownLdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCAdownLdown, AAAdownLdown, HHAdownLdown, LLAdownLdown, EEAdownLdown, WWAdownLdown, MUAdownLdown, TTAdownLdown, WPrimeAdownLdown);
        clear EEAdownLdown UUAdownLdown WWAdownLdown AAAdownLdown CCAdownLdown BBAdownLdown UBAdownLdown MUAdownLdown HHAdownLdown TTAdownLdown LLAdownLdown UTAdownLdown E2EAdownLdown ETAdownLdown ZZAdownLdown WPrimeAdownLdown ThetaPrimeAdownLdown;
        
        matfile = fullfile(pwd,initcondcompmats.HupLup);
        load(matfile);
        testopts = struct('name','HupLup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHupLup, AAHupLup, HHHupLup, LLHupLup, EEHupLup, WWHupLup, MUHupLup, TTHupLup, WPrimeHupLup);
        clear EEHupLup UUHupLup WWHupLup AAHupLup CCHupLup BBHupLup UBHupLup MUHupLup HHHupLup TTHupLup LLHupLup UTHupLup E2EHupLup ETHupLup ZZHupLup WPrimeHupLup ThetaPrimeHupLup;
        matfile = fullfile(pwd,initcondcompmats.HupLdown);
        load(matfile);
        testopts = struct('name','HupLdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHupLdown, AAHupLdown, HHHupLdown, LLHupLdown, EEHupLdown, WWHupLdown, MUHupLdown, TTHupLdown, WPrimeHupLdown);
        clear EEHupLdown UUHupLdown WWHupLdown AAHupLdown CCHupLdown BBHupLdown UBHupLdown MUHupLdown HHHupLdown TTHupLdown LLHupLdown UTHupLdown E2EHupLdown ETHupLdown ZZHupLdown WPrimeHupLdown ThetaPrimeHupLdown;
        matfile = fullfile(pwd,initcondcompmats.HdownLup);
        load(matfile);
        testopts = struct('name','HdownLup');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHdownLup, AAHdownLup, HHHdownLup, LLHdownLup, EEHdownLup, WWHdownLup, MUHdownLup, TTHdownLup, WPrimeHdownLup);
        clear EEHdownLup UUHdownLup WWHdownLup AAHdownLup CCHdownLup BBHdownLup UBHdownLup MUHdownLup HHHdownLup TTHdownLup LLHdownLup UTHdownLup E2EHdownLup ETHdownLup ZZHdownLup WPrimeHdownLup ThetaPrimeHdownLup;
        matfile = fullfile(pwd,initcondcompmats.HdownLdown);
        load(matfile);
        testopts = struct('name','HdownLdown');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCHdownLdown, AAHdownLdown, HHHdownLdown, LLHdownLdown, EEHdownLdown, WWHdownLdown, MUHdownLdown, TTHdownLdown, WPrimeHdownLdown);
        clear EEHdownLdown UUHdownLdown WWHdownLdown AAHdownLdown CCHdownLdown BBHdownLdown UBHdownLdown MUHdownLdown HHHdownLdown TTHdownLdown LLHdownLdown UTHdownLdown E2EHdownLdown ETHdownLdown ZZHdownLdown WPrimeHdownLdown ThetaPrimeHdownLdown;
        
        HVYPlots(params, order, opts, NumObs, NObsNames, initcondcompmats);
        
        initcondmats = struct('Baseline','Simulation_Med.mat','Q1','Simulation_Q1.mat','Q1A','Simulation_Q1A.mat', ...
                              'Q1H','Simulation_Q1H.mat','Q1L','Simulation_Q1L.mat','Q1DA','Simulation_Q1DA.mat', ...
                              'Q1DH','Simulation_Q1DH.mat','Q1DL','Simulation_Q1DL.mat','A1050','Simulation_A1050.mat', ...
                              'H1050','Simulation_H1050.mat','L1050','Simulation_L1050.mat','AQ1050','Simulation_A1050.mat', ...
                              'HQ1050','Simulation_H1050.mat','LQ1050','Simulation_L1050.mat','AD1050','Simulation_A1050.mat', ...
                              'HD1050','Simulation_H1050.mat','LD1050','Simulation_L1050.mat');

        matfile = fullfile(pwd,initcondmats.A1050);
        load(matfile);
        testopts = struct('name','A1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        matfile = fullfile(pwd,initcondmats.H1050);
        load(matfile);
        testopts = struct('name','H1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        matfile = fullfile(pwd,initcondmats.L1050);
        load(matfile);
        testopts = struct('name','L1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        
        matfile = fullfile(pwd,initcondmats.Q1);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.A1050);
        load(matfile);
        testopts = struct('name','A1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1, AAQ1, HHQ1, LLQ1, EEQ1, WWQ1, MUQ1, TTQ1, WPrimeQ1, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        
        matfile = fullfile(pwd,initcondmats.H1050);
        load(matfile);
        testopts = struct('name','H1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1, AAQ1, HHQ1, LLQ1, EEQ1, WWQ1, MUQ1, TTQ1, WPrimeQ1, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        
        matfile = fullfile(pwd,initcondmats.L1050);
        load(matfile);
        testopts = struct('name','L1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1, AAQ1, HHQ1, LLQ1, EEQ1, WWQ1, MUQ1, TTQ1, WPrimeQ1, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        clear EEQ1 UUQ1 WWQ1 AAQ1 CCQ1 BBQ1 UBQ1 MUQ1 HHQ1 TTQ1 LLQ1 UTQ1 E2EQ1 ETQ1 ZZQ1 WPrimeQ1 ThetaPrimeQ1;

        
        matfile = fullfile(pwd,initcondmats.AQ1050);
        load(matfile);
        testopts = struct('name','AQ1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        matfile = fullfile(pwd,initcondmats.HQ1050);
        load(matfile);
        testopts = struct('name','HQ1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        matfile = fullfile(pwd,initcondmats.LQ1050);
        load(matfile);
        testopts = struct('name','LQ1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        
        matfile = fullfile(pwd,initcondmats.Q1A);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.AQ1050);
        load(matfile);
        testopts = struct('name','AQ1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1A, AAQ1A, HHQ1A, LLQ1A, EEQ1A, WWQ1A, MUQ1A, TTQ1A, WPrimeQ1A, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        clear EEQ1A UUQ1A WWQ1A AAQ1A CCQ1A BBQ1A UBQ1A MUQ1A HHQ1A TTQ1A LLQ1A UTQ1A E2EQ1A ETQ1A ZZQ1A WPrimeQ1A ThetaPrimeQ1A;
        matfile = fullfile(pwd,initcondmats.Q1H);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.HQ1050);
        load(matfile);
        testopts = struct('name','HQ1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1H, AAQ1H, HHQ1H, LLQ1H, EEQ1H, WWQ1H, MUQ1H, TTQ1H, WPrimeQ1H, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        clear EEQ1H UUQ1H WWQ1H AAQ1H CCQ1H BBQ1H UBQ1H MUQ1H HHQ1H TTQ1H LLQ1H UTQ1H E2EQ1H ETQ1H ZZQ1H WPrimeQ1H ThetaPrimeQ1H;
        matfile = fullfile(pwd,initcondmats.Q1L);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.LQ1050);
        load(matfile);
        testopts = struct('name','LQ1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1L, AAQ1L, HHQ1L, LLQ1L, EEQ1L, WWQ1L, MUQ1L, TTQ1L, WPrimeQ1L, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        clear EEQ1L UUQ1L WWQ1L AAQ1L CCQ1L BBQ1L UBQ1L MUQ1L HHQ1L TTQ1L LLQ1L UTQ1L E2EQ1L ETQ1L ZZQ1L WPrimeQ1L ThetaPrimeQ1L;
        
        matfile = fullfile(pwd,initcondmats.AD1050);
        load(matfile);
        testopts = struct('name','AD1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        matfile = fullfile(pwd,initcondmats.HD1050);
        load(matfile);
        testopts = struct('name','HD1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        matfile = fullfile(pwd,initcondmats.LD1050);
        load(matfile);
        testopts = struct('name','LD1050');
        InitialConditionRatios(params, order,  opts, testopts, CC, AA, HH, LL, EE, WW, MU, TT, WPrime, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        
        matfile = fullfile(pwd,initcondmats.Q1DA);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.AD1050);
        load(matfile);
        testopts = struct('name','AD1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1DA, AAQ1DA, HHQ1DA, LLQ1DA, EEQ1DA, WWQ1DA, MUQ1DA, TTQ1DA, WPrimeQ1DA, CCA1050, AAA1050, HHA1050, LLA1050, EEA1050, WWA1050, MUA1050, TTA1050, WPrimeA1050);
        clear EEA1050 UUA1050 WWA1050 AAA1050 CCA1050 BBA1050 UBA1050 MUA1050 HHA1050 TTA1050 LLA1050 UTA1050 E2EA1050 ETA1050 ZZA1050 WPrimeA1050 ThetaPrimeA1050;
        clear EEQ1DA UUQ1DA WWQ1DA AAQ1DA CCQ1DA BBQ1DA UBQ1DA MUQ1DA HHQ1DA TTQ1DA LLQ1DA UTQ1DA E2EQ1DA ETQ1DA ZZQ1DA WPrimeQ1DA ThetaPrimeQ1DA;
        matfile = fullfile(pwd,initcondmats.Q1DH);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.HD1050);
        load(matfile);
        testopts = struct('name','HD1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1DH, AAQ1DH, HHQ1DH, LLQ1DH, EEQ1DH, WWQ1DH, MUQ1DH, TTQ1DH, WPrimeQ1DH, CCH1050, AAH1050, HHH1050, LLH1050, EEH1050, WWH1050, MUH1050, TTH1050, WPrimeH1050);
        clear EEH1050 UUH1050 WWH1050 AAH1050 CCH1050 BBH1050 UBH1050 MUH1050 HHH1050 TTH1050 LLH1050 UTH1050 E2EH1050 ETH1050 ZZH1050 WPrimeH1050 ThetaPrimeH1050;
        clear EEQ1DH UUQ1DH WWQ1DH AAQ1DH CCQ1DH BBQ1DH UBQ1DH MUQ1DH HHQ1DH TTQ1DH LLQ1DH UTQ1DH E2EQ1DH ETQ1DH ZZQ1DH WPrimeQ1DH ThetaPrimeQ1DH;
        matfile = fullfile(pwd,initcondmats.Q1DL);
        load(matfile);
        matfile = fullfile(pwd,initcondmats.LD1050);
        load(matfile);
        testopts = struct('name','LD1050Base');
        InitialConditionRatios(params, order,  opts, testopts, CCQ1DL, AAQ1DL, HHQ1DL, LLQ1DL, EEQ1DL, WWQ1DL, MUQ1DL, TTQ1DL, WPrimeQ1DL, CCL1050, AAL1050, HHL1050, LLL1050, EEL1050, WWL1050, MUL1050, TTL1050, WPrimeL1050);
        clear EEL1050 UUL1050 WWL1050 AAL1050 CCL1050 BBL1050 UBL1050 MUL1050 HHL1050 TTL1050 LLL1050 UTL1050 E2EL1050 ETL1050 ZZL1050 WPrimeL1050 ThetaPrimeL1050;
        clear EEQ1DL UUQ1DL WWQ1DL AAQ1DL CCQ1DL BBQ1DL UBQ1DL MUQ1DL HHQ1DL TTQ1DL LLQ1DL UTQ1DL E2EQ1DL ETQ1DL ZZQ1DL WPrimeQ1DL ThetaPrimeQ1DL;
        
        %InitialConditionComparison(params, order, pwd, initcondmats);

        %plotopts = '_InitCondCompare';

        %InitialConditionPlots(params, order, pwd, initcondmats, plotopts);
        
        initcondmats = struct('Test','AllQ1','Panel','Wealth','Med','Simulation_Med.mat','Q1','Simulation_Q1.mat', ... 
                              'Mat1050','Simulation_AQ1050.mat');
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','AllQ1','Panel','HumanCap','Med','Simulation_Med.mat','Q1','Simulation_Q1.mat', ...
                              'Mat1050','Simulation_HQ1050.mat');        
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','AllQ1','Panel','Learn','Med','Simulation_Med.mat','Q1','Simulation_Q1.mat', ...
                              'Mat1050','Simulation_LQ1050.mat');         
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','IndQ1','Panel','Wealth','Med','Simulation_Med.mat','Q1','Simulation_Q1A.mat', ...
                              'Mat1050','Simulation_A1050.mat');
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','IndQ1','Panel','HumanCap','Med','Simulation_Med.mat','Q1','Simulation_Q1H.mat', ...
                              'Mat1050','Simulation_H1050.mat');        
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','IndQ1','Panel','Learn','Med','Simulation_Med.mat','Q1','Simulation_Q1L.mat', ...
                              'Mat1050','Simulation_L1050.mat');         
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','Dist','Panel','Wealth','Med','Simulation_Med.mat','Q1','Simulation_Q1DA.mat', ...
                              'Mat1050','Simulation_AD1050.mat');
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','Dist','Panel','HumanCap','Med','Simulation_Med.mat','Q1','Simulation_Q1DH.mat', ...
                              'Mat1050','Simulation_HD1050.mat');        
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        initcondmats = struct('Test','Dist','Panel','Learn','Med','Simulation_Med.mat','Q1','Simulation_Q1DL.mat', ...
                              'Mat1050','Simulation_LD1050.mat');         
        InitialConditionIndPlots(params, order, opts, NumObs, NObsNames, initcondmats);
        
    end

    if opts.FindParamSEs == 'y'

        StdErrCalc(params, order, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, earnings_profile, earnings_variance);
        
    end
    if opts.MonteCarloTest == 'y'

        MCTest(params, order, nparams, opts, moments, weights, NumObs, NObsNames, init_earnings, init_assets, earnings_profile, earnings_variance);
        
    end

end
