function [rphate,rphatu,DELTA,EpsSHOCK,LLAMBE,LLAMBU,GAMU,EE,UU,WW,AA,BB,CC,UB,MU,HH,TT,UT,LL,UE,EU,E2E,ET,ZZ,WPrime,ThetaPrime,TreatedInd,PInitHat,initQtiles,wmesh,hmesh,lmesh,hmeshu,lmeshu,bmeshb,hmeshb,lmeshb] = SimGrids(params,order,opts,seedval)
%% SimGrids m-file for Wealth Effects, Search, and Life-Cycle Inequality
%
% Authors: Ben Griffy
% Date: May, 2017
    
    rng(seedval);

%load parameters
    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);
    
%separate into when we are using GPU and when we aren't
    if opts.gpu == 'y'
        [Epsgrid,~,Zcdf] = CompTrapInt(Epsnodes,MuEps,SigEps,StdEps);
        Epsgrid = gpuArray(Epsgrid);
        Zcdf = gpuArray(Zcdf);
        
        wgrid  = gpuArray(linspace(lb.w,ub.w,Nw)); 
        hgrid  = gpuArray(linspace(lb.h,ub.h,Nh)); 
        lgrid  = gpuArray(linspace(lb.l,ub.l,Nl));
        bgrid  = gpuArray(linspace(lb.b,ub.b,Nb));


        rdelta = rand(N,T+1);                  % Determines if employed worker is exogenously separated from his job
        rllambu = rand(N,T);                  % Determines if unemployed worker can search for a job
        rllambe = rand(N,T);                  % Determines if employed worker can search for a job
        rphatu = rand(N,T);        % Determines if unemployed worker got a job
        rphate = rand(N,T);        % Determines if employed worker got a new job
        rgamu  = rand(N,T);                  % Determines if an unemployed worker loses benefits

        DELTA  = (rdelta<=ddelta);           % Matrix with 1s if separation shocks hits or 0s otherwise
        LLAMBE  = (rllambe<=llambe);            % Binary matrix
        LLAMBU  = (rllambu<=llambu);            % Matrix with 1s if allowed to search if unemployed or 0s otherwise
        GAMU   = (rgamu<=ggamma);            % Binary matrix for benefits shocks
        EpsSHOCK   = normrnd(MuEps,SigEps,[N,T+1]);
        EpsSHOCK   = gpuArray(EpsSHOCK);
        EpsSHOCK(EpsSHOCK>=max(Epsgrid)) = max(Epsgrid);
        EpsSHOCK(EpsSHOCK<=min(Epsgrid)) = min(Epsgrid);
        EpsSHOCK = exp(EpsSHOCK);
        clear rdelta rllambu rllambe rgamu rdeltah;            % save as much memory as possible
        MuX = [ MuA MuH MuL ];
        SigX = [ SigA SigH SigL ];
        CorrMat = [1 SigAH SigAL ; SigAH 1 SigHL ; SigAL  SigHL 1];

        [initconds,phat] = LNRndCopula(MuX,SigX,CorrMat,N); % Chooses initial distribution
        alb = geosum(r,bl,T);
        tempconds = initconds;
        tempconds(tempconds(:,1)<=lb.a,1) = lb.a;
        tempconds(tempconds(:,1)>=(ub.a+alb),1) = (ub.a+alb);
        tempconds(tempconds(:,2)<=(lb.h-delt.h),2) = (lb.h-delt.h);
        tempconds(tempconds(:,3)<=(lb.l-delt.l),3) = (lb.l-delt.l);
        tempconds(tempconds(:,2)>=(ub.h-delt.h),2) = (ub.h-delt.h);
        tempconds(tempconds(:,3)>=(ub.l-delt.l),3) = (ub.l-delt.l);
        tempconds(tempconds(:,1)<=lb.a,1) = lb.a + eepsilon;
        tempconds(:,1) = tempconds(:,1) - repmat(alb,N,1);
        tempconds(tempconds(:,1)>=ub.a,1) = ub.a - eepsilon;
        tempconds(:,2) = tempconds(:,2) + delt.h;
        tempconds(:,3) = tempconds(:,3) + delt.l;
        tempconds(tempconds(:,2)<=lb.h,2) = lb.h + eepsilon;
        tempconds(tempconds(:,3)<=lb.l,3) = lb.l + eepsilon;
        tempconds(tempconds(:,2)>=ub.h,2) = ub.h - eepsilon;
        tempconds(tempconds(:,3)>=ub.l,3) = ub.l - eepsilon;
        initQtiles.Wealth = zeros(N,1);
        initQtiles.Wealth(tempconds(:,1) <= quantile(tempconds(:,1),0.2),:) = 1;
        initQtiles.Wealth(tempconds(:,1) > quantile(tempconds(:,1),0.2) & tempconds(:,1) <= quantile(tempconds(:,1),0.4),:) = 2;
        initQtiles.Wealth(tempconds(:,1) > quantile(tempconds(:,1),0.4) & tempconds(:,1) <= quantile(tempconds(:,1),0.6),:) = 3;
        initQtiles.Wealth(tempconds(:,1) > quantile(tempconds(:,1),0.6) & tempconds(:,1) <= quantile(tempconds(:,1),0.8),:) = 4;
        initQtiles.Wealth(tempconds(:,1) >= quantile(tempconds(:,1),0.8),:) = 5;
        initQtiles.HumanCap = zeros(N,1);
        initQtiles.HumanCap(tempconds(:,1) <= quantile(tempconds(:,1),0.2),:) = 1;
        initQtiles.HumanCap(tempconds(:,1) > quantile(tempconds(:,1),0.2) & tempconds(:,1) <= quantile(tempconds(:,1),0.4),:) = 2;
        initQtiles.HumanCap(tempconds(:,1) > quantile(tempconds(:,1),0.4) & tempconds(:,1) <= quantile(tempconds(:,1),0.6),:) = 3;
        initQtiles.HumanCap(tempconds(:,1) > quantile(tempconds(:,1),0.6) & tempconds(:,1) <= quantile(tempconds(:,1),0.8),:) = 4;
        initQtiles.HumanCap(tempconds(:,1) >= quantile(tempconds(:,1),0.8),:) = 5;
        initQtiles.Learn = zeros(N,1);
        initQtiles.Learn(tempconds(:,1) <= quantile(tempconds(:,1),0.2),:) = 1;
        initQtiles.Learn(tempconds(:,1) > quantile(tempconds(:,1),0.2) & tempconds(:,1) <= quantile(tempconds(:,1),0.4),:) = 2;
        initQtiles.Learn(tempconds(:,1) > quantile(tempconds(:,1),0.4) & tempconds(:,1) <= quantile(tempconds(:,1),0.6),:) = 3;
        initQtiles.Learn(tempconds(:,1) > quantile(tempconds(:,1),0.6) & tempconds(:,1) <= quantile(tempconds(:,1),0.8),:) = 4;
        initQtiles.Learn(tempconds(:,1) >= quantile(tempconds(:,1),0.8),:) = 5;
        clear tempconds;

        tempconds = initconds;
        tempconds(tempconds(:,1)<=lb.a,1) = lb.a;
        tempconds(tempconds(:,1)>=(ub.a+alb),1) = (ub.a+alb);
        tempconds(tempconds(:,2)<=(lb.h-delt.h),2) = (lb.h-delt.h);
        tempconds(tempconds(:,3)<=(lb.l-delt.l),3) = (lb.l-delt.l);
        tempconds(tempconds(:,2)>=(ub.h-delt.h),2) = (ub.h-delt.h);
        tempconds(tempconds(:,3)>=(ub.l-delt.l),3) = (ub.l-delt.l);
        TreatedInd = zeros(size(initconds,1),1);
        if opts.II == 'n'
            if strcmpi(opts.test,'AMPIncreaseS')
                lncoef = lognfit(reshape(tempconds(:,1),[],1));
                MuAC = lncoef(1);
                SigAC = lncoef(2);
                initconds(:,1) = MeanPreserveSpread(tempconds(:,1),MuAC,SigAC,MPIncreaseSA);
            elseif strcmpi(opts.test,'AMPDecreaseS')
                lncoef = lognfit(reshape(tempconds(:,1),[],1));
                MuAC = lncoef(1);
                SigAC = lncoef(2);
                initconds(:,1) = MeanPreserveSpread(tempconds(:,1),MuAC,SigAC,MPDecreaseSA);
            elseif strcmpi(opts.test,'HMPIncreaseS')
                lncoef = lognfit(reshape(tempconds(:,2),[],1));
                MuHC = lncoef(1);
                SigHC = lncoef(2);
                initconds(:,2) = MeanPreserveSpread(tempconds(:,2),MuHC,SigHC,MPIncreaseSH);
            elseif strcmpi(opts.test,'HMPDecreaseS')
                lncoef = lognfit(reshape(tempconds(:,2),[],1));
                MuHC = lncoef(1);
                SigHC = lncoef(2);
                initconds(:,2) = MeanPreserveSpread(tempconds(:,2),MuHC,SigHC,MPDecreaseSH);
            elseif strcmpi(opts.test,'LMPIncreaseS')
                lncoef = lognfit(reshape(tempconds(:,3),[],1));
                MuLC = lncoef(1);
                SigLC = lncoef(2);
                initconds(:,3) = MeanPreserveSpread(tempconds(:,3),MuLC,SigLC,MPIncreaseSL);
            elseif strcmpi(opts.test,'LMPDecreaseS')
                lncoef = lognfit(reshape(tempconds(:,3),[],1));
                MuLC = lncoef(1);
                SigLC = lncoef(2);
                initconds(:,3) = MeanPreserveSpread(tempconds(:,3),MuLC,SigLC,MPDecreaseSL);
            elseif strcmpi(opts.test,'DebtRelief')
                [Ind, ~] = find(initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowH')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedH')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighH')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowHL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.25) & initconds(:,3) >= quantile(tempconds(:,3),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedHL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.5) & initconds(:,3) >= quantile(tempconds(:,3),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighHL')
                [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.75) & initconds(:,3) >= quantile(tempconds(:,3),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'AUp')
                initconds(:,1) = logninv(normcdf((norminv(logncdf(initconds(:,1),MuA,SigA),MuA,SigA) + SigA),MuA,SigA),MuA,SigA);
            elseif strcmpi(opts.test,'ADown')
                initconds(:,1) = logninv(normcdf((norminv(logncdf(initconds(:,1),MuA,SigA),MuA,SigA) - SigA),MuA,SigA),MuA,SigA);
            elseif strcmpi(opts.test,'HUp')
                initconds(:,2) = logninv(normcdf((norminv(logncdf(initconds(:,2),MuH,SigH),MuH,SigH) + SigH),MuH,SigH),MuH,SigH);
            elseif strcmpi(opts.test,'HDown')
                initconds(:,2) = logninv(normcdf((norminv(logncdf(initconds(:,2),MuH,SigH),MuH,SigH) - SigH),MuH,SigH),MuH,SigH);
            elseif strcmpi(opts.test,'LUp')
                initconds(:,3) = logninv(normcdf((norminv(logncdf(initconds(:,3),MuL,SigL),MuL,SigL) + SigL),MuL,SigL),MuL,SigL);
            elseif strcmpi(opts.test,'LDown')
                initconds(:,3) = logninv(normcdf((norminv(logncdf(initconds(:,3),MuL,SigL),MuL,SigL) - SigL),MuL,SigL),MuL,SigL);
            elseif strcmpi(opts.test,'Med')
                initconds(:,1) = ones(N,1).*median(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(tempconds(:,3),1);
            elseif strcmpi(opts.test,'AUpHVY')
                initconds(:,1) = ones(N,1).*(median(tempconds(:,1),1) + std(initconds(:,1),1));
                initconds(:,2) = ones(N,1).*median(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(tempconds(:,3),1);
            elseif strcmpi(opts.test,'ADownHVY')
                initconds(:,1) = ones(N,1).*(median(tempconds(:,1),1) - std(initconds(:,1),1));
                initconds(:,2) = ones(N,1).*median(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(tempconds(:,3),1);
            elseif strcmpi(opts.test,'HUpHVY')
                initconds(:,1) = ones(N,1).*median(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*(median(tempconds(:,2),1) + std(initconds(:,2),1));
                initconds(:,3) = ones(N,1).*median(tempconds(:,3),1);
            elseif strcmpi(opts.test,'HDownHVY')
                initconds(:,1) = ones(N,1).*median(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*(median(tempconds(:,2),1) - std(initconds(:,2),1));
                initconds(:,3) = ones(N,1).*median(tempconds(:,3),1);
            elseif strcmpi(opts.test,'LUpHVY')
                initconds(:,1) = ones(N,1).*median(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*(median(tempconds(:,3),1) + std(initconds(:,3),1));
            elseif strcmpi(opts.test,'LDownHVY')
                initconds(:,1) = ones(N,1).*median(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*(median(tempconds(:,3),1) - std(initconds(:,3),1));
            elseif strcmpi(opts.test,'Cons')
                initconds(:,1) = ones(N,1).*nanmean(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*nanmean(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*nanmean(tempconds(:,3),1);
            elseif strcmpi(opts.test,'ACons')
                initconds(:,1) = ones(N,1).*nanmean(tempconds(:,1),1);
            elseif strcmpi(opts.test,'HCons')
                initconds(:,2) = ones(N,1).*nanmean(tempconds(:,2),1);
            elseif strcmpi(opts.test,'LCons')
                initconds(:,3) = ones(N,1).*nanmean(tempconds(:,3),1);
            elseif strcmpi(opts.test,'AHCons')
                initconds(:,1) = ones(N,1).*nanmean(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*nanmean(tempconds(:,2),1);
            elseif strcmpi(opts.test,'ALCons')
                initconds(:,1) = ones(N,1).*nanmean(tempconds(:,1),1);
                initconds(:,3) = ones(N,1).*nanmean(tempconds(:,3),1);
            elseif strcmpi(opts.test,'HLCons')
                initconds(:,2) = ones(N,1).*nanmean(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*nanmean(tempconds(:,3),1);
            elseif strcmpi(opts.test,'AMed')
                initconds(:,1) = ones(N,1).*nanmedian(tempconds(:,1),1);
            elseif strcmpi(opts.test,'HMed')
                initconds(:,2) = ones(N,1).*nanmedian(tempconds(:,2),1);
            elseif strcmpi(opts.test,'LMed')
                initconds(:,3) = ones(N,1).*nanmedian(tempconds(:,3),1);
            elseif strcmpi(opts.test,'AHMed')
                initconds(:,1) = ones(N,1).*nanmedian(tempconds(:,1),1);
                initconds(:,2) = ones(N,1).*nanmedian(tempconds(:,2),1);
            elseif strcmpi(opts.test,'ALMed')
                initconds(:,1) = ones(N,1).*nanmedian(tempconds(:,1),1);
                initconds(:,3) = ones(N,1).*nanmedian(tempconds(:,3),1);
            elseif strcmpi(opts.test,'HLMed')
                initconds(:,2) = ones(N,1).*nanmedian(tempconds(:,2),1);
                initconds(:,3) = ones(N,1).*nanmedian(tempconds(:,3),1);
            end
            clear tempconds;
        end
        initconds(initconds(:,1)<=lb.a,1) = lb.a + eepsilon;
        initconds(:,1) = initconds(:,1) - repmat(alb,N,1);
        initconds(initconds(:,1)>=ub.a,1) = ub.a - eepsilon;
        initconds(:,2) = initconds(:,2) + delt.h;
        initconds(:,3) = initconds(:,3) + delt.l;
        initconds(initconds(:,2)<=lb.h,2) = lb.h + eepsilon;
        initconds(initconds(:,3)<=lb.l,3) = lb.l + eepsilon;
        initconds(initconds(:,2)>=ub.h,2) = ub.h - eepsilon;
        initconds(initconds(:,3)>=ub.l,3) = ub.l - eepsilon;
%initconds = lognrnd(mu,sigma,N)

% State Matrices and Initial States

        EE      = zeros(N,T+1,'gpuArray');                 % Takes value one if the individual is employed at the beginning of the period
        EE(:,1) = 0;                                       % Initial employment status
        UU      = zeros(N,T+1,'gpuArray');                 % Takes value one if the individual is unemployed at the beginning of the period
        UU(:,1) = 1-EE(:,1);                               % Initial unemployment state
        WW      = zeros(N,T+1,'gpuArray');                 % Level of earnings
        WW(:,1) = 0;                                       % Initial earnings
        AA      = zeros(N,T+1,'gpuArray');                 % Asset holdings at the beginning of the period
        AA(:,1) = initconds(:,1);                               % Initial level of assets holdings
        BB      = zeros(N,T+1,'gpuArray');                 % Track unemployment benefit state. Binary
        if strcmpi(opts.simName,'UIExperiment4')
            BB(:,1:2) = 1;                                       % Start with no unemployment insurance
        else
            BB(:,1) = 0;                                       % Start with no unemployment insurance
        end
        CC      = zeros(N,T+1,'gpuArray');
        UB      = zeros(N,T+1,'gpuArray');                 % Track unemployment benefits as a potential calibration target
        UB(:,1) = 0;                                       % Can either assume nb ARE benefits, or that bl means benefits are 0.
        MU      = lb.w*ones(N,T+1,'gpuArray');             % Because unemployment benefits are a function of previous wages, track wage share.
        MU(:,1) = lb.w;                                    % for period 1, if MU = 0, interpolation won't work
        TT      = zeros(N,T+1,'gpuArray');
        TT(:,1) = 0;
        UT      = zeros(N,T+1,'gpuArray');
        UT(:,1) = 0;
        ET      = zeros(N,T+1,'gpuArray');
        ET(:,1) = 0;
        UE      = zeros(N,T+1,'gpuArray');
        UE(:,1) = 0;
        EU      = zeros(N,T+1,'gpuArray');
        EU(:,1) = 0;
        E2E      = zeros(N,T+1,'gpuArray');
        E2E(:,1) = 0;
        WPrime  = zeros(N,T+1,'gpuArray');
        ThetaPrime  = zeros(N,T+1,'gpuArray');
        ZZ      = zeros(N,T+1,'gpuArray');
        HH      = zeros(N,T+1,'gpuArray');
        HH(:,1) = initconds(:,2);
        LL      = initconds(:,3);
        PInitHat = phat;
        
        [bmeshb,~,hmeshb,lmeshb] = ndgrid(bgrid,zeros(Na,1),hgrid,lgrid);
        [wmesh,~,hmesh,lmesh] = ndgrid(wgrid,zeros(Na,1),hgrid,lgrid);
        [~,hmeshu,lmeshu] = ndgrid(zeros(Na,1),hgrid,lgrid);

        bmeshb = gpuArray(bmeshb);
        hmeshb = gpuArray(hmeshb);
        lmeshb = gpuArray(lmeshb);
        
        wmesh = gpuArray(wmesh);
        hmesh = gpuArray(hmesh);
        lmesh = gpuArray(lmesh);

        hmeshu = gpuArray(hmeshu);
        lmeshu = gpuArray(lmeshu);
        
        if strcmpi(opts.test,'UnempScarring')
            rphate = repmat(rphate,2,1);
            rphatu = repmat(rphatu,2,1);
            EpsSHOCK = repmat(EpsSHOCK,2,1);
            LLAMBE = repmat(LLAMBE,2,1);
            LLAMBU = repmat(LLAMBU,2,1);
            GAMU = repmat(GAMU,2,1);
            EE = repmat(EE,2,1);
            UU = repmat(UU,2,1);
            WW = repmat(WW,2,1);
            AA = repmat(AA,2,1);
            BB = repmat(BB,2,1);
            CC = repmat(CC,2,1);
            UB = repmat(UB,2,1);
            MU = repmat(MU,2,1);
            HH = repmat(HH,2,1);
            TT = repmat(TT,2,1);
            UT = repmat(UT,2,1);
            LL = repmat(LL,2,1);
            UE = repmat(UE,2,1);
            EU = repmat(EU,2,1);
            E2E = repmat(E2E,2,1);
            ET = repmat(ET,2,1);
            ZZ = repmat(ZZ,2,1);
            WPrime = repmat(WPrime,2,1);
            ThetaPrime = repmat(ThetaPrime,2,1);
            PInitHat = repmat(PInitHat,2,1);
            cidx = randi(size(DELTA,2),size(DELTA,1),1);
            cidx = sub2ind(size(DELTA), (1:size(DELTA,1))', cidx);
            TreatedInd = zeros(N,T+1);
            TreatedInd(cidx) = 1;
            tempDELTA = DELTA;
            DELTA(TreatedInd==1) = 1;
            tempDELTA(TreatedInd==1) = 0;
            DELTA = cat(1,tempDELTA,DELTA);
            TreatedInd = repmat(TreatedInd,2,1);
            TreatedInd(1:N,:) = 0;
            clear tempDELTA;
        end
        
        
% create meshgrids for interpolation during simulation
    else
        [Epsgrid,~,Zcdf] = CompTrapInt(Epsnodes,MuEps,SigEps,StdEps);
        [RRgrid, ~, RRcdf] = CompTrapInt(RRnodes,MuRR,SigRR,StdRR);
        
        wgrid  = linspace(lb.w,ub.w,Nw);
        hgrid  = linspace(lb.h,ub.h,Nh); 
        lgrid  = linspace(lb.l,ub.l,Nl);
        bgrid  = linspace(lb.b,ub.b,Nb);


        rdelta = rand(N,T+1);                  % Determines if employed worker is exogenously separated from his job
        rllambu = rand(N,T);                  % Determines if unemployed worker can search for a job
        rllambe = rand(N,T);                  % Determines if employed worker can search for a job
        rphatu = rand(N,T);        % Determines if unemployed worker got a job
        rphate = rand(N,T);        % Determines if employed worker got a new job
        rgamu  = rand(N,T);                  % Determines if an unemployed worker loses benefits

        DELTA  = (rdelta<=ddelta);           % Matrix with 1s if separation shocks hits or 0s otherwise
        LLAMBE  = (rllambe<=llambe);            % Binary matrix
        LLAMBU  = (rllambu<=llambu);            % Matrix with 1s if allowed to search if unemployed or 0s otherwise
        GAMU   = (rgamu<=ggamma);            % Binary matrix for benefits shocks
        EpsSHOCK   = normrnd(MuEps,SigEps,[N,T+1]);
        EpsSHOCK(EpsSHOCK>=max(Epsgrid)) = max(Epsgrid);
        EpsSHOCK(EpsSHOCK<=min(Epsgrid)) = min(Epsgrid);
        EpsSHOCK = exp(EpsSHOCK);
        RDRAW   = normrnd(MuRR,SigRR,[N,T+1]);
        RDRAW(RDRAW>=max(RRgrid)) = max(RRgrid);
        RDRAW(RDRAW<=min(RRgrid)) = min(RRgrid);
        clear rdelta rllambu rllambe rgamu rdeltah rbdraw;            % save as much memory as possible
        MuX = [ MuA MuH MuL ];
        SigX = [ SigA SigH SigL ];
        CorrMat = [1 SigAH SigAL ; SigAH 1 SigHL ; SigAL  SigHL 1];

        [initconds,phat] = LNRndCopula(MuX,SigX,CorrMat,N); % Chooses initial distribution
        [tempconds,tempphat] = LNRndCopula(MuX,SigX,CorrMat,200000);
        TreatedInd = zeros(size(initconds,1),1);
        alb = geosum(r,bl,T);
        if opts.II == 'n'
            if strcmpi(opts.test,'AMPIncreaseS')
                MuAC = mean(log(reshape(initconds(:,1),[],1)));
                SigAC = std(log(reshape(initconds(:,1),[],1)));
                initconds(:,1) = MeanPreserveSpread(initconds(:,1),MuA,SigA,SigAC*MPIncreaseSA);
            elseif strcmpi(opts.test,'AMPDecreaseS')
                MuAC = mean(log(reshape(initconds(:,1),[],1)));
                SigAC = std(log(reshape(initconds(:,1),[],1)));
                initconds(:,1) = MeanPreserveSpread(initconds(:,1),MuA,SigA,SigAC*MPDecreaseSA);
            elseif strcmpi(opts.test,'HMPIncreaseS')
                MuHC = mean(log(reshape(initconds(:,2),[],1)));
                SigHC = std(log(reshape(initconds(:,2),[],1)));
                initconds(:,2) = MeanPreserveSpread(initconds(:,2),MuH,SigH,SigHC*MPIncreaseSH);
            elseif strcmpi(opts.test,'HMPDecreaseS')
                MuHC = mean(log(reshape(initconds(:,2),[],1)));
                SigHC = std(log(reshape(initconds(:,2),[],1)));
                initconds(:,2) = MeanPreserveSpread(initconds(:,2),MuH,SigH,SigHC*MPDecreaseSH);
            elseif strcmpi(opts.test,'LMPIncreaseS')
                MuLC = mean(log(reshape(initconds(:,3),[],1)));
                SigLC = std(log(reshape(initconds(:,3),[],1)));
                initconds(:,3) = MeanPreserveSpread(initconds(:,3),MuL,SigL,SigLC*MPIncreaseSL);
            elseif strcmpi(opts.test,'LMPDecreaseS')
                MuLC = mean(log(reshape(initconds(:,3),[],1)));
                SigLC = std(log(reshape(initconds(:,3),[],1)));
                initconds(:,3) = MeanPreserveSpread(initconds(:,3),MuL,SigL,SigLC*MPDecreaseSL);
            elseif strcmpi(opts.test,'DebtRelief')
                [Ind, ~] = find(initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowH')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedH')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighH')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowL')
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedL')
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighL')
                [Ind, ~] = find(initconds(:,3) >= quantile(tempconds(:,3),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtLowHL')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.25) & initconds(:,3) >= quantile(tempconds(:,3),0.25) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtMedHL')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.5) & initconds(:,3) >= quantile(tempconds(:,3),0.5) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'StudentDebtHighHL')
                [Ind, ~] = find(initconds(:,2) >= quantile(tempconds(:,2),0.75) & initconds(:,3) >= quantile(tempconds(:,3),0.75) & initconds(:,1) <= alb);
                initconds(Ind,1) = alb*ones(size(Ind,1),1);
                TreatedInd(Ind) = ones(size(Ind,1),1);
            elseif strcmpi(opts.test,'Aup')
                initconds(:,1) = logninv(normcdf((norminv(logncdf(initconds(:,1),MuA,SigA),MuA,SigA) + SigA),MuA,SigA),MuA,SigA);
            elseif strcmpi(opts.test,'Adown')
                initconds(:,1) = logninv(normcdf((norminv(logncdf(initconds(:,1),MuA,SigA),MuA,SigA) - SigA),MuA,SigA),MuA,SigA);
            elseif strcmpi(opts.test,'Hup')
                initconds(:,2) = logninv(normcdf((norminv(logncdf(initconds(:,2),MuH,SigH),MuH,SigH) + SigH),MuH,SigH),MuH,SigH);
            elseif strcmpi(opts.test,'Hdown')
                initconds(:,2) = logninv(normcdf((norminv(logncdf(initconds(:,2),MuH,SigH),MuH,SigH) - SigH),MuH,SigH),MuH,SigH);
            elseif strcmpi(opts.test,'Lup')
                initconds(:,3) = logninv(normcdf((norminv(logncdf(initconds(:,3),MuL,SigL),MuL,SigL) + SigL),MuL,SigL),MuL,SigL);
            elseif strcmpi(opts.test,'Ldown')
                initconds(:,3) = logninv(normcdf((norminv(logncdf(initconds(:,3),MuL,SigL),MuL,SigL) - SigL),MuL,SigL),MuL,SigL);
            elseif strcmpi(opts.test,'Med')
                initconds(:,1) = ones(N,1).*median(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(initconds(:,3),1);
            elseif strcmpi(opts.test,'AupHVY')
                initconds(:,1) = ones(N,1).*(median(initconds(:,1),1) + std(initconds(:,1),1));
                initconds(:,2) = ones(N,1).*median(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(initconds(:,3),1);
            elseif strcmpi(opts.test,'AdownHVY')
                initconds(:,1) = ones(N,1).*(median(initconds(:,1),1) - std(initconds(:,1),1));
                initconds(:,2) = ones(N,1).*median(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*median(initconds(:,3),1);
            elseif strcmpi(opts.test,'HupHVY')
                initconds(:,1) = ones(N,1).*median(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*(median(initconds(:,2),1) + std(initconds(:,2),1));
                initconds(:,3) = ones(N,1).*median(initconds(:,3),1);
            elseif strcmpi(opts.test,'HdownHVY')
                initconds(:,1) = ones(N,1).*median(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*(median(initconds(:,2),1) - std(initconds(:,2),1));
                initconds(:,3) = ones(N,1).*median(initconds(:,3),1);
            elseif strcmpi(opts.test,'LupHVY')
                initconds(:,1) = ones(N,1).*median(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*(median(initconds(:,3),1) + std(initconds(:,3),1));
            elseif strcmpi(opts.test,'LdownHVY')
                initconds(:,1) = ones(N,1).*median(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*median(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*(median(initconds(:,3),1) - std(initconds(:,3),1));
            elseif strcmpi(opts.test,'Cons')
                initconds(:,1) = ones(N,1).*nanmean(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*nanmean(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*nanmean(initconds(:,3),1);
            elseif strcmpi(opts.test,'ACons')
                initconds(:,1) = ones(N,1).*nanmean(initconds(:,1),1);
            elseif strcmpi(opts.test,'HCons')
                initconds(:,2) = ones(N,1).*nanmean(initconds(:,2),1);
            elseif strcmpi(opts.test,'LCons')
                initconds(:,3) = ones(N,1).*nanmean(initconds(:,3),1);
            elseif strcmpi(opts.test,'AHCons')
                initconds(:,1) = ones(N,1).*nanmean(initconds(:,1),1);
                initconds(:,2) = ones(N,1).*nanmean(initconds(:,2),1);
            elseif strcmpi(opts.test,'ALCons')
                initconds(:,1) = ones(N,1).*nanmean(initconds(:,1),1);
                initconds(:,3) = ones(N,1).*nanmean(initconds(:,3),1);
            elseif strcmpi(opts.test,'HLCons')
                initconds(:,2) = ones(N,1).*nanmean(initconds(:,2),1);
                initconds(:,3) = ones(N,1).*nanmean(initconds(:,3),1);
            end
        end
        clear tempconds;
        initconds(initconds(:,1)<=lb.a,1) = lb.a + eepsilon;
        initconds(initconds(:,1)>=ub.a,1) = ub.a - eepsilon;
        initconds(:,1) = initconds(:,1) - repmat(alb,N,1);
        initconds(:,2) = initconds(:,2) + delt.h;
        initconds(:,3) = initconds(:,3) + delt.l;
        initconds(initconds(:,2)<=lb.h,2) = lb.h + eepsilon;
        initconds(initconds(:,3)<=lb.l,3) = lb.l + eepsilon;
        initconds(initconds(:,2)>=ub.h,2) = ub.h - eepsilon;
        initconds(initconds(:,3)>=ub.l,3) = ub.l - eepsilon;
%initconds = lognrnd(mu,sigma,N)

% State Matrices and Initial States

        EE      = zeros(N,T+1);                 % Takes value one if the individual is employed at the beginning of the period
        EE(:,1) = 0;                                       % Initial employment status
        UU      = zeros(N,T+1);                 % Takes value one if the individual is unemployed at the beginning of the period
        UU(:,1) = 1-EE(:,1);                               % Initial unemployment state
        WW      = zeros(N,T+1);                 % Level of earnings
        WW(:,1) = 0;                                       % Initial earnings
        AA      = zeros(N,T+1);                 % Asset holdings at the beginning of the period
        AA(:,1) = initconds(:,1);                               % Initial level of assets holdings
        BB      = zeros(N,T+1);                 % Track unemployment benefit state. Binary
        BB(:,1) = 0;                                       % Start with no unemployment insurance
        CC      = zeros(N,T+1);
        UB      = zeros(N,T+1);                 % Track unemployment benefits as a potential calibration target
        UB(:,1) = 0;                                       % Can either assume nb ARE benefits, or that bl means benefits are 0.
        MU      = lb.w*ones(N,T+1);             % Because unemployment benefits are a function of previous wages, track wage share.
        MU(:,1) = lb.w;                                    % for period 1, if MU = 0, interpolation won't work
        TT      = zeros(N,T+1);
        TT(:,1) = 0;
        UT      = zeros(N,T+1);
        UT(:,1) = 0;
        ET      = zeros(N,T+1);
        ET(:,1) = 0;
        E2E      = zeros(N,T+1);
        E2E(:,1) = 0;
% $$$         EU      = zeros(N,T+1);
% $$$         EU(:,1) = 0;
% $$$         UE      = zeros(N,T+1);
% $$$         UE(:,1) = 0;
        RR      = zeros(N,T+1);                 % Track unemployment benefits as a potential calibration target
        RR(:,1) = RDRAW(:,1);                                       % Can either assume bl ARE benefits, or that bl means benefits are 0.
        WPrime  = zeros(N,T+1);
        ThetaPrime  = zeros(N,T+1);
        ZZ      = zeros(N,T+1);
        HH      = zeros(N,T+1);
        HH(:,1) = initconds(:,2);
        LL      = initconds(:,3);
        PInitHat = phat;
        
        [bmeshb,~,hmeshb,lmeshb] = ndgrid(bgrid,zeros(Na,1),hgrid,lgrid);
        [wmesh,~,hmesh,lmesh] = ndgrid(wgrid,zeros(Na,1),hgrid,lgrid);
        [~,hmeshu,lmeshu] = ndgrid(zeros(Na,1),hgrid,lgrid);
    end

end