function [rphate,rphatu,DELTA,EpsSHOCK,LLAMBE,GAMU,EE,UU,WW,AA,BB,CC,UB,MU,HH,TT,UT,LL,UE,EU,E2E,ET,WPrime,ThetaPrime,wmesh,hmesh,lmesh,hmeshu,lmeshu,bmeshb,hmeshb,lmeshb] = SimGridsScarring(params,order,opts,seedval,dist_data)
%% SimGrids m-file for Search, Human Capital, and Business Cycles
%
% Authors: Ben Griffy
% Date: May, 2017

    rng(seedval);

%load parameters
[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

%separate into when we are using GPU and when we aren't
    if opts.gpu == 'y'
        [Epsgrid,~,Zcdf] = CompTrapInt(Epsnodes,MuEps,SigEps,StdEps);
        Epsgrid = gpuArray(Epsgrid);
        Zcdf = gpuArray(Zcdf);

        wgrid  = gpuArray(linspace(lb.w,ub.w,Nw));
        hgrid  = gpuArray(linspace(lb.h,ub.h,Nh));
        lgrid  = gpuArray(linspace(lb.l,ub.l,Nl));
        bgrid  = gpuArray(linspace(lb.b,ub.b,Nb));


        rdelta = rand(NScar,TScar+1,(T-TScar)+1);                  % Determines if employed worker is exogenously separated from his job
        rllambe = rand(NScar,TScar+1,(T-TScar)+1);                  % Determines if employed worker can search for a job
        rphatu = rand(NScar,TScar+1,(T-TScar)+1);        % Determines if unemployed worker got a job
        rphatu(:,1,:) = 1;
        rphate = rand(NScar,TScar+1,(T-TScar)+1);        % Determines if employed worker got a new job
        rgamu  = rand(NScar,TScar+1,(T-TScar)+1);                  % Determines if an unemployed worker loses benefits

        DELTA  = (rdelta<=ddelta);
        LLAMBE  = (rllambe<=llambe);            % Binary matrix
        GAMU   = (rgamu<=ggamma);            % Binary matrix for benefits shocks
        EpsSHOCK   = normrnd(MuEps,SigEps,[NScar,TScar+1,(T-TScar)+1]);
        EpsSHOCK   = gpuArray(EpsSHOCK);
        EpsSHOCK(EpsSHOCK>=max(Epsgrid)) = max(Epsgrid);
        EpsSHOCK(EpsSHOCK<=min(Epsgrid)) = min(Epsgrid);
        EpsSHOCK = exp(EpsSHOCK);
        clear rdelta rllambe rgamu rdeltah Epsgrid Zcdf;            % save as much memory as possible


        MuX = [ MuA MuH MuL ];
        SigX = [ SigA SigH SigL ];
        CorrMat = [1 SigAH SigAL ; SigAH 1 SigHL ; SigAL  SigHL 1];

        initconds = zeros(NScar,T-TScar+1,2);
        initconds(:,:,1) = dist_data.AA;
        initconds(:,:,2) = dist_data.HH;
        initcondsLL = dist_data.LL;
        if strcmpi(opts.test,'UnempScarring') | strcmpi(opts.test,'EmpScarring')
            initconds(:,:,1) = nanmedian(dist_data.AA);
            initconds(:,:,2) = nanmedian(dist_data.HH);
            initcondsLL = repmat(nanmedian(dist_data.LL),NScar,1);
        elseif strcmpi(opts.test,'UnempScarringWealth') | strcmpi(opts.test,'EmpScarringWealth')
            initconds(:,:,2) = repmat(nanmean(dist_data.HH),NScar,1);
            initcondsLL = repmat(nanmean(dist_data.LL),NScar,1);
            cidx = randi(size(dist_data.AA,1),size(dist_data.AA,2),NScar).';
            cidx = sub2ind(size(dist_data.AA), cidx(:), reshape(repmat(1:size(dist_data.AA,2),NScar,1),[],1));
            initconds(:,:,1) = reshape(dist_data.AA(cidx),NScar,T-TScar+1);
            tempHH = reshape(dist_data.HH(cidx),NScar,T-TScar+1);
            tempLL = reshape(dist_data.LL(cidx(1:NScar)),NScar,1);
            for i = 1:(T-TScar+1)
                [Ind, ~] = find(initconds(:,i,1) <= quantile(initconds(:,i,1),0.20));
                tempInd = Ind(randperm(length(Ind)));
                initconds(Ind,i,2) = tempHH(tempInd,i);
                [Ind, ~] = find((initconds(:,i,1) > quantile(initconds(:,i,1),0.20)) & (initconds(:,i,1) <= quantile(initconds(:,i,1),0.40)));
                tempInd = Ind(randperm(length(Ind)));
                initconds(Ind,i,2) = tempHH(tempInd,i);
                [Ind, ~] = find((initconds(:,i,1) > quantile(initconds(:,i,1),0.40)) & (initconds(:,i,1) <= quantile(initconds(:,i,1),0.60)));
                tempInd = Ind(randperm(length(Ind)));
                initconds(Ind,i,2) = tempHH(tempInd,i);
                [Ind, ~] = find((initconds(:,i,1) > quantile(initconds(:,i,1),0.60)) & (initconds(:,i,1) <= quantile(initconds(:,i,1),0.80)));
                tempInd = Ind(randperm(length(Ind)));
                initconds(Ind,i,2) = tempHH(tempInd,i);
                [Ind, ~] = find(initconds(:,i,1) > quantile(initconds(:,i,1),0.80));
                tempInd = Ind(randperm(length(Ind)));
                initconds(Ind,i,2) = tempHH(tempInd,i);
            end

            [Ind, ~] = find(initconds(:,:,1) <= quantile(initconds(:,:,1),0.20));
            Ind = Ind(1:NScar);
            tempInd = Ind(randperm(length(Ind)));
            initcondsLL(Ind) = tempLL(tempInd);
            [Ind, ~] = find((initconds(:,:,1) > quantile(initconds(:,:,1),0.20)) & (initconds(:,:,1) <= quantile(initconds(:,:,1),0.40)));
            Ind = Ind(1:NScar);
            tempInd = Ind(randperm(length(Ind)));
            initcondsLL(Ind) = tempLL(Ind(1:NScar));
            [Ind, ~] = find((initconds(:,:,1) > quantile(initconds(:,:,1),0.40)) & (initconds(:,:,1) <= quantile(initconds(:,:,1),0.60)));
            Ind = Ind(1:NScar);
            tempInd = Ind(randperm(length(Ind)));
            initcondsLL(Ind) = tempLL(Ind(1:NScar));
            [Ind, ~] = find((initconds(:,:,1) > quantile(initconds(:,:,1),0.60)) & (initconds(:,:,1) <= quantile(initconds(:,:,1),0.80)));
            Ind = Ind(1:NScar);
            tempInd = Ind(randperm(length(Ind)));
            initcondsLL(Ind) = tempLL(Ind(1:NScar));
            [Ind, ~] = find(initconds(:,:,1) > quantile(initconds(:,:,1),0.80));
            Ind = Ind(1:NScar);
            tempInd = Ind(randperm(length(Ind)));
            initcondsLL(Ind) = tempLL(Ind(1:NScar));

            clear cidx;
        elseif strcmpi(opts.test,'UnempScarringHumanCap') | strcmpi(opts.test,'EmpScarringHumanCap')
            initconds(:,:,1) = nanmedian(dist_data.AA);
            initcondsLL = repmat(nanmedian(dist_data.LL),NScar,1);
            cidx = randi(size(dist_data.HH,1),size(dist_data.HH,2),NScar).';
            cidx = sub2ind(size(dist_data.HH), cidx(:), reshape(repmat(1:size(dist_data.HH,2),NScar,1),[],1));
            initconds(:,:,1) = reshape(dist_data.HH(cidx),NScar,T-TScar);
            clear cidx;
        elseif strcmpi(opts.test,'UnempScarringLearn') | strcmpi(opts.test,'EmpScarringLearn')
            initconds(:,:,1) = nanmedian(dist_data.AA);
            initconds(:,:,2) = nanmedian(dist_data.HH);
            cidx = randi(size(dist_data.LL,1),size(dist_data.LL,2),NScar).';
            cidx = sub2ind(size(dist_data.LL), cidx(:), reshape(repmat(1:size(dist_data.LL,2),NScar,1),[],1));
            initcondsLL = dist_data.LL(cidx);
            clear cidx;
        end
        initconds = gpuArray(initconds);



        MU      = lb.w*ones(NScar,TScar+1,(T-TScar)+1,'gpuArray');             % Because unemployment benefits are a function of previous wages, track wage share.
        MU(:,1,:) = repmat(nanmedian(dist_data.MU),NScar,1);
        MU(MU<=lb.w) = lb.w + eepsilon;
        MU(MU>=ub.w) = ub.w - eepsilon;
        clear dist_data;
% State Matrices and Initial States
        AA      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Asset holdings at the beginning of the period
        AA(:,1,:) = initconds(:,:,1);
        HH      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        HH(:,1,:)  = initconds(:,:,2);
        LL     = zeros(NScar,1,'gpuArray');
        LL = initcondsLL;
        clear initconds initcondsLL;
        % AA(AA<=-alb) = -alb + eepsilon;
        % AA(AA>=ub.a) = ub.a - eepsilon;


        EE      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Takes value one if the individual is employed at the beginning of the period
        EE(:,1,:) = 1;
        UU      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Takes value one if the individual is unemployed at the beginning of the period
        UU(:,1,:) = 0;
        BB      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Track unemployment benefit state. Binary
        BB(:,1,:) = 1;
        CC      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        TT      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        TT(:,1,2:end) = TT(:,1,2:end);
        UT      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        ET      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        UE      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        EU      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        E2E      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        WPrime  = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        ThetaPrime  = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');
        WW      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Level of earnings
        WW(:,1,2:end) = EE(:,1,2:end).*MU(:,1,2:end).*HH(:,1,1:end-1);
        UB      = zeros(NScar,TScar+1,(T-TScar)+1,'gpuArray');                 % Track unemployment benefits as a potential calibration target

        [bmeshb,~,hmeshb,lmeshb] = ndgrid(bgrid,zeros(Na,1),hgrid,lgrid);
        [wmesh,~,hmesh,lmesh] = ndgrid(wgrid,zeros(Na,1),hgrid,lgrid);
        [~,hmeshu,lmeshu] = ndgrid(zeros(Na,1),hgrid,lgrid);

        bmeshb = gpuArray(bmeshb);
        hmeshb = gpuArray(hmeshb);
        lmeshb = gpuArray(lmeshb);

        wmesh = gpuArray(wmesh);
        hmesh = gpuArray(hmesh);
        lmesh = gpuArray(lmesh);

        hmeshu = gpuArray(hmeshu);
        lmeshu = gpuArray(lmeshu);

        if strcmpi(opts.test,'UnempScarring') | strcmpi(opts.test,'UnempScarringWealth') | strcmpi(opts.test,'UnempScarringHumanCap') | strcmpi(opts.test,'UnempScarringLearn')
            rphate = repmat(rphate,2,1,1);
            rphatu = repmat(rphatu,2,1,1);
            EpsSHOCK = repmat(EpsSHOCK,2,1,1);
            LLAMBE = repmat(LLAMBE,2,1,1);
            GAMU = repmat(GAMU,2,1,1);
            EE = repmat(EE,2,1,1);
            UU = repmat(UU,2,1,1);
            WW = repmat(WW,2,1,1);
            AA = repmat(AA,2,1,1);
            BB = repmat(BB,2,1,1);
            CC = repmat(CC,2,1,1);
            UB = repmat(UB,2,1,1);
            MU = repmat(MU,2,1,1);
            HH = repmat(HH,2,1,1);
            TT = repmat(TT,2,1,1);
            UT = repmat(UT,2,1,1);
            LL = repmat(LL,2,1,1);
            UE = repmat(UE,2,1,1);
            EU = repmat(EU,2,1,1);
            E2E = repmat(E2E,2,1,1);
            ET = repmat(ET,2,1,1);
            WPrime = repmat(WPrime,2,1,1);
            ThetaPrime = repmat(ThetaPrime,2,1,1);
            DELTA = repmat(DELTA,2,1,1);
            DELTA(1:NScar,1:end,:) = 0;
            DELTA(NScar+1:end,1,:) = 1;
            DELTA(NScar+1:end,2:end,:) = 0;
        end

        if strcmpi(opts.test,'EmpScarring') | strcmpi(opts.test,'EmpScarringWealth') | strcmpi(opts.test,'EmpScarringHumanCap') | strcmpi(opts.test,'EmpScarringLearn')
            rphate = repmat(rphate,2,1,1);
            rphatu = repmat(rphatu,2,1,1);
            EpsSHOCK = repmat(EpsSHOCK,2,1,1);
            LLAMBE = repmat(LLAMBE,2,1,1);
            LLAMBU = repmat(LLAMBU,2,1,1);
            GAMU = repmat(GAMU,2,1,1);
            EE = repmat(EE,2,1,1);
            UU = repmat(UU,2,1,1);
            WW = repmat(WW,2,1,1);
            AA = repmat(AA,2,1,1);
            BB = repmat(BB,2,1,1);
            CC = repmat(CC,2,1,1);
            UB = repmat(UB,2,1,1);
            MU = repmat(MU,2,1,1);
            HH = repmat(HH,2,1,1);
            TT = repmat(TT,2,1,1);
            UT = repmat(UT,2,1,1);
            LL = repmat(LL,2,1,1);
            UE = repmat(UE,2,1,1);
            EU = repmat(EU,2,1,1);
            E2E = repmat(E2E,2,1,1);
            ET = repmat(ET,2,1,1);
            % ZZ = repmat(ZZ,2,1,1);
            WPrime = repmat(WPrime,2,1,1);
            ThetaPrime = repmat(ThetaPrime,2,1,1);
        end

% create meshgrids for interpolation during simulation
    else

        rdelta = rand(NScar,TScar+1,(T-TScar) + 1);                  % Determines if employed worker is exogenously separated from his job
        rzshock= rand(NScar,TScar+1,(T-TScar) + 1);
        rllambu = rand(NScar,(T-TScar) + 1,T);                  % Determines if unemployed worker can search for a job
        rllambe = rand(NScar,(T-TScar) + 1,T);                  % Determines if employed worker can search for a job
        rphatu = rand(NScar,(T-TScar) + 1,T);        % Determines if unemployed worker got a job
        rphate = rand(NScar,(T-TScar) + 1,T);        % Determines if employed worker got a new job
        rgamu  = rand(NScar,(T-TScar) + 1,T);                  % Determines if an unemployed worker loses benefits

        DELTA  = (rdelta<=ddelta);           % Matrix with 1s if separation shocks hits or 0s otherwise
        LLAMBE  = (rllambe<=llambe);            % Binary matrix
        LLAMBU  = (rllambu<=llambu);            % Matrix with 1s if allowed to search if unemployed or 0s otherwise
        GAMU   = (rgamu<=ggamma);            % Binary matrix for benefits shocks
        EpsSHOCK   = exp(normrnd(MuEps,SigEps,[NScar,TScar+1,(T-TScar) + 1]));
% $$$         EpsSHOCK = exp(Epsgrid(rEpsshock));
        clear rdelta rllambu rllambe rgamu rdeltah rbdraw;            % save as much memory as possible

        if strcmpi(opts.agg_shocks,'tauchen')
            [Zgrid, ZPDF] = tauchen2(Nz,MuZ,rhoZ,SigZ,StdZ);
        elseif strcmpi(opts.agg_shocks,'rouwenhorst')
            [Zgrid, ZPDF] = rouwenhorst(Nz,MuZ,rhoZ,SigZ);
        end

        ZZ      = zeros((T-TScar) + 1,1);
        ZZErr   = normrnd(MuZ,SigZ,(T-TScar) + 1);
        for it = 2:(T-TScar) + 1
            ZZ(it) = rhoZ*ZZ(it-1) + ZZErr(it);
        end
        ZZ(ZZ<=Zgrid(1)) = Zgrid(1);
        ZZ(ZZ>=Zgrid(end)) = Zgrid(end);
        MuX = [ MuA MuH MuL ];
        SigX = [ SigA SigH SigL ];
        CorrMat = [1 SigAH SigAL ; SigAH 1 SigHL ; SigAL  SigHL 1];

        initconds = reshape(LNRndCopula(MuX,SigX,CorrMat,N*TScar),NScar,(T-TScar) + 1,3); % Chooses initial distribution
        initconds(initconds(:,:,1)<=lb.a,1) = lb.a + eepsilon;
        initconds(initconds(:,:,2)<=lb.h,2) = lb.h + eepsilon;
        initconds(initconds(:,:,3)<=lb.l,3) = lb.l + eepsilon;
        initconds(initconds(:,:,1)>=ub.a,1) = ub.a - eepsilon;
        initconds(initconds(:,:,2)>=ub.h,2) = ub.h - eepsilon;
        initconds(initconds(:,:,3)>=ub.l,3) = ub.l - eepsilon;
%initconds = lognrnd(mu,sigma,N)

% State Matrices and Initial States

        EE      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Takes value one if the individual is employed at the beginning of the period
        EE(:,:,1) = 0;                                       % Initial employment status
        UU      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Takes value one if the individual is unemployed at the beginning of the period
        UU(:,:,1) = 1-EE(:,:,1);                               % Initial unemployment state
        WW      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Level of earnings
        WW(:,:,1) = 0;                                       % Initial earnings
        AA      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Asset holdings at the beginning of the period
        AA(:,:,1) = initconds(:,:,1);                               % Initial level of assets holdings
        BB      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Track unemployment benefit state. Binary
        BB(:,:,1) = 0;                                       % Start with no unemployment insurance
        CC      = zeros(NScar,TScar+1,(T-TScar) + 1);
        UB      = zeros(NScar,TScar+1,(T-TScar) + 1);                 % Track unemployment benefits as a potential calibration target
        UB(:,:,1) = 0;                                       % Can either assume bl ARE benefits, or that bl means benefits are 0.
        MU      = lb.w*ones(NScar,TScar+1,(T-TScar) + 1);             % Because unemployment benefits are a function of previous wages, track wage share.
        MU(:,:,1) = lb.w;                                    % for period 1, if MU = 0, interpolation won't work
        TT      = zeros(NScar,TScar+1,(T-TScar) + 1);
        TT(:,:,1) = 0;
        UT      = zeros(NScar,TScar+1,(T-TScar) + 1);
        UT(:,:,1) = 0;
        ET      = zeros(NScar,TScar+1,(T-TScar) + 1);
        ET(:,:,1) = 0;
        E2E      = zeros(NScar,TScar+1,(T-TScar) + 1);
        E2E(:,:,1) = 0;
        WPrime  = zeros(NScar,TScar+1,(T-TScar) + 1);
        ThetaPrime  = zeros(NScar,TScar+1,(T-TScar) + 1);
        ZZ      = zeros(NScar,TScar+1,(T-TScar) + 1);
        HH      = zeros(NScar,TScar+1,(T-TScar) + 1);
        BH      = zeros(NScar,TScar+1,(T-TScar) + 1);
        HH(:,:,1) = initconds(:,:,2);
        BH(:,:,1) = initconds(:,:,2);
        LL      = zeros(NScar,TScar+1,(T-TScar) + 1);
        LL(:,:,1)      = initconds(:,:,3);

        wgrid  = linspace(lb.w,ub.w,Nw);
        hgrid  = linspace(lb.h,ub.h,Nh);
        lgrid  = linspace(lb.l,ub.l,Nl);
        bgrid  = linspace(lb.b,ub.b,Nb);


        [bmeshb,~,hmeshb,lmeshb] = ndgrid(bgrid,zeros(Na,1),hgrid,lgrid);
        [wmesh,~,hmesh,lmesh] = ndgrid(wgrid,zeros(Na,1),hgrid,lgrid);
        [~,hmeshu,lmeshu] = ndgrid(zeros(Na,1),hgrid,lgrid);
    end

end
