function [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles] = SimulationBaseDecomp(params,order,opts,seedval)
%% Simulation

    if opts.gpu == 'y'
        reset(gpuDevice())
    end
    
    [r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    [rphate,rphatu,DELTA,EpsSHOCK,LLAMBE,LLAMBU,GAMU,EE,UU,WW,AA,BB,CC,UB,MU,HH,TT,UT,LL,UE,EU,E2E,ET,ZZ,WPrime,ThetaPrime,TreatedInd,PInitHat,initQtiles,wmesh,hmesh,lmesh,hmeshu,lmeshu,bmeshb,hmeshb,lmeshb] = SimGrids(params,order,opts,seedval);

    rng(seedval);

    for t = 2:T+1
        it = t-1;
        albt = geosum(r,bl,(T-t+1));
        alb = geosum(r,bl,(T-t+2));
        matfile = fullfile(pwd,'/output/', sprintf('Result%d.mat',t-1));
        load(matfile);
        [amesh,ameshu,ameshb] = UpdateSimGrids(it, params, order, opts);
        BB(:,t)                    = UU(:,t-1).*(1 - GAMU(:,t-1)).*BB(:,t-1) + DELTA(:,t-1).*EE(:,t-1);
        UB(:,t)                    = min(DELTA(:,t-1).*EE(:,t-1).*max((1 - TT(:,t-1)).*WW(:,t-1).*b,bl+eepsilon) + (1 - EE(:,t-1)).*BB(:,t).*UB(:,t-1),MaxUI);
        UB(UB(:,t)>=ub.b,t)        = ub.b - eepsilon;
        UB(UB(:,t)<=lb.b,t)        = lb.b + eepsilon;
        
        
        % Job Finding Matrices
        
        wprimeex                     = interpn(wmesh,amesh,hmesh,lmesh,wprimee1,MU(:,t-1),AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        clear MUtemp;
        wprimeex(isnan(wprimeex))      = lb.w;
        wprimeex(wprimeex>=ub.w)       = ub.w; wprimeex(wprimeex<=lb.w) = lb.w;
        wprimeuxb                    = interpn(bmeshb,ameshb,hmeshb,lmeshb,wprimeu1b,UB(:,t-1),AA(:,t-1),HH(:,t-1),LL,'linear'); 
        clear UBtemp;
        wprimeuxb(isnan(wprimeuxb))    = lb.w;
        wprimeuxb(wprimeuxb>=ub.w)     = ub.w; wprimeuxb(wprimeuxb<=lb.w) = lb.w;        
        wprimeuxbl                   = interpn(ameshu,hmeshu,lmeshu,wprimeu1bl,AA(:,t-1),HH(:,t-1),LL,'linear');
        clear AAtemp;
        wprimeuxbl(wprimeuxbl>=ub.w)   = ub.w; wprimeuxbl(wprimeuxbl<=lb.w) = lb.w;
        wprimeuxbl(isnan(wprimeuxbl))  = lb.w;
        
        
        
        thetaprimeubl                = interpn(wmesh,amesh,hmesh,lmesh,Theta,wprimeuxbl,AA(:,t-1),HH(:,t-1),LL,'linear');
        thetaprimeub                 = interpn(wmesh,amesh,hmesh,lmesh,Theta,wprimeuxb,AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        thetaprimee                  = interpn(wmesh,amesh,hmesh,lmesh,Theta,wprimeex,AA(:,t-1),HH(:,t-1),LL,'linear');

        thetaprimee(thetaprimee<0)     = 0;                                     % Make thetaprimee>=0
        phate                      = p(thetaprimee);                          % Job-finding probability for employed workers
        newjobshock                = (rphate(:,t-1)<=phate).*LLAMBE(:,t-1);  % Takes value one if last period the employed worker was allowed to search and found a job
        enewjob                    = (1 - DELTA(:,t-1)).*EE(:,t-1).*newjobshock;                % Takes value one if the worker was employed last period and got a new job
        thetaprimeub(thetaprimeub<0)   = 0;       
        thetaprimeubl(thetaprimeubl<0) = 0;    % Make thetaprimeu>=0
        phatub                     = p(thetaprimeub);                         % Job-finding probability for each potentially unemployed worker
        phatubl                    = p(thetaprimeubl);                         % Job-finding probability for each potentially unemployed worker
        gotjobshock                = BB(:,t).*(rphatu(:,t-1)<=phatub).*LLAMBU(:,t-1) + (1 - BB(:,t)).*(rphatu(:,t-1)<=phatubl).*LLAMBU(:,t-1); % Takes value one if last period the unemployed worker was allowed to search and found a job
        ugotjob                    = UU(:,t-1).*gotjobshock + DELTA(:,t-1).*EE(:,t-1).*gotjobshock;               % Takes value one if the worker was unemployed last period and got a job
        
        clear gotjobshock newjobshock;
        
        UT(:,t)                    = (1 - EE(:,t-1)).*UT(:,t-1) + UU(:,t-1) + DELTA(:,t-1).*EE(:,t-1);
        EU(:,t)                    = DELTA(:,t-1).*EE(:,t-1);
        UE(:,t)                    = (1 - EE(:,t-1) + DELTA(:,t-1).*EE(:,t-1)).*ugotjob;
        E2E(:,t)                   = (1 - DELTA(:,t-1)).*EE(:,t-1).*enewjob;
        ET(:,t)                    = (1 - DELTA(:,t-1)).*EE(:,t-1).*(1 - enewjob).*(1 + ET(:,t-1)) + (1 - EE(:,t-1)).*ugotjob;
        EE(:,t)                    = (1-DELTA(:,t-1)).*EE(:,t-1) + ugotjob;
        MU(:,t)                    = EE(:,t).*((1-enewjob-ugotjob).*MU(:,t-1) + enewjob.*wprimeex + BB(:,t).*ugotjob.*wprimeuxb + (1 - BB(:,t)).*ugotjob.*wprimeuxbl);
        MU(MU(:,t)>=ub.w,t)        = ub.w - eepsilon;
        MU(MU(:,t)<=lb.w,t)        = lb.w + eepsilon;
        UU(:,t)                    = 1-EE(:,t);
        WPrime(:,t)                = (EE(:,t-1) - DELTA(:,t-1).*EE(:,t-1)).*wprimeex + (UU(:,t-1).*BB(:,t) + DELTA(:,t-1).*EE(:,t-1)).*wprimeuxb + UU(:,t-1).*(1 - BB(:,t)).*wprimeuxbl;
        ThetaPrime(:,t)            = (EE(:,t-1) - DELTA(:,t-1).*EE(:,t-1)).*thetaprimee + (UU(:,t-1).*BB(:,t) + DELTA(:,t-1).*EE(:,t-1)).*thetaprimeub + UU(:,t-1).*(1 - BB(:,t)).*thetaprimeubl;
        WW(:,t)                    = (EE(:,t).*((1-enewjob-ugotjob).*MU(:,t-1) + enewjob.*wprimeex + BB(:,t).*ugotjob.*wprimeuxb + (1 - BB(:,t)).*ugotjob.*wprimeuxbl)).*phi(HH(:,t-1),t);
        
        clear thetaprimeubl thetaprimee thetaprimeub phate phatub phatubl wprimeex wprimeuxb wprimeuxbl enewjob ugotjob;
        

        aprimeuxbl                   = interpn(ameshu,hmeshu,lmeshu,aprimeu1bl,AA(:,t-1),HH(:,t-1),LL,'linear');
        aprimeuxbl(isnan(aprimeuxbl))  = AA(isnan(aprimeuxbl),t-1);
        aprimeuxbl(aprimeuxbl>=ub.a)   = ub.a; aprimeuxbl(aprimeuxbl<=-albt) = -albt;
        aprimeex                     = interpn(wmesh,amesh,hmesh,lmesh,aprimee1,MU(:,t),AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        aprimeex(isnan(aprimeex))      = AA(isnan(aprimeex),t-1);
        aprimeex(aprimeex>=ub.a)       = ub.a; aprimeex(aprimeex<=-albt) = -albt;
        aprimeuxb                    = interpn(bmeshb,ameshb,hmeshb,lmeshb,aprimeu1b,UB(:,t),AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        aprimeuxb(isnan(aprimeuxb))    = AA(isnan(aprimeuxb),t-1);
        aprimeuxb(aprimeuxb>=ub.a)     = ub.a; aprimeuxb(aprimeuxb<=-albt) = -albt;


        if strcmpi(opts.test,'BaseDecomp1')
            AAtemp = repmat(nanmean(AA(:,t-1)),N,1);
        else
            AAtemp = AA(:,t-1);
        end

        
        thatex                     = interpn(wmesh,amesh,hmesh,lmesh,thate1,MU(:,t),AAtemp,HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        thatex(isnan(thatex))      = 0;
        thatex(thatex>=ub.t)       = ub.t; thatex(thatex<=lb.t) = lb.t;
        hhatex                     = interpn(wmesh,amesh,hmesh,lmesh,hhate1,MU(:,t),AAtemp,HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        hhatex(isnan(hhatex))      = HH(isnan(hhatex),t-1);
        hhatex(hhatex>=ub.h)       = ub.h; hhatex(hhatex<=lb.h) = lb.h;
        clear MUtemp AAtemp;        
        
        
        AA(:,t)                    = EE(:,t).*aprimeex + BB(:,t).*UU(:,t).*aprimeuxb + (1 - BB(:,t)).*UU(:,t).*aprimeuxbl;               % Employed workers save according to aprimeex and unemployed workers save according to aprimeux
        AA(AA(:,t)<=-albt,t)       = -albt + eepsilon;
        AA(AA(:,t)>=ub.a,t)        = ub.a - eepsilon;
        
% Update State Variables
        TT(:,t)                    = EE(:,t).*thatex;
        CC(:,t)                    = EE(:,t).*(1 - TT(:,t)).*WW(:,t) + (1 - EE(:,t)).*(BB(:,t).*UB(:,t) + (1 - BB(:,t)).*(bl+eepsilon)) + (1 + r).*AA(:,t-1) - AA(:,t);
        CC(CC(:,t)<=0,t)           = eepsilon;
        CC(CC(:,t)>=ub.a,t)        = ub.a - eepsilon;
        ZZ(:,t)                    = EpsSHOCK(:,t);
        HH(:,t)                    = EE(:,t).*(EpsSHOCK(:,t).*hhatex) + (1 - EE(:,t)).*(EpsSHOCK(:,t).*HH(:,t-1));
        HH(HH(:,t)>=ub.h,t)        = ub.h - eepsilon;
        HH(HH(:,t)<=lb.h,t)        = lb.h  + eepsilon;
        
        clear hhatex thatex aprimeex aprimeuxbl aprimeuxb;
        
    end % end for t
        
end
