function [DD, EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime, ThetaPrimeHat] = SimulationLBDEmpRisk(params,order,opts,seedval,dist_data)
%% Simulation

    if opts.gpu == 'y'
        reset(gpuDevice())
    end
    
    [r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    [rphate,rphatu,DELTA,EpsSHOCK,LLAMBE,GAMU,DD,EE,UU,WW,AA,BB,CC,UB,UBHat,MU,HH,TT,UT,LL,UE,EU,E2E,ET,WPrime,ThetaPrime,ThetaPrimeHat,dmesh,wmesh,hmesh,lmesh,dmeshu,hmeshu,lmeshu,dmeshb,bmeshb,hmeshb,lmeshb] = SimGridsEmpRisk(params,order,opts,seedval,dist_data);

        % for t = (c+1):(TScar+1)
            
matfile = fullfile(pwd,'ProfilesCalc_Standard.mat');
load(matfile);

AveTau = nanmean(squeeze(modelProfilesFinal(1,find(strcmp(statNames, 'LearnTimeEmp')),:)));
if strcmpi(opts.Basetest,'LBDDecompLearnDiffs')
    HHat = squeeze(max(min(interp1(ttgrid,permute(xxigrid,[3,1,2]),AveTau,'linear'),ub.h),lb.h));
else
    HumanCapProfile = squeeze(modelProfilesFinal(1,find(strcmp(statNames, 'LHumanCap')),:));
    DeltHC = (1 + nanmean(HumanCapProfile(2:end) - HumanCapProfile(1:end-1))).^(1/4);
    HHat = DeltHC.*hgrid;
end

    
    rng(seedval);
    for c = 1:(T-TScar+1)
        fprintf('Cohort %1.0f\n',c)
        for t = 2:(TScar+1)
            aget = t + c;
            iaget = t + c - 1;
            it = t-1;
            albt = geosum(r,bl,(T-aget+1));
            alb = geosum(r,bl,(T-aget+2));
            matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',iaget));
            load(matfile);
            [amesh,ameshu,ameshb] = UpdateSimGridsEmpRisk(it, params, order, opts);
            
            BB(:,t,c)                    = UU(:,it,c).*(1 - GAMU(:,it,c)).*BB(:,it,c) + DELTA(:,it,c).*EE(:,it,c);
            UB(:,t,c)                    = min(DELTA(:,it,c).*EE(:,it,c).*max((1 - AveTau).*MU(:,it,c).*b.*phi(HH(:,it,c),iaget),bl+eepsilon) + (1 - EE(:,it,c)).*BB(:,t,c).*UB(:,it,c),MaxUI);
            UB(UB(:,t,c)>=ub.b,t,c)        = ub.b - eepsilon;
            UB(UB(:,t,c)<=lb.b,t,c)        = lb.b + eepsilon;

            UBHat(:,t,c)                    = min(max((1 - TT(:,it,c)).*MU(:,it,c).*b.*phi(HH(:,it,c),iaget),bl+eepsilon),MaxUI);
            UBHat(UBHat(:,t,c)>=ub.b,t,c)        = ub.b - eepsilon;
            UBHat(UBHat(:,t,c)<=lb.b,t,c)        = lb.b + eepsilon;


            % Job Finding Matrces
            % wprimeu1bl                   = squeeze(interp1(Zgrid,wprimeu1bl,squeeze(DD(:,c)),'linear'));
            wprimeuxbl                   = interpn(dmeshu,ameshu,hmeshu,lmeshu,wprimeu1bl,squeeze(DD(:,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');
            wprimeuxbl(wprimeuxbl>=ub.w)   = ub.w; wprimeuxbl(wprimeuxbl<=lb.w) = lb.w;
            wprimeuxbl(isnan(wprimeuxbl))  = lb.w;
            % wprimee1                   = squeeze(interp1(Zgrid,wprimee1,squeeze(DD(:,c))));
            wprimeex                     = interpn(dmesh,wmesh,amesh,hmesh,lmesh,wprimee1,squeeze(DD(:,c)),squeeze(MU(:,it,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            wprimeex(isnan(wprimeex))      = lb.w;
            wprimeex(wprimeex>=ub.w)       = ub.w; wprimeex(wprimeex<=lb.w) = lb.w;
            % wprimeu1b                    = squeeze(interp1(Zgrid,wprimeu1b,squeeze(DD(:,c))));
            wprimeuxb                    = interpn(dmeshb,bmeshb,ameshb,hmeshb,lmeshb,wprimeu1b,squeeze(DD(:,c)),squeeze(UB(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear'); 
            wprimeuxb(isnan(wprimeuxb))    = lb.w;
            wprimeuxb(wprimeuxb>=ub.w)     = ub.w; wprimeuxb(wprimeuxb<=lb.w) = lb.w;

            wprimeuxbHat                    = interpn(dmeshb,bmeshb,ameshb,hmeshb,lmeshb,wprimeu1b,squeeze(DD(:,c)),squeeze(UBHat(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear'); 
            wprimeuxbHat(isnan(wprimeuxbHat))    = lb.w;
            wprimeuxbHat(wprimeuxbHat>=ub.w)     = ub.w; wprimeuxbHat(wprimeuxbHat<=lb.w) = lb.w;

            
            % Theta                   = squeeze(interp1(Zgrid,Theta,squeeze(DD(:,c)),'linear'));
            thetaprimeubl                = interpn(dmesh,wmesh,amesh,hmesh,lmesh,Theta,squeeze(DD(:,c)),wprimeuxbl,squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');
            thetaprimeub                 = interpn(dmesh,wmesh,amesh,hmesh,lmesh,Theta,squeeze(DD(:,c)),wprimeuxb,squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            thetaprimee                  = interpn(dmesh,wmesh,amesh,hmesh,lmesh,Theta,squeeze(DD(:,c)),wprimeex,squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');
            thetaprimeubHat              = interpn(dmesh,wmesh,amesh,hmesh,lmesh,Theta,squeeze(DD(:,c)),wprimeuxbHat,squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            clear wprimeuxbHat;


            thetaprimee(thetaprimee<0)     = 0;                                     % Make thetaprimee>=0
            phate                      = p(thetaprimee);                          % Job-finding probability for employed workers
            newjobshock                = (rphate(:,it,c)<=phate).*LLAMBE(:,it,c);  % Takes value one if last period the employed worker was allowed to search and found a job
            clear phate;
            enewjob                    = (1 - DELTA(:,it,c)).*EE(:,it,c).*newjobshock;                % Takes value one if the worker was employed last period and got a new job
            thetaprimeub(thetaprimeub<0)   = 0;       
            thetaprimeubl(thetaprimeubl<0) = 0;    % Make thetaprimeu>=0
            phatub                     = p(thetaprimeub);                         % Job-finding probability for each potentially unemployed worker
            phatubl                    = p(thetaprimeubl);                         % Job-finding probability for each potentially unemployed worker
            gotjobshock                = BB(:,t,c).*(rphatu(:,it,c)<=phatub) + (1 - BB(:,t,c)).*(rphatu(:,it,c)<=phatubl); % Takes value one if last period the unemployed worker was allowed to search and found a job
            clear phatub phatubl;
            ugotjob                    = UU(:,it,c).*gotjobshock + DELTA(:,it,c).*EE(:,it,c).*gotjobshock;               % Takes value one if the worker was unemployed last period and got a job
            
            clear gotjobshock newjobshock;
            

            EE(:,t,c)                    = (1-DELTA(:,it,c)).*EE(:,it,c) + ugotjob;
            MU(:,t,c)                    = EE(:,t,c).*((1-enewjob-ugotjob).*MU(:,it,c) + enewjob.*wprimeex + BB(:,t,c).*ugotjob.*wprimeuxb + (1 - BB(:,t,c)).*ugotjob.*wprimeuxbl);            
            MU(MU(:,t,c)>=ub.w,t,c)        = ub.w - eepsilon;
            MU(MU(:,t,c)<=lb.w,t,c)        = lb.w + eepsilon;
            UU(:,t,c)                    = 1-EE(:,t,c);
            WPrime(:,t,c)               = (EE(:,it,c) - DELTA(:,it,c).*EE(:,it,c)).*wprimeex + (UU(:,it,c).*BB(:,t,c) + DELTA(:,it,c).*EE(:,it,c)).*wprimeuxb + UU(:,it,c).*(1 - BB(:,t,c)).*wprimeuxbl;
            ThetaPrime(:,t,c)            = (EE(:,it,c) - DELTA(:,it,c).*EE(:,it,c)).*thetaprimee + (UU(:,it,c).*BB(:,t,c) + DELTA(:,it,c).*EE(:,it,c)).*thetaprimeub + UU(:,it,c).*(1 - BB(:,t,c)).*thetaprimeubl;
            ThetaPrimeHat(:,t,c)            = thetaprimeubHat;
            WW(:,t,c)                    = (EE(:,t,c).*((1-enewjob-ugotjob).*MU(:,it,c) + enewjob.*wprimeex + BB(:,t,c).*ugotjob.*wprimeuxb + (1 - BB(:,t,c)).*ugotjob.*wprimeuxbl)).*phi(HH(:,it,c),iaget);
            
            clear thetaprimeubl thetaprimee thetaprimeub thetaprimeubHat phate phatub phatubl wprimeex wprimeuxb wprimeuxbl;
            
            UT(:,t,c)                    = (1 - EE(:,it,c)).*UT(:,it,c) + UU(:,it,c) + DELTA(:,it,c).*EE(:,it,c);
            EU(:,t,c)                    = DELTA(:,it,c).*EE(:,it,c);
            UE(:,t,c)                    = (1 - EE(:,it,c) + DELTA(:,it,c).*EE(:,it,c)).*ugotjob;
            E2E(:,t,c)                   = (1 - DELTA(:,it,c)).*EE(:,it,c).*enewjob;
            ET(:,t,c)                    = (1 - DELTA(:,it,c)).*EE(:,it,c).*(1 - enewjob).*ET(:,it,c) + (1 - EE(:,it,c)).*ugotjob;            
            clear  enewjob ugotjob;
                        
            % aprimeu1bl                   = squeeze(interp1(Zgrid,aprimeu1bl,squeeze(DD(:,c)),'linear'));
            aprimeuxbl                   = interpn(dmeshu,ameshu,hmeshu,lmeshu,aprimeu1bl,squeeze(DD(:,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');
            aprimeuxbl(isnan(aprimeuxbl))  = AA(isnan(aprimeuxbl),it,c);
            aprimeuxbl(aprimeuxbl>=ub.a)   = ub.a; aprimeuxbl(aprimeuxbl<=-albt) = -albt;
            % aprimee1                   = squeeze(interp1(Zgrid,aprimee1,squeeze(DD(:,c)),'linear'));
            aprimeex                     = interpn(dmesh,wmesh,amesh,hmesh,lmesh,aprimee1,squeeze(DD(:,c)),squeeze(MU(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            aprimeex(isnan(aprimeex))      = AA(isnan(aprimeex),it,c);
            aprimeex(aprimeex>=ub.a)       = ub.a; aprimeex(aprimeex<=-albt) = -albt;
            % aprimeu1b                   = squeeze(interp1(Zgrid,aprimeu1b,squeeze(DD(:,c)),'linear'));
            aprimeuxb                    = interpn(dmeshb,bmeshb,ameshb,hmeshb,lmeshb,aprimeu1b,squeeze(DD(:,c)),squeeze(UB(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            aprimeuxb(isnan(aprimeuxb))    = AA(isnan(aprimeuxb),it,c);
            aprimeuxb(aprimeuxb>=ub.a)     = ub.a; aprimeuxb(aprimeuxb<=-albt) = -albt;
            % thate1                   = squeeze(interp1(Zgrid,thate1,squeeze(DD(:,c)),'linear'));
            % thatex                     = interpn(dmesh,wmesh,amesh,hmesh,lmesh,thate1,squeeze(DD(:,c)),squeeze(MU(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            % thatex(isnan(thatex))      = 0;
            % thatex(thatex>=ub.t)       = ub.t; thatex(thatex<=lb.t) = lb.t;
            % hhate1                   = squeeze(interp1(Zgrid,hhate1,squeeze(DD(:,c)),'linear'));
            if strcmpi(opts.Basetest,'LBDDecompLearnDiffs')
                hhatex                     = interpn(dmesh,wmesh,amesh,hmesh,lmesh,repmat(reshape(HHat,1,1,1,Nh,Nl),Nd,Nw,Na,1,1),squeeze(DD(:,c)),squeeze(MU(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
                hhatex(isnan(hhatex))      = HH(isnan(hhatex),it,c);
                hhatex(hhatex>=ub.h)       = ub.h; hhatex(hhatex<=lb.h) = lb.h;
            else
            hhatex                     = interpn(dmesh,wmesh,amesh,hmesh,lmesh,repmat(reshape(HHat,1,1,1,Nh,1),Nd,Nw,Na,1,Nl),squeeze(DD(:,c)),squeeze(MU(:,t,c)),squeeze(AA(:,it,c)),squeeze(HH(:,it,c)),LL,'linear');                   % Interpolated search decision: w dimension
            hhatex(isnan(hhatex))      = HH(isnan(hhatex),it,c);
            hhatex(hhatex>=ub.h)       = ub.h; hhatex(hhatex<=lb.h) = lb.h;
            end
            % hhatex                     = xxi(HH(:,it,c),LL,thatex);                   % Interpolated search decision: w dimension
            % hhatex(isnan(hhatex))      = HH(isnan(hhatex),it,c);
            % hhatex(hhatex>=ub.h)       = ub.h; hhatex(hhatex<=lb.h) = lb.h;


            
            AA(:,t,c)                    = EE(:,t,c).*aprimeex + BB(:,t,c).*UU(:,t,c).*aprimeuxb + (1 - BB(:,t,c)).*UU(:,t,c).*aprimeuxbl;               % Employed workers save according to aprimeex and unemployed workers save according to aprimeux
            AA(AA(:,t,c)<=-albt,t,c)       = -albt + eepsilon;
            AA(AA(:,t,c)>=ub.a,t,c)        = ub.a - eepsilon;
            
            % Update State Variables
            TT(:,t,c)                    = EE(:,t,c).*thatex;
            CC(:,t,c)                    = EE(:,t,c).*(1 - TT(:,t,c)).*WW(:,t,c) + (1 - EE(:,t,c)).*(BB(:,t,c).*UB(:,t,c) + (1 - BB(:,t,c)).*bl+eepsilon) + (1 + r).*AA(:,it,c) - AA(:,t,c);
            CC(CC(:,t,c)<=0,t,c)           = eepsilon;
            CC(CC(:,t,c)>=ub.a,t,c)        = ub.a - eepsilon;
            HH(:,t,c)                    = EE(:,t,c).*(EpsSHOCK(:,t,c).*hhatex) + (1 - EE(:,t,c)).*(EpsSHOCK(:,t,c).*HH(:,it,c));
            HH(HH(:,t,c)>=ub.h,t,c)        = ub.h - eepsilon;
            HH(HH(:,t,c)<=lb.h,t,c)        = lb.h + eepsilon;
            
            clear hhatex thatex aprimeex aprimeuxbl aprimeuxb;
            
        end % end for t
    end

end
