function SimulationLBD_Wrapper(params, order, opts, moments, weights, NumObs, NObsNames, randseed, momentNames, statNames, scarringStatNames)
%% Simulation_Wrapper m-file for Search and the Sources of Lifetime Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

    % opts.test = 'n';
    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    err = 0;
    exists = 1;
    dirnum = 0;
    % while exists ~= 0
    %     if isequal(exist(fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(dirnum))),'dir'),7)
    %         exists = 1;
    %         dirnum = dirnum + 1;
    %     else
    %         opts.simulation_directory_num = dirnum;
    %         opts.simulation_graphics_path = fullfile(pwd,opts.II_path,sprintf('simulation_%s/',int2str(dirnum)));
    %         mkdir(opts.simulation_graphics_path);
    %         exists = 0;
    %     end
    % end

    rng(1119);
    maxiter = 2*S;
    randseed = datasample((1:maxiter).', maxiter,'Replace',false);

    modelMoments = zeros(S,length(moments));
    modelSEs = zeros(S,length(moments));
    modelAverages = zeros(S,6,length(statNames));
    modelAveragesWealth = zeros(S,6,5,length(statNames));
    modelAveragesHumanCap = zeros(S,6,5,length(statNames));
    modelAveragesLearn = zeros(S,6,5,length(statNames));
    modelProfiles = zeros(S,2,length(statNames),T./freq);
    modelProfilesWealth = zeros(S,2,5,length(statNames),T./freq);
    modelProfilesHumanCap = zeros(S,2,5,length(statNames),T./freq);
    modelProfilesLearn = zeros(S,2,5,length(statNames),T./freq);
    modelUnempScar = zeros(S,length(scarringStatNames),TScar./freq);
    modelUnempScarComp = zeros(S,2,length(scarringStatNames),TScar./freq);
    modelUnempScarCompFE = zeros(S,2,length(scarringStatNames),TScar./freq);
    modelUnempScarWealth = zeros(S,5,length(scarringStatNames),TScar./freq);
    modelUnempScarHumanCap = zeros(S,5,length(scarringStatNames),TScar./freq);
    modelUnempScarLearn = zeros(S,5,length(scarringStatNames),TScar./freq);
    modelEmpRiskCompEmp = zeros(S,2,length(scarringStatNames),TScar./freq);
    modelEmpRiskCompUnemp = zeros(S,2,length(scarringStatNames),TScar./freq);
    modelEmpRiskWealth = zeros(S,5,length(scarringStatNames),TScar./freq);
    modelEmpRiskHumanCap = zeros(S,5,length(scarringStatNames),TScar./freq);
    modelEmpRiskLearn = zeros(S,5,length(scarringStatNames),TScar./freq);

    j = 1;
    i = 0;
    err = 0;
    fprintf('Simulating %s\n',opts.fancySimName);
    while i < maxiter
        i = i + 1;
        fprintf('%s Simulation %g, %g \n', opts.fancySimName, i, j);
        if i - j > 5
            i = maxiter;
        end
        if j <= S
            err = 0;
            [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles] = SimulationLBD(params, order, statNames, opts, randseed(i));
            EE = gather(EE);
            UU = gather(UU);
            WW = gather(WW);
            AA = gather(AA);
            BB = gather(BB);
            CC = gather(CC);
            UB = gather(UB);
            MU = gather(MU);
            HH = gather(HH);
            TT = gather(TT);
            UT = gather(UT);
            UE= gather(UE);
            EU= gather(EU);
            E2E= gather(E2E);
            ET = gather(ET);
            LL = gather(LL);
            ZZ = gather(ZZ);
            WPrime = gather(WPrime);
            ThetaPrime = gather(ThetaPrime);
            TreatedInd = gather(TreatedInd);
            PInitHat = gather(PInitHat);
            initQtiles = gather(initQtiles);

            EE = EE(:,2:end);
            UU = UU(:,2:end);
            WW = WW(:,2:end);
            AA = AA(:,1:end-1);
            BB = BB(:,2:end);
            CC = CC(:,1:end-1);
            UB = UB(:,2:end);
            MU = MU(:,1:end-1);
            HH = HH(:,1:end-1);
            TT = TT(:,2:end);
            UT = UT(:,2:end);
            % UE= UE(:,2:end);
            % EU= EU(:,2:end);
            E2E= E2E(:,2:end);
            ET = ET(:,2:end);
            ZZ = ZZ(:,2:end);
            WPrime = WPrime(:,2:end);
            ThetaPrime = ThetaPrime(:,2:end);
            TreatedInd = TreatedInd(:,2:end);

            % calcmoments
            if opts.calcMoments == 'y'
                [err, esttemp, setemp] = CalcFinalMoments(params, order, opts, moments, weights, NumObs, NObsNames, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, E2E, ET, ZZ, WPrime, ThetaPrime, TreatedInd, PInitHat, initQtiles);
            else
                esttemp = zeros(size(moments));
                setemp = zeros(size(moments));
            end

            dataopts.dataset = 'FullLifeCycle';
            [ModelPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, ZZ, WPrime, ThetaPrime, [], TreatedInd, PInitHat, initQtiles, dataopts);


            if opts.calcAverages == 'y'
                calcOpts = struct('qtrly','n', ...
                           'qtile','n');
                [err, avetemp] = CalcAverages(params, order, opts, calcOpts, ModelPanel);
                if opts.wealthQtiles == 'y'
                    calcOpts.qtile = 'Wealth';
                    [err, avetempWealth] = CalcAverages(params, order, opts, calcOpts, ModelPanel);
                else
                    avetempWealth = zeros(1,6,5,length(statNames));
                end
                if opts.humancapQtiles == 'y'
                    calcOpts.qtile = 'HumanCap';
                    [err, avetempHumanCap] = CalcAverages(params, order, opts, calcOpts, ModelPanel);
                else
                    avetempHumanCap = zeros(1,6,5,length(statNames));
                end
                if opts.learnQtiles == 'y'
                    calcOpts.qtile = 'Learn';
                    [err, avetempLearn] = CalcAverages(params, order, opts, calcOpts, ModelPanel);
                else
                    avetempLearn = zeros(1,6,5,length(statNames));
                end
            else
                avetemp = zeros(1,6,length(statNames));
                avetempWealth = zeros(1,6,5,length(statNames));
                avetempHumanCap = zeros(1,6,5,length(statNames));
                avetempLearn = zeros(1,6,5,length(statNames));
            end

            if opts.calcProfiles == 'y'
                calcOpts = struct('qtrly','n', ...
                           'qtile','n');
                [err, profiletemp] = CalcProfiles(params, order, opts, calcOpts, ModelPanel);
                if opts.wealthQtiles == 'y'
                    calcOpts.qtile = 'Wealth';
                    [err, profiletempWealth] = CalcProfiles(params, order, opts, calcOpts, ModelPanel);
                else
                    profiletempWealth = zeros(1,2,5,length(statNames),T./freq);
                end
                if opts.humancapQtiles == 'y'
                    calcOpts.qtile = 'HumanCap';
                    [err, profiletempHumanCap] = CalcProfiles(params, order, opts, calcOpts, ModelPanel);
                else
                    profiletempHumanCap = zeros(1,2,5,length(statNames),T./freq);
                end
                if opts.learnQtiles == 'y'
                    calcOpts.qtile = 'Learn';
                    [err, profiletempLearn] = CalcProfiles(params, order, opts, calcOpts, ModelPanel);
                else
                    profiletempLearn = zeros(1,2,5,length(statNames),T./freq);
                end
            else
                profiletemp = zeros(1,2,length(statNames),T./freq);
                profiletempWealth = zeros(1,2,5,length(statNames),T./freq);
                profiletempHumanCap = zeros(1,2,5,length(statNames),T./freq);
                profiletempLearn = zeros(1,2,5,length(statNames),T./freq);
            end

            if opts.savePanel == 'y'
                matfile = fullfile(pwd,sprintf('Simulation_%sPanel_%s.mat',opts.simName,int2str(i)));
                save(matfile, 'ModelPanel');
            end
            clear ModelPanel;


            dist_dataUnemp.MU = MU(1:NScar,1:(T-TScar+1));
            dist_dataUnemp.MU(EE(1:NScar,1:(T-TScar+1))==0) = NaN;
            dist_dataUnemp.TT = TT(1:NScar,1:(T-TScar+1));
            dist_dataUnemp.TT(EE(1:NScar,1:(T-TScar+1))==0) = NaN;
            dist_dataUnemp.HH = HH(1:NScar,1:(T-TScar+1));
            dist_dataUnemp.AA = AA(1:NScar,1:(T-TScar+1));
            dist_dataUnemp.LL = LL(1:NScar);

            dist_dataEmp.MU = MU(1:2*NScar,1:(T-TScar+1));
            dist_dataEmp.MU(EE(1:2*NScar,1:(T-TScar+1))==0) = NaN;
            dist_dataEmp.TT = TT(1:2*NScar,1:(T-TScar+1));
            dist_dataEmp.TT(EE(1:2*NScar,1:(T-TScar+1))==0) = NaN;
            dist_dataEmp.HH = HH(1:2*NScar,1:(T-TScar+1));
            dist_dataEmp.AA = AA(1:2*NScar,1:(T-TScar+1));
            dist_dataEmp.LL = LL(1:2*NScar);
            if opts.calcScarring == 'y'
                testInit = opts.test;
                opts.Basetest = testInit;
                if opts.saveSim == 'y'
                    matfile = fullfile(pwd,sprintf('Simulation_%s.mat',opts.simName));
                    save(matfile, 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'ZZ', 'WPrime', 'ThetaPrime', 'TreatedInd');
                else
                    matfile = fullfile(pwd,'/output/',sprintf('Simulation_%sScarringInit_%s.mat',opts.simName,int2str(i)));
                    save(matfile, 'AA', 'MU', 'HH', 'LL');
                end
                clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;
                if opts.calcUnempScarring == 'y'
                    % opts.test = 'UnempScarring';
                    opts.test = 'UnempScarringWealth';
                    [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime] = SimulationLBDScarring(params, order, statNames, opts, randseed(i), dist_dataUnemp);
                    EE = gather(EE);
                    UU = gather(UU);
                    WW = gather(WW);
                    AA = gather(AA);
                    BB = gather(BB);
                    CC = gather(CC);
                    UB = gather(UB);
                    MU = gather(MU);
                    HH = gather(HH);
                    TT = gather(TT);
                    UT = gather(UT);
                    UE= gather(UE);
                    EU= gather(EU);
                    E2E= gather(E2E);
                    ET = gather(ET);
                    LL = gather(LL);
                    WPrime = gather(WPrime);
                    ThetaPrime = gather(ThetaPrime);
                    if opts.saveSim == 'y'
                        matfile = fullfile(pwd,sprintf('Simulation_%sUnempScarring.mat',opts.simName));
                        save(matfile, 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime');
                    end
                    dataopts.dataset = 'ScarringPanel';
                    [ScarringPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, [], [], [], [], dataopts);
                    clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;

                    calcOpts = struct('qtrly','n', ...
                                      'scarTest','Unemp', ...
                                      'qtile','n');
                    [unempscartemp, err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel);

                    calcOpts.qtile = 'Comp';
                    [unempscartempComp, err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel);

                    calcOpts.qtile = 'Wealth';
                    [unempscartempWealth, err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel);

                    if opts.humancapQtilesScarring == 'y'
                        opts.test = 'UnempScarringHumanCap';
                        [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime] = SimulationLBDScarring(params, order, statNames, opts, randseed(i), dist_dataUnemp);
                        EE = gather(EE);
                        UU = gather(UU);
                        WW = gather(WW);
                        AA = gather(AA);
                        BB = gather(BB);
                        CC = gather(CC);
                        UB = gather(UB);
                        MU = gather(MU);
                        HH = gather(HH);
                        TT = gather(TT);
                        UT = gather(UT);
                        UE= gather(UE);
                        EU= gather(EU);
                        E2E= gather(E2E);
                        ET = gather(ET);
                        LL = gather(LL);
                        WPrime = gather(WPrime);
                        ThetaPrime = gather(ThetaPrime);
                        if opts.saveSim == 'y'
                            matfile = fullfile(pwd,sprintf('Simulation_%sUnempScarringHumanCap.mat',opts.simName));
                            save(matfile, 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime');
                        end
                        dataopts.dataset = 'ScarringPanel';
                        [ScarringPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, [], [], [], [], dataopts);
                        clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;

                        calcOpts.qtile = 'HumanCap';
                        [unempscartempHumanCap, err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel);
                    else
                        unempscartempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                    end
                    if opts.learnQtilesScarring == 'y'
                        opts.test = 'UnempScarringLearn';
                        [EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime] = SimulationLBDScarring(params, order, statNames, opts, randseed(i), dist_dataUnemp);
                        EE = gather(EE);
                        UU = gather(UU);
                        WW = gather(WW);
                        AA = gather(AA);
                        BB = gather(BB);
                        CC = gather(CC);
                        UB = gather(UB);
                        MU = gather(MU);
                        HH = gather(HH);
                        TT = gather(TT);
                        UT = gather(UT);
                        UE= gather(UE);
                        EU= gather(EU);
                        E2E= gather(E2E);
                        ET = gather(ET);
                        LL = gather(LL);
                        WPrime = gather(WPrime);
                        ThetaPrime = gather(ThetaPrime);
                        if opts.saveSim == 'y'
                            matfile = fullfile(pwd,sprintf('Simulation_%sUnempScarringLearn.mat',opts.simName));
                            save(matfile, 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime');
                        end
                        dataopts.dataset = 'ScarringPanel';
                        [ScarringPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, [], EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, [], [], [], [], dataopts);
                        clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;

                        calcOpts.qtile = 'Learn';
                        [unempscartempLearn, err] = CalcScarring(params, order, opts, calcOpts, ScarringPanel);
                    else
                        unempscartempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                    end
                else
                    unempscartemp = zeros(1,length(scarringStatNames),TScar./freq);
                    unempscartempComp = zeros(1,2,length(scarringStatNames),TScar./freq);
                    unempscartempCompFE = zeros(1,2,length(scarringStatNames),TScar./freq);
                    unempscartempWealth = zeros(1,5,length(scarringStatNames),TScar./freq);
                    unempscartempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                    unempscartempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                end
                clear dist_dataUnemp;

                if opts.calcEmpRisk == 'y'
                    % opts.test = 'EmpRisk';
                    opts.test = 'EmpRiskWealth';
                    output_pathInit = opts.output_path;
                    ddeltaInit = params(find(strcmp(order, 'ddelta')));
                    opts.output_path = '/output/EmpRisk/';
                    % if opts.solveAddl == 'y'
                    %     ModelEmpRisk(params, order, opts);
                    % end

                    [DD, EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime, ThetaPrimeHat] = SimulationLBDEmpRisk(params, order, statNames, opts, randseed(i), dist_dataEmp);
                    DD = gather(DD);
                    EE = gather(EE);
                    UU = gather(UU);
                    WW = gather(WW);
                    AA = gather(AA);
                    BB = gather(BB);
                    CC = gather(CC);
                    UB = gather(UB);
                    MU = gather(MU);
                    HH = gather(HH);
                    TT = gather(TT);
                    UT = gather(UT);
                    UE= gather(UE);
                    EU= gather(EU);
                    E2E= gather(E2E);
                    ET = gather(ET);
                    LL = gather(LL);
                    WPrime = gather(WPrime);
                    ThetaPrime = gather(ThetaPrime);
                    ThetaPrimeHat = gather(ThetaPrimeHat);
                    if opts.saveSim == 'y'
                        matfile = fullfile(pwd,sprintf('Simulation_%sEmpRisk.mat',opts.simName));
                        save(matfile, 'DD', 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime', 'ThetaPrimeHat');
                    end
                    dataopts.dataset = 'EmpRiskPanel';
                    [EmpRiskPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, DD, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, ThetaPrimeHat, [], [], [], dataopts);
                    clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;


                    calcOpts = struct('qtrly','n', ...
                                      'scarTest','Emp', ...
                                      'qtile','CompEmp');
                    [emprisktempCompEmp, err] = CalcScarring(params, order, opts, calcOpts, EmpRiskPanel);


                    calcOpts.qtile = 'CompUnemp';
                    [emprisktempCompUnemp, err] = CalcScarring(params, order, opts, calcOpts, EmpRiskPanel);


                    calcOpts.qtile = 'Wealth';
                    [emprisktempWealth, err] = CalcScarring(params, order, opts, calcOpts, EmpRiskPanel);

                    if opts.humancapQtilesScarring == 'y'
                        opts.test = 'EmpRiskHumanCap';
                        [DD, EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime] = SimulationLBDEmpRisk(params, order, statNames, opts, randseed(i), dist_dataEmp);
                        DD = gather(DD);
                        EE = gather(EE);
                        UU = gather(UU);
                        WW = gather(WW);
                        AA = gather(AA);
                        BB = gather(BB);
                        CC = gather(CC);
                        UB = gather(UB);
                        MU = gather(MU);
                        HH = gather(HH);
                        TT = gather(TT);
                        UT = gather(UT);
                        UE= gather(UE);
                        EU= gather(EU);
                        E2E= gather(E2E);
                        ET = gather(ET);
                        LL = gather(LL);
                        WPrime = gather(WPrime);
                        ThetaPrime = gather(ThetaPrime);
                        if opts.saveSim == 'y'
                            matfile = fullfile(pwd,sprintf('Simulation_%sEmpRiskHumanCap.mat',opts.simName));
                            save(matfile, 'DD', 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime');
                        end
                        dataopts.dataset = 'EmpRiskPanel';
                        [EmpRiskPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, DD, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, [], [], [], dataopts);
                        clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;

                        calcOpts.qtile = 'HumanCap';
                        [emprisktempHumanCap, err] = CalcScarring(params, order, opts, calcOpts, EmpRiskPanel);
                    else
                        emprisktempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                    end
                    if opts.learnQtilesScarring == 'y'
                        opts.test = 'EmpRiskLearn';
                        [DD, EE, UU, WW, AA, CC, BB, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, WPrime, ThetaPrime] = SimulationLBDEmpRisk(params, order, statNames, opts, randseed(i), dist_dataEmp);
                        DD = gather(DD);
                        EE = gather(EE);
                        UU = gather(UU);
                        WW = gather(WW);
                        AA = gather(AA);
                        BB = gather(BB);
                        CC = gather(CC);
                        UB = gather(UB);
                        MU = gather(MU);
                        HH = gather(HH);
                        TT = gather(TT);
                        UT = gather(UT);
                        UE= gather(UE);
                        EU= gather(EU);
                        E2E= gather(E2E);
                        ET = gather(ET);
                        LL = gather(LL);
                        WPrime = gather(WPrime);
                        ThetaPrime = gather(ThetaPrime);
                        if opts.saveSim == 'y'
                            matfile = fullfile(pwd,sprintf('Simulation_%sEmpRiskLearn.mat',opts.simName));
                            save(matfile, 'DD', 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'WPrime', 'ThetaPrime');
                        end
                        dataopts.dataset = 'EmpRiskPanel';
                        [EmpRiskPanel,~] = DataPanels(params, order, opts, NumObs, NObsNames, DD, EE, UU, WW, AA, BB, CC, UB, MU, HH, TT, LL, UT, UE, EU, E2E, ET, [], WPrime, ThetaPrime, [], [], [], dataopts);
                        clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;

                        calcOpts.qtile = 'Learn';
                        [emprisktempLearn, err] = CalcScarring(params, order, opts, calcOpts, EmpRiskPanel);
                    else
                        emprisktempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                    end
                    opts.output_path = output_pathInit;
                else
                    emprisktempCompEmp = zeros(1,2,length(scarringStatNames),TScar./freq);
                    emprisktempCompUnemp = zeros(1,2,length(scarringStatNames),TScar./freq);
                    emprisktempWealth = zeros(1,5,length(scarringStatNames),TScar./freq);
                    emprisktempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                    emprisktempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                end
                opts.test = testInit;
            else
                unempscartemp = zeros(1,length(scarringStatNames),TScar./freq);
                unempscartempComp = zeros(1,2,length(scarringStatNames),TScar./freq);
                unempscartempCompFE = zeros(1,2,length(scarringStatNames),TScar./freq);
                unempscartempWealth = zeros(1,5,length(scarringStatNames),TScar./freq);
                unempscartempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                unempscartempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                emprisktempCompEmp = zeros(1,2,length(scarringStatNames),TScar./freq);
                emprisktempCompUnemp = zeros(1,2,length(scarringStatNames),TScar./freq);
                emprisktempWealth = zeros(1,5,length(scarringStatNames),TScar./freq);
                emprisktempHumanCap = zeros(1,5,length(scarringStatNames),TScar./freq);
                emprisktempLearn = zeros(1,5,length(scarringStatNames),TScar./freq);
                if opts.saveSim == 'y'
                    matfile = fullfile(pwd,sprintf('Simulation_%s.mat',opts.simName));
                    save(matfile, 'EE', 'UU', 'WW', 'AA', 'BB', 'CC', 'UB', 'MU', 'TT', 'HH', 'LL', 'UT', 'E2E', 'EU', 'UE', 'ET', 'ZZ', 'WPrime', 'ThetaPrime', 'TreatedInd');
                end
            end
            clear EE UU WW AA BB CC UB MU HH TT LL UT E2E ET ZZ WPrime ThetaPrime;
            if err == 0
                modelMoments(j,:,:) = esttemp;
                modelSEs(j,:,:) = setemp;
                modelAverages(j,:,:) = avetemp;
                modelAveragesWealth(j,:,:,:) = avetempWealth;
                modelAveragesHumanCap(j,:,:,:) = avetempHumanCap;
                modelAveragesLearn(j,:,:,:) = avetempLearn;
                modelProfiles(j,:,:,:) = profiletemp;
                modelProfilesWealth(j,:,:,:,:) = profiletempWealth;
                modelProfilesHumanCap(j,:,:,:,:) = profiletempHumanCap;
                modelProfilesLearn(j,:,:,:,:) = profiletempLearn;
                modelUnempScar(j,:,:) = unempscartemp;
                modelUnempScarComp(j,:,:,:) = unempscartempComp;
                % modelUnempScarCompFE(j,:,:,:) = unempscartempCompFE;
                modelUnempScarWealth(j,:,:,:) = unempscartempWealth;
                modelUnempScarHumanCap(j,:,:,:) = unempscartempHumanCap;
                modelUnempScarLearn(j,:,:,:) = unempscartempLearn;
                modelEmpRiskCompEmp(j,:,:,:) = emprisktempCompEmp;
                modelEmpRiskCompUnemp(j,:,:,:) = emprisktempCompUnemp;
                modelEmpRiskWealth(j,:,:,:) = emprisktempWealth;
                modelEmpRiskHumanCap(j,:,:,:) = emprisktempHumanCap;
                modelEmpRiskLearn(j,:,:,:) = emprisktempLearn;
                j = j + 1;
            else
                fprintf('There was an error\n');
            end
        elseif j > S
            i = maxiter;
        end
    end

    fprintf('Saving Calculations');
    SaveCalcs(params, order, opts, moments, weights, modelMoments, modelSEs, modelAverages, modelAveragesWealth, modelAveragesHumanCap, modelAveragesLearn, modelProfiles, modelProfilesWealth, modelProfilesHumanCap, modelProfilesLearn, modelUnempScar, modelUnempScarComp, modelUnempScarCompFE, modelUnempScarWealth, modelUnempScarHumanCap, modelUnempScarLearn, modelEmpRiskCompEmp, modelEmpRiskCompUnemp, modelEmpRiskWealth, modelEmpRiskHumanCap, modelEmpRiskLearn);


end
