function [EE, WW, AA, CC, HH, TT, LL, TreatedInd, PInitHat, initQtiles] = SimulationNoSearch(params,order,opts,seedval)
%% Simulation

    if opts.gpu == 'y'
        reset(gpuDevice())
    end
    
    [r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl, ...
     na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps, ...
     SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

    [DELTA,EpsSHOCK,EE,WW,AA,CC,HH,TT,LL,TreatedInd,PInitHat,initQtiles,hmesh,lmesh] = SimGridsNoSearch(params,order,opts,seedval);

    rng(seedval);

    for t = 2:T+1
        it = t-1;
        albt = geosum(r,bl,(T-t+1));
        alb = geosum(r,bl,(T-t+2));
        matfile = fullfile(pwd,opts.output_path, sprintf('Result%d.mat',t-1));
        load(matfile);
        [amesh] = UpdateSimGridsNoSearch(it, params, order, opts);


        EE(:,t)                    = (1 - DELTA(:,t-1));
        WW(:,t)                    = phi(HH(:,t-1),t);
        
        clear thetaprimeubl thetaprimee thetaprimeub phate phatub phatubl wprimeex wprimeuxb wprimeuxbl enewjob ugotjob;
        

        
        aprimeex                     = interpn(amesh,hmesh,lmesh,aprimee1,AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        aprimeex(isnan(aprimeex))      = AA(isnan(aprimeex),t-1);
        aprimeex(aprimeex>=ub.a)       = ub.a; aprimeex(aprimeex<=-albt) = -albt;
        aprimeuxb                    = interpn(amesh,hmesh,lmesh,aprimeu1b,AA(:,t-1),HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        aprimeuxb(isnan(aprimeuxb))    = AA(isnan(aprimeuxb),t-1);
        aprimeuxb(aprimeuxb>=ub.a)     = ub.a; aprimeuxb(aprimeuxb<=-albt) = -albt;

        if strcmpi(opts.test,'NoSearchDecomp1')
            AAtemp = repmat(nanmean(AA(:,t-1)),N,1);
        else
            AAtemp = AA(:,t-1);
        end

        thatex                     = interpn(amesh,hmesh,lmesh,thate1,AAtemp,HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        thatex(isnan(thatex))      = 0;
        thatex(thatex>=ub.t)       = ub.t; thatex(thatex<=lb.t) = lb.t;
        hhatex                     = interpn(amesh,hmesh,lmesh,hhate1,AAtemp,HH(:,t-1),LL,'linear');                   % Interpolated search decision: w dimension
        hhatex(isnan(hhatex))      = HH(isnan(hhatex),t-1);
        hhatex(hhatex>=ub.h)       = ub.h; hhatex(hhatex<=lb.h) = lb.h;
        clear AAtemp;
        
        AA(:,t)                    = EE(:,t).*aprimeex + (1 - EE(:,t)).*aprimeuxb;               % Employed workers save according to aprimeex and unemployed workers save according to aprimeux
        AA(AA(:,t)<=-albt,t)       = -albt + eepsilon;
        AA(AA(:,t)>=ub.a,t)        = ub.a - eepsilon;
        
% Update State Variables
        TT(:,t)                    = EE(:,t).*thatex;
        CC(:,t)                    = (1 - TT(:,t)).*WW(:,t) + (1 + r).*AA(:,t-1) - AA(:,t);
        CC(CC(:,t)<=0,t)           = eepsilon;
        CC(CC(:,t)>=ub.a,t)        = ub.a - eepsilon;
        ZZ(:,t)                    = EpsSHOCK(:,t);
        HH(:,t)                    = EE(:,t).*(EpsSHOCK(:,t).*hhatex) + (1 - EE(:,t)).*(EpsSHOCK(:,t).*HH(:,t-1));
        HH(HH(:,t)>=ub.h,t)        = ub.h - eepsilon;
        HH(HH(:,t)<=lb.h,t)        = lb.h  + eepsilon;
        
        clear hhatex thatex aprimeex aprimeuxbl aprimeuxb;
        
    end % end for t
        
end
