function SpecificPlots(params, order, opts, plotopts, statNames, YLabs, lifetime_earnings, lifetime_variance, statArray, dataopts)
%% II m-file for Wealth Effects, Search, and Life-Cycle Earnings Inequality
% solve and simulate model given a set of parameters and then calculate
% distance

[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

if opts.II == 'n'
    results_graphics_path = fullfile(pwd,opts.results_path,'/figures/');
    results_table_path = fullfile(pwd,opts.results_path,'/tables/');
    model_results_graphics_path = fullfile(results_graphics_path,plotopts.dir);
    model_results_table_path = fullfile(results_table_path,plotopts.dir);

    if ~isequal(exist(fullfile(results_graphics_path),'dir'),7)
        mkdir(fullfile(results_graphics_path));
        if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
            mkdir(fullfile(model_results_graphics_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_graphics_path),'dir'),7)
        mkdir(fullfile(model_results_graphics_path));
    end
    if ~isequal(exist(fullfile(results_table_path),'dir'),7)
        mkdir(fullfile(results_table_path));
        if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
            mkdir(fullfile(model_results_table_path));
        end
    end
    if ~isequal(exist(fullfile(model_results_table_path),'dir'),7)
       mkdir(fullfile(model_results_table_path));
    end
else
    model_results_graphics_path = opts.simulation_graphics_path;
    model_results_table_path = opts.simulation_graphics_path;
end

results_graphics_path = model_results_graphics_path;
results_table_path = model_results_table_path;

[ColorSet2,~,~] = brewermap(24,'RdYlBu');
[ColorSet3,~,~] = brewermap(24,'BrBG');
[ColorSet4,~,~] = brewermap(24,'PRGn');
[ColorSet1,~,~] = brewermap(24,'RdYlBu');
[ColorSet5,~,~] = brewermap(12,'Paired');

FormatOpts = struct('GridLineStyle', '--'     , ...
                    'Box'         , 'off'     , ...
                    'TickDir'     , 'out'     , ...
                    'TickLength'  , [.02 .02] , ...
                    'XMinorTick'  , 'on'      , ...
                    'YMinorTick'  , 'on'      , ...
                    'XGrid'       , 'on'      , ...
                    'YGrid'       , 'on'      , ...
                    'XColor'      , [.3 .3 .3], ...
                    'YColor'      , [.3 .3 .3], ...
                    'LineWidth'   , 1         , ...
                    'LW'          , 2         , ...
                    'LS'          , []        , ...
                    'FontSize'    , 12        , ...
                    'PaperPosition', [0,0,4,4]);


% AggShocks = [0;AggShocks];


%%Plots
% Time Series: Loop over statNamess above

LRIncHVY23 = squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),:)) + squeeze(statArray(1,find(strcmp(statNames, 'LHumanCap')),1)) - squeeze(statArray(1,find(strcmp(statNames, 'LHumanCap')),:));


p1 = plot(squeeze(statArray(1,2,:)),squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),:)),'color',ColorSet1(22,:),'LineWidth',1.5,'LineStyle','-','Marker','o','MarkerIndices',1:5:length(LRIncHVY23));
hold on;
p2 = plot(squeeze(statArray(1,2,:)),LRIncHVY23,'color',ColorSet1(8,:),'LineWidth',1.5,'LineStyle','--','Marker','^','MarkerIndices',1:5:length(LRIncHVY23));
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
axes = get(gca, 'position');
br = drawbrace([32 squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),10))],[32 LRIncHVY23(10)],2,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),7))-LRIncHVY23(7))));
br = drawbrace([50 squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),27))],[50 LRIncHVY23(27)],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),27))-LRIncHVY23(27))));
xlabel('Age','Interpreter','latex')
ylabel('log(Income)','Interpreter','latex')
hleg1 = legend([p1,p2],'Baseline','Base. & Age 23 HC','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_Age23HCComp',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

LRIncCovar = squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),:)) - squeeze(statArray(2,find(strcmp(statNames, 'LPieceRate')),:)) - squeeze(statArray(2,find(strcmp(statNames, 'LHumanCap')),:));

p1 = plot(squeeze(statArray(1,2,:)),squeeze(statArray(2,find(strcmp(statNames, 'LRInc')),:)),'color',ColorSet1(22,:),'LineWidth',1.5,'LineStyle','-','Marker','p','MarkerIndices',1:5:length(LRIncHVY23));
hold on;
p2 = plot(squeeze(statArray(1,2,:)),squeeze(statArray(2,find(strcmp(statNames, 'LPieceRate')),:)),'color',ColorSet1(1,:),'LineWidth',1.5,'LineStyle','--','Marker','s','MarkerIndices',1:5:length(LRIncHVY23));
p3 = plot(squeeze(statArray(1,2,:)),squeeze(statArray(2,find(strcmp(statNames, 'LHumanCap')),:)),'color',ColorSet1(8,:),'LineWidth',1.5,'LineStyle',':','Marker','^','MarkerIndices',1:5:length(LRIncHVY23));
% p4 = plot(squeeze(statArray(1,2,:)),LRIncCovar,'color',ColorSet1(8,:),'LineWidth',1.5,'LineStyle','--','Marker','^','MarkerIndices',1:5:length(LRIncHVY23));
yLims = get(gca,'ylim');
ylim([min(yLims) max(yLims)]);
axes = get(gca, 'position');
br = drawbrace([32 squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),10))],[32 LRIncHVY23(10)],2,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),7))-LRIncHVY23(7))));
br = drawbrace([50 squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),27))],[50 LRIncHVY23(27)],10,'Color','k');
text(br.XData(101),br.YData(101),sprintf('Diff. of \n%0.2f',(squeeze(statArray(1,find(strcmp(statNames, 'LRInc')),27))-LRIncHVY23(27))));
xlabel('Age','Interpreter','latex')
ylabel('log(Income)','Interpreter','latex')
% hleg1 = legend([p1,p2,p3,p4],'var(log(Income))','var(log(Piece-Rate))','var(log(Human Cap.))','Covar.','Interpreter','latex');
hleg1 = legend([p1,p2,p3],'var(log(Income))','var(log(Piece-Rate))','var(log(Human Cap.))','Interpreter','latex');
set(hleg1,'Location','best');
set(gca, ...
    'GridLineStyle'         , '--'     , ...
    'Box'         , 'off'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'on'      , ...
    'YMinorTick'  , 'on'      , ...
    'XGrid'       , 'on'      , ...
    'YGrid'       , 'on'      , ...
    'XColor'      , [.3 .3 .3], ...
    'YColor'      , [.3 .3 .3], ...
    'FontSize'    , 12        , ...
    'LineWidth'   , 1         );
figfile = fullfile(results_graphics_path,strcat('LRInc_VarDecomp',plotopts.name));
saveas(gcf,figfile,'png');
if opts.II == 'n'
    saveas(gcf,figfile,'epsc');
end
hold off;

end
