function V = UbObj(aprime,agridt,uhat,Rb,Rbl,params,order,opts)

%VuEval: Solve for the value of the production period


% Load Parameters and Define Functional Forms
[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


% Calculate the value of unemployement

% Nb x Nr x Na x Nh x Nl -> Na x Nr x Nb x Nh x Nl -> Nh x Nb x Nl x Nr x na
V    = reshape(permute(interp1(agridt.',permute(Rb,[2,1,3,4]),aprime.','linear'),[2,3,4,1]),Nb,1,Nh,Nl,na); % Interpolated value of return to search at aprime
clear Rb;
% Na x Nh x Nl -> Nh x Nl x na
V       = bsxfun(@plus,(1 - ggamma).*V,ggamma.*reshape(permute(interp1(agridt.',Rbl,aprime.','linear'),[2,3,1]),1,1,Nh,Nl,na)); % Interpolated value of return to search at aprime
clear aprime Rbl agridt;

V        = bsxfun(@plus,reshape(uhat,Nb,Na,1,1,na) + nnu,bbeta.*V);                 % Value of unemployment

end